/* calendar-week.c generated by valac 0.24.0, the Vala compiler
 * generated from calendar-week.vala, do not modify */

/* Copyright 2014 Yorba Foundation
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define CALIFORNIA_TYPE_BASE_OBJECT (california_base_object_get_type ())
#define CALIFORNIA_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject))
#define CALIFORNIA_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))
#define CALIFORNIA_IS_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_IS_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_BASE_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))

typedef struct _CaliforniaBaseObject CaliforniaBaseObject;
typedef struct _CaliforniaBaseObjectClass CaliforniaBaseObjectClass;
typedef struct _CaliforniaBaseObjectPrivate CaliforniaBaseObjectPrivate;

#define CALIFORNIA_CALENDAR_TYPE_SPAN (california_calendar_span_get_type ())
#define CALIFORNIA_CALENDAR_SPAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan))
#define CALIFORNIA_CALENDAR_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpanClass))
#define CALIFORNIA_CALENDAR_IS_SPAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_SPAN))
#define CALIFORNIA_CALENDAR_IS_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_SPAN))
#define CALIFORNIA_CALENDAR_SPAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpanClass))

typedef struct _CaliforniaCalendarSpan CaliforniaCalendarSpan;
typedef struct _CaliforniaCalendarSpanClass CaliforniaCalendarSpanClass;
typedef struct _CaliforniaCalendarSpanPrivate CaliforniaCalendarSpanPrivate;

#define CALIFORNIA_CALENDAR_TYPE_UNIT (california_calendar_unit_get_type ())
#define CALIFORNIA_CALENDAR_UNIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnit))
#define CALIFORNIA_CALENDAR_UNIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnitClass))
#define CALIFORNIA_CALENDAR_IS_UNIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_UNIT))
#define CALIFORNIA_CALENDAR_IS_UNIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_UNIT))
#define CALIFORNIA_CALENDAR_UNIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnitClass))

typedef struct _CaliforniaCalendarUnit CaliforniaCalendarUnit;
typedef struct _CaliforniaCalendarUnitClass CaliforniaCalendarUnitClass;

#define CALIFORNIA_CALENDAR_TYPE_DATE (california_calendar_date_get_type ())
#define CALIFORNIA_CALENDAR_DATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDate))
#define CALIFORNIA_CALENDAR_DATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDateClass))
#define CALIFORNIA_CALENDAR_IS_DATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_DATE))
#define CALIFORNIA_CALENDAR_IS_DATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_DATE))
#define CALIFORNIA_CALENDAR_DATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDateClass))

typedef struct _CaliforniaCalendarDate CaliforniaCalendarDate;
typedef struct _CaliforniaCalendarDateClass CaliforniaCalendarDateClass;

#define CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERABLE (california_collection_simple_iterable_get_type ())
#define CALIFORNIA_COLLECTION_SIMPLE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERABLE, CaliforniaCollectionSimpleIterable))
#define CALIFORNIA_COLLECTION_IS_SIMPLE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERABLE))
#define CALIFORNIA_COLLECTION_SIMPLE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERABLE, CaliforniaCollectionSimpleIterableIface))

typedef struct _CaliforniaCollectionSimpleIterable CaliforniaCollectionSimpleIterable;
typedef struct _CaliforniaCollectionSimpleIterableIface CaliforniaCollectionSimpleIterableIface;

#define CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERATOR (california_collection_simple_iterator_get_type ())
#define CALIFORNIA_COLLECTION_SIMPLE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERATOR, CaliforniaCollectionSimpleIterator))
#define CALIFORNIA_COLLECTION_IS_SIMPLE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERATOR))
#define CALIFORNIA_COLLECTION_SIMPLE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERATOR, CaliforniaCollectionSimpleIteratorIface))

typedef struct _CaliforniaCollectionSimpleIterator CaliforniaCollectionSimpleIterator;
typedef struct _CaliforniaCollectionSimpleIteratorIface CaliforniaCollectionSimpleIteratorIface;
typedef struct _CaliforniaCalendarUnitPrivate CaliforniaCalendarUnitPrivate;

#define CALIFORNIA_CALENDAR_TYPE_WEEK (california_calendar_week_get_type ())
#define CALIFORNIA_CALENDAR_WEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_WEEK, CaliforniaCalendarWeek))
#define CALIFORNIA_CALENDAR_WEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_WEEK, CaliforniaCalendarWeekClass))
#define CALIFORNIA_CALENDAR_IS_WEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_WEEK))
#define CALIFORNIA_CALENDAR_IS_WEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_WEEK))
#define CALIFORNIA_CALENDAR_WEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_WEEK, CaliforniaCalendarWeekClass))

typedef struct _CaliforniaCalendarWeek CaliforniaCalendarWeek;
typedef struct _CaliforniaCalendarWeekClass CaliforniaCalendarWeekClass;
typedef struct _CaliforniaCalendarWeekPrivate CaliforniaCalendarWeekPrivate;

#define CALIFORNIA_CALENDAR_TYPE_MONTH_OF_YEAR (california_calendar_month_of_year_get_type ())
#define CALIFORNIA_CALENDAR_MONTH_OF_YEAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_MONTH_OF_YEAR, CaliforniaCalendarMonthOfYear))
#define CALIFORNIA_CALENDAR_MONTH_OF_YEAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_MONTH_OF_YEAR, CaliforniaCalendarMonthOfYearClass))
#define CALIFORNIA_CALENDAR_IS_MONTH_OF_YEAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_MONTH_OF_YEAR))
#define CALIFORNIA_CALENDAR_IS_MONTH_OF_YEAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_MONTH_OF_YEAR))
#define CALIFORNIA_CALENDAR_MONTH_OF_YEAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_MONTH_OF_YEAR, CaliforniaCalendarMonthOfYearClass))

typedef struct _CaliforniaCalendarMonthOfYear CaliforniaCalendarMonthOfYear;
typedef struct _CaliforniaCalendarMonthOfYearClass CaliforniaCalendarMonthOfYearClass;

#define CALIFORNIA_CALENDAR_TYPE_FIRST_OF_WEEK (california_calendar_first_of_week_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CALIFORNIA_CALENDAR_TYPE_DATE_UNIT (california_calendar_date_unit_get_type ())

#define CALIFORNIA_CALENDAR_TYPE_UNIT_SPAN (california_calendar_unit_span_get_type ())
#define CALIFORNIA_CALENDAR_UNIT_SPAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_UNIT_SPAN, CaliforniaCalendarUnitSpan))
#define CALIFORNIA_CALENDAR_UNIT_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_UNIT_SPAN, CaliforniaCalendarUnitSpanClass))
#define CALIFORNIA_CALENDAR_IS_UNIT_SPAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_UNIT_SPAN))
#define CALIFORNIA_CALENDAR_IS_UNIT_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_UNIT_SPAN))
#define CALIFORNIA_CALENDAR_UNIT_SPAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_UNIT_SPAN, CaliforniaCalendarUnitSpanClass))

typedef struct _CaliforniaCalendarUnitSpan CaliforniaCalendarUnitSpan;
typedef struct _CaliforniaCalendarUnitSpanClass CaliforniaCalendarUnitSpanClass;

#define CALIFORNIA_CALENDAR_TYPE_DATE_SPAN (california_calendar_date_span_get_type ())
#define CALIFORNIA_CALENDAR_DATE_SPAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, CaliforniaCalendarDateSpan))
#define CALIFORNIA_CALENDAR_DATE_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, CaliforniaCalendarDateSpanClass))
#define CALIFORNIA_CALENDAR_IS_DATE_SPAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_DATE_SPAN))
#define CALIFORNIA_CALENDAR_IS_DATE_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_DATE_SPAN))
#define CALIFORNIA_CALENDAR_DATE_SPAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, CaliforniaCalendarDateSpanClass))

typedef struct _CaliforniaCalendarDateSpan CaliforniaCalendarDateSpan;
typedef struct _CaliforniaCalendarDateSpanClass CaliforniaCalendarDateSpanClass;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _CaliforniaBaseObject {
	GObject parent_instance;
	CaliforniaBaseObjectPrivate * priv;
};

struct _CaliforniaBaseObjectClass {
	GObjectClass parent_class;
	gchar* (*to_string) (CaliforniaBaseObject* self);
};

struct _CaliforniaCalendarSpan {
	CaliforniaBaseObject parent_instance;
	CaliforniaCalendarSpanPrivate * priv;
};

struct _CaliforniaCalendarSpanClass {
	CaliforniaBaseObjectClass parent_class;
	CaliforniaCalendarDate* (*get_start_date) (CaliforniaCalendarSpan* self);
	CaliforniaCalendarDate* (*get_end_date) (CaliforniaCalendarSpan* self);
};

struct _CaliforniaCollectionSimpleIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (CaliforniaCollectionSimpleIterator* self);
	gpointer (*get) (CaliforniaCollectionSimpleIterator* self);
};

struct _CaliforniaCollectionSimpleIterableIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (CaliforniaCollectionSimpleIterable* self);
	GBoxedCopyFunc (*get_g_dup_func) (CaliforniaCollectionSimpleIterable* self);
	GDestroyNotify (*get_g_destroy_func) (CaliforniaCollectionSimpleIterable* self);
	CaliforniaCollectionSimpleIterator* (*iterator) (CaliforniaCollectionSimpleIterable* self);
};

struct _CaliforniaCalendarUnit {
	CaliforniaCalendarSpan parent_instance;
	CaliforniaCalendarUnitPrivate * priv;
};

struct _CaliforniaCalendarUnitClass {
	CaliforniaCalendarSpanClass parent_class;
	gpointer (*adjust) (CaliforniaCalendarUnit* self, gint quantity);
	gint (*difference) (CaliforniaCalendarUnit* self, gconstpointer other);
};

struct _CaliforniaCalendarWeek {
	CaliforniaCalendarUnit parent_instance;
	CaliforniaCalendarWeekPrivate * priv;
};

struct _CaliforniaCalendarWeekClass {
	CaliforniaCalendarUnitClass parent_class;
};

typedef enum  {
	CALIFORNIA_CALENDAR_FIRST_OF_WEEK_MONDAY,
	CALIFORNIA_CALENDAR_FIRST_OF_WEEK_SUNDAY
} CaliforniaCalendarFirstOfWeek;

struct _CaliforniaCalendarWeekPrivate {
	gint _week_of_month;
	gint _week_of_year;
	CaliforniaCalendarMonthOfYear* _month_of_year;
	CaliforniaCalendarFirstOfWeek _first_of_week;
};

typedef enum  {
	CALIFORNIA_CALENDAR_DATE_UNIT_DAY,
	CALIFORNIA_CALENDAR_DATE_UNIT_WEEK,
	CALIFORNIA_CALENDAR_DATE_UNIT_MONTH,
	CALIFORNIA_CALENDAR_DATE_UNIT_YEAR
} CaliforniaCalendarDateUnit;


static gpointer california_calendar_week_parent_class = NULL;
static GeeComparableIface* california_calendar_week_gee_comparable_parent_iface = NULL;
static GeeHashableIface* california_calendar_week_gee_hashable_parent_iface = NULL;

GType california_base_object_get_type (void) G_GNUC_CONST;
GType california_calendar_span_get_type (void) G_GNUC_CONST;
GType california_calendar_unit_get_type (void) G_GNUC_CONST;
GType california_calendar_date_get_type (void) G_GNUC_CONST;
GType california_collection_simple_iterator_get_type (void) G_GNUC_CONST;
GType california_collection_simple_iterable_get_type (void) G_GNUC_CONST;
GType california_calendar_week_get_type (void) G_GNUC_CONST;
GType california_calendar_month_of_year_get_type (void) G_GNUC_CONST;
GType california_calendar_first_of_week_get_type (void) G_GNUC_CONST;
#define CALIFORNIA_CALENDAR_WEEK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CALIFORNIA_CALENDAR_TYPE_WEEK, CaliforniaCalendarWeekPrivate))
enum  {
	CALIFORNIA_CALENDAR_WEEK_DUMMY_PROPERTY,
	CALIFORNIA_CALENDAR_WEEK_WEEK_OF_MONTH,
	CALIFORNIA_CALENDAR_WEEK_WEEK_OF_YEAR,
	CALIFORNIA_CALENDAR_WEEK_MONTH_OF_YEAR,
	CALIFORNIA_CALENDAR_WEEK_FIRST_OF_WEEK
};
CaliforniaCalendarWeek* california_calendar_week_new (CaliforniaCalendarDate* start, CaliforniaCalendarDate* end, gint week_of_month, gint week_of_year, CaliforniaCalendarMonthOfYear* month_of_year, CaliforniaCalendarFirstOfWeek first_of_week);
CaliforniaCalendarWeek* california_calendar_week_construct (GType object_type, CaliforniaCalendarDate* start, CaliforniaCalendarDate* end, gint week_of_month, gint week_of_year, CaliforniaCalendarMonthOfYear* month_of_year, CaliforniaCalendarFirstOfWeek first_of_week);
GType california_calendar_date_unit_get_type (void) G_GNUC_CONST;
CaliforniaCalendarUnit* california_calendar_unit_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, CaliforniaCalendarDateUnit date_unit, CaliforniaCalendarDate* start_date, CaliforniaCalendarDate* end_date);
static void california_calendar_week_set_week_of_month (CaliforniaCalendarWeek* self, gint value);
static void california_calendar_week_set_week_of_year (CaliforniaCalendarWeek* self, gint value);
static void california_calendar_week_set_month_of_year (CaliforniaCalendarWeek* self, CaliforniaCalendarMonthOfYear* value);
static void california_calendar_week_set_first_of_week (CaliforniaCalendarWeek* self, CaliforniaCalendarFirstOfWeek value);
static CaliforniaCalendarWeek* california_calendar_week_real_adjust (CaliforniaCalendarUnit* base, gint quantity);
CaliforniaCalendarDate* california_calendar_span_get_start_date (CaliforniaCalendarSpan* self);
CaliforniaCalendarDate* california_calendar_date_adjust_by (CaliforniaCalendarDate* self, gint quantity, CaliforniaCalendarDateUnit unit);
CaliforniaCalendarWeek* california_calendar_date_week_of (CaliforniaCalendarDate* self, CaliforniaCalendarFirstOfWeek first);
CaliforniaCalendarFirstOfWeek california_calendar_week_get_first_of_week (CaliforniaCalendarWeek* self);
static gint california_calendar_week_real_difference (CaliforniaCalendarUnit* base, CaliforniaCalendarWeek* other);
gpointer california_calendar_unit_previous (CaliforniaCalendarUnit* self);
gpointer california_calendar_unit_next (CaliforniaCalendarUnit* self);
static gint california_calendar_week_real_compare_to (GeeComparable* base, CaliforniaCalendarWeek* other);
static gboolean california_calendar_week_real_equal_to (GeeHashable* base, CaliforniaCalendarWeek* other);
static guint california_calendar_week_real_hash (GeeHashable* base);
CaliforniaCalendarMonthOfYear* california_calendar_week_get_month_of_year (CaliforniaCalendarWeek* self);
gint california_calendar_week_get_week_of_year (CaliforniaCalendarWeek* self);
static gchar* california_calendar_week_real_to_string (CaliforniaBaseObject* base);
gchar* california_base_object_to_string (CaliforniaBaseObject* self);
GType california_calendar_unit_span_get_type (void) G_GNUC_CONST;
GType california_calendar_date_span_get_type (void) G_GNUC_CONST;
CaliforniaCalendarDateSpan* california_calendar_span_to_date_span (CaliforniaCalendarSpan* self);
gint california_calendar_week_get_week_of_month (CaliforniaCalendarWeek* self);
static void california_calendar_week_finalize (GObject* obj);
static void _vala_california_calendar_week_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_california_calendar_week_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
     * Important: Week does not validate that start and end are in fact the start and end of the
     * calendar week.
     */
CaliforniaCalendarWeek* california_calendar_week_construct (GType object_type, CaliforniaCalendarDate* start, CaliforniaCalendarDate* end, gint week_of_month, gint week_of_year, CaliforniaCalendarMonthOfYear* month_of_year, CaliforniaCalendarFirstOfWeek first_of_week) {
	CaliforniaCalendarWeek * self = NULL;
	CaliforniaCalendarDate* _tmp0_ = NULL;
	CaliforniaCalendarDate* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	CaliforniaCalendarMonthOfYear* _tmp4_ = NULL;
	CaliforniaCalendarFirstOfWeek _tmp5_ = 0;
#line 53 "/home/jim/git/california/src/calendar/calendar-week.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (start), NULL);
#line 53 "/home/jim/git/california/src/calendar/calendar-week.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (end), NULL);
#line 53 "/home/jim/git/california/src/calendar/calendar-week.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_MONTH_OF_YEAR (month_of_year), NULL);
#line 55 "/home/jim/git/california/src/calendar/calendar-week.vala"
	_tmp0_ = start;
#line 55 "/home/jim/git/california/src/calendar/calendar-week.vala"
	_tmp1_ = end;
#line 55 "/home/jim/git/california/src/calendar/calendar-week.vala"
	self = (CaliforniaCalendarWeek*) california_calendar_unit_construct (object_type, CALIFORNIA_CALENDAR_TYPE_WEEK, (GBoxedCopyFunc) g_object_ref, g_object_unref, CALIFORNIA_CALENDAR_DATE_UNIT_WEEK, _tmp0_, _tmp1_);
#line 57 "/home/jim/git/california/src/calendar/calendar-week.vala"
	_tmp2_ = week_of_month;
#line 57 "/home/jim/git/california/src/calendar/calendar-week.vala"
	california_calendar_week_set_week_of_month (self, _tmp2_);
#line 58 "/home/jim/git/california/src/calendar/calendar-week.vala"
	_tmp3_ = week_of_year;
#line 58 "/home/jim/git/california/src/calendar/calendar-week.vala"
	california_calendar_week_set_week_of_year (self, _tmp3_);
#line 59 "/home/jim/git/california/src/calendar/calendar-week.vala"
	_tmp4_ = month_of_year;
#line 59 "/home/jim/git/california/src/calendar/calendar-week.vala"
	california_calendar_week_set_month_of_year (self, _tmp4_);
#line 60 "/home/jim/git/california/src/calendar/calendar-week.vala"
	_tmp5_ = first_of_week;
#line 60 "/home/jim/git/california/src/calendar/calendar-week.vala"
	california_calendar_week_set_first_of_week (self, _tmp5_);
#line 53 "/home/jim/git/california/src/calendar/calendar-week.vala"
	return self;
#line 294 "calendar-week.c"
}


CaliforniaCalendarWeek* california_calendar_week_new (CaliforniaCalendarDate* start, CaliforniaCalendarDate* end, gint week_of_month, gint week_of_year, CaliforniaCalendarMonthOfYear* month_of_year, CaliforniaCalendarFirstOfWeek first_of_week) {
#line 53 "/home/jim/git/california/src/calendar/calendar-week.vala"
	return california_calendar_week_construct (CALIFORNIA_CALENDAR_TYPE_WEEK, start, end, week_of_month, week_of_year, month_of_year, first_of_week);
#line 301 "calendar-week.c"
}


/**
     * @inheritDoc
     */
static CaliforniaCalendarWeek* california_calendar_week_real_adjust (CaliforniaCalendarUnit* base, gint quantity) {
	CaliforniaCalendarWeek * self;
	CaliforniaCalendarWeek* result = NULL;
	CaliforniaCalendarDate* _tmp0_ = NULL;
	CaliforniaCalendarDate* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	CaliforniaCalendarDate* _tmp3_ = NULL;
	CaliforniaCalendarDate* _tmp4_ = NULL;
	CaliforniaCalendarFirstOfWeek _tmp5_ = 0;
	CaliforniaCalendarWeek* _tmp6_ = NULL;
	CaliforniaCalendarWeek* _tmp7_ = NULL;
#line 66 "/home/jim/git/california/src/calendar/calendar-week.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_WEEK, CaliforniaCalendarWeek);
#line 67 "/home/jim/git/california/src/calendar/calendar-week.vala"
	_tmp0_ = california_calendar_span_get_start_date (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 67 "/home/jim/git/california/src/calendar/calendar-week.vala"
	_tmp1_ = _tmp0_;
#line 67 "/home/jim/git/california/src/calendar/calendar-week.vala"
	_tmp2_ = quantity;
#line 67 "/home/jim/git/california/src/calendar/calendar-week.vala"
	_tmp3_ = california_calendar_date_adjust_by (_tmp1_, _tmp2_, CALIFORNIA_CALENDAR_DATE_UNIT_WEEK);
#line 67 "/home/jim/git/california/src/calendar/calendar-week.vala"
	_tmp4_ = _tmp3_;
#line 67 "/home/jim/git/california/src/calendar/calendar-week.vala"
	_tmp5_ = self->priv->_first_of_week;
#line 67 "/home/jim/git/california/src/calendar/calendar-week.vala"
	_tmp6_ = california_calendar_date_week_of (_tmp4_, _tmp5_);
#line 67 "/home/jim/git/california/src/calendar/calendar-week.vala"
	_tmp7_ = _tmp6_;
#line 67 "/home/jim/git/california/src/calendar/calendar-week.vala"
	_g_object_unref0 (_tmp4_);
#line 67 "/home/jim/git/california/src/calendar/calendar-week.vala"
	result = _tmp7_;
#line 67 "/home/jim/git/california/src/calendar/calendar-week.vala"
	return result;
#line 343 "calendar-week.c"
}


/**
     * @inheritDoc
     */
static gpointer _g_object_ref0 (gpointer self) {
#line 80 "/home/jim/git/california/src/calendar/calendar-week.vala"
	return self ? g_object_ref (self) : NULL;
#line 353 "calendar-week.c"
}


static gint california_calendar_week_real_difference (CaliforniaCalendarUnit* base, CaliforniaCalendarWeek* other) {
	CaliforniaCalendarWeek * self;
	gint result = 0;
	gint compare = 0;
	CaliforniaCalendarWeek* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint count = 0;
	CaliforniaCalendarWeek* current = NULL;
	CaliforniaCalendarWeek* _tmp3_ = NULL;
#line 73 "/home/jim/git/california/src/calendar/calendar-week.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_WEEK, CaliforniaCalendarWeek);
#line 73 "/home/jim/git/california/src/calendar/calendar-week.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_WEEK (other), 0);
#line 74 "/home/jim/git/california/src/calendar/calendar-week.vala"
	_tmp0_ = other;
#line 74 "/home/jim/git/california/src/calendar/calendar-week.vala"
	_tmp1_ = gee_comparable_compare_to (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COMPARABLE, GeeComparable), _tmp0_);
#line 74 "/home/jim/git/california/src/calendar/calendar-week.vala"
	compare = _tmp1_;
#line 75 "/home/jim/git/california/src/calendar/calendar-week.vala"
	_tmp2_ = compare;
#line 75 "/home/jim/git/california/src/calendar/calendar-week.vala"
	if (_tmp2_ == 0) {
#line 76 "/home/jim/git/california/src/calendar/calendar-week.vala"
		result = 0;
#line 76 "/home/jim/git/california/src/calendar/calendar-week.vala"
		return result;
#line 385 "calendar-week.c"
	}
#line 79 "/home/jim/git/california/src/calendar/calendar-week.vala"
	count = 0;
#line 80 "/home/jim/git/california/src/calendar/calendar-week.vala"
	_tmp3_ = _g_object_ref0 (self);
#line 80 "/home/jim/git/california/src/calendar/calendar-week.vala"
	current = _tmp3_;
#line 393 "calendar-week.c"
	{
		gboolean _tmp4_ = FALSE;
#line 81 "/home/jim/git/california/src/calendar/calendar-week.vala"
		_tmp4_ = TRUE;
#line 81 "/home/jim/git/california/src/calendar/calendar-week.vala"
		while (TRUE) {
#line 400 "calendar-week.c"
			CaliforniaCalendarWeek* _tmp5_ = NULL;
			gint _tmp6_ = 0;
			CaliforniaCalendarWeek* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			CaliforniaCalendarWeek* _tmp15_ = NULL;
			CaliforniaCalendarWeek* _tmp16_ = NULL;
			gboolean _tmp17_ = FALSE;
#line 81 "/home/jim/git/california/src/calendar/calendar-week.vala"
			if (!_tmp4_) {
#line 412 "calendar-week.c"
			}
#line 81 "/home/jim/git/california/src/calendar/calendar-week.vala"
			_tmp4_ = FALSE;
#line 82 "/home/jim/git/california/src/calendar/calendar-week.vala"
			_tmp6_ = compare;
#line 82 "/home/jim/git/california/src/calendar/calendar-week.vala"
			if (_tmp6_ > 0) {
#line 420 "calendar-week.c"
				CaliforniaCalendarWeek* _tmp7_ = NULL;
				gpointer _tmp8_ = NULL;
#line 82 "/home/jim/git/california/src/calendar/calendar-week.vala"
				_tmp7_ = current;
#line 82 "/home/jim/git/california/src/calendar/calendar-week.vala"
				_tmp8_ = california_calendar_unit_previous (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnit));
#line 82 "/home/jim/git/california/src/calendar/calendar-week.vala"
				_g_object_unref0 (_tmp5_);
#line 82 "/home/jim/git/california/src/calendar/calendar-week.vala"
				_tmp5_ = (CaliforniaCalendarWeek*) _tmp8_;
#line 431 "calendar-week.c"
			} else {
				CaliforniaCalendarWeek* _tmp9_ = NULL;
				gpointer _tmp10_ = NULL;
#line 82 "/home/jim/git/california/src/calendar/calendar-week.vala"
				_tmp9_ = current;
#line 82 "/home/jim/git/california/src/calendar/calendar-week.vala"
				_tmp10_ = california_calendar_unit_next (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnit));
#line 82 "/home/jim/git/california/src/calendar/calendar-week.vala"
				_g_object_unref0 (_tmp5_);
#line 82 "/home/jim/git/california/src/calendar/calendar-week.vala"
				_tmp5_ = (CaliforniaCalendarWeek*) _tmp10_;
#line 443 "calendar-week.c"
			}
#line 82 "/home/jim/git/california/src/calendar/calendar-week.vala"
			_tmp11_ = _g_object_ref0 (_tmp5_);
#line 82 "/home/jim/git/california/src/calendar/calendar-week.vala"
			_g_object_unref0 (current);
#line 82 "/home/jim/git/california/src/calendar/calendar-week.vala"
			current = _tmp11_;
#line 83 "/home/jim/git/california/src/calendar/calendar-week.vala"
			_tmp13_ = compare;
#line 83 "/home/jim/git/california/src/calendar/calendar-week.vala"
			if (_tmp13_ > 0) {
#line 83 "/home/jim/git/california/src/calendar/calendar-week.vala"
				_tmp12_ = -1;
#line 457 "calendar-week.c"
			} else {
#line 83 "/home/jim/git/california/src/calendar/calendar-week.vala"
				_tmp12_ = 1;
#line 461 "calendar-week.c"
			}
#line 83 "/home/jim/git/california/src/calendar/calendar-week.vala"
			_tmp14_ = count;
#line 83 "/home/jim/git/california/src/calendar/calendar-week.vala"
			count = _tmp14_ + _tmp12_;
#line 85 "/home/jim/git/california/src/calendar/calendar-week.vala"
			_tmp15_ = current;
#line 85 "/home/jim/git/california/src/calendar/calendar-week.vala"
			_tmp16_ = other;
#line 85 "/home/jim/git/california/src/calendar/calendar-week.vala"
			_tmp17_ = gee_hashable_equal_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_HASHABLE, GeeHashable), _tmp16_);
#line 85 "/home/jim/git/california/src/calendar/calendar-week.vala"
			if (_tmp17_) {
#line 86 "/home/jim/git/california/src/calendar/calendar-week.vala"
				result = count;
#line 86 "/home/jim/git/california/src/calendar/calendar-week.vala"
				_g_object_unref0 (_tmp5_);
#line 86 "/home/jim/git/california/src/calendar/calendar-week.vala"
				_g_object_unref0 (current);
#line 86 "/home/jim/git/california/src/calendar/calendar-week.vala"
				return result;
#line 483 "calendar-week.c"
			}
#line 81 "/home/jim/git/california/src/calendar/calendar-week.vala"
			_g_object_unref0 (_tmp5_);
#line 487 "calendar-week.c"
		}
	}
#line 73 "/home/jim/git/california/src/calendar/calendar-week.vala"
	_g_object_unref0 (current);
#line 492 "calendar-week.c"
}


static gint california_calendar_week_real_compare_to (GeeComparable* base, CaliforniaCalendarWeek* other) {
	CaliforniaCalendarWeek * self;
	gint result = 0;
	gint _tmp0_ = 0;
	CaliforniaCalendarWeek* _tmp1_ = NULL;
#line 90 "/home/jim/git/california/src/calendar/calendar-week.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_WEEK, CaliforniaCalendarWeek);
#line 90 "/home/jim/git/california/src/calendar/calendar-week.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_WEEK (other), 0);
#line 91 "/home/jim/git/california/src/calendar/calendar-week.vala"
	_tmp1_ = other;
#line 91 "/home/jim/git/california/src/calendar/calendar-week.vala"
	if (self != _tmp1_) {
#line 509 "calendar-week.c"
		CaliforniaCalendarDate* _tmp2_ = NULL;
		CaliforniaCalendarDate* _tmp3_ = NULL;
		CaliforniaCalendarWeek* _tmp4_ = NULL;
		CaliforniaCalendarDate* _tmp5_ = NULL;
		CaliforniaCalendarDate* _tmp6_ = NULL;
		gint _tmp7_ = 0;
#line 91 "/home/jim/git/california/src/calendar/calendar-week.vala"
		_tmp2_ = california_calendar_span_get_start_date (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 91 "/home/jim/git/california/src/calendar/calendar-week.vala"
		_tmp3_ = _tmp2_;
#line 91 "/home/jim/git/california/src/calendar/calendar-week.vala"
		_tmp4_ = other;
#line 91 "/home/jim/git/california/src/calendar/calendar-week.vala"
		_tmp5_ = california_calendar_span_get_start_date (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 91 "/home/jim/git/california/src/calendar/calendar-week.vala"
		_tmp6_ = _tmp5_;
#line 91 "/home/jim/git/california/src/calendar/calendar-week.vala"
		_tmp7_ = gee_comparable_compare_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COMPARABLE, GeeComparable), _tmp6_);
#line 91 "/home/jim/git/california/src/calendar/calendar-week.vala"
		_tmp0_ = _tmp7_;
#line 530 "calendar-week.c"
	} else {
#line 91 "/home/jim/git/california/src/calendar/calendar-week.vala"
		_tmp0_ = 0;
#line 534 "calendar-week.c"
	}
#line 91 "/home/jim/git/california/src/calendar/calendar-week.vala"
	result = _tmp0_;
#line 91 "/home/jim/git/california/src/calendar/calendar-week.vala"
	return result;
#line 540 "calendar-week.c"
}


static gboolean california_calendar_week_real_equal_to (GeeHashable* base, CaliforniaCalendarWeek* other) {
	CaliforniaCalendarWeek * self;
	gboolean result = FALSE;
	CaliforniaCalendarWeek* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 94 "/home/jim/git/california/src/calendar/calendar-week.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_WEEK, CaliforniaCalendarWeek);
#line 94 "/home/jim/git/california/src/calendar/calendar-week.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_WEEK (other), FALSE);
#line 95 "/home/jim/git/california/src/calendar/calendar-week.vala"
	_tmp0_ = other;
#line 95 "/home/jim/git/california/src/calendar/calendar-week.vala"
	_tmp1_ = gee_comparable_compare_to (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COMPARABLE, GeeComparable), _tmp0_);
#line 95 "/home/jim/git/california/src/calendar/calendar-week.vala"
	result = _tmp1_ == 0;
#line 95 "/home/jim/git/california/src/calendar/calendar-week.vala"
	return result;
#line 561 "calendar-week.c"
}


static guint california_calendar_week_real_hash (GeeHashable* base) {
	CaliforniaCalendarWeek * self;
	guint result = 0U;
	CaliforniaCalendarMonthOfYear* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	gint _tmp2_ = 0;
#line 98 "/home/jim/git/california/src/calendar/calendar-week.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_WEEK, CaliforniaCalendarWeek);
#line 100 "/home/jim/git/california/src/calendar/calendar-week.vala"
	_tmp0_ = self->priv->_month_of_year;
#line 100 "/home/jim/git/california/src/calendar/calendar-week.vala"
	_tmp1_ = gee_hashable_hash (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_HASHABLE, GeeHashable));
#line 100 "/home/jim/git/california/src/calendar/calendar-week.vala"
	_tmp2_ = self->priv->_week_of_year;
#line 100 "/home/jim/git/california/src/calendar/calendar-week.vala"
	result = (_tmp1_ << 6) | _tmp2_;
#line 100 "/home/jim/git/california/src/calendar/calendar-week.vala"
	return result;
#line 583 "calendar-week.c"
}


static gchar* california_calendar_week_real_to_string (CaliforniaBaseObject* base) {
	CaliforniaCalendarWeek * self;
	gchar* result = NULL;
	gint _tmp0_ = 0;
	CaliforniaCalendarMonthOfYear* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	CaliforniaCalendarDateSpan* _tmp4_ = NULL;
	CaliforniaCalendarDateSpan* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
#line 103 "/home/jim/git/california/src/calendar/calendar-week.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_WEEK, CaliforniaCalendarWeek);
#line 104 "/home/jim/git/california/src/calendar/calendar-week.vala"
	_tmp0_ = self->priv->_week_of_year;
#line 104 "/home/jim/git/california/src/calendar/calendar-week.vala"
	_tmp1_ = self->priv->_month_of_year;
#line 104 "/home/jim/git/california/src/calendar/calendar-week.vala"
	_tmp2_ = california_base_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject));
#line 104 "/home/jim/git/california/src/calendar/calendar-week.vala"
	_tmp3_ = _tmp2_;
#line 104 "/home/jim/git/california/src/calendar/calendar-week.vala"
	_tmp4_ = california_calendar_span_to_date_span (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 104 "/home/jim/git/california/src/calendar/calendar-week.vala"
	_tmp5_ = _tmp4_;
#line 104 "/home/jim/git/california/src/calendar/calendar-week.vala"
	_tmp6_ = california_base_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject));
#line 104 "/home/jim/git/california/src/calendar/calendar-week.vala"
	_tmp7_ = _tmp6_;
#line 104 "/home/jim/git/california/src/calendar/calendar-week.vala"
	_tmp8_ = g_strdup_printf ("week %d of %s (%s)", _tmp0_, _tmp3_, _tmp7_);
#line 104 "/home/jim/git/california/src/calendar/calendar-week.vala"
	_tmp9_ = _tmp8_;
#line 104 "/home/jim/git/california/src/calendar/calendar-week.vala"
	_g_free0 (_tmp7_);
#line 104 "/home/jim/git/california/src/calendar/calendar-week.vala"
	_g_object_unref0 (_tmp5_);
#line 104 "/home/jim/git/california/src/calendar/calendar-week.vala"
	_g_free0 (_tmp3_);
#line 104 "/home/jim/git/california/src/calendar/calendar-week.vala"
	result = _tmp9_;
#line 104 "/home/jim/git/california/src/calendar/calendar-week.vala"
	return result;
#line 632 "calendar-week.c"
}


gint california_calendar_week_get_week_of_month (CaliforniaCalendarWeek* self) {
	gint result;
	gint _tmp0_ = 0;
#line 25 "/home/jim/git/california/src/calendar/calendar-week.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_WEEK (self), 0);
#line 25 "/home/jim/git/california/src/calendar/calendar-week.vala"
	_tmp0_ = self->priv->_week_of_month;
#line 25 "/home/jim/git/california/src/calendar/calendar-week.vala"
	result = _tmp0_;
#line 25 "/home/jim/git/california/src/calendar/calendar-week.vala"
	return result;
#line 647 "calendar-week.c"
}


static void california_calendar_week_set_week_of_month (CaliforniaCalendarWeek* self, gint value) {
	gint _tmp0_ = 0;
#line 25 "/home/jim/git/california/src/calendar/calendar-week.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_WEEK (self));
#line 25 "/home/jim/git/california/src/calendar/calendar-week.vala"
	_tmp0_ = value;
#line 25 "/home/jim/git/california/src/calendar/calendar-week.vala"
	self->priv->_week_of_month = _tmp0_;
#line 25 "/home/jim/git/california/src/calendar/calendar-week.vala"
	g_object_notify ((GObject *) self, "week-of-month");
#line 661 "calendar-week.c"
}


gint california_calendar_week_get_week_of_year (CaliforniaCalendarWeek* self) {
	gint result;
	gint _tmp0_ = 0;
#line 34 "/home/jim/git/california/src/calendar/calendar-week.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_WEEK (self), 0);
#line 34 "/home/jim/git/california/src/calendar/calendar-week.vala"
	_tmp0_ = self->priv->_week_of_year;
#line 34 "/home/jim/git/california/src/calendar/calendar-week.vala"
	result = _tmp0_;
#line 34 "/home/jim/git/california/src/calendar/calendar-week.vala"
	return result;
#line 676 "calendar-week.c"
}


static void california_calendar_week_set_week_of_year (CaliforniaCalendarWeek* self, gint value) {
	gint _tmp0_ = 0;
#line 34 "/home/jim/git/california/src/calendar/calendar-week.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_WEEK (self));
#line 34 "/home/jim/git/california/src/calendar/calendar-week.vala"
	_tmp0_ = value;
#line 34 "/home/jim/git/california/src/calendar/calendar-week.vala"
	self->priv->_week_of_year = _tmp0_;
#line 34 "/home/jim/git/california/src/calendar/calendar-week.vala"
	g_object_notify ((GObject *) self, "week-of-year");
#line 690 "calendar-week.c"
}


CaliforniaCalendarMonthOfYear* california_calendar_week_get_month_of_year (CaliforniaCalendarWeek* self) {
	CaliforniaCalendarMonthOfYear* result;
	CaliforniaCalendarMonthOfYear* _tmp0_ = NULL;
#line 42 "/home/jim/git/california/src/calendar/calendar-week.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_WEEK (self), NULL);
#line 42 "/home/jim/git/california/src/calendar/calendar-week.vala"
	_tmp0_ = self->priv->_month_of_year;
#line 42 "/home/jim/git/california/src/calendar/calendar-week.vala"
	result = _tmp0_;
#line 42 "/home/jim/git/california/src/calendar/calendar-week.vala"
	return result;
#line 705 "calendar-week.c"
}


static void california_calendar_week_set_month_of_year (CaliforniaCalendarWeek* self, CaliforniaCalendarMonthOfYear* value) {
	CaliforniaCalendarMonthOfYear* _tmp0_ = NULL;
	CaliforniaCalendarMonthOfYear* _tmp1_ = NULL;
#line 42 "/home/jim/git/california/src/calendar/calendar-week.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_WEEK (self));
#line 42 "/home/jim/git/california/src/calendar/calendar-week.vala"
	_tmp0_ = value;
#line 42 "/home/jim/git/california/src/calendar/calendar-week.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 42 "/home/jim/git/california/src/calendar/calendar-week.vala"
	_g_object_unref0 (self->priv->_month_of_year);
#line 42 "/home/jim/git/california/src/calendar/calendar-week.vala"
	self->priv->_month_of_year = _tmp1_;
#line 42 "/home/jim/git/california/src/calendar/calendar-week.vala"
	g_object_notify ((GObject *) self, "month-of-year");
#line 724 "calendar-week.c"
}


CaliforniaCalendarFirstOfWeek california_calendar_week_get_first_of_week (CaliforniaCalendarWeek* self) {
	CaliforniaCalendarFirstOfWeek result;
	CaliforniaCalendarFirstOfWeek _tmp0_ = 0;
#line 47 "/home/jim/git/california/src/calendar/calendar-week.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_WEEK (self), 0);
#line 47 "/home/jim/git/california/src/calendar/calendar-week.vala"
	_tmp0_ = self->priv->_first_of_week;
#line 47 "/home/jim/git/california/src/calendar/calendar-week.vala"
	result = _tmp0_;
#line 47 "/home/jim/git/california/src/calendar/calendar-week.vala"
	return result;
#line 739 "calendar-week.c"
}


static void california_calendar_week_set_first_of_week (CaliforniaCalendarWeek* self, CaliforniaCalendarFirstOfWeek value) {
	CaliforniaCalendarFirstOfWeek _tmp0_ = 0;
#line 47 "/home/jim/git/california/src/calendar/calendar-week.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_WEEK (self));
#line 47 "/home/jim/git/california/src/calendar/calendar-week.vala"
	_tmp0_ = value;
#line 47 "/home/jim/git/california/src/calendar/calendar-week.vala"
	self->priv->_first_of_week = _tmp0_;
#line 47 "/home/jim/git/california/src/calendar/calendar-week.vala"
	g_object_notify ((GObject *) self, "first-of-week");
#line 753 "calendar-week.c"
}


static void california_calendar_week_class_init (CaliforniaCalendarWeekClass * klass) {
#line 21 "/home/jim/git/california/src/calendar/calendar-week.vala"
	california_calendar_week_parent_class = g_type_class_peek_parent (klass);
#line 21 "/home/jim/git/california/src/calendar/calendar-week.vala"
	g_type_class_add_private (klass, sizeof (CaliforniaCalendarWeekPrivate));
#line 21 "/home/jim/git/california/src/calendar/calendar-week.vala"
	CALIFORNIA_CALENDAR_UNIT_CLASS (klass)->adjust = california_calendar_week_real_adjust;
#line 21 "/home/jim/git/california/src/calendar/calendar-week.vala"
	CALIFORNIA_CALENDAR_UNIT_CLASS (klass)->difference = california_calendar_week_real_difference;
#line 21 "/home/jim/git/california/src/calendar/calendar-week.vala"
	CALIFORNIA_BASE_OBJECT_CLASS (klass)->to_string = california_calendar_week_real_to_string;
#line 21 "/home/jim/git/california/src/calendar/calendar-week.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_california_calendar_week_get_property;
#line 21 "/home/jim/git/california/src/calendar/calendar-week.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_california_calendar_week_set_property;
#line 21 "/home/jim/git/california/src/calendar/calendar-week.vala"
	G_OBJECT_CLASS (klass)->finalize = california_calendar_week_finalize;
#line 774 "calendar-week.c"
	/**
	     * The one-based week of the month (1 to 6).
	     */
#line 21 "/home/jim/git/california/src/calendar/calendar-week.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_WEEK_WEEK_OF_MONTH, g_param_spec_int ("week-of-month", "week-of-month", "week-of-month", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 780 "calendar-week.c"
	/**
	     * The one-based week of the year (1 to 52).
	     *
	     * If the start of the week is before the first day of {@link month_of_year}, this value will
	     * be zero.
	     *
	     */
#line 21 "/home/jim/git/california/src/calendar/calendar-week.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_WEEK_WEEK_OF_YEAR, g_param_spec_int ("week-of-year", "week-of-year", "week-of-year", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 790 "calendar-week.c"
	/**
	     * The {@link Month} of the {@link Year} the week falls in.
	     *
	     * It's possible days within this week fall outside this Month or even this Year.  This Month
	     * and Year is what {@link week_of_the_month} and {@link week_of_the_year} refer to.
	     */
#line 21 "/home/jim/git/california/src/calendar/calendar-week.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_WEEK_MONTH_OF_YEAR, g_param_spec_object ("month-of-year", "month-of-year", "month-of-year", CALIFORNIA_CALENDAR_TYPE_MONTH_OF_YEAR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 799 "calendar-week.c"
	/**
	     * How this object defines the first day of the week.
	     */
#line 21 "/home/jim/git/california/src/calendar/calendar-week.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_WEEK_FIRST_OF_WEEK, g_param_spec_enum ("first-of-week", "first-of-week", "first-of-week", CALIFORNIA_CALENDAR_TYPE_FIRST_OF_WEEK, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 805 "calendar-week.c"
}


static void california_calendar_week_gee_comparable_interface_init (GeeComparableIface * iface) {
#line 21 "/home/jim/git/california/src/calendar/calendar-week.vala"
	california_calendar_week_gee_comparable_parent_iface = g_type_interface_peek_parent (iface);
#line 21 "/home/jim/git/california/src/calendar/calendar-week.vala"
	iface->compare_to = (gint (*)(GeeComparable*, gconstpointer)) california_calendar_week_real_compare_to;
#line 814 "calendar-week.c"
}


static void california_calendar_week_gee_hashable_interface_init (GeeHashableIface * iface) {
#line 21 "/home/jim/git/california/src/calendar/calendar-week.vala"
	california_calendar_week_gee_hashable_parent_iface = g_type_interface_peek_parent (iface);
#line 21 "/home/jim/git/california/src/calendar/calendar-week.vala"
	iface->equal_to = (gboolean (*)(GeeHashable*, gconstpointer)) california_calendar_week_real_equal_to;
#line 21 "/home/jim/git/california/src/calendar/calendar-week.vala"
	iface->hash = (guint (*)(GeeHashable*)) california_calendar_week_real_hash;
#line 825 "calendar-week.c"
}


static void california_calendar_week_instance_init (CaliforniaCalendarWeek * self) {
#line 21 "/home/jim/git/california/src/calendar/calendar-week.vala"
	self->priv = CALIFORNIA_CALENDAR_WEEK_GET_PRIVATE (self);
#line 832 "calendar-week.c"
}


static void california_calendar_week_finalize (GObject* obj) {
	CaliforniaCalendarWeek * self;
#line 21 "/home/jim/git/california/src/calendar/calendar-week.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CALIFORNIA_CALENDAR_TYPE_WEEK, CaliforniaCalendarWeek);
#line 42 "/home/jim/git/california/src/calendar/calendar-week.vala"
	_g_object_unref0 (self->priv->_month_of_year);
#line 21 "/home/jim/git/california/src/calendar/calendar-week.vala"
	G_OBJECT_CLASS (california_calendar_week_parent_class)->finalize (obj);
#line 844 "calendar-week.c"
}


/**
 * An immutable representation of a calendar week, meaning the {@link start_date} is the first
 * day of the week (as defined by {@link FirstOfWeek} and the {@link end_date) is six days after
 * that.
 *
 * As a {@link DateSpan}, it's possible for the start and end date to "bleed" into other months and
 * years.
 *
 * Due to the rigid definition of a Week, they cannot be created off-the-cuff.  Use
 * {@link Date.week_of} to obtain a Week for a particular calendar day.
 */
GType california_calendar_week_get_type (void) {
	static volatile gsize california_calendar_week_type_id__volatile = 0;
	if (g_once_init_enter (&california_calendar_week_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CaliforniaCalendarWeekClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) california_calendar_week_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CaliforniaCalendarWeek), 0, (GInstanceInitFunc) california_calendar_week_instance_init, NULL };
		static const GInterfaceInfo gee_comparable_info = { (GInterfaceInitFunc) california_calendar_week_gee_comparable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_hashable_info = { (GInterfaceInitFunc) california_calendar_week_gee_hashable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType california_calendar_week_type_id;
		california_calendar_week_type_id = g_type_register_static (CALIFORNIA_CALENDAR_TYPE_UNIT, "CaliforniaCalendarWeek", &g_define_type_info, 0);
		g_type_add_interface_static (california_calendar_week_type_id, GEE_TYPE_COMPARABLE, &gee_comparable_info);
		g_type_add_interface_static (california_calendar_week_type_id, GEE_TYPE_HASHABLE, &gee_hashable_info);
		g_once_init_leave (&california_calendar_week_type_id__volatile, california_calendar_week_type_id);
	}
	return california_calendar_week_type_id__volatile;
}


static void _vala_california_calendar_week_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	CaliforniaCalendarWeek * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_CALENDAR_TYPE_WEEK, CaliforniaCalendarWeek);
#line 21 "/home/jim/git/california/src/calendar/calendar-week.vala"
	switch (property_id) {
#line 21 "/home/jim/git/california/src/calendar/calendar-week.vala"
		case CALIFORNIA_CALENDAR_WEEK_WEEK_OF_MONTH:
#line 21 "/home/jim/git/california/src/calendar/calendar-week.vala"
		g_value_set_int (value, california_calendar_week_get_week_of_month (self));
#line 21 "/home/jim/git/california/src/calendar/calendar-week.vala"
		break;
#line 21 "/home/jim/git/california/src/calendar/calendar-week.vala"
		case CALIFORNIA_CALENDAR_WEEK_WEEK_OF_YEAR:
#line 21 "/home/jim/git/california/src/calendar/calendar-week.vala"
		g_value_set_int (value, california_calendar_week_get_week_of_year (self));
#line 21 "/home/jim/git/california/src/calendar/calendar-week.vala"
		break;
#line 21 "/home/jim/git/california/src/calendar/calendar-week.vala"
		case CALIFORNIA_CALENDAR_WEEK_MONTH_OF_YEAR:
#line 21 "/home/jim/git/california/src/calendar/calendar-week.vala"
		g_value_set_object (value, california_calendar_week_get_month_of_year (self));
#line 21 "/home/jim/git/california/src/calendar/calendar-week.vala"
		break;
#line 21 "/home/jim/git/california/src/calendar/calendar-week.vala"
		case CALIFORNIA_CALENDAR_WEEK_FIRST_OF_WEEK:
#line 21 "/home/jim/git/california/src/calendar/calendar-week.vala"
		g_value_set_enum (value, california_calendar_week_get_first_of_week (self));
#line 21 "/home/jim/git/california/src/calendar/calendar-week.vala"
		break;
#line 904 "calendar-week.c"
		default:
#line 21 "/home/jim/git/california/src/calendar/calendar-week.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 21 "/home/jim/git/california/src/calendar/calendar-week.vala"
		break;
#line 910 "calendar-week.c"
	}
}


static void _vala_california_calendar_week_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	CaliforniaCalendarWeek * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_CALENDAR_TYPE_WEEK, CaliforniaCalendarWeek);
#line 21 "/home/jim/git/california/src/calendar/calendar-week.vala"
	switch (property_id) {
#line 21 "/home/jim/git/california/src/calendar/calendar-week.vala"
		case CALIFORNIA_CALENDAR_WEEK_WEEK_OF_MONTH:
#line 21 "/home/jim/git/california/src/calendar/calendar-week.vala"
		california_calendar_week_set_week_of_month (self, g_value_get_int (value));
#line 21 "/home/jim/git/california/src/calendar/calendar-week.vala"
		break;
#line 21 "/home/jim/git/california/src/calendar/calendar-week.vala"
		case CALIFORNIA_CALENDAR_WEEK_WEEK_OF_YEAR:
#line 21 "/home/jim/git/california/src/calendar/calendar-week.vala"
		california_calendar_week_set_week_of_year (self, g_value_get_int (value));
#line 21 "/home/jim/git/california/src/calendar/calendar-week.vala"
		break;
#line 21 "/home/jim/git/california/src/calendar/calendar-week.vala"
		case CALIFORNIA_CALENDAR_WEEK_MONTH_OF_YEAR:
#line 21 "/home/jim/git/california/src/calendar/calendar-week.vala"
		california_calendar_week_set_month_of_year (self, g_value_get_object (value));
#line 21 "/home/jim/git/california/src/calendar/calendar-week.vala"
		break;
#line 21 "/home/jim/git/california/src/calendar/calendar-week.vala"
		case CALIFORNIA_CALENDAR_WEEK_FIRST_OF_WEEK:
#line 21 "/home/jim/git/california/src/calendar/calendar-week.vala"
		california_calendar_week_set_first_of_week (self, g_value_get_enum (value));
#line 21 "/home/jim/git/california/src/calendar/calendar-week.vala"
		break;
#line 944 "calendar-week.c"
		default:
#line 21 "/home/jim/git/california/src/calendar/calendar-week.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 21 "/home/jim/git/california/src/calendar/calendar-week.vala"
		break;
#line 950 "calendar-week.c"
	}
}



