/* calendar-span.c generated by valac 0.24.0, the Vala compiler
 * generated from calendar-span.vala, do not modify */

/* Copyright 2014 Yorba Foundation
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>


#define CALIFORNIA_TYPE_BASE_OBJECT (california_base_object_get_type ())
#define CALIFORNIA_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject))
#define CALIFORNIA_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))
#define CALIFORNIA_IS_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_IS_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_BASE_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))

typedef struct _CaliforniaBaseObject CaliforniaBaseObject;
typedef struct _CaliforniaBaseObjectClass CaliforniaBaseObjectClass;

#define CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERABLE (california_collection_simple_iterable_get_type ())
#define CALIFORNIA_COLLECTION_SIMPLE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERABLE, CaliforniaCollectionSimpleIterable))
#define CALIFORNIA_COLLECTION_IS_SIMPLE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERABLE))
#define CALIFORNIA_COLLECTION_SIMPLE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERABLE, CaliforniaCollectionSimpleIterableIface))

typedef struct _CaliforniaCollectionSimpleIterable CaliforniaCollectionSimpleIterable;
typedef struct _CaliforniaCollectionSimpleIterableIface CaliforniaCollectionSimpleIterableIface;

#define CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERATOR (california_collection_simple_iterator_get_type ())
#define CALIFORNIA_COLLECTION_SIMPLE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERATOR, CaliforniaCollectionSimpleIterator))
#define CALIFORNIA_COLLECTION_IS_SIMPLE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERATOR))
#define CALIFORNIA_COLLECTION_SIMPLE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERATOR, CaliforniaCollectionSimpleIteratorIface))

typedef struct _CaliforniaCollectionSimpleIterator CaliforniaCollectionSimpleIterator;
typedef struct _CaliforniaCollectionSimpleIteratorIface CaliforniaCollectionSimpleIteratorIface;

#define CALIFORNIA_CALENDAR_TYPE_SPAN (california_calendar_span_get_type ())
#define CALIFORNIA_CALENDAR_SPAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan))
#define CALIFORNIA_CALENDAR_IS_SPAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_SPAN))
#define CALIFORNIA_CALENDAR_SPAN_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpanIface))

typedef struct _CaliforniaCalendarSpan CaliforniaCalendarSpan;
typedef struct _CaliforniaCalendarSpanIface CaliforniaCalendarSpanIface;

#define CALIFORNIA_CALENDAR_TYPE_DATE (california_calendar_date_get_type ())
#define CALIFORNIA_CALENDAR_DATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDate))
#define CALIFORNIA_CALENDAR_DATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDateClass))
#define CALIFORNIA_CALENDAR_IS_DATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_DATE))
#define CALIFORNIA_CALENDAR_IS_DATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_DATE))
#define CALIFORNIA_CALENDAR_DATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDateClass))

typedef struct _CaliforniaCalendarDate CaliforniaCalendarDate;
typedef struct _CaliforniaCalendarDateClass CaliforniaCalendarDateClass;

#define CALIFORNIA_CALENDAR_TYPE_TIMEZONE (california_calendar_timezone_get_type ())
#define CALIFORNIA_CALENDAR_TIMEZONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_TIMEZONE, CaliforniaCalendarTimezone))
#define CALIFORNIA_CALENDAR_TIMEZONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_TIMEZONE, CaliforniaCalendarTimezoneClass))
#define CALIFORNIA_CALENDAR_IS_TIMEZONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_TIMEZONE))
#define CALIFORNIA_CALENDAR_IS_TIMEZONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_TIMEZONE))
#define CALIFORNIA_CALENDAR_TIMEZONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_TIMEZONE, CaliforniaCalendarTimezoneClass))

typedef struct _CaliforniaCalendarTimezone CaliforniaCalendarTimezone;
typedef struct _CaliforniaCalendarTimezoneClass CaliforniaCalendarTimezoneClass;

#define CALIFORNIA_CALENDAR_TYPE_EXACT_TIME (california_calendar_exact_time_get_type ())
#define CALIFORNIA_CALENDAR_EXACT_TIME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME, CaliforniaCalendarExactTime))
#define CALIFORNIA_CALENDAR_EXACT_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME, CaliforniaCalendarExactTimeClass))
#define CALIFORNIA_CALENDAR_IS_EXACT_TIME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME))
#define CALIFORNIA_CALENDAR_IS_EXACT_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME))
#define CALIFORNIA_CALENDAR_EXACT_TIME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME, CaliforniaCalendarExactTimeClass))

typedef struct _CaliforniaCalendarExactTime CaliforniaCalendarExactTime;
typedef struct _CaliforniaCalendarExactTimeClass CaliforniaCalendarExactTimeClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CALIFORNIA_CALENDAR_TYPE_DATE_SPAN (california_calendar_date_span_get_type ())
#define CALIFORNIA_CALENDAR_DATE_SPAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, CaliforniaCalendarDateSpan))
#define CALIFORNIA_CALENDAR_DATE_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, CaliforniaCalendarDateSpanClass))
#define CALIFORNIA_CALENDAR_IS_DATE_SPAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_DATE_SPAN))
#define CALIFORNIA_CALENDAR_IS_DATE_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_DATE_SPAN))
#define CALIFORNIA_CALENDAR_DATE_SPAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, CaliforniaCalendarDateSpanClass))

typedef struct _CaliforniaCalendarDateSpan CaliforniaCalendarDateSpan;
typedef struct _CaliforniaCalendarDateSpanClass CaliforniaCalendarDateSpanClass;

struct _CaliforniaCollectionSimpleIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (CaliforniaCollectionSimpleIterator* self);
	gpointer (*get) (CaliforniaCollectionSimpleIterator* self);
};

struct _CaliforniaCollectionSimpleIterableIface {
	GTypeInterface parent_iface;
	CaliforniaCollectionSimpleIterator* (*iterator) (CaliforniaCollectionSimpleIterable* self);
};

struct _CaliforniaCalendarSpanIface {
	GTypeInterface parent_iface;
	gpointer (*start) (CaliforniaCalendarSpan* self);
	gpointer (*end) (CaliforniaCalendarSpan* self);
	gboolean (*contains) (CaliforniaCalendarSpan* self, CaliforniaCalendarDate* date);
	gboolean (*has) (CaliforniaCalendarSpan* self, gconstpointer unit);
	CaliforniaCalendarDate* (*get_start_date) (CaliforniaCalendarSpan* self);
	CaliforniaCalendarDate* (*get_end_date) (CaliforniaCalendarSpan* self);
};



GType california_base_object_get_type (void) G_GNUC_CONST;
GType california_collection_simple_iterator_get_type (void) G_GNUC_CONST;
GType california_collection_simple_iterable_get_type (void) G_GNUC_CONST;
GType california_calendar_date_get_type (void) G_GNUC_CONST;
GType california_calendar_span_get_type (void) G_GNUC_CONST;
gpointer california_calendar_span_start (CaliforniaCalendarSpan* self);
gpointer california_calendar_span_end (CaliforniaCalendarSpan* self);
GType california_calendar_timezone_get_type (void) G_GNUC_CONST;
GType california_calendar_exact_time_get_type (void) G_GNUC_CONST;
CaliforniaCalendarExactTime* california_calendar_span_earliest_exact_time (CaliforniaCalendarSpan* self, CaliforniaCalendarTimezone* tz);
CaliforniaCalendarDate* california_calendar_span_get_start_date (CaliforniaCalendarSpan* self);
CaliforniaCalendarExactTime* california_calendar_date_earliest_exact_time (CaliforniaCalendarDate* self, CaliforniaCalendarTimezone* tz);
CaliforniaCalendarExactTime* california_calendar_span_latest_exact_time (CaliforniaCalendarSpan* self, CaliforniaCalendarTimezone* tz);
CaliforniaCalendarDate* california_calendar_span_get_end_date (CaliforniaCalendarSpan* self);
CaliforniaCalendarExactTime* california_calendar_date_latest_exact_time (CaliforniaCalendarDate* self, CaliforniaCalendarTimezone* tz);
GType california_calendar_date_span_get_type (void) G_GNUC_CONST;
CaliforniaCalendarDateSpan* california_calendar_span_to_date_span (CaliforniaCalendarSpan* self);
CaliforniaCalendarDateSpan* california_calendar_date_span_new (CaliforniaCalendarDate* start_date, CaliforniaCalendarDate* end_date);
CaliforniaCalendarDateSpan* california_calendar_date_span_construct (GType object_type, CaliforniaCalendarDate* start_date, CaliforniaCalendarDate* end_date);
gboolean california_calendar_span_contains (CaliforniaCalendarSpan* self, CaliforniaCalendarDate* date);
gboolean california_calendar_span_has (CaliforniaCalendarSpan* self, gconstpointer unit);


/**
     * The earliest delinated unit of time within the {@link Span}.
     */
gpointer california_calendar_span_start (CaliforniaCalendarSpan* self) {
#line 43 "/home/jim/git/california/src/calendar/calendar-span.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_SPAN (self), NULL);
#line 43 "/home/jim/git/california/src/calendar/calendar-span.vala"
	return CALIFORNIA_CALENDAR_SPAN_GET_INTERFACE (self)->start (self);
#line 144 "calendar-span.c"
}


/**
     * The latest delineated unit of time within the {@link Span}.
     */
gpointer california_calendar_span_end (CaliforniaCalendarSpan* self) {
#line 48 "/home/jim/git/california/src/calendar/calendar-span.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_SPAN (self), NULL);
#line 48 "/home/jim/git/california/src/calendar/calendar-span.vala"
	return CALIFORNIA_CALENDAR_SPAN_GET_INTERFACE (self)->end (self);
#line 156 "calendar-span.c"
}


/**
     * Returns the earliest {@link ExactTime} for this {@link Span}.
     *
     * @see Date.earliest_exact_time
     */
CaliforniaCalendarExactTime* california_calendar_span_earliest_exact_time (CaliforniaCalendarSpan* self, CaliforniaCalendarTimezone* tz) {
	CaliforniaCalendarExactTime* result = NULL;
	CaliforniaCalendarDate* _tmp0_ = NULL;
	CaliforniaCalendarDate* _tmp1_ = NULL;
	CaliforniaCalendarDate* _tmp2_ = NULL;
	CaliforniaCalendarTimezone* _tmp3_ = NULL;
	CaliforniaCalendarExactTime* _tmp4_ = NULL;
	CaliforniaCalendarExactTime* _tmp5_ = NULL;
#line 55 "/home/jim/git/california/src/calendar/calendar-span.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_TIMEZONE (tz), NULL);
#line 56 "/home/jim/git/california/src/calendar/calendar-span.vala"
	_tmp0_ = california_calendar_span_get_start_date (self);
#line 56 "/home/jim/git/california/src/calendar/calendar-span.vala"
	_tmp1_ = _tmp0_;
#line 56 "/home/jim/git/california/src/calendar/calendar-span.vala"
	_tmp2_ = _tmp1_;
#line 56 "/home/jim/git/california/src/calendar/calendar-span.vala"
	_tmp3_ = tz;
#line 56 "/home/jim/git/california/src/calendar/calendar-span.vala"
	_tmp4_ = california_calendar_date_earliest_exact_time (_tmp2_, _tmp3_);
#line 56 "/home/jim/git/california/src/calendar/calendar-span.vala"
	_tmp5_ = _tmp4_;
#line 56 "/home/jim/git/california/src/calendar/calendar-span.vala"
	_g_object_unref0 (_tmp2_);
#line 56 "/home/jim/git/california/src/calendar/calendar-span.vala"
	result = _tmp5_;
#line 56 "/home/jim/git/california/src/calendar/calendar-span.vala"
	return result;
#line 193 "calendar-span.c"
}


/**
     * Returns the latest {@link ExactTime} for this {@link Span}.
     *
     * @see Date.latest_exact_time
     */
CaliforniaCalendarExactTime* california_calendar_span_latest_exact_time (CaliforniaCalendarSpan* self, CaliforniaCalendarTimezone* tz) {
	CaliforniaCalendarExactTime* result = NULL;
	CaliforniaCalendarDate* _tmp0_ = NULL;
	CaliforniaCalendarDate* _tmp1_ = NULL;
	CaliforniaCalendarDate* _tmp2_ = NULL;
	CaliforniaCalendarTimezone* _tmp3_ = NULL;
	CaliforniaCalendarExactTime* _tmp4_ = NULL;
	CaliforniaCalendarExactTime* _tmp5_ = NULL;
#line 64 "/home/jim/git/california/src/calendar/calendar-span.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_TIMEZONE (tz), NULL);
#line 65 "/home/jim/git/california/src/calendar/calendar-span.vala"
	_tmp0_ = california_calendar_span_get_end_date (self);
#line 65 "/home/jim/git/california/src/calendar/calendar-span.vala"
	_tmp1_ = _tmp0_;
#line 65 "/home/jim/git/california/src/calendar/calendar-span.vala"
	_tmp2_ = _tmp1_;
#line 65 "/home/jim/git/california/src/calendar/calendar-span.vala"
	_tmp3_ = tz;
#line 65 "/home/jim/git/california/src/calendar/calendar-span.vala"
	_tmp4_ = california_calendar_date_latest_exact_time (_tmp2_, _tmp3_);
#line 65 "/home/jim/git/california/src/calendar/calendar-span.vala"
	_tmp5_ = _tmp4_;
#line 65 "/home/jim/git/california/src/calendar/calendar-span.vala"
	_g_object_unref0 (_tmp2_);
#line 65 "/home/jim/git/california/src/calendar/calendar-span.vala"
	result = _tmp5_;
#line 65 "/home/jim/git/california/src/calendar/calendar-span.vala"
	return result;
#line 230 "calendar-span.c"
}


/**
     * Converts the {@link Span} into a {@link DateSpan}.
     */
CaliforniaCalendarDateSpan* california_calendar_span_to_date_span (CaliforniaCalendarSpan* self) {
	CaliforniaCalendarDateSpan* result = NULL;
	CaliforniaCalendarDate* _tmp0_ = NULL;
	CaliforniaCalendarDate* _tmp1_ = NULL;
	CaliforniaCalendarDate* _tmp2_ = NULL;
	CaliforniaCalendarDate* _tmp3_ = NULL;
	CaliforniaCalendarDate* _tmp4_ = NULL;
	CaliforniaCalendarDate* _tmp5_ = NULL;
	CaliforniaCalendarDateSpan* _tmp6_ = NULL;
	CaliforniaCalendarDateSpan* _tmp7_ = NULL;
#line 72 "/home/jim/git/california/src/calendar/calendar-span.vala"
	_tmp0_ = california_calendar_span_get_start_date (self);
#line 72 "/home/jim/git/california/src/calendar/calendar-span.vala"
	_tmp1_ = _tmp0_;
#line 72 "/home/jim/git/california/src/calendar/calendar-span.vala"
	_tmp2_ = _tmp1_;
#line 72 "/home/jim/git/california/src/calendar/calendar-span.vala"
	_tmp3_ = california_calendar_span_get_end_date (self);
#line 72 "/home/jim/git/california/src/calendar/calendar-span.vala"
	_tmp4_ = _tmp3_;
#line 72 "/home/jim/git/california/src/calendar/calendar-span.vala"
	_tmp5_ = _tmp4_;
#line 72 "/home/jim/git/california/src/calendar/calendar-span.vala"
	_tmp6_ = california_calendar_date_span_new (_tmp2_, _tmp5_);
#line 72 "/home/jim/git/california/src/calendar/calendar-span.vala"
	_tmp7_ = _tmp6_;
#line 72 "/home/jim/git/california/src/calendar/calendar-span.vala"
	_g_object_unref0 (_tmp5_);
#line 72 "/home/jim/git/california/src/calendar/calendar-span.vala"
	_g_object_unref0 (_tmp2_);
#line 72 "/home/jim/git/california/src/calendar/calendar-span.vala"
	result = _tmp7_;
#line 72 "/home/jim/git/california/src/calendar/calendar-span.vala"
	return result;
#line 271 "calendar-span.c"
}


/**
     * true if the {@link Span} contains the specified {@link Date}.
     *
     * This is named to conform to Vala's rule for automatic syntax support.  This allows for the
     * ''in'' operator to function on Spans, but only for Dates (which is perceived as a common
     * operation).
     *
     * @see has
     */
gboolean california_calendar_span_contains (CaliforniaCalendarSpan* self, CaliforniaCalendarDate* date) {
#line 84 "/home/jim/git/california/src/calendar/calendar-span.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_SPAN (self), FALSE);
#line 84 "/home/jim/git/california/src/calendar/calendar-span.vala"
	return CALIFORNIA_CALENDAR_SPAN_GET_INTERFACE (self)->contains (self, date);
#line 289 "calendar-span.c"
}


/**
     * true if the {@link Span} contains the specified unit of time.
     *
     * @see contains
     */
gboolean california_calendar_span_has (CaliforniaCalendarSpan* self, gconstpointer unit) {
#line 91 "/home/jim/git/california/src/calendar/calendar-span.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_SPAN (self), FALSE);
#line 91 "/home/jim/git/california/src/calendar/calendar-span.vala"
	return CALIFORNIA_CALENDAR_SPAN_GET_INTERFACE (self)->has (self, unit);
#line 303 "calendar-span.c"
}


CaliforniaCalendarDate* california_calendar_span_get_start_date (CaliforniaCalendarSpan* self) {
#line 33 "/home/jim/git/california/src/calendar/calendar-span.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_SPAN (self), NULL);
#line 33 "/home/jim/git/california/src/calendar/calendar-span.vala"
	return CALIFORNIA_CALENDAR_SPAN_GET_INTERFACE (self)->get_start_date (self);
#line 312 "calendar-span.c"
}


CaliforniaCalendarDate* california_calendar_span_get_end_date (CaliforniaCalendarSpan* self) {
#line 38 "/home/jim/git/california/src/calendar/calendar-span.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_SPAN (self), NULL);
#line 38 "/home/jim/git/california/src/calendar/calendar-span.vala"
	return CALIFORNIA_CALENDAR_SPAN_GET_INTERFACE (self)->get_end_date (self);
#line 321 "calendar-span.c"
}


static void california_calendar_span_base_init (CaliforniaCalendarSpanIface * iface) {
#line 29 "/home/jim/git/california/src/calendar/calendar-span.vala"
	static gboolean initialized = FALSE;
#line 29 "/home/jim/git/california/src/calendar/calendar-span.vala"
	if (!initialized) {
#line 29 "/home/jim/git/california/src/calendar/calendar-span.vala"
		initialized = TRUE;
#line 332 "calendar-span.c"
		/**
		     * Returns the earliest {@link Date} within the {@link Span}.
		     */
#line 29 "/home/jim/git/california/src/calendar/calendar-span.vala"
		g_object_interface_install_property (iface, g_param_spec_object ("start-date", "start-date", "start-date", CALIFORNIA_CALENDAR_TYPE_DATE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 338 "calendar-span.c"
		/**
		     * Returns the latest {@link Date} within the {@link Span}.
		     */
#line 29 "/home/jim/git/california/src/calendar/calendar-span.vala"
		g_object_interface_install_property (iface, g_param_spec_object ("end-date", "end-date", "end-date", CALIFORNIA_CALENDAR_TYPE_DATE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 344 "calendar-span.c"
	}
}


/**
 * An immutable generic span or range of consecutive calendar dates.
 *
 * The Span is delineated by specific lengths of time (such as {@link Date}, {@link Week}, or
 * {@link Month} and is required to be Traversable and Iterable by the same.
 *
 * Since the start and end Date of a Span may fall within the larger delineated unit of time,
 * the contract is that partial units will always be returned.  If the caller wants to only deal
 * with full units within this Span, they must check all returned values.
 *
 * Although not specified, it's expected that all Spans will also implement Gee.Comparable and
 * Gee.Hashable.
 *
 * Span is not designed for {@link ExactTime} resolution.
 *
 * @see DateSpan
 * @see WeekSpan
 * @see MonthSpan
 */
GType california_calendar_span_get_type (void) {
	static volatile gsize california_calendar_span_type_id__volatile = 0;
	if (g_once_init_enter (&california_calendar_span_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CaliforniaCalendarSpanIface), (GBaseInitFunc) california_calendar_span_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType california_calendar_span_type_id;
		california_calendar_span_type_id = g_type_register_static (G_TYPE_INTERFACE, "CaliforniaCalendarSpan", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (california_calendar_span_type_id, CALIFORNIA_TYPE_BASE_OBJECT);
		g_type_interface_add_prerequisite (california_calendar_span_type_id, CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERABLE);
		g_once_init_leave (&california_calendar_span_type_id__volatile, california_calendar_span_type_id);
	}
	return california_calendar_span_type_id__volatile;
}



