#include <stdlib.h>

#include <bonobo.h>

#include "bonobo-conf/bonobo-config-database.h"

static void
read_data (Bonobo_ConfigDatabase db)
{
        CORBA_Environment ev;
	Bonobo_KeyList *klist;
	
        CORBA_exception_init (&ev);

	g_assert (bonobo_config_get_long (db, "/t/test", NULL) == 5);

	g_assert (bonobo_config_get_long (db, "/t/test", NULL) == 5);

	g_assert (bonobo_config_get_long (db, "/t/test////", NULL) == 5);

	g_assert (bonobo_config_get_long (db, "/t/System/Test/t1", NULL) == 5);
	g_assert (bonobo_config_get_long (db, "/t/System/Test/t2", NULL) == 5);
	g_assert (bonobo_config_get_long (db, "/t/System/Test/t3", NULL) == 5);

	g_assert (bonobo_config_get_long (db, "/t/System///Test/t1", NULL)==5);

	g_assert (bonobo_config_get_long (db, "/t/System/Test//t1/", NULL)==5);

	g_assert (bonobo_config_get_long (db, "/t/System/t4", NULL) == 5);

	klist = Bonobo_ConfigDatabase_listDirs (db, "t/Internet", &ev);
	g_assert (!BONOBO_EX (&ev));
	g_assert (klist->_length == 5);

	klist = Bonobo_ConfigDatabase_listKeys (db, "t/Internet/d1", &ev);
	g_assert (!BONOBO_EX (&ev));
	g_assert (klist->_length == 1);

	klist = Bonobo_ConfigDatabase_listKeys (db, "t/Internet/d2", &ev);
	g_assert (!BONOBO_EX (&ev));
	g_assert (klist->_length == 0);

	g_assert (Bonobo_ConfigDatabase_dirExists (db,"t/Internet/d1", &ev));
	g_assert (Bonobo_ConfigDatabase_dirExists (db,"t/Internet/d2", &ev));
	g_assert (Bonobo_ConfigDatabase_dirExists (db,"t/Internet/d3", &ev));
	g_assert (Bonobo_ConfigDatabase_dirExists (db,"t/Internet/d4", &ev));
	g_assert (Bonobo_ConfigDatabase_dirExists (db,"t/Internet/d5", &ev));
	g_assert (Bonobo_ConfigDatabase_dirExists (db,"t/Internet/d5/d", &ev));
	g_assert (!Bonobo_ConfigDatabase_dirExists (db,"t/Internet/d6", &ev));
	g_assert (!Bonobo_ConfigDatabase_dirExists (db,"t/Internet/d7", &ev));

	printf ("read test finished\n"); 
}

static void
write_data (Bonobo_ConfigDatabase db)
{
        CORBA_Environment ev;
	CORBA_any *value;

        CORBA_exception_init (&ev);

	value = bonobo_arg_new (TC_long);
	BONOBO_ARG_SET_LONG (value, 5);
	
	Bonobo_ConfigDatabase_setValue (db, "/t/test", value, &ev);
	g_assert (!BONOBO_EX (&ev));

	Bonobo_ConfigDatabase_setValue (db, "/t/System/Test/t1", value, &ev);
	g_assert (!BONOBO_EX (&ev));

	Bonobo_ConfigDatabase_setValue (db, "/t/System/Test/t2", value, &ev);
	g_assert (!BONOBO_EX (&ev));

	Bonobo_ConfigDatabase_setValue (db, "/t/System/Test/t3", value, &ev);
	g_assert (!BONOBO_EX (&ev));

	Bonobo_ConfigDatabase_setValue (db, "/t/System/t4", value, &ev);
	g_assert (!BONOBO_EX (&ev));

	Bonobo_ConfigDatabase_setValue (db, "/t/Application/a1", value, &ev);
	g_assert (!BONOBO_EX (&ev));

	Bonobo_ConfigDatabase_setValue (db, "/t/Internet/d1/i1", value, &ev);
	g_assert (!BONOBO_EX (&ev));

	Bonobo_ConfigDatabase_setValue (db, "/t/Internet/d2/i1", value, &ev);
	g_assert (!BONOBO_EX (&ev));

	Bonobo_ConfigDatabase_removeValue (db, "/t/Internet/d2/i1", &ev);
	g_assert (!BONOBO_EX (&ev));

	Bonobo_ConfigDatabase_setValue (db, "/t/Internet/d3/i1", value, &ev);
	g_assert (!BONOBO_EX (&ev));

	Bonobo_ConfigDatabase_setValue (db, "/t/Internet/d4/i1", value, &ev);
	g_assert (!BONOBO_EX (&ev));

	Bonobo_ConfigDatabase_setValue (db, "/t/Internet/d5/d/d/i1",value,&ev);
	g_assert (!BONOBO_EX (&ev));

	Bonobo_ConfigDatabase_setValue (db, "/t/Internet/d6/i1", value, &ev);
	g_assert (!BONOBO_EX (&ev));

	Bonobo_ConfigDatabase_removeDir (db, "/t/Internet/d6", &ev);
	g_assert (!BONOBO_EX (&ev));

	Bonobo_ConfigDatabase_sync (db, &ev);
	g_assert (!BONOBO_EX (&ev));

	printf ("write test finished\n"); 
}

static void
test_xmldirdb ()
{
	Bonobo_ConfigDatabase db = NULL;
        CORBA_Environment  ev;
	
        CORBA_exception_init (&ev);

	//db = bonobo_get_object ("config:", "Bonobo/ConfigDatabase", &ev);
	db = bonobo_get_object ("xmldirdb:/tmp/t.xmldir", 
				"Bonobo/ConfigDatabase", &ev);
	g_assert (!BONOBO_EX (&ev));
	g_assert (db != NULL);

	write_data (db);

	read_data (db);

	bonobo_object_release_unref (db, &ev);
	g_assert (!BONOBO_EX (&ev));
}

static gint
run_tests ()
{
	test_xmldirdb ();


	gtk_main_quit ();

	return 0;
}

int
main (int argc, char **argv)
{
	CORBA_ORB orb;

	gnome_init ("test-moniker", "0.0", argc, argv);

	if ((orb = oaf_init (argc, argv)) == NULL)
		g_error ("Cannot init oaf");

	if (bonobo_init (orb, NULL, NULL) == FALSE)
		g_error ("Cannot init bonobo");


	gtk_idle_add ((GtkFunction) run_tests, NULL);

	bonobo_main ();

	exit (0);
}
