/*
 * bonobo-property-editor-default.c:
 *
 * Author:
 *   Dietmar Maurer (dietmar@ximian.com)
 *
 * Copyright 2000 Ximian, Inc.
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <bonobo.h>

#include "bonobo-property-editor.h"
#include "bonobo-config-utils.h"

static void
set_value_cb (BonoboPropertyEditor *editor,
	      BonoboArg            *value,
	      CORBA_Environment    *ev)
{
	GtkWidget *e;
	char *s;

	e = GTK_BIN (editor)->child;

	s = bonobo_config_any_to_string (value);
	
	gtk_entry_set_text (GTK_ENTRY (e), s);

	g_free (s);
}

GtkWidget *
bonobo_property_editor_default_new ()
{
	GtkWidget *e;
	BonoboPropertyEditor *ed;

	e = gtk_entry_new ();
	gtk_entry_set_text (GTK_ENTRY (e), "no value set");
	gtk_entry_set_editable (GTK_ENTRY (e), FALSE);

	ed = bonobo_property_editor_construct (e, set_value_cb, NULL);

	return GTK_WIDGET (ed);
}
