/*
 * bonobo-property-editor-boolean.c:
 *
 * Author:
 *   Dietmar Maurer (dietmar@ximian.com)
 *
 * Copyright 2000 Ximian, Inc.
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <bonobo.h>

#include "bonobo-property-editor.h"

static void
toggled_cb (GtkToggleButton *toggle,
	    gpointer         user_data) 
{
	BonoboPropertyEditor *editor = BONOBO_PROPERTY_EDITOR (user_data);
	CORBA_Environment ev;
	BonoboArg *arg;
	gboolean active;

	CORBA_exception_init (&ev);
	
	active = gtk_toggle_button_get_active (toggle);	
	arg = bonobo_arg_new (TC_boolean);

	BONOBO_ARG_SET_BOOLEAN (arg, active);

	bonobo_property_editor_set_value (editor, arg, &ev);

	bonobo_arg_release (arg);

	CORBA_exception_free (&ev);
}

static void
set_value_cb (BonoboPropertyEditor *editor,
	      BonoboArg            *value,
	      CORBA_Environment    *ev)
{
	GtkWidget *widget;
	CORBA_boolean new_value;

	if (!bonobo_arg_type_is_equal (value->_type, TC_boolean, NULL))
		return;

	widget = GTK_BIN (editor)->child;

	new_value = BONOBO_ARG_GET_BOOLEAN (value);

	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget), new_value);
}

GtkWidget *
bonobo_property_editor_boolean_new (const char *label)
{
	GtkWidget *check;
	BonoboPropertyEditor *ed;

	if (label)
		check = gtk_check_button_new_with_label (label);
	else
		check = gtk_check_button_new ();

	ed = bonobo_property_editor_construct (check, set_value_cb, 
					       TC_boolean);

	gtk_signal_connect (GTK_OBJECT (check), "toggled",
			    (GtkSignalFunc) toggled_cb, ed);

	return GTK_WIDGET (ed);
}
