/**
 * bonobo-property-editor.h:
 *
 * Author:
 *   Dietmar Maurer (dietmar@ximian.com)
 *
 * Copyright 2001 Ximian, Inc.
 */
#ifndef _BONOBO_PROPERTY_EDITOR_H_
#define _BONOBO_PROPERTY_EDITOR_H_

#include <gtk/gtkbin.h>
#include <bonobo/bonobo-property-bag.h>
#include <bonobo-conf/Bonobo_Config.h>

BEGIN_GNOME_DECLS
 
#define BONOBO_PROPERTY_EDITOR_TYPE        (bonobo_property_editor_get_type ())
#define BONOBO_PROPERTY_EDITOR(o)          (GTK_CHECK_CAST ((o), BONOBO_PROPERTY_EDITOR_TYPE, BonoboPropertyEditor))
#define BONOBO_PROPERTY_EDITOR_CLASS(k)    (GTK_CHECK_CLASS_CAST((k), BONOBO_PROPERTY_EDITOR_TYPE, BonoboPropertyEditorClass))
#define BONOBO_IS_PROPERTY_EDITOR(o)       (GTK_CHECK_TYPE ((o), BONOBO_PROPERTY_EDITOR_TYPE))
#define BONOBO_IS_PROPERTY_EDITOR_CLASS(k) (GTK_CHECK_CLASS_TYPE ((k), BONOBO_PROPERTY_EDITOR_TYPE))

typedef struct _BonoboPropertyEditorPrivate BonoboPropertyEditorPrivate;

typedef struct {
	GtkBin             base;

	CORBA_TypeCode     tc;
	gpointer           data;

	BonoboPropertyEditorPrivate *priv;
} BonoboPropertyEditor;

typedef void (*BonoboPropertyEditorSetFn) (BonoboPropertyEditor *editor,
					   BonoboArg            *value,
					   CORBA_Environment    *ev);

typedef struct {
	GtkBinClass parent_class;

	/* virtual methods */

	BonoboPropertyEditorSetFn set_value;

} BonoboPropertyEditorClass;

GtkType            
bonobo_property_editor_get_type     (void);

BonoboPropertyEditor *
bonobo_property_editor_construct    (GtkWidget                 *widget,
				     BonoboPropertyEditorSetFn  set_cb,
				     CORBA_TypeCode             tc);

void                
bonobo_property_editor_set_property (BonoboPropertyEditor *editor,
				     Bonobo_PropertyBag    bag,
				     const char           *name,
				     CORBA_TypeCode        tc, 
				     CORBA_any            *defval);

void                
bonobo_property_editor_set_value    (BonoboPropertyEditor *editor,
				     const BonoboArg      *value,
				     CORBA_Environment    *opt_ev);

void
bonobo_property_editor_set_guard    (GtkWidget            *widget,
				     Bonobo_PropertyBag    bag,
				     const char           *prop_name);

GtkWidget *
bonobo_property_editor_resolve      (CORBA_TypeCode tc);

GtkWidget *
bonobo_property_editor_new          (Bonobo_PropertyBag  pb,
				     const char         *name,
				     CORBA_TypeCode      tc, 		
				     CORBA_any          *defval);

GtkWidget *
bonobo_property_editor_option_new   (gboolean             horiz, 
				     char               **titles);
GtkWidget *
bonobo_property_editor_short_new    ();

GtkWidget *
bonobo_property_editor_ushort_new   ();

GtkWidget *
bonobo_property_editor_long_new     ();

GtkWidget *
bonobo_property_editor_ulong_new    ();

GtkWidget *
bonobo_property_editor_float_new    ();

GtkWidget *
bonobo_property_editor_double_new   ();

GtkWidget *
bonobo_property_editor_string_new   ();

GtkWidget *
bonobo_property_editor_boolean_new  (const char *label);

GtkWidget *
bonobo_property_editor_int_range_new (gint32 lower, gint32 upper, gint32 incr);

GtkWidget *
bonobo_property_editor_enum_new     ();

GtkWidget *
bonobo_property_editor_default_new  ();

GtkWidget *
bonobo_property_editor_filename_new ();

GtkWidget *
bonobo_property_editor_color_new    ();

END_GNOME_DECLS

#endif /* _BONOBO_PROPERTY_EDITOR_H_ */
