/*
 * bonobo-moniker-config.c: Configuration moniker implementation
 *
 * Author:
 *   Dietmar Maurer (dietmar@ximian.com)
 *
 * Copyright 2000 Ximian, Inc.
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <bonobo/bonobo-moniker.h>
#include <bonobo/bonobo-moniker-util.h>
#include <bonobo/bonobo-moniker-simple.h>
#include <bonobo/bonobo-shlib-factory.h>
#include <bonobo/bonobo-exception.h>
#include <bonobo/bonobo-ui-container.h>
#include <bonobo/bonobo-widget.h>

#include <bonobo-conf/bonobo-config-bag.h>
#include <bonobo-conf/bonobo-config-property.h>

#include <bonobo-conf/bonobo-property-editor.h>
#include <bonobo-conf/bonobo-property-bag-editor.h>
//#include <bonobo-conf/bonobo-property-editor-struct.h>
//#include <bonobo-conf/bonobo-property-editor-list.h>
#include <bonobo-conf/gtkwtree.h>
#include <bonobo-conf/gtkwtreeitem.h>

static Bonobo_Unknown
create_bag_editor (Bonobo_ConfigDatabase  db,
		   const char            *name, 
		   CORBA_Environment     *ev)
{
	BonoboConfigBag     *config_bag;
	CORBA_Object         bag;
	BonoboControl       *control;
	BonoboUIContainer   *uic;

	if (!(config_bag = bonobo_config_bag_new (db, name))) {
		bonobo_exception_set (ev, ex_Bonobo_Moniker_InterfaceNotFound);
		return CORBA_OBJECT_NIL;
	}

	bag = BONOBO_OBJREF (config_bag);

	uic = bonobo_ui_container_new ();

	control = bonobo_property_bag_editor_new (bag, BONOBO_OBJREF(uic), ev);

	bonobo_object_unref (BONOBO_OBJECT (uic));

	/* fixme: */ 
	/* bonobo_object_unref (BONOBO_OBJECT (config_bag)); */

	return CORBA_Object_duplicate (BONOBO_OBJREF (control), ev);
}

static Bonobo_Unknown
create_property_editor (Bonobo_ConfigDatabase  db,
			const char            *name, 
			CORBA_Environment     *ev)
{
	CORBA_any            *value;
	CORBA_Object          editor;
	BonoboConfigProperty *prop;
	char                 *locale;

	if (!(locale = g_getenv ("LANG")))
		locale = "";

	value = Bonobo_ConfigDatabase_getValue (db, name, locale, ev);

	if (BONOBO_EX (ev) || !value)
		return CORBA_OBJECT_NIL;

	editor = bonobo_property_editor_resolve (value->_type, ev);

	CORBA_free (value);

	if (BONOBO_EX (ev) || editor == CORBA_OBJECT_NIL)
		return CORBA_OBJECT_NIL;

	if (!CORBA_Object_is_a (editor, "IDL:Bonobo/PropertyEditor:1.0", ev)) {
		bonobo_object_release_unref (editor, NULL);
		bonobo_exception_set (ev, ex_Bonobo_Moniker_InterfaceNotFound);
		return CORBA_OBJECT_NIL;
	}

	prop = bonobo_config_property_new (db, name);
	
	if (!prop) {
		bonobo_object_release_unref (editor, NULL);
		bonobo_exception_set (ev, ex_Bonobo_Moniker_InterfaceNotFound);
		return CORBA_OBJECT_NIL;
	}

	Bonobo_PropertyEditor_setProperty (editor, BONOBO_OBJREF (prop), ev);

	if (BONOBO_EX (ev)) {
		bonobo_object_release_unref (editor, NULL);
		bonobo_object_unref (BONOBO_OBJECT (prop));
		return CORBA_OBJECT_NIL;
	}

	return CORBA_Object_duplicate (editor, ev);
}

static Bonobo_Unknown
config_resolve (BonoboMoniker               *moniker,
		const Bonobo_ResolveOptions *options,
		const CORBA_char            *requested_interface,
		CORBA_Environment           *ev)
{
	Bonobo_Moniker         parent;
	Bonobo_ConfigDatabase  db;
	const gchar           *name;

	parent = bonobo_moniker_get_parent (moniker, ev);
	if (BONOBO_EX (ev) || parent == CORBA_OBJECT_NIL)
		return CORBA_OBJECT_NIL;

	db = Bonobo_Moniker_resolve (parent, options, 
				     "IDL:Bonobo/ConfigDatabase:1.0", ev);

	bonobo_object_release_unref (parent, NULL);
	
	if (BONOBO_EX (ev) || db == CORBA_OBJECT_NIL)
		return CORBA_OBJECT_NIL;
       
	name = bonobo_moniker_get_name (moniker);

	if (!strcmp (requested_interface, "IDL:Bonobo/ConfigDatabase:1.0"))
		return db;

	if (!strcmp (requested_interface, "IDL:Bonobo/PropertyBag:1.0")) {
		BonoboConfigBag *bag;
	
		bag = bonobo_config_bag_new (db, name);

		bonobo_object_release_unref (db, NULL);
	
		if (bag)
			return (Bonobo_Unknown) CORBA_Object_duplicate (
			      BONOBO_OBJREF (bag), ev);
		
	       
		bonobo_exception_set (ev, ex_Bonobo_Moniker_InterfaceNotFound);

		return CORBA_OBJECT_NIL;
	}

	
 	if (!strcmp (requested_interface, "IDL:Bonobo/Property:1.0")) {
		BonoboConfigProperty *prop;

		prop = bonobo_config_property_new (db, name);

		if (prop)
			return (Bonobo_Unknown) CORBA_Object_duplicate (
			      BONOBO_OBJREF (prop), ev);

		bonobo_exception_set (ev, ex_Bonobo_Moniker_InterfaceNotFound);

		return CORBA_OBJECT_NIL;
	} 

 	if (!strcmp (requested_interface, "IDL:Bonobo/Control:1.0")) {
		if (Bonobo_ConfigDatabase_dirExists (db, name, ev) &&
		    !BONOBO_EX (ev)) {
			return create_bag_editor (db, name, ev);
		} else {
			CORBA_exception_init (ev);
			return create_property_editor (db, name, ev);
		}
	} 
	
 	if (!strcmp (requested_interface, "IDL:Bonobo/PropertyEditor:1.0"))
		return create_property_editor (db, name, ev);
	
	return CORBA_OBJECT_NIL; /* try moniker extenders */
}


static BonoboObject *
bonobo_moniker_config_factory (BonoboGenericFactory *this, 
			       const char           *object_id,
			       void                 *closure)
{
	static gboolean initialized = FALSE;

	if (!initialized) {
		initialized = TRUE;		
	}

	if (!strcmp (object_id, "OAFIID:Bonobo_Moniker_config")) {

		return BONOBO_OBJECT (bonobo_moniker_simple_new (
		        "config:", config_resolve));
	
	} else if (!strcmp (object_id, 
			   BONOBO_PROPERTY_EDITOR_PREFIX "short")) {
		
		return bonobo_property_editor_basic_new (TC_short);
	
	} else if (!strcmp (object_id, 
			   BONOBO_PROPERTY_EDITOR_PREFIX "ushort")) {
		
		return bonobo_property_editor_basic_new (TC_ushort);
	
	} else if (!strcmp (object_id, 
			   BONOBO_PROPERTY_EDITOR_PREFIX "long")) {
		
		return bonobo_property_editor_basic_new (TC_long);

	} else if (!strcmp (object_id, 
			   BONOBO_PROPERTY_EDITOR_PREFIX "ulong")) {
		
		return bonobo_property_editor_basic_new (TC_ulong);
	
	} else if (!strcmp (object_id, 
			   BONOBO_PROPERTY_EDITOR_PREFIX "float")) {
		
		return bonobo_property_editor_basic_new (TC_float);
	
	} else if (!strcmp (object_id, 
			   BONOBO_PROPERTY_EDITOR_PREFIX "double")) {
		
		return bonobo_property_editor_basic_new (TC_double);
	
	} else if (!strcmp (object_id, 
			    BONOBO_PROPERTY_EDITOR_PREFIX "string")) {
		
		return bonobo_property_editor_basic_new (TC_string);

	} else if (!strcmp (object_id, 
			    BONOBO_PROPERTY_EDITOR_PREFIX "enum")) {
		
		return bonobo_property_editor_enum_new ();
		
	} else if (!strcmp (object_id, 
	 		    BONOBO_PROPERTY_EDITOR_PREFIX "boolean")) {
		
		return bonobo_property_editor_boolean_new ();
/*
	} else if (!strcmp (object_id, 
			    BONOBO_PROPERTY_EDITOR_PREFIX "char")) {
		
		return bonobo_property_editor_char_new ();
*/
/*
	} else if (!strcmp (object_id, 
	 		    BONOBO_PROPERTY_EDITOR_PREFIX "struct")) {
		
		return bonobo_property_editor_struct_new ();

	} else if (!strcmp (object_id, 
			    BONOBO_PROPERTY_EDITOR_PREFIX "sequence")) {
		
		return bonobo_property_editor_sequence_new ();
*/
/*
	} else if (!strcmp (object_id, 
			    BONOBO_PROPERTY_EDITOR_PREFIX "union")) {
		
		return bonobo_property_editor_union_new ();

	} else if (!strcmp (object_id, 
			    BONOBO_PROPERTY_EDITOR_PREFIX "array")) {
		
		return bonobo_property_editor_array_new ();
*/
	} else if (!strcmp (object_id, 
			    BONOBO_PROPERTY_EDITOR_PREFIX "default")) {
		
		return bonobo_property_editor_default_new ();
	} else
		g_warning ("Failing to manufacture a '%s'", object_id);
	
	return NULL;
}

BONOBO_OAF_SHLIB_FACTORY_MULTI ("OAFIID:Bonobo_Moniker_config_Factory",
				"bonobo configuration moniker",
				bonobo_moniker_config_factory,
				NULL);
