/*
 * test-config-moniker.c: configuration moniker tests
 *
 * Author:
 *   Dietmar Maurer (dietmar@ximian.com)
 *
 * Copyright 2001 Ximian, Inc.
 */
#include <bonobo.h>
#include <gconf/gconf-client.h>

static void 
listener_callback (BonoboListener    *listener,
		   char              *event_name, 
		   CORBA_any         *any,
		   CORBA_Environment *ev,
		   gpointer           user_data)
{
	BonoboUINode      *node;
	gchar             *enc;

	node = bonobo_property_bag_xml_encode_any (NULL, any, ev);
	enc = bonobo_ui_node_to_string (node, TRUE);

	printf ("got event %s value %s\n", event_name, enc);

	bonobo_ui_node_free (node);

	g_free (enc);

}

static void
test_moniker (const char *moniker, CORBA_Environment *ev)
{
	Bonobo_Unknown bag, v;
	CORBA_any *value;
	CORBA_TypeCode tc;
	CORBA_char *name, *doc;
	Bonobo_PropertyNames *names;
	Bonobo_PropertyList *plist;
	gint i;

	printf("TEST0\n");

	bag = bonobo_get_object (moniker, "IDL:Bonobo/PropertyBag:1.0", ev);
	if (BONOBO_EX(ev) || !bag) {
		printf ("ERR %s\n", bonobo_exception_get_text (ev));
		g_error ("Couldn't get Bonobo/PropertyBag interface");
	}

	bonobo_event_source_client_add_listener (bag, listener_callback, NULL, 
						 NULL, NULL); 

	printf("TEST01\n");
	names = Bonobo_PropertyBag_getPropertyNames (bag, ev);
	if (BONOBO_EX (ev))
		return;

	for (i = 0; i < names->_length; i++)
		printf ("FOUND name: %s\n", names->_buffer [i]);

	CORBA_free (names);

	printf("TEST1\n");
	plist = Bonobo_PropertyBag_getProperties (bag, ev);
	if (BONOBO_EX (ev))
		return;

	for (i = 0; i < plist->_length; i++) {

		name = Bonobo_Property_getName (plist->_buffer [i], ev);
		if (BONOBO_EX (ev))
			return;

		printf ("property name: %s\n", name);
	}

	CORBA_free (plist);

	printf("TEST2\n");
	v = Bonobo_PropertyBag_getPropertyByName (bag, "value2", ev);
	if (BONOBO_EX (ev))
		return;
	
	printf("TEST3\n");
	name = Bonobo_Property_getName (v, ev);
	if (BONOBO_EX (ev))
		return;

	printf("TEST4\n");
	printf ("property name: %s\n", name);
	CORBA_free (name);

	value = bonobo_arg_new (BONOBO_ARG_INT);
	BONOBO_ARG_SET_LONG (value, 17);

	Bonobo_Property_setValue (v, value, ev);
	if (BONOBO_EX (ev))
		return;

	BONOBO_ARG_SET_LONG (value, 19);

	Bonobo_Property_setValue (v, value, ev);
	if (BONOBO_EX (ev))
		return;

	doc = Bonobo_Property_getDocString (v, ev);	
	if (BONOBO_EX (ev))
		return;

	printf("DocString: %s\n", doc);

	tc = Bonobo_Property_getType (v, ev);
	if (BONOBO_EX (ev))
		return;

	if (!bonobo_arg_type_is_equal(tc, BONOBO_ARG_LONG, NULL)) {
		printf ("Wrong TypeCode %p\n", value->_type);
		return;
	}

	value = Bonobo_Property_getValue (v, ev);
	if (BONOBO_EX (ev))
		return;

	if (bonobo_arg_type_is_equal(value->_type, BONOBO_ARG_LONG, NULL))
		printf ("Value: %d\n", BONOBO_ARG_GET_LONG(value));
	else
		printf ("Property is not long %p\n", value->_type);
	
}

static void
test2_moniker (const char *moniker, CORBA_Environment *ev)
{
	Bonobo_Unknown v;
	CORBA_any *value;
	CORBA_TypeCode tc;
	CORBA_char *name, *doc;

	printf("XTEST1\n");
	v = bonobo_get_object (moniker, "IDL:Bonobo/Property:1.0", ev);
	if (BONOBO_EX(ev) || !v) {
		printf ("ERR %s\n", bonobo_exception_get_text (ev));
		g_error ("Couldn't get Bonobo/Property interface");
	}

	bonobo_event_source_client_add_listener (v, listener_callback, NULL, 
						 NULL, NULL); 

	printf("XTEST2\n");
	name = Bonobo_Property_getName (v, ev);
	if (BONOBO_EX (ev))
		return;

	printf("XTEST3\n");
	printf ("property name: %s\n", name);
	CORBA_free (name);

	value = bonobo_arg_new (BONOBO_ARG_INT);
	BONOBO_ARG_SET_LONG (value, 17);

	Bonobo_Property_setValue (v, value, ev);
	if (BONOBO_EX (ev))
		return;

	BONOBO_ARG_SET_LONG (value, 19);

	Bonobo_Property_setValue (v, value, ev);
	if (BONOBO_EX (ev))
		return;

	doc = Bonobo_Property_getDocString (v, ev);	
	if (BONOBO_EX (ev))
		return;

	printf("XDocString: %s\n", doc);

	tc = Bonobo_Property_getType (v, ev);
	if (BONOBO_EX (ev))
		return;

	if (!bonobo_arg_type_is_equal(tc, BONOBO_ARG_LONG, NULL)) {
		printf ("Wrong TypeCode %p\n", value->_type);
		return;
	}
	printf ("TypeCode %p\n", tc->name);

	value = Bonobo_Property_getValue (v, ev);
	if (BONOBO_EX (ev))
		return;

	if (bonobo_arg_type_is_equal(value->_type, BONOBO_ARG_LONG, NULL))
		printf ("Value: %d\n", BONOBO_ARG_GET_LONG(value));
	else
		printf ("Property is not long %p\n", value->_type);
	
}

static void
test3_moniker (const char *moniker, CORBA_Environment *ev)
{
	Bonobo_Unknown v;
	CORBA_any *value;

	printf("YTEST1\n");
	v = bonobo_get_object (moniker, "IDL:Bonobo/Property:1.0", ev);
	if (BONOBO_EX(ev) || !v) {
		printf ("ERR %s\n", bonobo_exception_get_text (ev));
		g_error ("Couldn't get Bonobo/Property interface");
	}

	bonobo_event_source_client_add_listener (v, listener_callback, NULL, 
						 NULL, NULL); 


	value = bonobo_arg_new (TC_Bonobo_StorageType);
	BONOBO_ARG_SET_GENERAL (value, Bonobo_STORAGE_TYPE_REGULAR,
				TC_Bonobo_StorageType, long, NULL); 

	Bonobo_Property_setValue (v, value, ev);
	if (BONOBO_EX (ev))
		return;

}

int
main (int argc, char **argv)
{
	CORBA_Environment ev;
	CORBA_ORB orb;

	CORBA_exception_init (&ev);

	gnome_init ("moniker-test", "0.0", argc, argv);

	if ((orb = oaf_init (argc, argv)) == NULL)
		g_error ("Cannot init oaf");

	if (bonobo_init (orb, NULL, NULL) == FALSE)
		g_error ("Cannot init bonobo");

	gconf_init (argc, argv, NULL);

	test_moniker ("config:/test3", &ev);

	if (!BONOBO_EX (&ev))
	    test2_moniker ("config:/test3/test2/value5", &ev);
	if (!BONOBO_EX (&ev))
	    test2_moniker ("config:/test3/test2/value1", &ev);
	if (!BONOBO_EX (&ev))
	    test3_moniker ("config:/test3/test2/value2", &ev);

	bonobo_activate ();

	return 0;
}


