/*
 * config-moniker-demo.c: a small demo for the configuration moniker
 *
 * Author:
 *   Dietmar Maurer (dietmar@ximian.com)
 *
 * Copyright 2001 Ximian, Inc.
 */
#include <bonobo.h>
#include <gconf/gconf-client.h>

static void
display_as_control (const char *moniker, 
		    CORBA_Environment *ev)
{
	Bonobo_Control     control;
	GtkWidget         *widget;
	BonoboUIContainer *ui_container;

	GtkWidget *window;

	control = bonobo_get_object (moniker, "IDL:Bonobo/Control:1.0", ev);
	if (ev->_major != CORBA_NO_EXCEPTION || !control)
		g_error ("Couldn't get Bonobo/Control interface");

	window = bonobo_window_new ("moniker-test", moniker);
	ui_container = bonobo_ui_container_new ();
	bonobo_ui_container_set_win (ui_container, BONOBO_WINDOW (window));

	gtk_window_set_default_size (GTK_WINDOW (window), 400, 350);

	widget = bonobo_widget_new_control_from_objref (control,
		BONOBO_OBJREF (ui_container));
	
	bonobo_object_unref (BONOBO_OBJECT (ui_container));

	if (ev->_major != CORBA_NO_EXCEPTION || !widget)
		g_error ("Couldn't get a widget from the_control");

	bonobo_control_frame_control_activate (
		bonobo_widget_get_control_frame (BONOBO_WIDGET (widget)));

	bonobo_window_set_contents (BONOBO_WINDOW (window), widget);

	gtk_signal_connect (GTK_OBJECT (window), "destroy",
			    GTK_SIGNAL_FUNC (gtk_main_quit), NULL);

	gtk_widget_show_all (window);
}

static void
create_enum (const char *moniker, CORBA_Environment *ev)
{
	Bonobo_Unknown v;
	CORBA_any *value;

	v = bonobo_get_object (moniker, "IDL:Bonobo/Property:1.0", ev);
	if (BONOBO_EX(ev) || !v) {
		printf ("ERR %s\n", bonobo_exception_get_text (ev));
		g_error ("Couldn't get Bonobo/Property interface");
	}

	value = bonobo_arg_new (TC_Bonobo_StorageType);
	BONOBO_ARG_SET_GENERAL (value, Bonobo_STORAGE_TYPE_REGULAR,
				TC_Bonobo_StorageType, long, NULL); 

	Bonobo_Property_setValue (v, value, ev);
}

int
main (int argc, char **argv)
{
	CORBA_Environment ev;
	GConfClient *client;

	CORBA_exception_init (&ev);

	gnome_init ("moniker-test", "0.0", argc, argv);

	if ((oaf_init (argc, argv)) == NULL)
		g_error ("Cannot init oaf");

	if (bonobo_init (NULL, NULL, NULL) == FALSE)
		g_error ("Cannot init bonobo");

	gconf_init (argc, argv, NULL);

	client = gconf_client_get_default ();

	gconf_client_set_float (client, "/bonobo-conf/test/floattest", 
				12.5, NULL);
	gconf_client_set_int (client, "/bonobo-conf/test/longtest", 
			      19, NULL);
	gconf_client_set_string (client, "/bonobo-conf/test/stringtest", 
				 "This is a test", NULL);
	gconf_client_set_bool (client, "/bonobo-conf/test/booltest", 
			      TRUE, NULL);

	create_enum ("config:/bonobo-conf/test/enumtest", &ev);


	display_as_control ("config:/bonobo-conf/test", &ev);
	display_as_control ("config:/bonobo-conf/test", &ev);

	bonobo_main ();

	return 0;
}


