/**
 * bonobo-property-editor.h:
 *
 * Author:
 *   Dietmar Maurer (dietmar@ximian.com)
 *
 * Copyright 2001 Ximian, Inc.
 */
#ifndef _BONOBO_PROPERTY_EDITOR_H_
#define _BONOBO_PROPERTY_EDITOR_H_

#include <bonobo/bonobo-control.h>
#include "Bonobo_PropertyEditor.h"

BEGIN_GNOME_DECLS

#define BONOBO_PROPERTY_EDITOR_PREFIX "OAFIID:Bonobo_PropertyEditor_"
 
#define BONOBO_PROPERTY_EDITOR_TYPE        (bonobo_property_editor_get_type ())
#define BONOBO_PROPERTY_EDITOR(o)          (GTK_CHECK_CAST ((o), BONOBO_PROPERTY_EDITOR_TYPE, BonoboPropertyEditor))
#define BONOBO_PROPERTY_EDITOR_CLASS(k)    (GTK_CHECK_CLASS_CAST((k), BONOBO_PROPERTY_EDITOR_TYPE, BonoboPropertyEditorClass))
#define BONOBO_IS_PROPERTY_EDITOR(o)       (GTK_CHECK_TYPE ((o), BONOBO_PROPERTY_EDITOR_TYPE))
#define BONOBO_IS_PROPERTY_EDITOR_CLASS(k) (GTK_CHECK_CLASS_TYPE ((k), BONOBO_PROPERTY_EDITOR_TYPE))

typedef struct _BonoboPropertyEditorPrivate BonoboPropertyEditorPrivate;

typedef struct {
	BonoboControl base;

	CORBA_TypeCode tc; /* read only */

	BonoboPropertyEditorPrivate *priv;
} BonoboPropertyEditor;

typedef struct {
	BonoboControlClass parent_class;

	POA_Bonobo_PropertyEditor__epv epv;

} BonoboPropertyEditorClass;

typedef void (*BonoboPropertyEditorSetFn) (BonoboPropertyEditor *editor,
					   BonoboArg            *value,
					   GtkWidget            *widget);

GtkType            
bonobo_property_editor_get_type   (void);

BonoboPropertyEditor *
bonobo_property_editor_new        (GtkWidget *widget,
				   BonoboPropertyEditorSetFn set_cb);

void                
bonobo_property_editor_set_value  (BonoboPropertyEditor *editor,
				   const BonoboArg   *value,
				   CORBA_Environment *opt_ev);

BonoboObject *
bonobo_property_editor_basic_new   (CORBA_TypeCode tc);

BonoboObject *
bonobo_property_editor_boolean_new ();

BonoboObject *
bonobo_property_editor_enum_new    ();

Bonobo_PropertyEditor
bonobo_property_editor_resolve     (CORBA_TypeCode tc,  
				    CORBA_Environment *ev);


END_GNOME_DECLS

#endif /* _BONOBO_PROPERTY_EDITOR_H_ */
