/*
 * bonobo-property-editor-boolean.c:
 *
 * Author:
 *   Dietmar Maurer (dietmar@ximian.com)
 *
 * Copyright 2000 Ximian, Inc.
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <ctype.h>
#include <bonobo.h>

#include "bonobo-property-editor.h"

static void
changed_cb (GtkEditable *editable,
	    gpointer     user_data) 
{
	BonoboPropertyEditor *editor = BONOBO_PROPERTY_EDITOR (user_data);
	CORBA_Environment ev;
	DynamicAny_DynAny dyn;
	BonoboArg *arg;
	char *new_str;

	CORBA_exception_init (&ev);

	new_str = gtk_entry_get_text (GTK_ENTRY (editable));

	dyn = CORBA_ORB_create_dyn_enum (bonobo_orb (), editor->tc, &ev);

	if (!strcmp ("TRUE", new_str))
		DynamicAny_DynAny_insert_boolean (dyn, TRUE, &ev);
	else 
		DynamicAny_DynAny_insert_boolean (dyn, FALSE, &ev);

	arg = DynamicAny_DynAny_to_any (dyn, &ev);

	CORBA_Object_release ((CORBA_Object) dyn, &ev);

	bonobo_property_editor_set_value (editor, arg, &ev);

	bonobo_arg_release (arg);

	CORBA_exception_free (&ev);
}

static void
set_value_cb (BonoboPropertyEditor *editor,
	      BonoboArg            *value,
	      GtkWidget            *widget)
{
	CORBA_Environment ev;
	DynamicAny_DynAny dyn;
	GtkCombo *combo;
	GtkEntry *entry;
	CORBA_boolean new_value, old_value;

	if (!bonobo_arg_type_is_equal (value->_type, TC_boolean, NULL))
		return;

	CORBA_exception_init (&ev);
	
	combo = GTK_COMBO (widget);
	entry = GTK_ENTRY (combo->entry);

	dyn = CORBA_ORB_create_dyn_any (bonobo_orb (), value, &ev);

	if (!strcmp (gtk_entry_get_text (entry), "TRUE"))
		old_value = TRUE;
	else
		old_value = FALSE;

	new_value = DynamicAny_DynAny_get_boolean (dyn, &ev);
	
	if (new_value != old_value)
		gtk_entry_set_text (entry, new_value ? "TRUE" : "FALSE");
		
	CORBA_Object_release ((CORBA_Object) dyn, &ev);

	CORBA_exception_free (&ev);
}

BonoboObject *
bonobo_property_editor_boolean_new ()
{
	GtkWidget *combo;
	BonoboPropertyEditor *ed;
	GList *l;

	combo = gtk_combo_new ();

	l = g_list_append (NULL, "TRUE");
	l = g_list_append (l, "FALSE");

	gtk_combo_set_popdown_strings (GTK_COMBO (combo), l);
	g_list_free (l);
	gtk_widget_show (combo);

	ed = bonobo_property_editor_new (combo, set_value_cb);

	gtk_signal_connect (GTK_OBJECT (GTK_COMBO (combo)->entry), "changed",
			    (GtkSignalFunc) changed_cb, ed);

	return BONOBO_OBJECT (ed);
}
