/*
 * bonobo-property-editor-basic.c:
 *
 * Author:
 *   Dietmar Maurer (dietmar@ximian.com)
 *
 * Copyright 2000 Ximian, Inc.
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <ctype.h>
#include <bonobo.h>

#include "bonobo-property-editor.h"

typedef struct {
	CORBA_TypeCode tc;
} Bonobo_PropertyEditor_Data_long;

static Bonobo_PropertyEditor_Data_long *
get_data (BonoboPropertyEditor *editor)
{
	return gtk_object_get_data (GTK_OBJECT (editor), 
				    "PROPERTY_EDITOR_DATA");
}

static void
destroy_cb (BonoboPropertyEditor *editor,
	    gpointer              user_data) 
{
	Bonobo_PropertyEditor_Data_long *pd;

	pd = get_data (editor);

	if (pd)
		g_free (pd);
}

static void
set_value_cb (BonoboPropertyEditor *editor,
	      BonoboArg            *value,
	      GtkWidget            *widget)
{
	Bonobo_PropertyEditor_Data_long *pd;
	GtkEntry *entry = GTK_ENTRY (widget);
	CORBA_Environment ev;
	DynamicAny_DynAny dyn;
	char *text;

	pd = get_data (editor);

	if (!pd)
		return;

	if (!bonobo_arg_type_is_equal (value->_type, pd->tc, NULL))
		return;

	CORBA_exception_init (&ev);

	dyn = CORBA_ORB_create_dyn_any (bonobo_orb (), value, &ev);

	if (BONOBO_EX (&ev) || dyn == NULL)
		return;

	if (bonobo_arg_type_is_equal (value->_type, TC_ushort, NULL)) {
		CORBA_unsigned_short v;
		
		v = DynamicAny_DynAny_get_ushort (dyn, &ev); 
		text =  g_strdup_printf ("%u", v);
	
	} else if (bonobo_arg_type_is_equal (value->_type, TC_short, NULL)) {
		CORBA_short v;
		
		v = DynamicAny_DynAny_get_short (dyn, &ev); 
		text =  g_strdup_printf ("%d", v);

	} else if (bonobo_arg_type_is_equal (value->_type, TC_ulong, NULL)) {
		CORBA_unsigned_long v;
		
		v = DynamicAny_DynAny_get_ulong (dyn, &ev); 
		text =  g_strdup_printf ("%u", v);
	
	} else if (bonobo_arg_type_is_equal (value->_type, TC_long, NULL)) {
		CORBA_long v;
		v = DynamicAny_DynAny_get_long (dyn, &ev); 
		text =  g_strdup_printf ("%d", v);

	} else if (bonobo_arg_type_is_equal (value->_type, TC_float, NULL)) {
		CORBA_float v;
		
		v = DynamicAny_DynAny_get_float (dyn, &ev); 
		text =  g_strdup_printf ("%f", v);

	} else if (bonobo_arg_type_is_equal (value->_type, TC_double, NULL)) {
		CORBA_double v;
		
		v = DynamicAny_DynAny_get_double (dyn, &ev); 
		text =  g_strdup_printf ("%g", v);

	} else if (bonobo_arg_type_is_equal (value->_type, TC_string, NULL)) {
		CORBA_char *v;

		v = DynamicAny_DynAny_get_string (dyn, &ev); 
		text =  g_strdup (v);
		CORBA_free (v);

	} else {
		text = g_strdup ("(unknown type code)");
	}


	gtk_entry_set_text (entry, text);
	g_free (text);

	CORBA_exception_free (&ev);
}

static void        
key_press_cb (GtkEntry *entry,
	      GdkEventKey *event,
	      gpointer user_data)
{
	BonoboPropertyEditor *editor = BONOBO_PROPERTY_EDITOR (user_data);
	Bonobo_PropertyEditor_Data_long *pd;
	CORBA_Environment ev;
	DynamicAny_DynAny dyn = NULL;
	BonoboArg *arg;
	CORBA_ORB orb;
	char *text;

	if (!((event->type == GDK_KEY_PRESS) && (event->state == 0) &&
	      (event->keyval == GDK_Return)))
		return;

	pd = get_data (editor);

	if (!pd)
		return;

	CORBA_exception_init (&ev);

	orb = bonobo_orb ();

	text = gtk_entry_get_text (entry);

	if (bonobo_arg_type_is_equal (pd->tc, TC_ushort, NULL)) {
		CORBA_unsigned_short v;

		dyn = CORBA_ORB_create_basic_dyn_any (orb, TC_ushort, &ev);
		v = strtoul (text, NULL, 0);
		DynamicAny_DynAny_insert_ushort (dyn, v, &ev);

	} else if (bonobo_arg_type_is_equal (pd->tc, TC_short, NULL)) {
		CORBA_short v;
		
		dyn = CORBA_ORB_create_basic_dyn_any (orb, TC_short, &ev);
		v = strtol (text, NULL, 0);
		DynamicAny_DynAny_insert_short (dyn, v, &ev);
	
	} else if (bonobo_arg_type_is_equal (pd->tc, TC_ulong, NULL)) {
		CORBA_unsigned_long v;

		dyn = CORBA_ORB_create_basic_dyn_any (orb, TC_ulong, &ev);
		v = strtoul (text, NULL, 0);
		DynamicAny_DynAny_insert_ulong (dyn, v, &ev);

	} else if (bonobo_arg_type_is_equal (pd->tc, TC_long, NULL)) {
		CORBA_long v;
		
		dyn = CORBA_ORB_create_basic_dyn_any (orb, TC_long, &ev);
		v = strtol (text, NULL, 0);
		DynamicAny_DynAny_insert_long (dyn, v, &ev);
	
	} else if (bonobo_arg_type_is_equal (pd->tc, TC_float, NULL)) {
		CORBA_float v;
		
		dyn = CORBA_ORB_create_basic_dyn_any (orb, TC_float, &ev);
		v = strtod (text, NULL);
		DynamicAny_DynAny_insert_float (dyn, v, &ev);

	} else if (bonobo_arg_type_is_equal (pd->tc, TC_double, NULL)) {
		CORBA_float v;
		
		dyn = CORBA_ORB_create_basic_dyn_any (orb, TC_double, &ev);
		v = strtod (text, NULL);
		DynamicAny_DynAny_insert_double (dyn, v, &ev);

	} else if (bonobo_arg_type_is_equal (pd->tc, TC_string, NULL)) {

		dyn = CORBA_ORB_create_basic_dyn_any (orb, TC_string, &ev);
		DynamicAny_DynAny_insert_string (dyn, text, &ev);
	}
	
	if (BONOBO_EX (&ev) || dyn == NULL)
		return;

	arg = DynamicAny_DynAny_to_any (dyn, &ev);

	CORBA_Object_release ((CORBA_Object) dyn, &ev);

	bonobo_property_editor_set_value (editor, arg, &ev);

	bonobo_arg_release (arg);

	CORBA_exception_free (&ev);
}

static gboolean
is_supported (CORBA_TypeCode tc)
{
	if (bonobo_arg_type_is_equal (tc, TC_short, NULL))
		return TRUE;
	if (bonobo_arg_type_is_equal (tc, TC_ushort, NULL))
		return TRUE;
	if (bonobo_arg_type_is_equal (tc, TC_long, NULL))
		return TRUE;
	if (bonobo_arg_type_is_equal (tc, TC_ulong, NULL))
		return TRUE;
	if (bonobo_arg_type_is_equal (tc, TC_float, NULL))
		return TRUE;
	if (bonobo_arg_type_is_equal (tc, TC_double, NULL))
		return TRUE;
	if (bonobo_arg_type_is_equal (tc, TC_string, NULL))
		return TRUE;

	return FALSE;
}

BonoboObject *
bonobo_property_editor_basic_new (CORBA_TypeCode tc)
{
	GtkWidget *entry;
	BonoboPropertyEditor *ed;
	Bonobo_PropertyEditor_Data_long *data;

	if (!is_supported (tc))
		return NULL;

	entry = gtk_entry_new ();
	gtk_widget_show (entry);

	data = g_new0 (Bonobo_PropertyEditor_Data_long, 1);
	data->tc = tc;

	ed = bonobo_property_editor_new (entry, set_value_cb);

	gtk_object_set_data (GTK_OBJECT (ed), "PROPERTY_EDITOR_DATA", data);

	gtk_signal_connect (GTK_OBJECT (entry), "key-press-event",
			    (GtkSignalFunc) key_press_cb, ed);

	gtk_signal_connect (GTK_OBJECT (ed), "destroy",
			    (GtkSignalFunc) destroy_cb, NULL);

	return BONOBO_OBJECT (ed);
}
