/* ***** BEGIN LICENSE BLOCK *****  
 * Source last modified: $Id: cnttab.h,v 1.2 2005/08/26 02:06:53 abock Exp $ 
 *   
 * Portions Copyright (c) 1995-2005 RealNetworks, Inc. All Rights Reserved.  
 *       
 * The contents of this file, and the files included with this file, 
 * are subject to the current version of the RealNetworks Public 
 * Source License (the "RPSL") available at 
 * http://www.helixcommunity.org/content/rpsl unless you have licensed 
 * the file under the current version of the RealNetworks Community 
 * Source License (the "RCSL") available at 
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL 
 * will apply. You may also obtain the license terms directly from 
 * RealNetworks.  You may not use this file except in compliance with 
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable 
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for 
 * the rights, obligations and limitations governing use of the 
 * contents of the file. 
 *   
 * This file is part of the Helix DNA Technology. RealNetworks is the 
 * developer of the Original Code and owns the copyrights in the 
 * portions it created. 
 *   
 * This file, and the files included with this file, is distributed 
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY 
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS 
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES 
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET 
 * ENJOYMENT OR NON-INFRINGEMENT. 
 *  
 * Technology Compatibility Kit Test Suite(s) Location:  
 *    http://www.helixcommunity.org/content/tck  
 *  
 * Contributor(s):  
 *   
 * ***** END LICENSE BLOCK ***** */

static unsigned int SelectTable[][5] = {
    {0, 0, 0, 0, 0,},   /*  0 */
    {1, 3, 0, 0, 1,},   /*  1 */
    {2, 3, 0, 0, 2,},   /*  2 */
    {5, 6, 0, 0, 3,},   /*  3 */
    {7, 8, 9, 12, 5,},  /*  4 */
    {7, 8, 9, 12, 5,},  /*  5 */
    {10, 11, 12, 15, 7,},       /*  6 */
    {10, 11, 12, 15, 7,},       /*  7 */
    {13, 15, 0, 0, 15,},        /*  8 */
    {13, 15, 0, 0, 15,},        /*  9 */
    {13, 15, 0, 0, 15,},        /* 10 */
    {13, 15, 0, 0, 15,},        /* 11 */
    {13, 15, 0, 0, 15,},        /* 12 */
    {13, 15, 0, 0, 15,},        /* 13 */
    {13, 15, 0, 0, 15,},        /* 14 */
    {13, 15, 0, 0, 15,},        /* 15 */
    {16, 24, 0, 0, 16,},        /* 16 */
    {17, 24, 0, 0, 18,},        /* 17 */
    {17, 24, 0, 0, 18,},        /* 18 */
    {18, 24, 0, 0, 22,},        /* 19 */
    {18, 24, 0, 0, 22,},        /* 20 */
    {18, 24, 0, 0, 22,},        /* 21 */
    {18, 24, 0, 0, 22,},        /* 22 */
};

/*   0  idim =  1 len =   1   wide = 0  */
static unsigned int count_table_0_0[][1] = {
    0x00000000,
};

/*   1  idim =  2 len =   4   wide = 0  */
static unsigned int count_table_1_3[][2] = {
    0x00020001, 0x00030004, 0x00040003, 0x00040005,
};

/*   2  idim =  4 len =  16   wide = 0  */
static unsigned int count_table_2_3[][4] = {
    0x00020001, 0x00030004, 0x00070007, 0x00000000, 0x00040004, 0x00040005,
    0x00070007, 0x00000000, 0x00060006, 0x00070007, 0x00080008, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
};

/*   3  idim =  4 len =  16   wide = 0  */
static unsigned int count_table_5_6[][4] = {
    0x00030001, 0x00040004, 0x00060007, 0x00080008, 0x00040004, 0x00040005,
    0x00060008, 0x00070009, 0x00050007, 0x00060008, 0x00070009, 0x0008000A,
    0x00070008, 0x00070008, 0x00080009, 0x0009000A,
};

/*   4  idim =  8 len =  64   wide = 1  */
static unsigned int count_table_7_8_9_12[][8][2] = {
    0x00020001, 0x00040003, 0x00040004, 0x00040004,
    0x00070007, 0x00060006, 0x00090009, 0x00080007,
    0x00090009, 0x00090009, 0x000A000A, 0x000A000A,
    0x00000000, 0x000A0000, 0x00000000, 0x000A0000,
    0x00040004, 0x00040004, 0x00040006, 0x00050005,
    0x00060008, 0x00060006, 0x000A0009, 0x00070007,
    0x000A0009, 0x00090008, 0x000A000A, 0x0009000A,
    0x00000000, 0x000A0000, 0x00000000, 0x000A0000,
    0x00070007, 0x00060005, 0x00060007, 0x00060006,
    0x00080009, 0x00070007, 0x000A000A, 0x00080008,
    0x000A000A, 0x00090009, 0x000B000B, 0x000A000A,
    0x00000000, 0x00090000, 0x00000000, 0x000A0000,
    0x00090008, 0x00070007, 0x000A0009, 0x00070007,
    0x000A000A, 0x00080008, 0x000B000B, 0x00080009,
    0x000B000B, 0x00090009, 0x000C000B, 0x000A000A,
    0x00000000, 0x000A0000, 0x00000000, 0x000A0000,
    0x00090008, 0x00080008, 0x00090009, 0x00080008,
    0x000A000A, 0x00090009, 0x000B000B, 0x00090009,
    0x000C000B, 0x000A000A, 0x000C000C, 0x000A000B,
    0x00000000, 0x000A0000, 0x00000000, 0x000B0000,
    0x000A0009, 0x00090009, 0x000A000A, 0x00090009,
    0x000B000B, 0x000A000A, 0x000B000C, 0x000A000A,
    0x000D000C, 0x000A000B, 0x000D000C, 0x000B000B,
    0x00000000, 0x000A0000, 0x00000000, 0x000B0000,
    0x00030002, 0x00090001, 0x00040004, 0x00090004,
    0x00060007, 0x00090007, 0x00070009, 0x000A0009,
    0x00090009, 0x000A000A, 0x000A000A, 0x000B000A,
    0x00000000, 0x000B000A, 0x00000000, 0x000C000B,
    0x00040004, 0x000A0004, 0x00050004, 0x000A0006,
    0x00060006, 0x000A0008, 0x0007000A, 0x000B0009,
    0x0008000A, 0x000B000A, 0x000A000A, 0x000B000B,
    0x00000000, 0x000B000A, 0x00000000, 0x000C000A,
};

/*   5  idim =  8 len =  64   wide = 1  */

/*   6  idim =  8 len =  64   wide = 1  */
static unsigned int count_table_10_11_12_15[][8][2] = {
    0x00020001, 0x00030004, 0x00040004, 0x00050004,
    0x00060007, 0x00060006, 0x00080009, 0x00080008,
    0x0009000A, 0x00080009, 0x000A000A, 0x0009000A,
    0x0009000A, 0x000A000A, 0x000A000B, 0x000A000A,
    0x00040004, 0x00050004, 0x00050006, 0x00050005,
    0x00060008, 0x00070006, 0x00080009, 0x00080007,
    0x000A000A, 0x00090009, 0x000A000B, 0x00090009,
    0x0009000A, 0x000A000A, 0x000A000A, 0x000A000A,
    0x00060007, 0x00060006, 0x00070008, 0x00070006,
    0x00080009, 0x00070007, 0x0009000A, 0x00080008,
    0x000A000B, 0x00090009, 0x000B000C, 0x0009000A,
    0x000A000B, 0x000A0009, 0x000A000B, 0x000A000A,
    0x00080008, 0x00070007, 0x00080009, 0x00080007,
    0x0009000A, 0x00080008, 0x000B000B, 0x00090008,
    0x000A000C, 0x00090009, 0x000C000C, 0x000A000A,
    0x000A000B, 0x000A000A, 0x000B000C, 0x000B000A,
    0x00090009, 0x00080008, 0x000A000A, 0x00080008,
    0x000A000B, 0x00090009, 0x000B000C, 0x00090009,
    0x000B000C, 0x000A000A, 0x000C000C, 0x000A000A,
    0x000B000C, 0x000B000A, 0x000C000C, 0x000B000B,
    0x0009000A, 0x00090009, 0x000A000B, 0x00090009,
    0x000B000C, 0x0009000A, 0x000C000C, 0x000A000A,
    0x000C000D, 0x000A000A, 0x000D000D, 0x000A000B,
    0x000C000C, 0x000B000A, 0x000D000D, 0x000B000B,
    0x00090009, 0x000A0009, 0x0009000A, 0x00090009,
    0x0009000B, 0x000A0009, 0x000A000C, 0x000A000A,
    0x000B000C, 0x000A000A, 0x000C000C, 0x000B000B,
    0x000C000D, 0x000B000B, 0x000C000D, 0x000B000C,
    0x0009000A, 0x000A000A, 0x0009000A, 0x000A000A,
    0x000A000B, 0x000A000A, 0x000B000C, 0x000B000B,
    0x000C000C, 0x000B000B, 0x000C000D, 0x000B000B,
    0x000C000D, 0x000B000B, 0x000C000D, 0x000C000C,
};

/*   7  idim =  8 len =  64   wide = 1  */

/*   8  idim = 16 len = 256   wide = 0  */
static unsigned int count_table_13_15[][16] = {
    0x00030001, 0x00050005, 0x00060007, 0x00080008, 0x00080009, 0x0009000A,
    0x000A000A, 0x000A000B, 0x000A000A, 0x000B000B, 0x000B000C, 0x000C000C,
    0x000C000D, 0x000C000D, 0x000D000E, 0x000E000E, 0x00050004, 0x00050006,
    0x00070008, 0x00080009, 0x0009000A, 0x0009000A, 0x000A000B, 0x000A000B,
    0x000A000B, 0x000B000B, 0x000B000C, 0x000C000C, 0x000C000D, 0x000C000E,
    0x000D000E, 0x000D000E, 0x00060007, 0x00070008, 0x00070009, 0x0008000A,
    0x0009000B, 0x0009000B, 0x000A000C, 0x000A000C, 0x000A000B, 0x000B000C,
    0x000B000C, 0x000C000D, 0x000C000D, 0x000D000E, 0x000D000F, 0x000D000F,
    0x00070008, 0x00080009, 0x0008000A, 0x0009000B, 0x0009000B, 0x000A000C,
    0x000A000C, 0x000B000C, 0x000B000C, 0x000B000D, 0x000C000D, 0x000C000D,
    0x000C000D, 0x000D000E, 0x000D000F, 0x000D000F, 0x00080009, 0x00080009,
    0x0009000B, 0x0009000B, 0x000A000C, 0x000A000C, 0x000B000D, 0x000B000D,
    0x000B000C, 0x000B000D, 0x000C000D, 0x000C000E, 0x000C000E, 0x000D000F,
    0x000D000F, 0x000D0010, 0x0009000A, 0x0009000A, 0x0009000B, 0x000A000C,
    0x000A000C, 0x000A000C, 0x000B000D, 0x000B000D, 0x000B000D, 0x000B000D,
    0x000C000E, 0x000C000D, 0x000D000F, 0x000D000F, 0x000D0010, 0x000E0010,
    0x000A000A, 0x0009000B, 0x000A000C, 0x000A000C, 0x000A000D, 0x000B000D,
    0x000B000D, 0x000B000D, 0x000B000D, 0x000C000E, 0x000C000E, 0x000C000E,
    0x000D000F, 0x000D000F, 0x000E0010, 0x000E0010, 0x000A000B, 0x000A000B,
    0x000A000C, 0x000B000D, 0x000B000D, 0x000B000D, 0x000B000E, 0x000C000E,
    0x000C000E, 0x000C000E, 0x000C000F, 0x000C000F, 0x000D000F, 0x000D0010,
    0x000D0012, 0x000E0012, 0x000A000A, 0x000A000A, 0x000A000B, 0x000B000C,
    0x000B000C, 0x000B000D, 0x000B000D, 0x000C000E, 0x000C000E, 0x000C000E,
    0x000C000E, 0x000D000F, 0x000D000F, 0x000E0010, 0x000E0011, 0x000E0011,
    0x000A000B, 0x000A000B, 0x000B000C, 0x000B000C, 0x000B000D, 0x000B000D,
    0x000C000D, 0x000C000F, 0x000C000E, 0x000D000F, 0x000D000F, 0x000D0010,
    0x000D0010, 0x000E0010, 0x000E0012, 0x000E0011, 0x000B000B, 0x000B000C,
    0x000B000C, 0x000B000D, 0x000C000D, 0x000C000E, 0x000C000E, 0x000C000F,
    0x000C000E, 0x000D000F, 0x000D0010, 0x000D000F, 0x000D0010, 0x000E0011,
    0x000F0012, 0x000E0013, 0x000B000C, 0x000B000C, 0x000B000C, 0x000B000D,
    0x000C000E, 0x000C000E, 0x000C000E, 0x000C000E, 0x000D000F, 0x000D000F,
    0x000D000F, 0x000D0010, 0x000E0011, 0x000E0011, 0x000E0011, 0x000F0012,
    0x000C000C, 0x000C000D, 0x000B000D, 0x000C000E, 0x000C000E, 0x000C000F,
    0x000D000E, 0x000D000F, 0x000D0010, 0x000D0010, 0x000D0011, 0x000D0011,
    0x000E0011, 0x000E0012, 0x000F0012, 0x000F0012, 0x000C000D, 0x000C000D,
    0x000C000E, 0x000C000F, 0x000C000F, 0x000D000F, 0x000D0010, 0x000D0010,
    0x000D0010, 0x000E0010, 0x000E0010, 0x000E0011, 0x000E0012, 0x000E0011,
    0x000F0012, 0x000F0012, 0x000D000E, 0x000D000E, 0x000D000E, 0x000D000F,
    0x000D000F, 0x000D000F, 0x000D0011, 0x000D0010, 0x000E0010, 0x000E0013,
    0x000E0011, 0x000E0011, 0x000F0011, 0x000F0013, 0x000E0012, 0x000F0012,
    0x000D000D, 0x000D000E, 0x000D000F, 0x000D0010, 0x000D0010, 0x000D0010,
    0x000D0011, 0x000E0010, 0x000E0011, 0x000E0011, 0x000E0012, 0x000E0012,
    0x000F0015, 0x000F0014, 0x000F0015, 0x000F0012,
};

/*   9  idim = 16 len = 256   wide = 0  */

/*  10  idim = 16 len = 256   wide = 0  */

/*  11  idim = 16 len = 256   wide = 0  */

/*  12  idim = 16 len = 256   wide = 0  */

/*  13  idim = 16 len = 256   wide = 0  */

/*  14  idim = 16 len = 256   wide = 0  */

/*  15  idim = 16 len = 256   wide = 0  */

/*  16  idim = 16 len = 256   wide = 0  */
static unsigned int count_table_16_24[][16] = {
    0x00040001, 0x00050005, 0x00070007, 0x00080009, 0x0009000A, 0x000A000A,
    0x000A000B, 0x000B000B, 0x000B000C, 0x000C000C, 0x000C000C, 0x000C000D,
    0x000C000D, 0x000C000D, 0x000D000E, 0x000E000B, 0x00050004, 0x00060006,
    0x00070008, 0x00080009, 0x0009000A, 0x000A000B, 0x000A000B, 0x000B000B,
    0x000B000C, 0x000B000C, 0x000C000C, 0x000C000D, 0x000C000E, 0x000C000D,
    0x000C000E, 0x000E000B, 0x00070007, 0x00070008, 0x00080009, 0x0009000A,
    0x0009000B, 0x000A000B, 0x000A000C, 0x000B000C, 0x000B000D, 0x000B000C,
    0x000B000D, 0x000C000D, 0x000C000D, 0x000C000E, 0x000D000E, 0x000D000C,
    0x00080009, 0x00080009, 0x0009000A, 0x0009000B, 0x000A000B, 0x000A000C,
    0x000A000C, 0x000B000C, 0x000B000D, 0x000B000D, 0x000B000E, 0x000C000E,
    0x000C000E, 0x000C000F, 0x000C000F, 0x000D000D, 0x0009000A, 0x0009000A,
    0x0009000B, 0x000A000B, 0x000A000C, 0x000A000C, 0x000A000D, 0x000B000D,
    0x000B000D, 0x000B000E, 0x000C000E, 0x000C000E, 0x000C000F, 0x000C000F,
    0x000D000F, 0x000D000C, 0x000A000A, 0x0009000A, 0x000A000B, 0x000A000B,
    0x000A000C, 0x000A000D, 0x000B000D, 0x000B000E, 0x000B000D, 0x000B000E,
    0x000C000E, 0x000C000F, 0x000C000F, 0x000C000F, 0x000C0010, 0x000D000D,
    0x000A000B, 0x000A000B, 0x000A000B, 0x000A000C, 0x000A000D, 0x000B000D,
    0x000B000D, 0x000B000D, 0x000B000E, 0x000C000E, 0x000C000E, 0x000C000E,
    0x000C000F, 0x000C000F, 0x000D0010, 0x000D000D, 0x000B000B, 0x000A000B,
    0x000A000C, 0x000A000C, 0x000B000D, 0x000B000D, 0x000B000D, 0x000B000E,
    0x000C000E, 0x000C000F, 0x000C000F, 0x000C000F, 0x000C000F, 0x000D0011,
    0x000D0011, 0x000E000D, 0x000B000B, 0x000B000C, 0x000B000C, 0x000B000D,
    0x000B000D, 0x000B000D, 0x000B000E, 0x000B000E, 0x000B000F, 0x000C000F,
    0x000C000F, 0x000C000F, 0x000C0010, 0x000D0010, 0x000D0010, 0x000E000D,
    0x000B000C, 0x000B000C, 0x000B000C, 0x000B000D, 0x000B000D, 0x000B000E,
    0x000B000E, 0x000C000F, 0x000C000F, 0x000C000F, 0x000C000F, 0x000C0010,
    0x000D000F, 0x000D0010, 0x000D000F, 0x000E000E, 0x000C000C, 0x000B000D,
    0x000B000C, 0x000B000D, 0x000B000E, 0x000C000E, 0x000C000E, 0x000C000E,
    0x000C000F, 0x000C0010, 0x000C0010, 0x000D0010, 0x000D0011, 0x000D0011,
    0x000D0010, 0x000E000D, 0x000C000D, 0x000C000D, 0x000B000D, 0x000B000D,
    0x000B000E, 0x000C000E, 0x000C000F, 0x000C0010, 0x000C0010, 0x000C0010,
    0x000C0010, 0x000D0010, 0x000D0010, 0x000D000F, 0x000D0010, 0x000E000E,
    0x000C000D, 0x000C000E, 0x000C000E, 0x000C000E, 0x000C000E, 0x000C000F,
    0x000C000F, 0x000C000F, 0x000C000F, 0x000C0011, 0x000D0010, 0x000D0010,
    0x000D0010, 0x000D0010, 0x000D0012, 0x000E000E, 0x000C000F, 0x000C000E,
    0x000C000E, 0x000C000E, 0x000C000F, 0x000C000F, 0x000C0010, 0x000C0010,
    0x000D0010, 0x000D0012, 0x000D0011, 0x000D0011, 0x000D0011, 0x000D0013,
    0x000D0011, 0x000E000E, 0x000D000E, 0x000C000F, 0x000C000D, 0x000C000E,
    0x000C0010, 0x000C0010, 0x000C000F, 0x000D0010, 0x000D0010, 0x000D0011,
    0x000D0012, 0x000D0011, 0x000D0013, 0x000D0011, 0x000D0010, 0x000E000E,
    0x000D000B, 0x000D000B, 0x000D000B, 0x000D000C, 0x000D000C, 0x000D000D,
    0x000D000D, 0x000D000D, 0x000D000E, 0x000D000E, 0x000D000E, 0x000E000E,
    0x000E000E, 0x000E000E, 0x000E000E, 0x000E000C,
};

/*  17  idim = 16 len = 256   wide = 0  */
static unsigned int count_table_17_24[][16] = {
    0x00040001, 0x00050005, 0x00070007, 0x00080009, 0x0009000A, 0x000A000A,
    0x000A000B, 0x000B000B, 0x000B000C, 0x000C000C, 0x000C000C, 0x000C000D,
    0x000C000D, 0x000C000D, 0x000D000E, 0x000E000C, 0x00050004, 0x00060006,
    0x00070008, 0x00080009, 0x0009000A, 0x000A000B, 0x000A000B, 0x000B000B,
    0x000B000C, 0x000B000C, 0x000C000C, 0x000C000D, 0x000C000E, 0x000C000D,
    0x000C000E, 0x000E000C, 0x00070007, 0x00070008, 0x00080009, 0x0009000A,
    0x0009000B, 0x000A000B, 0x000A000C, 0x000B000C, 0x000B000D, 0x000B000C,
    0x000B000D, 0x000C000D, 0x000C000D, 0x000C000E, 0x000D000E, 0x000D000D,
    0x00080009, 0x00080009, 0x0009000A, 0x0009000B, 0x000A000B, 0x000A000C,
    0x000A000C, 0x000B000C, 0x000B000D, 0x000B000D, 0x000B000E, 0x000C000E,
    0x000C000E, 0x000C000F, 0x000C000F, 0x000D000E, 0x0009000A, 0x0009000A,
    0x0009000B, 0x000A000B, 0x000A000C, 0x000A000C, 0x000A000D, 0x000B000D,
    0x000B000D, 0x000B000E, 0x000C000E, 0x000C000E, 0x000C000F, 0x000C000F,
    0x000D000F, 0x000D000D, 0x000A000A, 0x0009000A, 0x000A000B, 0x000A000B,
    0x000A000C, 0x000A000D, 0x000B000D, 0x000B000E, 0x000B000D, 0x000B000E,
    0x000C000E, 0x000C000F, 0x000C000F, 0x000C000F, 0x000C0010, 0x000D000E,
    0x000A000B, 0x000A000B, 0x000A000B, 0x000A000C, 0x000A000D, 0x000B000D,
    0x000B000D, 0x000B000D, 0x000B000E, 0x000C000E, 0x000C000E, 0x000C000E,
    0x000C000F, 0x000C000F, 0x000D0010, 0x000D000E, 0x000B000B, 0x000A000B,
    0x000A000C, 0x000A000C, 0x000B000D, 0x000B000D, 0x000B000D, 0x000B000E,
    0x000C000E, 0x000C000F, 0x000C000F, 0x000C000F, 0x000C000F, 0x000D0011,
    0x000D0011, 0x000E000E, 0x000B000B, 0x000B000C, 0x000B000C, 0x000B000D,
    0x000B000D, 0x000B000D, 0x000B000E, 0x000B000E, 0x000B000F, 0x000C000F,
    0x000C000F, 0x000C000F, 0x000C0010, 0x000D0010, 0x000D0010, 0x000E000E,
    0x000B000C, 0x000B000C, 0x000B000C, 0x000B000D, 0x000B000D, 0x000B000E,
    0x000B000E, 0x000C000F, 0x000C000F, 0x000C000F, 0x000C000F, 0x000C0010,
    0x000D000F, 0x000D0010, 0x000D000F, 0x000E000F, 0x000C000C, 0x000B000D,
    0x000B000C, 0x000B000D, 0x000B000E, 0x000C000E, 0x000C000E, 0x000C000E,
    0x000C000F, 0x000C0010, 0x000C0010, 0x000D0010, 0x000D0011, 0x000D0011,
    0x000D0010, 0x000E000E, 0x000C000D, 0x000C000D, 0x000B000D, 0x000B000D,
    0x000B000E, 0x000C000E, 0x000C000F, 0x000C0010, 0x000C0010, 0x000C0010,
    0x000C0010, 0x000D0010, 0x000D0010, 0x000D000F, 0x000D0010, 0x000E000F,
    0x000C000D, 0x000C000E, 0x000C000E, 0x000C000E, 0x000C000E, 0x000C000F,
    0x000C000F, 0x000C000F, 0x000C000F, 0x000C0011, 0x000D0010, 0x000D0010,
    0x000D0010, 0x000D0010, 0x000D0012, 0x000E000F, 0x000C000F, 0x000C000E,
    0x000C000E, 0x000C000E, 0x000C000F, 0x000C000F, 0x000C0010, 0x000C0010,
    0x000D0010, 0x000D0012, 0x000D0011, 0x000D0011, 0x000D0011, 0x000D0013,
    0x000D0011, 0x000E000F, 0x000D000E, 0x000C000F, 0x000C000D, 0x000C000E,
    0x000C0010, 0x000C0010, 0x000C000F, 0x000D0010, 0x000D0010, 0x000D0011,
    0x000D0012, 0x000D0011, 0x000D0013, 0x000D0011, 0x000D0010, 0x000E000F,
    0x000D000C, 0x000D000C, 0x000D000C, 0x000D000D, 0x000D000D, 0x000D000E,
    0x000D000E, 0x000D000E, 0x000D000F, 0x000D000F, 0x000D000F, 0x000E000F,
    0x000E000F, 0x000E000F, 0x000E000F, 0x000E000E,
};

/*  18  idim = 16 len = 256   wide = 0  */

/*  19  idim = 16 len = 256   wide = 0  */
static unsigned int count_table_18_24[][16] = {
    0x00040001, 0x00050005, 0x00070007, 0x00080009, 0x0009000A, 0x000A000A,
    0x000A000B, 0x000B000B, 0x000B000C, 0x000C000C, 0x000C000C, 0x000C000D,
    0x000C000D, 0x000C000D, 0x000D000E, 0x000E000D, 0x00050004, 0x00060006,
    0x00070008, 0x00080009, 0x0009000A, 0x000A000B, 0x000A000B, 0x000B000B,
    0x000B000C, 0x000B000C, 0x000C000C, 0x000C000D, 0x000C000E, 0x000C000D,
    0x000C000E, 0x000E000D, 0x00070007, 0x00070008, 0x00080009, 0x0009000A,
    0x0009000B, 0x000A000B, 0x000A000C, 0x000B000C, 0x000B000D, 0x000B000C,
    0x000B000D, 0x000C000D, 0x000C000D, 0x000C000E, 0x000D000E, 0x000D000E,
    0x00080009, 0x00080009, 0x0009000A, 0x0009000B, 0x000A000B, 0x000A000C,
    0x000A000C, 0x000B000C, 0x000B000D, 0x000B000D, 0x000B000E, 0x000C000E,
    0x000C000E, 0x000C000F, 0x000C000F, 0x000D000F, 0x0009000A, 0x0009000A,
    0x0009000B, 0x000A000B, 0x000A000C, 0x000A000C, 0x000A000D, 0x000B000D,
    0x000B000D, 0x000B000E, 0x000C000E, 0x000C000E, 0x000C000F, 0x000C000F,
    0x000D000F, 0x000D000E, 0x000A000A, 0x0009000A, 0x000A000B, 0x000A000B,
    0x000A000C, 0x000A000D, 0x000B000D, 0x000B000E, 0x000B000D, 0x000B000E,
    0x000C000E, 0x000C000F, 0x000C000F, 0x000C000F, 0x000C0010, 0x000D000F,
    0x000A000B, 0x000A000B, 0x000A000B, 0x000A000C, 0x000A000D, 0x000B000D,
    0x000B000D, 0x000B000D, 0x000B000E, 0x000C000E, 0x000C000E, 0x000C000E,
    0x000C000F, 0x000C000F, 0x000D0010, 0x000D000F, 0x000B000B, 0x000A000B,
    0x000A000C, 0x000A000C, 0x000B000D, 0x000B000D, 0x000B000D, 0x000B000E,
    0x000C000E, 0x000C000F, 0x000C000F, 0x000C000F, 0x000C000F, 0x000D0011,
    0x000D0011, 0x000E000F, 0x000B000B, 0x000B000C, 0x000B000C, 0x000B000D,
    0x000B000D, 0x000B000D, 0x000B000E, 0x000B000E, 0x000B000F, 0x000C000F,
    0x000C000F, 0x000C000F, 0x000C0010, 0x000D0010, 0x000D0010, 0x000E000F,
    0x000B000C, 0x000B000C, 0x000B000C, 0x000B000D, 0x000B000D, 0x000B000E,
    0x000B000E, 0x000C000F, 0x000C000F, 0x000C000F, 0x000C000F, 0x000C0010,
    0x000D000F, 0x000D0010, 0x000D000F, 0x000E0010, 0x000C000C, 0x000B000D,
    0x000B000C, 0x000B000D, 0x000B000E, 0x000C000E, 0x000C000E, 0x000C000E,
    0x000C000F, 0x000C0010, 0x000C0010, 0x000D0010, 0x000D0011, 0x000D0011,
    0x000D0010, 0x000E000F, 0x000C000D, 0x000C000D, 0x000B000D, 0x000B000D,
    0x000B000E, 0x000C000E, 0x000C000F, 0x000C0010, 0x000C0010, 0x000C0010,
    0x000C0010, 0x000D0010, 0x000D0010, 0x000D000F, 0x000D0010, 0x000E0010,
    0x000C000D, 0x000C000E, 0x000C000E, 0x000C000E, 0x000C000E, 0x000C000F,
    0x000C000F, 0x000C000F, 0x000C000F, 0x000C0011, 0x000D0010, 0x000D0010,
    0x000D0010, 0x000D0010, 0x000D0012, 0x000E0010, 0x000C000F, 0x000C000E,
    0x000C000E, 0x000C000E, 0x000C000F, 0x000C000F, 0x000C0010, 0x000C0010,
    0x000D0010, 0x000D0012, 0x000D0011, 0x000D0011, 0x000D0011, 0x000D0013,
    0x000D0011, 0x000E0010, 0x000D000E, 0x000C000F, 0x000C000D, 0x000C000E,
    0x000C0010, 0x000C0010, 0x000C000F, 0x000D0010, 0x000D0010, 0x000D0011,
    0x000D0012, 0x000D0011, 0x000D0013, 0x000D0011, 0x000D0010, 0x000E0010,
    0x000D000D, 0x000D000D, 0x000D000D, 0x000D000E, 0x000D000E, 0x000D000F,
    0x000D000F, 0x000D000F, 0x000D0010, 0x000D0010, 0x000D0010, 0x000E0010,
    0x000E0010, 0x000E0010, 0x000E0010, 0x000E0010,
};

/*  20  idim = 16 len = 256   wide = 0  */

/*  21  idim = 16 len = 256   wide = 0  */

/*  22  idim = 16 len = 256   wide = 0  */

/*  23  idim = 16 len = 256   wide = 0  */
static unsigned int count_table_19_24[][16] = {
    0x00040001, 0x00050005, 0x00070007, 0x00080009, 0x0009000A, 0x000A000A,
    0x000A000B, 0x000B000B, 0x000B000C, 0x000C000C, 0x000C000C, 0x000C000D,
    0x000C000D, 0x000C000D, 0x000D000E, 0x000E000E, 0x00050004, 0x00060006,
    0x00070008, 0x00080009, 0x0009000A, 0x000A000B, 0x000A000B, 0x000B000B,
    0x000B000C, 0x000B000C, 0x000C000C, 0x000C000D, 0x000C000E, 0x000C000D,
    0x000C000E, 0x000E000E, 0x00070007, 0x00070008, 0x00080009, 0x0009000A,
    0x0009000B, 0x000A000B, 0x000A000C, 0x000B000C, 0x000B000D, 0x000B000C,
    0x000B000D, 0x000C000D, 0x000C000D, 0x000C000E, 0x000D000E, 0x000D000F,
    0x00080009, 0x00080009, 0x0009000A, 0x0009000B, 0x000A000B, 0x000A000C,
    0x000A000C, 0x000B000C, 0x000B000D, 0x000B000D, 0x000B000E, 0x000C000E,
    0x000C000E, 0x000C000F, 0x000C000F, 0x000D0010, 0x0009000A, 0x0009000A,
    0x0009000B, 0x000A000B, 0x000A000C, 0x000A000C, 0x000A000D, 0x000B000D,
    0x000B000D, 0x000B000E, 0x000C000E, 0x000C000E, 0x000C000F, 0x000C000F,
    0x000D000F, 0x000D000F, 0x000A000A, 0x0009000A, 0x000A000B, 0x000A000B,
    0x000A000C, 0x000A000D, 0x000B000D, 0x000B000E, 0x000B000D, 0x000B000E,
    0x000C000E, 0x000C000F, 0x000C000F, 0x000C000F, 0x000C0010, 0x000D0010,
    0x000A000B, 0x000A000B, 0x000A000B, 0x000A000C, 0x000A000D, 0x000B000D,
    0x000B000D, 0x000B000D, 0x000B000E, 0x000C000E, 0x000C000E, 0x000C000E,
    0x000C000F, 0x000C000F, 0x000D0010, 0x000D0010, 0x000B000B, 0x000A000B,
    0x000A000C, 0x000A000C, 0x000B000D, 0x000B000D, 0x000B000D, 0x000B000E,
    0x000C000E, 0x000C000F, 0x000C000F, 0x000C000F, 0x000C000F, 0x000D0011,
    0x000D0011, 0x000E0010, 0x000B000B, 0x000B000C, 0x000B000C, 0x000B000D,
    0x000B000D, 0x000B000D, 0x000B000E, 0x000B000E, 0x000B000F, 0x000C000F,
    0x000C000F, 0x000C000F, 0x000C0010, 0x000D0010, 0x000D0010, 0x000E0010,
    0x000B000C, 0x000B000C, 0x000B000C, 0x000B000D, 0x000B000D, 0x000B000E,
    0x000B000E, 0x000C000F, 0x000C000F, 0x000C000F, 0x000C000F, 0x000C0010,
    0x000D000F, 0x000D0010, 0x000D000F, 0x000E0011, 0x000C000C, 0x000B000D,
    0x000B000C, 0x000B000D, 0x000B000E, 0x000C000E, 0x000C000E, 0x000C000E,
    0x000C000F, 0x000C0010, 0x000C0010, 0x000D0010, 0x000D0011, 0x000D0011,
    0x000D0010, 0x000E0010, 0x000C000D, 0x000C000D, 0x000B000D, 0x000B000D,
    0x000B000E, 0x000C000E, 0x000C000F, 0x000C0010, 0x000C0010, 0x000C0010,
    0x000C0010, 0x000D0010, 0x000D0010, 0x000D000F, 0x000D0010, 0x000E0011,
    0x000C000D, 0x000C000E, 0x000C000E, 0x000C000E, 0x000C000E, 0x000C000F,
    0x000C000F, 0x000C000F, 0x000C000F, 0x000C0011, 0x000D0010, 0x000D0010,
    0x000D0010, 0x000D0010, 0x000D0012, 0x000E0011, 0x000C000F, 0x000C000E,
    0x000C000E, 0x000C000E, 0x000C000F, 0x000C000F, 0x000C0010, 0x000C0010,
    0x000D0010, 0x000D0012, 0x000D0011, 0x000D0011, 0x000D0011, 0x000D0013,
    0x000D0011, 0x000E0011, 0x000D000E, 0x000C000F, 0x000C000D, 0x000C000E,
    0x000C0010, 0x000C0010, 0x000C000F, 0x000D0010, 0x000D0010, 0x000D0011,
    0x000D0012, 0x000D0011, 0x000D0013, 0x000D0011, 0x000D0010, 0x000E0011,
    0x000D000E, 0x000D000E, 0x000D000E, 0x000D000F, 0x000D000F, 0x000D0010,
    0x000D0010, 0x000D0010, 0x000D0011, 0x000D0011, 0x000D0011, 0x000E0011,
    0x000E0011, 0x000E0011, 0x000E0011, 0x000E0012,
};

/*  24  idim = 16 len = 256   wide = 0  */
static unsigned int count_table_25_20[][16] = {
    0x00010004, 0x00050005, 0x00070007, 0x00090008, 0x000A0009, 0x000A000A,
    0x000B000A, 0x000B000B, 0x000C000B, 0x000C000C, 0x000C000C, 0x000D000C,
    0x000D000C, 0x000D000C, 0x000E000D, 0x0010000F, 0x00040005, 0x00060006,
    0x00080007, 0x00090008, 0x000A0009, 0x000B000A, 0x000B000A, 0x000B000B,
    0x000C000B, 0x000C000B, 0x000C000C, 0x000D000C, 0x000E000C, 0x000D000C,
    0x000E000C, 0x0010000F, 0x00070007, 0x00080007, 0x00090008, 0x000A0009,
    0x000B0009, 0x000B000A, 0x000C000A, 0x000C000B, 0x000D000B, 0x000C000B,
    0x000D000B, 0x000D000C, 0x000D000C, 0x000E000C, 0x000E000D, 0x0011000E,
    0x00090008, 0x00090008, 0x000A0009, 0x000B0009, 0x000B000A, 0x000C000A,
    0x000C000A, 0x000C000B, 0x000D000B, 0x000D000B, 0x000E000B, 0x000E000C,
    0x000E000C, 0x000F000C, 0x000F000C, 0x0012000E, 0x000A0009, 0x000A0009,
    0x000B0009, 0x000B000A, 0x000C000A, 0x000C000A, 0x000D000A, 0x000D000B,
    0x000D000B, 0x000E000B, 0x000E000C, 0x000E000C, 0x000F000C, 0x000F000C,
    0x000F000D, 0x0011000E, 0x000A000A, 0x000A0009, 0x000B000A, 0x000B000A,
    0x000C000A, 0x000D000A, 0x000D000B, 0x000E000B, 0x000D000B, 0x000E000B,
    0x000E000C, 0x000F000C, 0x000F000C, 0x000F000C, 0x0010000C, 0x0012000E,
    0x000B000A, 0x000B000A, 0x000B000A, 0x000C000A, 0x000D000A, 0x000D000B,
    0x000D000B, 0x000D000B, 0x000E000B, 0x000E000C, 0x000E000C, 0x000E000C,
    0x000F000C, 0x000F000C, 0x0010000D, 0x0012000E, 0x000B000B, 0x000B000A,
    0x000C000A, 0x000C000A, 0x000D000B, 0x000D000B, 0x000D000B, 0x000E000B,
    0x000E000C, 0x000F000C, 0x000F000C, 0x000F000C, 0x000F000C, 0x0011000D,
    0x0011000D, 0x0012000F, 0x000B000B, 0x000C000B, 0x000C000B, 0x000D000B,
    0x000D000B, 0x000D000B, 0x000E000B, 0x000E000B, 0x000F000B, 0x000F000C,
    0x000F000C, 0x000F000C, 0x0010000C, 0x0010000D, 0x0010000D, 0x0012000F,
    0x000C000B, 0x000C000B, 0x000C000B, 0x000D000B, 0x000D000B, 0x000E000B,
    0x000E000B, 0x000F000C, 0x000F000C, 0x000F000C, 0x000F000C, 0x0010000C,
    0x000F000D, 0x0010000D, 0x000F000D, 0x0013000F, 0x000C000C, 0x000D000B,
    0x000C000B, 0x000D000B, 0x000E000B, 0x000E000C, 0x000E000C, 0x000E000C,
    0x000F000C, 0x0010000C, 0x0010000C, 0x0010000D, 0x0011000D, 0x0011000D,
    0x0010000D, 0x0012000F, 0x000D000C, 0x000D000C, 0x000D000B, 0x000D000B,
    0x000E000B, 0x000E000C, 0x000F000C, 0x0010000C, 0x0010000C, 0x0010000C,
    0x0010000C, 0x0010000D, 0x0010000D, 0x000F000D, 0x0010000D, 0x0013000F,
    0x000D000C, 0x000E000C, 0x000E000C, 0x000E000C, 0x000E000C, 0x000F000C,
    0x000F000C, 0x000F000C, 0x000F000C, 0x0011000C, 0x0010000D, 0x0010000D,
    0x0010000D, 0x0010000D, 0x0012000D, 0x0013000F, 0x000F000C, 0x000E000C,
    0x000E000C, 0x000E000C, 0x000F000C, 0x000F000C, 0x0010000C, 0x0010000C,
    0x0010000D, 0x0012000D, 0x0011000D, 0x0011000D, 0x0011000D, 0x0013000D,
    0x0011000D, 0x0013000F, 0x000E000D, 0x000F000C, 0x000D000C, 0x000E000C,
    0x0010000C, 0x0010000C, 0x000F000C, 0x0010000D, 0x0010000D, 0x0011000D,
    0x0012000D, 0x0011000D, 0x0013000D, 0x0011000D, 0x0010000D, 0x0013000F,
    0x0010000E, 0x0010000E, 0x0010000E, 0x0011000E, 0x0011000E, 0x0012000E,
    0x0012000E, 0x0012000E, 0x0013000E, 0x0013000E, 0x0013000E, 0x0013000F,
    0x0013000F, 0x0013000F, 0x0013000F, 0x00160010,
};

/*  25  idim = 16 len = 256   wide = 0  */
static unsigned int count_table_20_26[][16] = {
    0x00040001, 0x00050005, 0x00070007, 0x00080009, 0x0009000A, 0x000A000A,
    0x000A000B, 0x000B000B, 0x000B000C, 0x000C000C, 0x000C000C, 0x000C000D,
    0x000C000D, 0x000C000D, 0x000D000E, 0x00100010, 0x00050004, 0x00060006,
    0x00070008, 0x00080009, 0x0009000A, 0x000A000B, 0x000A000B, 0x000B000B,
    0x000B000C, 0x000B000C, 0x000C000C, 0x000C000D, 0x000C000E, 0x000C000D,
    0x000C000E, 0x00100010, 0x00070007, 0x00070008, 0x00080009, 0x0009000A,
    0x0009000B, 0x000A000B, 0x000A000C, 0x000B000C, 0x000B000D, 0x000B000C,
    0x000B000D, 0x000C000D, 0x000C000D, 0x000C000E, 0x000D000E, 0x000F0011,
    0x00080009, 0x00080009, 0x0009000A, 0x0009000B, 0x000A000B, 0x000A000C,
    0x000A000C, 0x000B000C, 0x000B000D, 0x000B000D, 0x000B000E, 0x000C000E,
    0x000C000E, 0x000C000F, 0x000C000F, 0x000F0012, 0x0009000A, 0x0009000A,
    0x0009000B, 0x000A000B, 0x000A000C, 0x000A000C, 0x000A000D, 0x000B000D,
    0x000B000D, 0x000B000E, 0x000C000E, 0x000C000E, 0x000C000F, 0x000C000F,
    0x000D000F, 0x000F0011, 0x000A000A, 0x0009000A, 0x000A000B, 0x000A000B,
    0x000A000C, 0x000A000D, 0x000B000D, 0x000B000E, 0x000B000D, 0x000B000E,
    0x000C000E, 0x000C000F, 0x000C000F, 0x000C000F, 0x000C0010, 0x000F0012,
    0x000A000B, 0x000A000B, 0x000A000B, 0x000A000C, 0x000A000D, 0x000B000D,
    0x000B000D, 0x000B000D, 0x000B000E, 0x000C000E, 0x000C000E, 0x000C000E,
    0x000C000F, 0x000C000F, 0x000D0010, 0x000F0012, 0x000B000B, 0x000A000B,
    0x000A000C, 0x000A000C, 0x000B000D, 0x000B000D, 0x000B000D, 0x000B000E,
    0x000C000E, 0x000C000F, 0x000C000F, 0x000C000F, 0x000C000F, 0x000D0011,
    0x000D0011, 0x00100012, 0x000B000B, 0x000B000C, 0x000B000C, 0x000B000D,
    0x000B000D, 0x000B000D, 0x000B000E, 0x000B000E, 0x000B000F, 0x000C000F,
    0x000C000F, 0x000C000F, 0x000C0010, 0x000D0010, 0x000D0010, 0x00100012,
    0x000B000C, 0x000B000C, 0x000B000C, 0x000B000D, 0x000B000D, 0x000B000E,
    0x000B000E, 0x000C000F, 0x000C000F, 0x000C000F, 0x000C000F, 0x000C0010,
    0x000D000F, 0x000D0010, 0x000D000F, 0x00100013, 0x000C000C, 0x000B000D,
    0x000B000C, 0x000B000D, 0x000B000E, 0x000C000E, 0x000C000E, 0x000C000E,
    0x000C000F, 0x000C0010, 0x000C0010, 0x000D0010, 0x000D0011, 0x000D0011,
    0x000D0010, 0x00100012, 0x000C000D, 0x000C000D, 0x000B000D, 0x000B000D,
    0x000B000E, 0x000C000E, 0x000C000F, 0x000C0010, 0x000C0010, 0x000C0010,
    0x000C0010, 0x000D0010, 0x000D0010, 0x000D000F, 0x000D0010, 0x00100013,
    0x000C000D, 0x000C000E, 0x000C000E, 0x000C000E, 0x000C000E, 0x000C000F,
    0x000C000F, 0x000C000F, 0x000C000F, 0x000C0011, 0x000D0010, 0x000D0010,
    0x000D0010, 0x000D0010, 0x000D0012, 0x00100013, 0x000C000F, 0x000C000E,
    0x000C000E, 0x000C000E, 0x000C000F, 0x000C000F, 0x000C0010, 0x000C0010,
    0x000D0010, 0x000D0012, 0x000D0011, 0x000D0011, 0x000D0011, 0x000D0013,
    0x000D0011, 0x00100013, 0x000D000E, 0x000C000F, 0x000C000D, 0x000C000E,
    0x000C0010, 0x000C0010, 0x000C000F, 0x000D0010, 0x000D0010, 0x000D0011,
    0x000D0012, 0x000D0011, 0x000D0013, 0x000D0011, 0x000D0010, 0x00100013,
    0x000F0010, 0x000F0010, 0x000F0010, 0x000F0011, 0x000F0011, 0x000F0012,
    0x000F0012, 0x000F0012, 0x000F0013, 0x000F0013, 0x000F0013, 0x00100013,
    0x00100013, 0x00100013, 0x00100013, 0x00120016,
};

/*  26  idim = 16 len = 256   wide = 0  */
static unsigned int count_table_27_21[][16] = {
    0x00010004, 0x00050005, 0x00070007, 0x00090008, 0x000A0009, 0x000A000A,
    0x000B000A, 0x000B000B, 0x000C000B, 0x000C000C, 0x000C000C, 0x000D000C,
    0x000D000C, 0x000D000C, 0x000E000D, 0x00120011, 0x00040005, 0x00060006,
    0x00080007, 0x00090008, 0x000A0009, 0x000B000A, 0x000B000A, 0x000B000B,
    0x000C000B, 0x000C000B, 0x000C000C, 0x000D000C, 0x000E000C, 0x000D000C,
    0x000E000C, 0x00120011, 0x00070007, 0x00080007, 0x00090008, 0x000A0009,
    0x000B0009, 0x000B000A, 0x000C000A, 0x000C000B, 0x000D000B, 0x000C000B,
    0x000D000B, 0x000D000C, 0x000D000C, 0x000E000C, 0x000E000D, 0x00130010,
    0x00090008, 0x00090008, 0x000A0009, 0x000B0009, 0x000B000A, 0x000C000A,
    0x000C000A, 0x000C000B, 0x000D000B, 0x000D000B, 0x000E000B, 0x000E000C,
    0x000E000C, 0x000F000C, 0x000F000C, 0x00140010, 0x000A0009, 0x000A0009,
    0x000B0009, 0x000B000A, 0x000C000A, 0x000C000A, 0x000D000A, 0x000D000B,
    0x000D000B, 0x000E000B, 0x000E000C, 0x000E000C, 0x000F000C, 0x000F000C,
    0x000F000D, 0x00130010, 0x000A000A, 0x000A0009, 0x000B000A, 0x000B000A,
    0x000C000A, 0x000D000A, 0x000D000B, 0x000E000B, 0x000D000B, 0x000E000B,
    0x000E000C, 0x000F000C, 0x000F000C, 0x000F000C, 0x0010000C, 0x00140010,
    0x000B000A, 0x000B000A, 0x000B000A, 0x000C000A, 0x000D000A, 0x000D000B,
    0x000D000B, 0x000D000B, 0x000E000B, 0x000E000C, 0x000E000C, 0x000E000C,
    0x000F000C, 0x000F000C, 0x0010000D, 0x00140010, 0x000B000B, 0x000B000A,
    0x000C000A, 0x000C000A, 0x000D000B, 0x000D000B, 0x000D000B, 0x000E000B,
    0x000E000C, 0x000F000C, 0x000F000C, 0x000F000C, 0x000F000C, 0x0011000D,
    0x0011000D, 0x00140011, 0x000B000B, 0x000C000B, 0x000C000B, 0x000D000B,
    0x000D000B, 0x000D000B, 0x000E000B, 0x000E000B, 0x000F000B, 0x000F000C,
    0x000F000C, 0x000F000C, 0x0010000C, 0x0010000D, 0x0010000D, 0x00140011,
    0x000C000B, 0x000C000B, 0x000C000B, 0x000D000B, 0x000D000B, 0x000E000B,
    0x000E000B, 0x000F000C, 0x000F000C, 0x000F000C, 0x000F000C, 0x0010000C,
    0x000F000D, 0x0010000D, 0x000F000D, 0x00150011, 0x000C000C, 0x000D000B,
    0x000C000B, 0x000D000B, 0x000E000B, 0x000E000C, 0x000E000C, 0x000E000C,
    0x000F000C, 0x0010000C, 0x0010000C, 0x0010000D, 0x0011000D, 0x0011000D,
    0x0010000D, 0x00140011, 0x000D000C, 0x000D000C, 0x000D000B, 0x000D000B,
    0x000E000B, 0x000E000C, 0x000F000C, 0x0010000C, 0x0010000C, 0x0010000C,
    0x0010000C, 0x0010000D, 0x0010000D, 0x000F000D, 0x0010000D, 0x00150011,
    0x000D000C, 0x000E000C, 0x000E000C, 0x000E000C, 0x000E000C, 0x000F000C,
    0x000F000C, 0x000F000C, 0x000F000C, 0x0011000C, 0x0010000D, 0x0010000D,
    0x0010000D, 0x0010000D, 0x0012000D, 0x00150011, 0x000F000C, 0x000E000C,
    0x000E000C, 0x000E000C, 0x000F000C, 0x000F000C, 0x0010000C, 0x0010000C,
    0x0010000D, 0x0012000D, 0x0011000D, 0x0011000D, 0x0011000D, 0x0013000D,
    0x0011000D, 0x00150011, 0x000E000D, 0x000F000C, 0x000D000C, 0x000E000C,
    0x0010000C, 0x0010000C, 0x000F000C, 0x0010000D, 0x0010000D, 0x0011000D,
    0x0012000D, 0x0011000D, 0x0013000D, 0x0011000D, 0x0010000D, 0x00150011,
    0x00120010, 0x00120010, 0x00120010, 0x00130010, 0x00130010, 0x00140010,
    0x00140010, 0x00140010, 0x00150010, 0x00150010, 0x00150010, 0x00150011,
    0x00150011, 0x00150011, 0x00150011, 0x001A0014,
};

/*  27  idim = 16 len = 256   wide = 0  */
static unsigned int count_table_21_28[][16] = {
    0x00040001, 0x00050005, 0x00070007, 0x00080009, 0x0009000A, 0x000A000A,
    0x000A000B, 0x000B000B, 0x000B000C, 0x000C000C, 0x000C000C, 0x000C000D,
    0x000C000D, 0x000C000D, 0x000D000E, 0x00120012, 0x00050004, 0x00060006,
    0x00070008, 0x00080009, 0x0009000A, 0x000A000B, 0x000A000B, 0x000B000B,
    0x000B000C, 0x000B000C, 0x000C000C, 0x000C000D, 0x000C000E, 0x000C000D,
    0x000C000E, 0x00120012, 0x00070007, 0x00070008, 0x00080009, 0x0009000A,
    0x0009000B, 0x000A000B, 0x000A000C, 0x000B000C, 0x000B000D, 0x000B000C,
    0x000B000D, 0x000C000D, 0x000C000D, 0x000C000E, 0x000D000E, 0x00110013,
    0x00080009, 0x00080009, 0x0009000A, 0x0009000B, 0x000A000B, 0x000A000C,
    0x000A000C, 0x000B000C, 0x000B000D, 0x000B000D, 0x000B000E, 0x000C000E,
    0x000C000E, 0x000C000F, 0x000C000F, 0x00110014, 0x0009000A, 0x0009000A,
    0x0009000B, 0x000A000B, 0x000A000C, 0x000A000C, 0x000A000D, 0x000B000D,
    0x000B000D, 0x000B000E, 0x000C000E, 0x000C000E, 0x000C000F, 0x000C000F,
    0x000D000F, 0x00110013, 0x000A000A, 0x0009000A, 0x000A000B, 0x000A000B,
    0x000A000C, 0x000A000D, 0x000B000D, 0x000B000E, 0x000B000D, 0x000B000E,
    0x000C000E, 0x000C000F, 0x000C000F, 0x000C000F, 0x000C0010, 0x00110014,
    0x000A000B, 0x000A000B, 0x000A000B, 0x000A000C, 0x000A000D, 0x000B000D,
    0x000B000D, 0x000B000D, 0x000B000E, 0x000C000E, 0x000C000E, 0x000C000E,
    0x000C000F, 0x000C000F, 0x000D0010, 0x00110014, 0x000B000B, 0x000A000B,
    0x000A000C, 0x000A000C, 0x000B000D, 0x000B000D, 0x000B000D, 0x000B000E,
    0x000C000E, 0x000C000F, 0x000C000F, 0x000C000F, 0x000C000F, 0x000D0011,
    0x000D0011, 0x00120014, 0x000B000B, 0x000B000C, 0x000B000C, 0x000B000D,
    0x000B000D, 0x000B000D, 0x000B000E, 0x000B000E, 0x000B000F, 0x000C000F,
    0x000C000F, 0x000C000F, 0x000C0010, 0x000D0010, 0x000D0010, 0x00120014,
    0x000B000C, 0x000B000C, 0x000B000C, 0x000B000D, 0x000B000D, 0x000B000E,
    0x000B000E, 0x000C000F, 0x000C000F, 0x000C000F, 0x000C000F, 0x000C0010,
    0x000D000F, 0x000D0010, 0x000D000F, 0x00120015, 0x000C000C, 0x000B000D,
    0x000B000C, 0x000B000D, 0x000B000E, 0x000C000E, 0x000C000E, 0x000C000E,
    0x000C000F, 0x000C0010, 0x000C0010, 0x000D0010, 0x000D0011, 0x000D0011,
    0x000D0010, 0x00120014, 0x000C000D, 0x000C000D, 0x000B000D, 0x000B000D,
    0x000B000E, 0x000C000E, 0x000C000F, 0x000C0010, 0x000C0010, 0x000C0010,
    0x000C0010, 0x000D0010, 0x000D0010, 0x000D000F, 0x000D0010, 0x00120015,
    0x000C000D, 0x000C000E, 0x000C000E, 0x000C000E, 0x000C000E, 0x000C000F,
    0x000C000F, 0x000C000F, 0x000C000F, 0x000C0011, 0x000D0010, 0x000D0010,
    0x000D0010, 0x000D0010, 0x000D0012, 0x00120015, 0x000C000F, 0x000C000E,
    0x000C000E, 0x000C000E, 0x000C000F, 0x000C000F, 0x000C0010, 0x000C0010,
    0x000D0010, 0x000D0012, 0x000D0011, 0x000D0011, 0x000D0011, 0x000D0013,
    0x000D0011, 0x00120015, 0x000D000E, 0x000C000F, 0x000C000D, 0x000C000E,
    0x000C0010, 0x000C0010, 0x000C000F, 0x000D0010, 0x000D0010, 0x000D0011,
    0x000D0012, 0x000D0011, 0x000D0013, 0x000D0011, 0x000D0010, 0x00120015,
    0x00110012, 0x00110012, 0x00110012, 0x00110013, 0x00110013, 0x00110014,
    0x00110014, 0x00110014, 0x00110015, 0x00110015, 0x00110015, 0x00120015,
    0x00120015, 0x00120015, 0x00120015, 0x0016001A,
};

/*  28  idim = 16 len = 256   wide = 0  */
static unsigned int count_table_29_22[][16] = {
    0x00010004, 0x00050005, 0x00070007, 0x00090008, 0x000A0009, 0x000A000A,
    0x000B000A, 0x000B000B, 0x000C000B, 0x000C000C, 0x000C000C, 0x000D000C,
    0x000D000C, 0x000D000C, 0x000E000D, 0x00140013, 0x00040005, 0x00060006,
    0x00080007, 0x00090008, 0x000A0009, 0x000B000A, 0x000B000A, 0x000B000B,
    0x000C000B, 0x000C000B, 0x000C000C, 0x000D000C, 0x000E000C, 0x000D000C,
    0x000E000C, 0x00140013, 0x00070007, 0x00080007, 0x00090008, 0x000A0009,
    0x000B0009, 0x000B000A, 0x000C000A, 0x000C000B, 0x000D000B, 0x000C000B,
    0x000D000B, 0x000D000C, 0x000D000C, 0x000E000C, 0x000E000D, 0x00150012,
    0x00090008, 0x00090008, 0x000A0009, 0x000B0009, 0x000B000A, 0x000C000A,
    0x000C000A, 0x000C000B, 0x000D000B, 0x000D000B, 0x000E000B, 0x000E000C,
    0x000E000C, 0x000F000C, 0x000F000C, 0x00160012, 0x000A0009, 0x000A0009,
    0x000B0009, 0x000B000A, 0x000C000A, 0x000C000A, 0x000D000A, 0x000D000B,
    0x000D000B, 0x000E000B, 0x000E000C, 0x000E000C, 0x000F000C, 0x000F000C,
    0x000F000D, 0x00150012, 0x000A000A, 0x000A0009, 0x000B000A, 0x000B000A,
    0x000C000A, 0x000D000A, 0x000D000B, 0x000E000B, 0x000D000B, 0x000E000B,
    0x000E000C, 0x000F000C, 0x000F000C, 0x000F000C, 0x0010000C, 0x00160012,
    0x000B000A, 0x000B000A, 0x000B000A, 0x000C000A, 0x000D000A, 0x000D000B,
    0x000D000B, 0x000D000B, 0x000E000B, 0x000E000C, 0x000E000C, 0x000E000C,
    0x000F000C, 0x000F000C, 0x0010000D, 0x00160012, 0x000B000B, 0x000B000A,
    0x000C000A, 0x000C000A, 0x000D000B, 0x000D000B, 0x000D000B, 0x000E000B,
    0x000E000C, 0x000F000C, 0x000F000C, 0x000F000C, 0x000F000C, 0x0011000D,
    0x0011000D, 0x00160013, 0x000B000B, 0x000C000B, 0x000C000B, 0x000D000B,
    0x000D000B, 0x000D000B, 0x000E000B, 0x000E000B, 0x000F000B, 0x000F000C,
    0x000F000C, 0x000F000C, 0x0010000C, 0x0010000D, 0x0010000D, 0x00160013,
    0x000C000B, 0x000C000B, 0x000C000B, 0x000D000B, 0x000D000B, 0x000E000B,
    0x000E000B, 0x000F000C, 0x000F000C, 0x000F000C, 0x000F000C, 0x0010000C,
    0x000F000D, 0x0010000D, 0x000F000D, 0x00170013, 0x000C000C, 0x000D000B,
    0x000C000B, 0x000D000B, 0x000E000B, 0x000E000C, 0x000E000C, 0x000E000C,
    0x000F000C, 0x0010000C, 0x0010000C, 0x0010000D, 0x0011000D, 0x0011000D,
    0x0010000D, 0x00160013, 0x000D000C, 0x000D000C, 0x000D000B, 0x000D000B,
    0x000E000B, 0x000E000C, 0x000F000C, 0x0010000C, 0x0010000C, 0x0010000C,
    0x0010000C, 0x0010000D, 0x0010000D, 0x000F000D, 0x0010000D, 0x00170013,
    0x000D000C, 0x000E000C, 0x000E000C, 0x000E000C, 0x000E000C, 0x000F000C,
    0x000F000C, 0x000F000C, 0x000F000C, 0x0011000C, 0x0010000D, 0x0010000D,
    0x0010000D, 0x0010000D, 0x0012000D, 0x00170013, 0x000F000C, 0x000E000C,
    0x000E000C, 0x000E000C, 0x000F000C, 0x000F000C, 0x0010000C, 0x0010000C,
    0x0010000D, 0x0012000D, 0x0011000D, 0x0011000D, 0x0011000D, 0x0013000D,
    0x0011000D, 0x00170013, 0x000E000D, 0x000F000C, 0x000D000C, 0x000E000C,
    0x0010000C, 0x0010000C, 0x000F000C, 0x0010000D, 0x0010000D, 0x0011000D,
    0x0012000D, 0x0011000D, 0x0013000D, 0x0011000D, 0x0010000D, 0x00170013,
    0x00140012, 0x00140012, 0x00140012, 0x00150012, 0x00150012, 0x00160012,
    0x00160012, 0x00160012, 0x00170012, 0x00170012, 0x00170012, 0x00170013,
    0x00170013, 0x00170013, 0x00170013, 0x001E0018,
};

/*  29  idim = 16 len = 256   wide = 0  */
static unsigned int count_table_22_30[][16] = {
    0x00040001, 0x00050005, 0x00070007, 0x00080009, 0x0009000A, 0x000A000A,
    0x000A000B, 0x000B000B, 0x000B000C, 0x000C000C, 0x000C000C, 0x000C000D,
    0x000C000D, 0x000C000D, 0x000D000E, 0x00150014, 0x00050004, 0x00060006,
    0x00070008, 0x00080009, 0x0009000A, 0x000A000B, 0x000A000B, 0x000B000B,
    0x000B000C, 0x000B000C, 0x000C000C, 0x000C000D, 0x000C000E, 0x000C000D,
    0x000C000E, 0x00150014, 0x00070007, 0x00070008, 0x00080009, 0x0009000A,
    0x0009000B, 0x000A000B, 0x000A000C, 0x000B000C, 0x000B000D, 0x000B000C,
    0x000B000D, 0x000C000D, 0x000C000D, 0x000C000E, 0x000D000E, 0x00140015,
    0x00080009, 0x00080009, 0x0009000A, 0x0009000B, 0x000A000B, 0x000A000C,
    0x000A000C, 0x000B000C, 0x000B000D, 0x000B000D, 0x000B000E, 0x000C000E,
    0x000C000E, 0x000C000F, 0x000C000F, 0x00140016, 0x0009000A, 0x0009000A,
    0x0009000B, 0x000A000B, 0x000A000C, 0x000A000C, 0x000A000D, 0x000B000D,
    0x000B000D, 0x000B000E, 0x000C000E, 0x000C000E, 0x000C000F, 0x000C000F,
    0x000D000F, 0x00140015, 0x000A000A, 0x0009000A, 0x000A000B, 0x000A000B,
    0x000A000C, 0x000A000D, 0x000B000D, 0x000B000E, 0x000B000D, 0x000B000E,
    0x000C000E, 0x000C000F, 0x000C000F, 0x000C000F, 0x000C0010, 0x00140016,
    0x000A000B, 0x000A000B, 0x000A000B, 0x000A000C, 0x000A000D, 0x000B000D,
    0x000B000D, 0x000B000D, 0x000B000E, 0x000C000E, 0x000C000E, 0x000C000E,
    0x000C000F, 0x000C000F, 0x000D0010, 0x00140016, 0x000B000B, 0x000A000B,
    0x000A000C, 0x000A000C, 0x000B000D, 0x000B000D, 0x000B000D, 0x000B000E,
    0x000C000E, 0x000C000F, 0x000C000F, 0x000C000F, 0x000C000F, 0x000D0011,
    0x000D0011, 0x00150016, 0x000B000B, 0x000B000C, 0x000B000C, 0x000B000D,
    0x000B000D, 0x000B000D, 0x000B000E, 0x000B000E, 0x000B000F, 0x000C000F,
    0x000C000F, 0x000C000F, 0x000C0010, 0x000D0010, 0x000D0010, 0x00150016,
    0x000B000C, 0x000B000C, 0x000B000C, 0x000B000D, 0x000B000D, 0x000B000E,
    0x000B000E, 0x000C000F, 0x000C000F, 0x000C000F, 0x000C000F, 0x000C0010,
    0x000D000F, 0x000D0010, 0x000D000F, 0x00150017, 0x000C000C, 0x000B000D,
    0x000B000C, 0x000B000D, 0x000B000E, 0x000C000E, 0x000C000E, 0x000C000E,
    0x000C000F, 0x000C0010, 0x000C0010, 0x000D0010, 0x000D0011, 0x000D0011,
    0x000D0010, 0x00150016, 0x000C000D, 0x000C000D, 0x000B000D, 0x000B000D,
    0x000B000E, 0x000C000E, 0x000C000F, 0x000C0010, 0x000C0010, 0x000C0010,
    0x000C0010, 0x000D0010, 0x000D0010, 0x000D000F, 0x000D0010, 0x00150017,
    0x000C000D, 0x000C000E, 0x000C000E, 0x000C000E, 0x000C000E, 0x000C000F,
    0x000C000F, 0x000C000F, 0x000C000F, 0x000C0011, 0x000D0010, 0x000D0010,
    0x000D0010, 0x000D0010, 0x000D0012, 0x00150017, 0x000C000F, 0x000C000E,
    0x000C000E, 0x000C000E, 0x000C000F, 0x000C000F, 0x000C0010, 0x000C0010,
    0x000D0010, 0x000D0012, 0x000D0011, 0x000D0011, 0x000D0011, 0x000D0013,
    0x000D0011, 0x00150017, 0x000D000E, 0x000C000F, 0x000C000D, 0x000C000E,
    0x000C0010, 0x000C0010, 0x000C000F, 0x000D0010, 0x000D0010, 0x000D0011,
    0x000D0012, 0x000D0011, 0x000D0013, 0x000D0011, 0x000D0010, 0x00150017,
    0x00140014, 0x00140014, 0x00140014, 0x00140015, 0x00140015, 0x00140016,
    0x00140016, 0x00140016, 0x00140017, 0x00140017, 0x00140017, 0x00150017,
    0x00150017, 0x00150017, 0x00150017, 0x001C001E,
};

/*  30  idim = 16 len = 256   wide = 0  */
static unsigned int count_table_30_23[][16] = {
    0x00010004, 0x00050005, 0x00070007, 0x00090008, 0x000A0009, 0x000A000A,
    0x000B000A, 0x000B000B, 0x000C000B, 0x000C000C, 0x000C000C, 0x000D000C,
    0x000D000C, 0x000D000C, 0x000E000D, 0x00170015, 0x00040005, 0x00060006,
    0x00080007, 0x00090008, 0x000A0009, 0x000B000A, 0x000B000A, 0x000B000B,
    0x000C000B, 0x000C000B, 0x000C000C, 0x000D000C, 0x000E000C, 0x000D000C,
    0x000E000C, 0x00170015, 0x00070007, 0x00080007, 0x00090008, 0x000A0009,
    0x000B0009, 0x000B000A, 0x000C000A, 0x000C000B, 0x000D000B, 0x000C000B,
    0x000D000B, 0x000D000C, 0x000D000C, 0x000E000C, 0x000E000D, 0x00180014,
    0x00090008, 0x00090008, 0x000A0009, 0x000B0009, 0x000B000A, 0x000C000A,
    0x000C000A, 0x000C000B, 0x000D000B, 0x000D000B, 0x000E000B, 0x000E000C,
    0x000E000C, 0x000F000C, 0x000F000C, 0x00190014, 0x000A0009, 0x000A0009,
    0x000B0009, 0x000B000A, 0x000C000A, 0x000C000A, 0x000D000A, 0x000D000B,
    0x000D000B, 0x000E000B, 0x000E000C, 0x000E000C, 0x000F000C, 0x000F000C,
    0x000F000D, 0x00180014, 0x000A000A, 0x000A0009, 0x000B000A, 0x000B000A,
    0x000C000A, 0x000D000A, 0x000D000B, 0x000E000B, 0x000D000B, 0x000E000B,
    0x000E000C, 0x000F000C, 0x000F000C, 0x000F000C, 0x0010000C, 0x00190014,
    0x000B000A, 0x000B000A, 0x000B000A, 0x000C000A, 0x000D000A, 0x000D000B,
    0x000D000B, 0x000D000B, 0x000E000B, 0x000E000C, 0x000E000C, 0x000E000C,
    0x000F000C, 0x000F000C, 0x0010000D, 0x00190014, 0x000B000B, 0x000B000A,
    0x000C000A, 0x000C000A, 0x000D000B, 0x000D000B, 0x000D000B, 0x000E000B,
    0x000E000C, 0x000F000C, 0x000F000C, 0x000F000C, 0x000F000C, 0x0011000D,
    0x0011000D, 0x00190015, 0x000B000B, 0x000C000B, 0x000C000B, 0x000D000B,
    0x000D000B, 0x000D000B, 0x000E000B, 0x000E000B, 0x000F000B, 0x000F000C,
    0x000F000C, 0x000F000C, 0x0010000C, 0x0010000D, 0x0010000D, 0x00190015,
    0x000C000B, 0x000C000B, 0x000C000B, 0x000D000B, 0x000D000B, 0x000E000B,
    0x000E000B, 0x000F000C, 0x000F000C, 0x000F000C, 0x000F000C, 0x0010000C,
    0x000F000D, 0x0010000D, 0x000F000D, 0x001A0015, 0x000C000C, 0x000D000B,
    0x000C000B, 0x000D000B, 0x000E000B, 0x000E000C, 0x000E000C, 0x000E000C,
    0x000F000C, 0x0010000C, 0x0010000C, 0x0010000D, 0x0011000D, 0x0011000D,
    0x0010000D, 0x00190015, 0x000D000C, 0x000D000C, 0x000D000B, 0x000D000B,
    0x000E000B, 0x000E000C, 0x000F000C, 0x0010000C, 0x0010000C, 0x0010000C,
    0x0010000C, 0x0010000D, 0x0010000D, 0x000F000D, 0x0010000D, 0x001A0015,
    0x000D000C, 0x000E000C, 0x000E000C, 0x000E000C, 0x000E000C, 0x000F000C,
    0x000F000C, 0x000F000C, 0x000F000C, 0x0011000C, 0x0010000D, 0x0010000D,
    0x0010000D, 0x0010000D, 0x0012000D, 0x001A0015, 0x000F000C, 0x000E000C,
    0x000E000C, 0x000E000C, 0x000F000C, 0x000F000C, 0x0010000C, 0x0010000C,
    0x0010000D, 0x0012000D, 0x0011000D, 0x0011000D, 0x0011000D, 0x0013000D,
    0x0011000D, 0x001A0015, 0x000E000D, 0x000F000C, 0x000D000C, 0x000E000C,
    0x0010000C, 0x0010000C, 0x000F000C, 0x0010000D, 0x0010000D, 0x0011000D,
    0x0012000D, 0x0011000D, 0x0013000D, 0x0011000D, 0x0010000D, 0x001A0015,
    0x00170014, 0x00170014, 0x00170014, 0x00180014, 0x00180014, 0x00190014,
    0x00190014, 0x00190014, 0x001A0014, 0x001A0014, 0x001A0014, 0x001A0015,
    0x001A0015, 0x001A0015, 0x001A0015, 0x0024001C,
};

/*  31  idim = 16 len = 256   wide = 0  */
static unsigned int count_table_31_23[][16] = {
    0x00010004, 0x00050005, 0x00070007, 0x00090008, 0x000A0009, 0x000A000A,
    0x000B000A, 0x000B000B, 0x000C000B, 0x000C000C, 0x000C000C, 0x000D000C,
    0x000D000C, 0x000D000C, 0x000E000D, 0x00170017, 0x00040005, 0x00060006,
    0x00080007, 0x00090008, 0x000A0009, 0x000B000A, 0x000B000A, 0x000B000B,
    0x000C000B, 0x000C000B, 0x000C000C, 0x000D000C, 0x000E000C, 0x000D000C,
    0x000E000C, 0x00170017, 0x00070007, 0x00080007, 0x00090008, 0x000A0009,
    0x000B0009, 0x000B000A, 0x000C000A, 0x000C000B, 0x000D000B, 0x000C000B,
    0x000D000B, 0x000D000C, 0x000D000C, 0x000E000C, 0x000E000D, 0x00180016,
    0x00090008, 0x00090008, 0x000A0009, 0x000B0009, 0x000B000A, 0x000C000A,
    0x000C000A, 0x000C000B, 0x000D000B, 0x000D000B, 0x000E000B, 0x000E000C,
    0x000E000C, 0x000F000C, 0x000F000C, 0x00190016, 0x000A0009, 0x000A0009,
    0x000B0009, 0x000B000A, 0x000C000A, 0x000C000A, 0x000D000A, 0x000D000B,
    0x000D000B, 0x000E000B, 0x000E000C, 0x000E000C, 0x000F000C, 0x000F000C,
    0x000F000D, 0x00180016, 0x000A000A, 0x000A0009, 0x000B000A, 0x000B000A,
    0x000C000A, 0x000D000A, 0x000D000B, 0x000E000B, 0x000D000B, 0x000E000B,
    0x000E000C, 0x000F000C, 0x000F000C, 0x000F000C, 0x0010000C, 0x00190016,
    0x000B000A, 0x000B000A, 0x000B000A, 0x000C000A, 0x000D000A, 0x000D000B,
    0x000D000B, 0x000D000B, 0x000E000B, 0x000E000C, 0x000E000C, 0x000E000C,
    0x000F000C, 0x000F000C, 0x0010000D, 0x00190016, 0x000B000B, 0x000B000A,
    0x000C000A, 0x000C000A, 0x000D000B, 0x000D000B, 0x000D000B, 0x000E000B,
    0x000E000C, 0x000F000C, 0x000F000C, 0x000F000C, 0x000F000C, 0x0011000D,
    0x0011000D, 0x00190017, 0x000B000B, 0x000C000B, 0x000C000B, 0x000D000B,
    0x000D000B, 0x000D000B, 0x000E000B, 0x000E000B, 0x000F000B, 0x000F000C,
    0x000F000C, 0x000F000C, 0x0010000C, 0x0010000D, 0x0010000D, 0x00190017,
    0x000C000B, 0x000C000B, 0x000C000B, 0x000D000B, 0x000D000B, 0x000E000B,
    0x000E000B, 0x000F000C, 0x000F000C, 0x000F000C, 0x000F000C, 0x0010000C,
    0x000F000D, 0x0010000D, 0x000F000D, 0x001A0017, 0x000C000C, 0x000D000B,
    0x000C000B, 0x000D000B, 0x000E000B, 0x000E000C, 0x000E000C, 0x000E000C,
    0x000F000C, 0x0010000C, 0x0010000C, 0x0010000D, 0x0011000D, 0x0011000D,
    0x0010000D, 0x00190017, 0x000D000C, 0x000D000C, 0x000D000B, 0x000D000B,
    0x000E000B, 0x000E000C, 0x000F000C, 0x0010000C, 0x0010000C, 0x0010000C,
    0x0010000C, 0x0010000D, 0x0010000D, 0x000F000D, 0x0010000D, 0x001A0017,
    0x000D000C, 0x000E000C, 0x000E000C, 0x000E000C, 0x000E000C, 0x000F000C,
    0x000F000C, 0x000F000C, 0x000F000C, 0x0011000C, 0x0010000D, 0x0010000D,
    0x0010000D, 0x0010000D, 0x0012000D, 0x001A0017, 0x000F000C, 0x000E000C,
    0x000E000C, 0x000E000C, 0x000F000C, 0x000F000C, 0x0010000C, 0x0010000C,
    0x0010000D, 0x0012000D, 0x0011000D, 0x0011000D, 0x0011000D, 0x0013000D,
    0x0011000D, 0x001A0017, 0x000E000D, 0x000F000C, 0x000D000C, 0x000E000C,
    0x0010000C, 0x0010000C, 0x000F000C, 0x0010000D, 0x0010000D, 0x0011000D,
    0x0012000D, 0x0011000D, 0x0013000D, 0x0011000D, 0x0010000D, 0x001A0017,
    0x00170016, 0x00170016, 0x00170016, 0x00180016, 0x00180016, 0x00190016,
    0x00190016, 0x00190016, 0x001A0016, 0x001A0016, 0x001A0016, 0x001A0017,
    0x001A0017, 0x001A0017, 0x001A0017, 0x00240020,
};

static struct
{
    int icase;
    void *table;
}
CountCase[32] =
{
    {
    0, count_table_0_0[0]}
    ,
    {
    1, count_table_1_3[0]}
    ,
    {
    2, count_table_2_3[0]}
    ,
    {
    2, count_table_5_6[0]}
    ,
    {
    3, count_table_7_8_9_12[0][0]}
    ,
    {
    3, count_table_7_8_9_12[0][0]}
    ,
    {
    3, count_table_10_11_12_15[0][0]}
    ,
    {
    3, count_table_10_11_12_15[0][0]}
    ,
    {
    4, count_table_13_15[0]}
    ,
    {
    4, count_table_13_15[0]}
    ,
    {
    4, count_table_13_15[0]}
    ,
    {
    4, count_table_13_15[0]}
    ,
    {
    4, count_table_13_15[0]}
    ,
    {
    4, count_table_13_15[0]}
    ,
    {
    4, count_table_13_15[0]}
    ,
    {
    4, count_table_13_15[0]}
    ,
    {
    5, count_table_16_24[0]}
    ,
    {
    5, count_table_17_24[0]}
    ,
    {
    5, count_table_17_24[0]}
    ,
    {
    5, count_table_18_24[0]}
    ,
    {
    5, count_table_18_24[0]}
    ,
    {
    5, count_table_18_24[0]}
    ,
    {
    5, count_table_18_24[0]}
    ,
    {
    5, count_table_19_24[0]}
    ,
    {
    5, count_table_25_20[0]}
    ,
    {
    5, count_table_20_26[0]}
    ,
    {
    5, count_table_27_21[0]}
    ,
    {
    5, count_table_21_28[0]}
    ,
    {
    5, count_table_29_22[0]}
    ,
    {
    5, count_table_22_30[0]}
    ,
    {
    5, count_table_30_23[0]}
    ,
    {
    5, count_table_31_23[0]}
,};

/* done */
