/* -*- Mode: csharp; tab-width: 4; c-basic-offset: 4; indent-tabs-mode: t -*- */
/***************************************************************************
 *  TrackInfoHeader.cs
 *
 *  Copyright (C) 2005 Novell
 *  Written by Aaron Bockover (aaron@aaronbock.net)
 ****************************************************************************/

/*  THIS FILE IS LICENSED UNDER THE MIT LICENSE AS OUTLINED IMMEDIATELY BELOW: 
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),  
 *  to deal in the Software without restriction, including without limitation  
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,  
 *  and/or sell copies of the Software, and to permit persons to whom the  
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

using System;
using System.Collections;
using Mono.Unix;
using Gtk;

using Banshee.Widgets;

namespace Banshee
{
    public class TrackInfoHeader : HBox
    {
        private string artist;
        private string album;
        private string title;
    
        private Label artist_album_label;
        private Label title_label;
        private CoverArtThumbnail cover;
        
        public TrackInfoHeader() : base()
        {
            ConstructWidget();
        }
        
        private void ConstructWidget()
        {
            Spacing = 8;
        
            Gdk.Pixbuf default_pixbuf = Banshee.Base.IconThemeUtils.LoadIcon("audio-x-generic", 48);
            if(default_pixbuf == null) {
                default_pixbuf = new Gdk.Pixbuf(System.Reflection.Assembly.GetEntryAssembly(), "banshee-logo.png");   
            }
            
            cover = new CoverArtThumbnail(36);
            cover.NoArtworkPixbuf = default_pixbuf;
            PackStart(cover, false, false, 0);
            cover.Show();
        
            VBox box = new VBox();
            box.Spacing = 2;
        
            artist_album_label = new EllipsizeLabel();
            artist_album_label.Show();
            artist_album_label.Xalign = 0.0f;
            artist_album_label.Yalign = 0.5f;
            artist_album_label.Selectable = true;
            
            title_label = new EllipsizeLabel();
            title_label.Show();            
            title_label.Xalign = 0.0f;
            title_label.Yalign = 0.5f;
            title_label.Selectable = true;
            
            box.PackStart(title_label, false, false, 0);
            box.PackStart(artist_album_label, false, false, 0);
            
            PackStart(box, true, true, 0);
            box.ShowAll();
            Hide();
        }
        
        private void UpdateDisplay()
        {
            Gdk.Color blend = Banshee.Base.Utilities.ColorBlend(
                artist_album_label.Style.Background(StateType.Normal),
                artist_album_label.Style.Foreground(StateType.Normal));
            string hex_blend = String.Format("#{0:x2}{1:x2}{2:x2}", blend.Red, blend.Green, blend.Blue);
            
            artist_album_label.Markup = String.Format(
                "<span color=\"{0}\">{1}</span>  {3}  <span color=\"{0}\">{2}</span>  {4}",
                hex_blend, 
                Catalog.GetString("by"),
                Catalog.GetString("from"),
                GLib.Markup.EscapeText(artist), 
                GLib.Markup.EscapeText(album));
                
            title_label.Markup = String.Format("<b>{0}</b>", GLib.Markup.EscapeText(title));
            
            ShowAll();
        }
        
        public string Artist {
            set {
                artist = value;
                UpdateDisplay();
            }
        }
        
        public string Title {
            set {
                title = value;
                UpdateDisplay();
            }
        }
        
        public string Album {
            set {
                album = value;
                UpdateDisplay();
            }
        }
        
        public CoverArtThumbnail Cover {
            get {
                return cover;
            }
        }
        
        public void SetIdle()
        {
        }
    }
}
