#redhat and mdk are exclusive
%define redhat 1
%define mdk    0
%if %redhat
%define config_opts --prefix=%{_prefix} --sysconfdir=%{_sysconfdir} --mandir=%{_mandir} --libdir=%{_libdir} --bindir=%{_bindir} --includedir=%{_includedir} --datadir=%{_datadir} --enable-threads --disable-system-install --disable-more-warnings
%endif
%if %mdk || 1
%define config_opts --prefix=%{_prefix} --sysconfdir=%{_sysconfdir} --mandir=%{_mandir} --libdir=%{_libdir} --bindir=%{_bindir} --includedir=%{_includedir} --datadir=%{_datadir} --enable-threads --disable-more-warnings --enable-gtkhtml --with-ssl
%endif

Summary:   Balsa Mail Client
Name:      balsa
Version:   1.4.1
Release:   1
Copyright: GPL
Group:     Applications/Internet
Source0:   %{name}-%{version}.tar.bz2
URL:       http://balsa.gnome.org/
BuildRoot: %{_tmppath}/%{name}-%{version}-root
Packager: Pawel Salek <pawsa@theochem.kth.se>
Requires: gtk+ >= 1.2.7
Requires: gnome-libs >= 1.2.13
Requires: gnome-vfs >= 1.0.0
Requires: libesmtp >= 0.8.6
Requires: pspell
Provides: balsa

BuildRequires:  libesmtp >= 0.8.6
BuildRequires:  gnome-libs-devel >= 1.2.13
BuildRequires:  gtk+-devel >= 1.2.7
BuildRequires:  gdk-pixbuf-devel
%if %redhat
BuildRequires:  gnome-vfs-devel
BuildRequires:  pspell-devel
%endif
%if %mdk
BuildRequires:  libgnome-vfs0-devel
BuildRequires:  libpspell4-devel
%endif

%description
Balsa is an e-mail reader.  This client is part of the GNOME
desktop environment.  It supports local mailboxes, POP3 and
IMAP.
 
%prep
%setup

%build
# Needed for snapshot releases.
%ifarch alpha
  ARCHFLAG="--host=alpha-redhat-linux"
%endif

if [ ! -f configure ]; then
  CFLAGS="$RPM_OPT_FLAGS" ./autogen.sh $ARCHFLAG %{config_opts}
fi

CFLAGS="$RPM_OPT_FLAGS" ./configure $ARCHFLAG %{config_opts}


if [ "$SMP" != "" ]; then
  (make "MAKE=make -k -j $SMP"; exit 0)
  make
else
  make
fi

%install
rm -rf "$RPM_BUILD_ROOT"

make DESTDIR="$RPM_BUILD_ROOT" install

%find_lang %{name}


%clean
[ -n "$RPM_BUILD_DIR/%{name}-%{version}" ] && rm -rf "$RPM_BUILD_DIR/%{name}-%{version}"

%files -f %{name}.lang
%defattr(-, root, root)
%doc README COPYING ChangeLog NEWS TODO AUTHORS HACKING docs/mh-mail-HOWTO
%doc docs/vconvert.awk docs/pine2vcard
%{_bindir}/balsa
%{_datadir}/gnome/apps/Internet/balsa.desktop
%{_datadir}/gnome/help/balsa/*
%{_datadir}/pixmaps/*
%{_datadir}/sounds/balsa/*
%{_mandir}/man1/balsa.1*
%config %{_sysconfdir}/sound/events/*


%changelog
* Sun Jun 24 2001 Spider <spider@darkmere.wanfear.com>
- remove all defined paths to user-specified. 
- update configures, locales, update esmtp as a requires/buildrequires 

* Fri Nov 03 2000 Pawel Salek <pawsa@theochem.kth.se>
- use %{_mandir} for location of the manual.

* Fri Oct 20 2000 Pawel Salek <pawsa@theochem.kth.se>
- require gtk+>= 1.2.7, not gnome-libs. 

* Fri Oct 20 2000 Pawel Salek <pawsa@theochem.kth.se>
- require gnome-libs >= 1.2.7, earlier versions are buggy. drop building GSS.

* Mon Sep 18 2000 Pawel Salek <pawsa@theochem.kth.se>
- include only translation files, not whole directories, to aviod
  misleading messages when removing the package.

* Tue Aug 15 2000 Pawel Salek <pawsa@theochem.kth.se>
- added --disable-more-warning option - libmutt configure fails without it.

* Thu Jun  1 2000 Peter Williams <peter@newton.cx>
- Don't try to install IDL stuff as we have deleted it :-)

* Thu Dec 30 1999 Bruno Pires Marinho <bapm@camoes.rnl.ist.utl.pt>
- Improved the spec file by adding a sysconfdir=/etc, removing the man
  instalation because balsa does it now and adding the files on the /etc
  to the distribution

* Tue Oct  5 1999 Jan Nieuwenhuizen <janneke@gnu.org>
- Fixed man install

* Sun Sep 26 1999 Stuart Parmenter <pavlov@balsa.net>
- Updated to version 0.5.0

* Mon Dec 14 1998 Stuart Parmenter <pavlov@pavlov.net>
- Updated to version 0.4.8.

* Sun Sep 09 1998 Stuart Parmenter <pavlov@pavlov.net>
- Updated to version 0.4.7.

* Sun Aug 23 1998 Stuart Parmenter <pavlov@pavlov.net>
- Updated to version 0.4.5.

* Mon Aug  3 1998 Stuart Parmenter <pavlov@pavlov.net>
- Updated to version 0.4.0.

* Sun Jul 26 1998 Stuart Parmenter <pavlov@pavlov.net>
- Updated RPM file to reflect recent changes with the
  removal of c-client.

* Thu Apr 02 1998 Michael Fulbright <msf@redhat.com>
- First try at an RPM
