# Note that this is NOT a relocatable package
%define ver      1.0.0
%define rel      1
%define prefix   /usr

%define config_opts --prefix=%{prefix} --sysconfdir=/etc --mandir=%{_mandir} --enable-threads --disable-system-install --disable-more-warnings

Summary:   Balsa Mail Client
Name:      balsa
Version:   %ver
Release:   %rel
Copyright: GPL
Group:     Applications/Internet
Source0:   balsa-%{PACKAGE_VERSION}.tar.bz2
URL:       http://www.balsa.net/
BuildRoot: /tmp/balsa-%{PACKAGE_VERSION}-root
Packager: Pawel Salek <pawsa@theochem.kth.se>
Requires: gtk+ >= 1.2.7
Requires: gnome-libs >= 1.2.0
Provides: balsa
Docdir: %{prefix}/doc

%description
Balsa is an e-mail reader.  This client is part of the GNOME
desktop environment.  It supports local mailboxes, POP3 and
IMAP.
 
%prep
%setup

%build
# Needed for snapshot releases.
if [ ! -f configure ]; then
%ifarch alpha
  CFLAGS="$RPM_OPT_FLAGS" ./autogen.sh --host=alpha-redhat-linux %{config_opts}
%else
  CFLAGS="$RPM_OPT_FLAGS" ./autogen.sh %{config_opts}
%endif
else
%ifarch alpha
  CFLAGS="$RPM_OPT_FLAGS" ./configure --host=alpha-redhat-linux %{config_opts}
%else
  CFLAGS="$RPM_OPT_FLAGS" ./configure %{config_opts}
%endif
fi

patch -p0 < rpm-po.patch
if [ "$SMP" != "" ]; then
  (make "MAKE=make -k -j $SMP"; exit 0)
  make
else
  make CFLAGS="$RPM_OPT_FLAGS"
fi

%install
rm -rf "$RPM_BUILD_ROOT"

make sysconfdir=/etc  DESTDIR="$RPM_BUILD_ROOT" install

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-, root, root)
%doc README COPYING ChangeLog NEWS TODO AUTHORS HACKING docs/mh-mail-HOWTO
%doc docs/vconvert.awk docs/pine2vcard
%{prefix}/bin/balsa
/usr/share/gnome/apps/Internet/balsa.desktop
%{prefix}/share/gnome/help/balsa/*
/usr/share/locale/*/LC_MESSAGES/balsa.mo
/usr/share/pixmaps/*
/usr/share/sounds/balsa/*
%{_mandir}/man1/balsa.1*
%config /etc/sound/events/*


%changelog
* Fri Nov 03 2000 Pawel Salek <pawsa@theochem.kth.se>

- use %{_mandir} for location of the manual.

* Fri Oct 20 2000 Pawel Salek <pawsa@theochem.kth.se>

- require gtk+>= 1.2.7, not gnome-libs. 

* Fri Oct 20 2000 Pawel Salek <pawsa@theochem.kth.se>

- require gnome-libs >= 1.2.7, earlier versions are buggy. drop building GSS.

* Mon Sep 18 2000 Pawel Salek <pawsa@theochem.kth.se>

- include only translation files, not whole directories, to aviod
  misleading messages when removing the package.

* Tue Aug 15 2000 Pawel Salek <pawsa@theochem.kth.se>

- added --disable-more-warning option - libmutt configure fails without it.

* Thu Jun  1 2000 Peter Williams <peter@newton.cx>

- Don't try to install IDL stuff as we have deleted it :-)

* Thu Dec 30 1999 Bruno Pires Marinho <bapm@camoes.rnl.ist.utl.pt>

- Improved the spec file by adding a sysconfdir=/etc, removing the man
  instalation because balsa does it now and adding the files on the /etc
  to the distribution

* Tue Oct  5 1999 Jan Nieuwenhuizen <janneke@gnu.org>

- Fixed man install

* Sun Sep 26 1999 Stuart Parmenter <pavlov@balsa.net>

- Updated to version 0.5.0

* Mon Dec 14 1998 Stuart Parmenter <pavlov@pavlov.net>

- Updated to version 0.4.8.

* Sun Sep 09 1998 Stuart Parmenter <pavlov@pavlov.net>

- Updated to version 0.4.7.

* Sun Aug 23 1998 Stuart Parmenter <pavlov@pavlov.net>

- Updated to version 0.4.5.

* Mon Aug  3 1998 Stuart Parmenter <pavlov@pavlov.net>

- Updated to version 0.4.0.

* Sun Jul 26 1998 Stuart Parmenter <pavlov@pavlov.net>

- Updated RPM file to reflect recent changes with the
  removal of c-client.

* Thu Apr 02 1998 Michael Fulbright <msf@redhat.com>

- First try at an RPM
