enum {
  ENC_ISO_8859_1  = 1 << 0,
  ENC_ISO_8859_2  = 1 << 1,
  ENC_ISO_8859_3  = 1 << 2,
  ENC_ISO_8859_4  = 1 << 3,
  ENC_ISO_8859_5  = 1 << 4,
  ENC_ISO_8859_6  = 1 << 5,
  ENC_ISO_8859_7  = 1 << 6,
  ENC_ISO_8859_8  = 1 << 7,
  ENC_ISO_8859_9  = 1 << 8,
  ENC_ISO_8859_10 = 1 << 9,
  ENC_ISO_8859_13 = 1 << 10,
  ENC_ISO_8859_14 = 1 << 11,
  ENC_ISO_8859_15 = 1 << 12,
  ENC_KOI8_R      = 1 << 13,
  ENC_TIS_620     = 1 << 14,
  ENC_JIS_0208    = 1 << 15,
  ENC_GB_2312     = 1 << 16,
  ENC_KSC_5601    = 1 << 17,
  ENC_JIS_0201    = 1 << 18,
  ENC_JIS_0212    = 1 << 19,
  ENC_BIG5	  = 1 << 20,
  ENC_ISO_10646   = 1 << 21
};

Charset charsets[] = {
  { 0,  NULL,           "iso8859-1",       conv_ucs4 },
  { 1,  "ISO-8859-2",   "iso8859-2",       conv_8bit },
  { 2,  "ISO-8859-3",   "iso8859-3",       conv_8bit },
  { 3,  "ISO-8859-4",   "iso8859-4",       conv_8bit },
  { 4,  "ISO-8859-5",   "iso8859-5",       conv_8bit },
  { 5,  "ISO-8859-6",   "iso8859-6",       conv_8bit },
  { 6,  "ISO-8859-7",   "iso8859-7",       conv_8bit },
  { 7,  "ISO-8859-8",   "iso8859-8",       conv_8bit },
  { 8,  "ISO-8859-9",   "iso8859-9",       conv_8bit },
  { 9,  "ISO-8859-10",  "iso8859-10",      conv_8bit },
  { 10, "ISO-8859-13",  "iso8859-13",      conv_8bit },
  { 11, "ISO-8859-14",  "iso8859-14",      conv_8bit },
  { 12, "ISO-8859-15",  "iso8859-15",      conv_8bit },
  { 13, "KOI8-R",       "koi8-r",          conv_8bit },
  { 14, "TIS-620",      "tis620.2529-1",   conv_8bit },
  { 15, "EUC-JP",       "jisx0208.1983-0", conv_eucjp },
  { 16, "GB2312",       "gb2312.1980-0",   conv_16bit },
  { 17, "EUC-KR",       "ksc5601.1987-0",  conv_16bit },
  { 18, "EUC-JP",       "jisx0201.1976-0", conv_eucjp },
  { 19, "EUC-JP",       "jisx0212.1990-0", conv_eucjp },
  { 20, "BIG5",	        "big5-0",	   conv_16bit },
  { 21, NULL,           "iso10646-1",      conv_ucs4 }
};

CharsetOrdering charset_orderings[] = {
	{ "zh-cn", { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16, 20, 18, 15, 17, 19, 21} },
	{ "zh-tw", { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 20, 16, 18, 15, 19, 17, 21} },
	{ "ja", { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 18, 19, 16, 17, 20, 21} },
	{ "ko", { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 17, 21, 15, 16, 18, 19, 20} },
	{ NULL, { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 21, 15, 16, 17, 18, 19, 20} }
};

const guint32 char_mask_map[] = {
  0,
  ENC_ISO_8859_10|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_5|ENC_ISO_8859_6|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_KOI8_R,
  ENC_ISO_8859_10|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_5|ENC_ISO_8859_6|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0201|ENC_KOI8_R|ENC_TIS_620,
  ENC_ISO_8859_10|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_5|ENC_ISO_8859_6|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0208|ENC_KOI8_R|ENC_TIS_620,
  ENC_ISO_8859_10|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_5|ENC_ISO_8859_6|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0212|ENC_KOI8_R|ENC_TIS_620,
  ENC_ISO_8859_10|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_5|ENC_ISO_8859_6|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9,
  ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_BIG5|ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0208,
  ENC_BIG5|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_3|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0208,
  ENC_GB_2312|ENC_ISO_8859_13|ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_6|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_BIG5|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0201,
  ENC_ISO_8859_13|ENC_ISO_8859_1|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_BIG5|ENC_GB_2312|ENC_ISO_8859_10|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_5|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0208,
  ENC_GB_2312|ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0208,
  ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0212|ENC_KOI8_R,
  ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9,
  ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0208,
  ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_4|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_BIG5|ENC_GB_2312|ENC_ISO_8859_10|ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0208|ENC_KOI8_R,
  ENC_BIG5|ENC_GB_2312|ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0208,
  ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_3|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_KOI8_R,
  ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_3|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9,
  ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0208,
  ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_3|ENC_ISO_8859_8|ENC_ISO_8859_9,
  ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0208,
  ENC_BIG5|ENC_ISO_8859_10|ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_3|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_KOI8_R,
  ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_8|ENC_ISO_8859_9,
  ENC_ISO_8859_13|ENC_ISO_8859_1|ENC_ISO_8859_8|ENC_ISO_8859_9,
  ENC_ISO_8859_13|ENC_ISO_8859_1|ENC_ISO_8859_3|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9,
  ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_3|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_ISO_8859_10|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_ISO_8859_10|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_4|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_ISO_8859_10|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_ISO_8859_10|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_4|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_ISO_8859_10|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_3|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_ISO_8859_10|ENC_ISO_8859_15|ENC_ISO_8859_1,
  ENC_ISO_8859_10|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_BIG5|ENC_GB_2312|ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0208,
  ENC_ISO_8859_10|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_ISO_8859_10|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_JIS_0212,
  ENC_ISO_8859_10|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_JIS_0212,
  ENC_GB_2312|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_3|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_GB_2312|ENC_ISO_8859_10|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_GB_2312|ENC_ISO_8859_10|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_GB_2312|ENC_ISO_8859_10|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_BIG5|ENC_GB_2312|ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0208|ENC_KOI8_R,
  ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_1|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_ISO_8859_10|ENC_ISO_8859_13|ENC_ISO_8859_4|ENC_JIS_0212,
  ENC_GB_2312|ENC_ISO_8859_10|ENC_ISO_8859_13|ENC_ISO_8859_4|ENC_JIS_0212,
  ENC_ISO_8859_2|ENC_JIS_0212,
  ENC_ISO_8859_10|ENC_ISO_8859_13|ENC_ISO_8859_2|ENC_ISO_8859_4|ENC_JIS_0212,
  ENC_ISO_8859_13|ENC_ISO_8859_2|ENC_JIS_0212,
  ENC_ISO_8859_3|ENC_JIS_0212,
  ENC_ISO_8859_14|ENC_ISO_8859_3|ENC_JIS_0212,
  ENC_ISO_8859_10|ENC_ISO_8859_2|ENC_ISO_8859_4|ENC_JIS_0212,
  ENC_GB_2312|ENC_ISO_8859_2|ENC_JIS_0212,
  ENC_ISO_8859_3|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_ISO_8859_10|ENC_ISO_8859_13|ENC_ISO_8859_4,
  ENC_ISO_8859_10|ENC_ISO_8859_4|ENC_JIS_0212,
  ENC_JIS_0212,
  ENC_ISO_8859_15|ENC_JIS_0212,
  ENC_ISO_8859_13|ENC_ISO_8859_4|ENC_JIS_0212,
  ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_ISO_8859_10|ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_2|ENC_ISO_8859_4|ENC_JIS_0212,
  ENC_ISO_8859_14|ENC_JIS_0212,
  ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_JIS_0212,
  ENC_ISO_8859_13|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_JIS_0212,
  ENC_GB_2312|ENC_JIS_0212,
  ENC_BIG5|ENC_GB_2312|ENC_ISO_8859_2|ENC_ISO_8859_4|ENC_JIS_0212,
  ENC_BIG5|ENC_GB_2312,
  ENC_BIG5,
  ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_JIS_0212,
  ENC_BIG5|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_JIS_0212,
  ENC_ISO_8859_2|ENC_ISO_8859_4|ENC_JIS_0212,
  ENC_ISO_8859_7|ENC_JIS_0212,
  ENC_BIG5|ENC_GB_2312|ENC_ISO_8859_7|ENC_JIS_0208,
  ENC_BIG5|ENC_GB_2312|ENC_ISO_8859_5|ENC_JIS_0208|ENC_KOI8_R,
  ENC_ISO_8859_5|ENC_JIS_0212,
  ENC_GB_2312|ENC_ISO_8859_5|ENC_JIS_0208|ENC_KOI8_R,
  ENC_ISO_8859_8,
  ENC_ISO_8859_6,
  ENC_TIS_620,
  ENC_ISO_8859_14,
  ENC_JIS_0208,
  ENC_GB_2312|ENC_ISO_8859_10|ENC_ISO_8859_7|ENC_JIS_0208,
  ENC_GB_2312|ENC_JIS_0208,
  ENC_BIG5|ENC_GB_2312|ENC_ISO_8859_13|ENC_ISO_8859_7|ENC_JIS_0208,
  ENC_BIG5|ENC_GB_2312|ENC_ISO_8859_13|ENC_JIS_0208,
  ENC_ISO_8859_13,
  ENC_BIG5|ENC_JIS_0208,
  ENC_BIG5|ENC_GB_2312|ENC_JIS_0208,
  ENC_BIG5|ENC_JIS_0201,
  ENC_ISO_8859_15,
  ENC_GB_2312|ENC_ISO_8859_5|ENC_JIS_0212,
  ENC_GB_2312,
  ENC_KOI8_R,
  ENC_BIG5|ENC_GB_2312|ENC_JIS_0208|ENC_KOI8_R,
  ENC_GB_2312|ENC_KOI8_R,
  ENC_BIG5|ENC_KOI8_R,
  ENC_BIG5|ENC_GB_2312|ENC_JIS_0212,
  ENC_BIG5|ENC_JIS_0212,
  ENC_JIS_0201,
  ENC_BIG5|ENC_BIG5|ENC_BIG5|ENC_BIG5|ENC_BIG5|ENC_BIG5|ENC_BIG5,
  ENC_KSC_5601, // 106
  ENC_JIS_0212|ENC_KSC_5601,
  ENC_GB_2312|ENC_JIS_0212|ENC_KSC_5601,
  ENC_BIG5|ENC_GB_2312|ENC_KSC_5601,
  ENC_BIG5|ENC_KSC_5601,
  ENC_JIS_0208|ENC_KSC_5601,
  ENC_GB_2312|ENC_JIS_0208|ENC_KSC_5601,
  ENC_BIG5|ENC_JIS_0208|ENC_KSC_5601,
  ENC_BIG5|ENC_GB_2312|ENC_JIS_0208|ENC_KSC_5601,
  ENC_GB_2312|ENC_KSC_5601,
  ENC_BIG5|ENC_GB_2312|ENC_JIS_0212|ENC_KSC_5601,
  ENC_BIG5|ENC_JIS_0212|ENC_KSC_5601,
};

const guchar char_masks[] = {
  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  3,  2,  2,  2,
  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  4,  1,
  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
  1,  6,  7,  8,  9, 10, 11, 12, 13, 14,  6, 15, 16,  5, 17, 18,
 19, 20, 21, 22, 23, 24, 25, 26, 27, 28,  6, 15, 29, 30, 29,  6,
 31, 32, 32, 33, 34, 35, 35, 36, 31, 34, 31, 32, 31, 32, 32, 37,
 38, 31, 31, 39, 32, 35, 34, 40, 35, 31, 32, 41, 34, 42, 43, 34,
 44, 45, 32, 33, 34, 35, 35, 36, 44, 46, 44, 32, 44, 45, 32, 37,
 43, 31, 44, 47, 32, 35, 34, 48, 35, 44, 45, 41, 46, 42, 43, 49,
 50, 51, 52, 52, 53, 53, 54, 54, 55, 55, 56, 56, 53, 53, 52, 52,
 57, 57, 50, 51,  0,  0, 50, 50, 53, 53, 52, 58, 55, 55, 59, 59,
 56, 56, 50, 60, 55, 55, 55, 55, 61, 61, 50, 51,  0,  0, 50, 50,
 59, 59, 62, 62, 55, 55, 50, 50, 61, 52, 52, 50, 50, 52, 52, 62,
 62, 54, 54, 54, 54, 50, 50, 52, 52, 62, 61, 61, 50, 51,  0,  0,
 52, 52, 63, 63, 52, 52, 64, 64, 52, 52, 54, 54, 55, 55, 65, 65,
 66, 66, 52, 52, 52, 52, 61, 61, 61, 61, 50, 51, 55, 55, 52, 52,
 52, 52, 50, 50, 67, 67, 67, 67, 68, 54, 54, 69, 69, 66, 66,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 62, 70, 62,
 70, 62, 70, 62, 70, 62, 70, 62, 70, 62, 70, 62, 70,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 62,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0, 71,  0, 72, 73, 73,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 74, 75, 62, 76,  0, 52,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 77, 77, 77,  0, 77, 77, 77,  0, 77,  0, 77, 77,
 77, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78,
 78, 78,  0, 78, 78, 78, 78, 78, 78, 78, 77, 77, 77, 77, 77, 77,
 77, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78,
 78, 78, 77, 78, 78, 78, 78, 78, 78, 78, 77, 77, 77, 77, 77,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 79, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,  0, 80, 80,
 81, 81, 81, 81, 79, 79, 79, 79, 79, 79, 79, 79, 79, 81, 81, 81,
 81, 81, 81, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79,
 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79,
 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79,
  0, 79, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,  0, 80, 80,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82,
 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 83,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 83,  0,  0,  0, 83,
  0, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,  0,  0,  0,  0,  0,
 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
 83, 83, 83,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84,
 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84,
 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84,
 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84,  0,  0,  0,  0, 84,
 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84,
 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 85, 85,  0,  0,  0,  0,  0,  0, 85, 85,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 85, 85,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 85, 85,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0, 85, 85,  0,  0,  0,  0,  0,  0,  0,  0,
 85, 85,  0,  0,  0,  0,  0,  0,  0,  0, 85, 85,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 85, 85, 85, 85, 85, 85,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 85, 85,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 82, 82,
 86,  0,  0, 73, 73, 87, 88, 82, 78, 89,  0,  0, 90, 90, 91,  0,
 86, 86, 73,  0,  0, 92, 93,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 88,  0, 93, 88,  0, 73,  0,  0,  0,  0,  0, 93,  0,  0, 94,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 95,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0, 93,  0, 73,  0,  0,  0, 73,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0, 96,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 62,  0,  0,  0,  0,  0,  0,  0,  0, 86,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 97, 97,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 93, 93, 93, 93,  0,  0, 73, 73, 73, 73,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 86,  0, 86,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 86,  0, 86, 86,  0,  0,  0, 86, 88,  0,  0, 86,  0,  0,  0, 97,
  0, 97, 86,  0,  0,  0,  0,  0,  0, 98, 99,  0,  0, 88, 93, 73,
 93,  0,  0, 73,  0, 72,  0, 88, 88, 93, 93, 93, 86,  0, 72,  0,
  0,  0,  0,  0, 93, 93, 97, 97,  0,  0,  0,  0, 73, 88,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 100,  0,  0,  0, 97,  0,  0,  0,
  0,  0, 92,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 93, 93,  0,  0, 100, 100, 92, 92,  0,  0, 86, 86,  0,  0, 97, 97,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 86, 86,  0,  0, 86, 86,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0, 97,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 93,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 73,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 88,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 72, 72, 72, 72, 72, 72, 72, 72, 72, 72,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 99, 88, 99, 88, 97, 97, 97, 97, 97, 97, 97, 97, 99, 97, 97, 88,
 99, 97, 97, 88, 99, 97, 97, 88, 99, 97, 97, 88, 99, 88, 97, 97,
 88, 97, 97, 88, 99, 88, 97, 97, 88, 97, 97, 88, 99, 97, 97, 88,
 88, 97, 97, 88, 99, 97, 97, 88, 88, 97, 97, 88, 99, 97, 97, 88,
 97, 97, 88, 97, 97, 97, 97, 97, 97, 97, 97, 88,  0,  0,  0,  0,
 101, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 101, 98,
 98, 101, 98, 98, 98, 98, 98, 98, 98, 98, 101, 98, 98, 73, 73, 73,
 73, 73, 73, 73,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 98, 73, 73, 73, 101, 73, 73, 73, 101, 73, 73, 73, 101, 73, 73, 73,
 98, 98, 98, 98, 73, 73,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 99, 93,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 93, 93,  0,  0,  0,  0,  0,  0,  0,  0, 92, 92,  0,  0,
  0,  0,  0,  0,  0,  0, 93, 93,  0,  0,  0, 93,  0,  0, 93, 93,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 73, 73, 73, 73,  0,  0,  0,  0,  0,  0,  0,  0,  0, 86,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 93, 93,  0,  0, 73,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 93, 73, 93,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 86,  0,  0, 86,  0, 86,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 93, 93, 93, 93,  0, 93, 86, 86, 93, 93, 93, 93, 93, 93, 93, 93,
 93, 93, 92, 88, 93, 93, 97, 97,  0,  0,  0,  0, 86, 73, 73,  0,
  0, 73, 73, 73, 73, 73, 73, 73, 73, 73,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
 93, 93, 93, 93,  0,  0,  0,  0,  0,  0,  0, 86, 86, 92, 92,  0,
  0, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
 93, 93, 93, 93, 93, 93, 93,  0,  0,  0,  0, 88, 86, 86, 92,  0,
  0,  0,  0,  0,  0, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72,
 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72,
 72, 72, 72, 72, 72, 72, 72, 72, 72, 72,  0,  0,  0,  0,  0,  0,
  0,106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,
106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,
106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,
106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,
106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,
106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0, 73,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 73, 73,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 73, 73, 73,  0,
  0, 73,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 73,  0,  0,  0,  0,  0,  0,  0,  0,  0, 73,  0,
  0, 73, 73,  0,  0, 73,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
114,114, 62,114, 62, 62,  0,114,114,114,114,114,102,114, 93, 73,
 93,114, 62, 97,114,114,114, 86,114,114, 97, 97, 97, 97,114,103,
  0, 86, 97, 62, 70, 97, 92, 97, 70,  0, 88,102, 97,114,103, 62,
102, 92,114, 73, 97, 62, 88,  0,114,114, 97,114, 92, 97, 97, 88,
 62, 62,113,114, 62,114,  0,102, 72, 97,  0,114, 97,114,114,114,
 97, 62, 72, 72, 97, 86,114, 86,114,114, 62,  0,102,114,114,114,
 97, 97, 86, 62,  0,  0, 97,  0, 62,102,  0,106,  0,106,  0,  0,
 97, 88,  0,114, 62, 62,106,106,  0, 62,  0,  0,  0,  0,114,103,
 86,  0,113, 73, 73, 86,114,  0,114, 88, 86,114,114,102,114, 97,
106,114,114, 72,114,114, 62, 62,112, 92, 97,114, 86, 62,113, 93,
 88,114,114,  0,114,114,114, 97,114, 97,  0,114,114,114,114, 62,
 86,  0, 97, 93,  0, 97,113,  0,  0,103,114, 97,  0,  0,  0, 97,
114,114, 93,102,114, 97, 93,114, 73, 72,114,114,  0,114, 88, 86,
 62, 97,  0, 97,114,114,114,114,114,114,103, 62, 73,114, 93,114,
 62,102, 62,114,114,114,  0,  0,102, 73, 97, 97, 97, 86, 86, 62,
114,103,114,102, 73,102,114,114,  0,  0,  0,114,  0,102, 62,102,
103,114,103, 62, 73, 73,  0,  0,103,114,114,117, 62,114,114,114,
114,114,103, 73, 73,103, 62, 70, 72,102, 88, 97, 86, 92, 97, 97,
 97,  0, 72,  0, 97, 97, 97, 97,  0,  0, 97, 97, 73, 73, 62,114,
 93, 62, 97,103,114, 62,114, 62,114, 62,114,103,114,114,103, 73,
 62, 73, 62,114,  0,  0,114,113,117,103,  0, 62,103,114,114,114,
114,114,103, 93,103,114,103, 93,102,114,114,114,114, 93, 93,102,
102, 73, 73,102, 72, 97,  0, 72,  0,114,103, 73,102,  0,103,114,
114, 62,  0,114, 72, 92,114,103,103,103,117, 93, 93,103,116,114,
 73,117,103,114,116,103,113, 73,114,102,107,114, 62,114, 62,114,
103,114,103, 62,102, 73,113,102,113, 62,103,114, 73,114,103, 62,
 88, 86,  0, 97,  0, 97, 97, 97, 97, 97, 97, 86, 97, 86,114,114,
  0,  0,103, 73,  0,114,113,103,  0,103, 73,103, 62, 62, 62,114,
103,103,113,114,114,102, 62, 73, 62,117,114,103, 62,103,114,102,
 93,114, 62,110,113,  0, 73,114, 93, 73,114, 92,102,114, 72,114,
117,114, 62, 88, 86, 86, 97,  0, 97, 97, 97,  0, 73, 97,114,114,
 62,109, 62,114, 73,113, 92, 73,114,  0,114,  0, 62, 62, 93, 62,
103, 62,106,  0, 62, 92,113,103,  0,113, 62,113,102,114,103, 93,
 62,113,114,103, 93, 73,113,103,102,114,114,103,116, 62,117,114,
 73,114,103,113,111, 93,114,117,114, 93,114,113,114,114, 70, 73,
103, 73, 62,103,  0,103, 86, 73,  0, 86, 97,107, 72,  0, 97,  0,
103,103, 62,114,  0,103,103,114,114,113,103, 73,102, 73,102,114,
 86,103, 62,103,  0,114, 86,103,  0, 62,114, 73,114, 73, 73,103,
103, 73,103,103, 73,114, 62, 62, 73, 73,103, 73, 88,103, 73, 73,
103, 62, 92, 73,113,113,114, 72,111,  0, 73, 97,  0, 92, 97, 97,
114, 62, 73,103, 62,114, 62, 73, 97,  0, 62, 73, 73,114,103, 62,
 62,113,103, 62,103, 73,103,  0,113,113, 92,103,103, 73,103, 62,
 62, 62,103, 72,  0, 97,  0, 97, 97, 97, 62,  0,114,113, 73,103,
103, 73,114,113, 92,113, 73,113, 73, 62,102, 72,  0,103,113, 73,
 62, 73, 92, 62,103,113, 73,103, 73,113,113, 73, 62, 86,103,114,
 62,113,  0,103,103,113,114, 73, 62,  0,114, 73, 62,103,111, 62,
 73,  0, 62, 92,103,113,102,114,103,103, 73,  0, 72,114, 93,103,
 73,103, 62, 72,  0, 93,103,  0, 73,113, 62,114,  0, 73,103,110,
113,111, 92,103,113, 73,116,102,103,113, 73,102,103, 62, 62,  0,
103, 73,114, 73, 92, 92, 86,103, 92, 62, 92, 62,103, 62, 62,113,
 73,114, 73, 62, 73, 73, 73, 62, 62, 73,113,  0, 62,103, 73, 62,
 73,103,113,103,103,103,  0,113,103,103,113, 92,113, 73,  0, 93,
114,114, 62,114,114,114,114,113,114,114, 62,114,113,114,111, 62,
 86, 97,113, 62, 93,102, 97,103, 62, 73, 93, 73,114, 73, 73,103,
  0, 73,114, 73, 62,114, 62,110,114,113,111,114,114,114,114,  0,
 97,114,  0, 97, 97,114,114,114,114, 97,  0, 97,114, 97, 62,  0,
114, 97, 88, 62, 62, 88,111, 73, 97, 93,113, 62, 88,114, 62, 92,
 86, 92,114, 92, 73,114, 88,114,103, 88,  0, 97, 97, 62, 73,  0,
114, 62, 93, 62, 93,114, 86,  0, 86, 86,113, 88,114, 62,  0, 97,
 93, 93, 88, 88, 86, 88,114,114, 62, 73, 62, 97,102,114,103, 62,
 97,  0, 62,  0,114, 92,114, 97,103,112, 73,114,114,113, 73, 70,
 73, 70, 62, 62, 73, 62, 86, 73,103,  0,  0, 88,113,114,117,  0,
 93,114, 62,  0, 97, 62, 86, 86,  0, 86, 86, 97,  0, 88, 62, 97,
114,113, 62,102, 62, 93,114, 62,114,114,114, 97, 97,114, 86, 97,
114,102, 70,114, 86, 62,114,114,114, 73,114, 86, 73, 97,114,  0,
 73,114,102,103, 86, 62,102,114, 70, 97, 97, 97, 73,114, 73,  0,
 97, 73, 62,  0,114,113,  0, 86,102,114,113, 97,  0, 97,114,  0,
114,103,103, 93,  0,103,114,114,114,112,114,114, 62, 97,  0, 97,
 97, 72, 97,114, 92, 62, 73,113,  0,103,114,113,114,114, 73, 86,
 97, 97, 73,  0,114,103,114, 62, 62,  0,103,113,102,110, 93,103,
 62,116, 73, 86, 86, 88, 62, 97,  0,114,114, 73, 73, 73,103,114,
 86, 86,114, 86, 92,113,  0,103,103, 62, 73, 73, 73,114,  0,114,
103, 72,102,113, 73, 62,  0,113,114,113,103, 73,103,113,  0,  0,
 97,113,111,102, 86, 62,103,103,103, 73, 62,114, 62, 97, 97,114,
114, 97, 97,114,107, 62,103, 62, 97,114,114,114, 93, 93, 73, 62,
 62, 88, 97, 97, 86, 86, 62, 62, 62, 86, 62,103, 92, 62,114, 97,
103,113, 73,114, 62,111, 62,114, 62,114,  0, 97, 62,113,  0, 62,
 97, 62,114, 73, 62,113,116, 92,114,113,  0,117, 62,113,113,114,
 86, 62,113,113,114, 62, 92, 86, 62,103, 62, 73, 62,  0,  0, 73,
102,103, 86,113,103,113, 62,103,113, 88,114,110, 73,  0,114,114,
 70, 86, 86, 62,  0,114, 93,  0,114, 73,103,103, 62,114, 73,114,
114,103, 73, 62,  0,114,114,114, 62,114, 93, 62,103, 93, 62,103,
114,114, 73,114,  0, 62, 97, 62, 62, 62,114, 62, 62,103, 97,113,
103, 92, 62, 86, 73, 62,  0, 73, 86,114, 88, 88,103,103,102,114,
113,114, 62,114,110, 93, 86,114,114,114,114, 62,103,113, 97, 97,
  0,114,114,114,113, 97, 97,114, 86, 62,114, 62,114,  0,114, 97,
114,102, 97,102, 97, 62,114, 97,106, 88,  0, 97,103, 62, 93,114,
114,114,103, 93,112,114,  0,114, 93,103, 97, 92, 73,106, 62,114,
  0,  0, 93, 62,114, 97, 97, 62, 62, 97, 73, 97, 97, 97,103, 73,
  0,  0, 73,107,103, 97, 92, 73,114,103,114,  0, 73,102, 73,114,
111, 62, 97, 97,103,114,112, 73, 88, 88, 62, 62, 73,113, 88, 62,
 86,  0,103, 86,103, 62, 88, 62, 62, 73, 62,114,  0, 62,  0, 97,
 62, 97, 88,113,  0, 62,  0,  0,114,114,114,114, 88,114, 86, 62,
  0, 97, 62, 62,114, 62,114,114, 97, 88, 62,114,  0, 62, 62, 93,
 70,113,113,114,114,114,102, 62, 93,114,114,114,114,114, 93,114,
114,114,114,114,  0,102, 88, 88,114, 97, 86, 72, 72, 97,  0,  0,
  0, 93, 62,114,114,  0, 72, 73,114,114,114, 92,114,114,114,114,
114,114, 72, 70,  0, 97, 97, 97, 73, 73, 62,114, 73,114, 72,114,
114, 70,  0, 97, 73, 73,114,102,102,114,103,114, 93, 93, 93, 70,
 73,102, 97,110, 70,102, 92, 73,114,114,  0,114,114, 92,114,  0,
 93, 73,113,102, 62, 73, 93,103,114, 86,114, 97,  0, 62, 92,103,
 97,111, 97, 97, 72, 97, 97, 97, 97, 97,  0, 97, 97,  0, 62, 86,
 73, 73,102, 73,102, 73,102,103,114, 62,111,103, 73, 62, 62, 73,
 92,114, 72,114,103,114, 93, 93, 72,  0, 73,114,114,114, 73,103,
114,103, 72, 62, 93, 62,114, 73,103, 62,  0, 93,114,103,114, 88,
114,103, 93,  0, 97,102,102,  0, 73, 97, 72, 97, 62, 97,  0, 62,
 73,103, 92, 97,112, 92,102,102,114,102,102,114,114,102,103, 93,
 73,102, 86,114, 97,  0, 73,103,114, 62,103,102, 92,114, 92,102,
114,114, 93, 73,114, 73,102, 93,114,114, 62,  0, 97, 70,102, 72,
 97, 97, 97, 97, 97, 97, 73, 97, 86, 97, 97,  0, 97, 97, 72, 97,
103,113, 92,  0, 73,114, 93, 72,114, 93,102, 73, 62,114,114, 62,
  0, 73,114, 72,  0,  0, 62, 73, 73,  0,114, 73,102, 93, 62,102,
 62,102,  0, 73,113,103,114,114,103,102, 73, 73,103, 62,117, 93,
114, 72, 73,  0, 93, 62, 86, 73,  0,  0, 73, 97,106,  0,  0,  0,
 97,  0, 97, 97, 97,  0, 73, 72,  0,  0,102, 62, 72, 73, 93,114,
 72,114,103, 93, 73,117,103, 72, 92, 92,  0,103,102, 62,114, 97,
 92,102,  0, 72,114, 92,114, 62, 73, 70,102, 73, 86,103, 73,113,
102,103, 73,111,  0, 72,114, 92, 62,  0, 62, 62, 93, 86,117, 73,
 62,102, 73,113,102, 72,102, 97,  0,  0, 72,  0, 97, 97, 97,  0,
  0,  0,  0,  0,  0, 72, 72, 72, 97,  0,  0, 93,114, 73, 93,103,
114,102,102, 93,114,  0,107,114,102,114,114, 93, 73, 73,103,102,
  0,102,103,103,102, 73,  0, 62,114,114,113,  0,114,114, 86, 93,
  0, 73, 73,103,103, 73, 73,114, 92,111,113,113,113,103,113,  0,
 86, 72,103, 72,  0, 72, 86, 97,  0, 97,  0, 72,  0, 97, 97,103,
 73, 62, 73,103, 93,114,103,113, 73,102, 73,103,102, 72,103, 73,
 73,102,102,102,114, 73, 72, 62, 62, 73,113,103,114, 72, 62,114,
  0, 72,103,114,114, 72, 72, 73, 72,103, 97, 97, 97,  0,  0, 72,
  0,  0, 72, 97,  0, 97,103, 93,  0, 92, 73,  0, 73,114,114,103,
 72, 72, 73,  0, 73, 62,113,  0,102,114, 62,  0, 72,103,102,102,
103, 62,103, 73,113, 73, 92,113, 88, 62,  0, 93, 73, 73, 97, 72,
  0,  0,  0, 97, 97,  0,  0, 72,  0, 92, 73,  0,102, 97, 73,113,
103, 88,114,103,114,103,114, 62, 92,102, 73,102, 62,103, 73,102,
103,103, 92, 62, 62, 73,103,  0, 73,103, 73, 62, 93, 70, 93, 62,
 86,  0,  0,110, 70,  0,  0, 72, 72, 72, 73, 86, 97,  0,103,  0,
103, 62,102,103, 93, 73,103,  0,114,102, 93,114, 93,103, 73,103,
 73,102,103, 73,113, 62, 72, 73, 92, 73, 86, 97, 97,  0, 73, 73,
 92, 73, 73, 73,103,102,114, 92, 62,  0, 86, 62,103, 73, 72, 93,
 73,  0,  0, 72, 86,103,  0, 73, 73,103,103,  0, 73,103, 62, 62,
 86,  0, 86, 97,  0,113,103,103,103, 62, 73,103,117,103,113, 97,
  0, 62, 73,103,113, 73, 92,102,  0,  0,  0,  0,114, 73,103,  0,
 92, 92, 92, 92,  0,103, 73,  0, 92,103,116,103,103,117, 86, 62,
 62,113,  0, 92, 72,  0,  0, 93, 86, 62,114,114, 62,102,114,102,
114,102, 97, 86,102,103, 62,103, 62,  0, 73,102,  0, 70, 92,  0,
114, 70, 86, 86, 97, 97, 62,103,  0,114,114,  0,  0, 88, 97, 93,
 86,103,103,114,114,  0, 97,103,114, 93,102,113,103,113,  0, 86,
  0, 62,113,113, 73, 62,113,  0,113,  0,103,103, 93, 62, 73,114,
103,  0,103,102, 62, 62, 86, 86,114,102,102,  0,102,114,102,102,
114,  0,  0,102,103,  0,  0, 86, 86, 97, 97,114,  0, 62,102, 62,
114, 73,112,  0,  0,103, 62,114,  0, 73,114, 73,102,116,114, 93,
114,114,103,  0,  0,  0,  0, 97,  0,  0, 97, 97, 97, 97, 97, 97,
 97,114,103,  0,114, 62,114, 62,102, 93,114,102,  0,102,107,102,
117,103, 73,102,103,117, 72,102,  0, 62, 62,102,116, 73, 62, 86,
 73, 62,114,102, 97, 97, 97,  0,111, 86,  0,114,102,  0,  0, 73,
  0,  0, 97,114,103,103,  0,103, 73,103,103, 72, 62,103,103,103,
114, 70,114,114, 93, 73, 97, 70, 62, 70, 86, 97, 62, 97, 72,  0,
 86,  0, 97, 86, 97, 73, 73,  0,102, 73, 73,  0, 73,103,  0, 73,
 86, 73, 72,114,  0,  0, 92,117,107,  0,  0,114,103,  0,114,102,
 73,  0, 93, 86, 93,102, 86,  0, 97, 97, 97,  0, 92, 70, 62,114,
114,103, 73, 92,102, 73, 62,103,  0,103,  0,  0, 73,102, 73, 97,
117, 73, 73, 73,114,103,103,113,102,114,114, 73,113,102, 62, 62,
114, 73,114, 62,103,113,114, 72,117,117,113, 93,103,102, 73,  0,
 73, 97,  0,  0, 73, 88,  0,  0,  0, 93,  0,103, 73, 92,116, 62,
102,114,  0, 73,114, 73, 62,117, 73, 73,114,  0, 73,103, 73,113,
114,113,103, 73,113,114, 73, 73, 73,103,111, 73,  0, 92,  0,103,
 86, 86,  0,  0, 97,  0,  0,  0, 73,103,113,113,102,102, 73,117,
 62,114, 92, 73,114,103,  0,113,114, 92,113, 73,  0, 73,114, 62,
  0,107,113, 73,117, 72,  0, 62,103, 86,  0, 93, 97, 73,  0, 73,
 86, 73, 86,  0, 73,113, 73,  0, 62,113, 73, 73,117, 73,114,103,
102,102, 73,114,  0,114, 73,103,103,116,103, 73, 62, 62, 73,103,
103, 73, 97,114,103,  0, 62, 86, 73, 97, 97,  0,113,103,109,114,
103,103, 62, 73,  0, 73,103,  0,114,116,  0, 92, 73,  0,113, 73,
  0,103, 62,113,  0,  0,  0,  0, 86, 86,113,111,102, 73,113, 73,
  0,114,103,  0, 62,114, 73,113,103, 73, 86,  0, 86, 62,117, 73,
 62,114,103,113,103,114,103, 86,113,113,103, 73, 86,103,113,113,
  0, 62,103, 73,114, 86,  0, 73, 73,103,  0,114,114,  0, 88,113,
 88, 86, 86, 70, 73,  0, 97, 86,  0,114,113,111, 92,113, 73, 73,
  0,  0, 88, 73, 97, 62,103, 97,  0, 86, 86, 62,103, 72, 73,114,
 86,  0,103, 62,116,114,114, 73, 86,114,114, 86,114, 62,  0, 97,
 73, 62,113, 62,102, 93,  0,114, 62,114,114,114, 92,114,114,102,
 62,114, 86, 62, 97, 62, 62,114, 93, 97, 97,  0, 72,  0,113, 62,
 73, 97, 97, 62,114, 73, 62,114,114,114, 73, 97,  0,  0,114,114,
113,114, 62,103,114,114, 97,114, 93, 62,114, 62, 73, 62, 62, 62,
114,103,114, 62,  0, 88,  0,113, 86, 92,113,117,111,117,113, 62,
 73, 73,103,114,114, 62,102, 73,114,102,  0,103,103,114, 73, 73,
 73, 93,114,114,114, 73, 97, 97, 97,  0,114, 62, 62, 93,103, 73,
 73,  0,102,114,  0, 62,114,116, 73,114,  0, 86,  0, 92, 72, 62,
 73, 73, 73, 93,102,114, 73,103,114, 97, 97, 97,111, 62,102,102,
 62, 73, 93,103, 73, 73, 73, 62,  0,114,103,114,103, 73,114,  0,
 73,103,  0,117, 62, 73,114, 73,103,111,102,114, 73,103, 73, 73,
114,114,102,114,114,  0, 73, 97, 72,111,114, 73,114,116,103, 62,
 73, 73,  0,102,103, 93,113, 62,114, 73,113, 86,109, 73,117, 62,
  0,103,103, 73,103, 73, 92,103,106, 97, 73,114, 73, 73, 73,114,
103,114,  0,114, 70, 97, 97, 97, 97, 93, 73,  0,102, 62, 62, 73,
  0,114, 62,102,  0, 73, 73, 73,114, 73, 86,110,114,  0,103,114,
114,  0,  0,102, 62,114,  0, 62, 62,114, 62,  0,  0,103, 73, 86,
 62, 97, 97, 73, 97, 92,114, 73, 73, 73,  0,  0,114,  0, 73,  0,
 93,113, 73, 73,103, 62,114,103,103,114, 72,  0,103, 73,  0,  0,
103, 73, 73, 73,  0,102, 73, 73, 73,  0,114, 73, 73, 73,103, 73,
 73,  0,114, 62, 73,103,113,102,  0, 73, 93,  0, 92,103,  0,  0,
 73,  0,  0,  0, 97, 97, 97,102, 73,  0,102,103, 73, 73, 62, 93,
  0,  0,  0, 73, 73,  0,  0,  0,  0,  0, 73,103, 73,  0, 73, 73,
103,  0,114,103, 73, 73, 62, 73,  0, 62,114,114,103, 73,103,103,
 62,  0,103,  0,106, 73, 73,103,  0, 73, 97,  0,103,  0, 73, 73,
 73,103,102,102, 73,102, 73, 73,102, 73,103,103, 92, 92, 93,103,
 73,114,114,  0,117,  0,103, 73,103,114, 73, 92,114, 73,  0, 62,
 86,  0, 97,  0, 97, 73, 93, 92, 72, 73,103, 73,102, 73, 73, 73,
102,114, 73, 93,  0,103,114,  0, 73,114,103, 72, 73, 73,103,  0,
  0, 97,  0, 73, 73,103,103, 73, 73, 73, 86, 92,  0,103,  0, 73,
 62,103, 73, 73,  0,110,  0, 73,103,114,  0,113,113,  0,  0, 73,
 73,  0,  0, 73, 73,  0,114,102,  0,103, 73,103,  0,103, 73,  0,
 73,103, 86, 73, 73,103, 73, 73, 73,  0,113,  0, 92,103, 73, 73,
 92,  0, 93,  0,102,  0, 86, 97,103,  0,  0,  0, 73, 73, 92, 73,
114, 62,  0,113,  0, 92,  0, 73, 73,  0,  0,103,103, 73, 73,  0,
114,114, 62, 72,114,114,103,114,114, 97,114, 93,114,114, 62,114,
  0,  0, 72,114,114, 93, 88,  0, 62,114, 97,113, 72,  0,103, 62,
114,114, 73, 93,  0,114,  0, 73,113,  0,114, 73,107,102, 62,103,
 88,102,  0, 93,102,114, 62,114,114,114, 62,114,114, 86,103,114,
 62, 62, 73,116, 62,114,107,114,114,114,114,114,114, 88, 97, 86,
 97, 97,114,114,114,114,114, 73,103, 62, 97, 97,117,103,113, 62,
114, 62, 62,114,114,114,114, 62,114,114, 62,  0, 62, 97, 97,114,
117,103,114,111,114,114,114,114,  0, 86, 73, 73,114,103, 73, 62,
114, 73,114,114,113,  0,103,107,103,103, 62, 86,  0, 88,114,114,
103,114,113, 73,114,114,113,113,114,113, 73,113,110,  0,114,117,
 93,103, 73, 86, 62,113,113,  0,114, 97,114, 97, 97, 62, 86, 88,
  0,114, 86, 73,114, 86, 88,113,113,114,114,113,103,113,113,114,
 73,114, 73, 86, 97, 72,114, 62, 97,106, 93,  0, 97, 97, 62,103,
 86,  0, 93, 62,114, 72, 62, 97,113, 62, 73, 62,102, 86, 62,  0,
103,114, 62, 73, 97, 62, 62, 73,114,114,114,114,114, 88,114,114,
114, 93, 97,  0, 73,114,113, 73,114, 97, 88,114, 73,113,114, 93,
 93,114,  0, 86, 73,114, 73,  0, 73,102, 62,106,103, 73, 88,  0,
114, 88,117,102,113,114, 97,103,103,103, 73,  0,113,103, 93,114,
 62,114,  0, 73,103, 62, 86,  0,  0,114,102,103,103, 62, 73, 97,
  0, 97, 97,  0,  0,  0, 73, 62,102, 73,103, 73, 93, 72,  0,103,
114,114,103, 73, 93, 73, 97, 97, 97, 97, 97, 97, 97,103,  0,103,
103,113,102,102, 73, 73,103, 73, 92,114,103,114,114, 72, 73, 73,
 73,114, 62,114, 62,116, 92,114,114,  0,107, 86, 86, 97,111, 97,
106, 97,  0,  0, 97, 86, 73, 92, 73,103, 73,102, 73,  0, 73, 73,
 73,  0,102, 73, 73,  0, 73,103, 73,114, 73, 73,  0, 62, 73, 73,
111, 88,  0,  0, 97, 97, 97,  0,114, 86, 93,  0, 73, 93,103,111,
114,103, 62,  0,117,  0,113, 73, 73, 73, 86,114,  0,113,  0, 73,
 73,103, 97, 97,  0,  0,102,114,  0,  0,  0, 92, 73,117,114, 73,
  0,113,103,  0,114, 86,114,113, 86,113, 92, 93,  0, 73, 72, 92,
 73,  0, 92,103,102, 73,102,116, 73,114,  0, 62,  0, 97, 72,  0,
 73,103, 73, 73,102, 73, 73, 73, 73,103, 73,  0, 73,102, 97,103,
 73, 73,103,103,  0, 73, 62, 72, 62, 73,102,114,114,  0, 92,  0,
113,103, 92,  0,  0,103,  0,  0, 97,103,  0, 97, 86, 97, 73, 62,
 62, 62,103, 73, 62, 73,  0, 73, 73,114, 62, 72,114, 62,  0,114,
 62, 73, 73, 86, 97,  0, 86, 73,  0,103,103,  0, 73, 73,103,103,
 73,103, 93, 62, 92,  0, 73,113,103, 73,103,111, 86, 73,  0,  0,
 86,  0,103,103,103,103,  0, 73,  0,102, 73, 62, 73,114, 73,103,
117, 73,113,  0,  0,  0,  0,103, 73, 73,110, 62, 92, 73, 92, 73,
103, 73,103,  0,103, 73,  0, 93,117, 62,113,  0,113,113,  0,  0,
 73,  0, 73,103,  0, 97, 73,103,  0, 92,  0,103, 86,114, 62, 73,
 62, 73,113, 86, 73, 73,113,  0,103, 62,  0, 88,  0,114,114, 73,
103,114,109, 86, 62,114,114,114,114, 70,  0,114,  0,  0,114, 97,
 73,114,114,114,114, 86,  0,114, 62,103,  0, 86,  0,114,114, 73,
 62, 97,114,114, 73, 97,114, 62, 97,  0, 73, 86,114, 62, 73, 97,
 97,114, 62,  0,102,102,114, 73,102,114, 93,114, 97,114,  0,103,
103, 73, 73, 73, 73,113, 97, 97,103, 73,  0,113,  0,114, 70, 86,
 86, 97, 62,113, 73, 62,113, 93,114,  0,  0, 97, 97,114,103,106,
113, 73, 97, 92,114,114,  0,111,  0, 62, 73,103,114, 73, 92, 73,
 62, 62,  0, 73, 93,114, 62, 92,103, 73,  0,102,103, 73, 70,113,
 73,114,114,113, 86,  0, 73, 73,103, 73,103,103,103,103,103, 73,
103,  0,114,114,114, 92, 93,106,114,113, 88,114,114,114,113, 88,
102, 86, 73, 86,114,  0, 97,114, 73, 73,114,102, 73, 73, 62,114,
 97, 97,  0, 97, 97,114, 93,114,  0, 97,114, 73,114,  0, 97, 97,
114,  0,103, 73,103,102,114,114,103,  0,103,113,103,114, 73,  0,
 73,103, 73,102, 73,114,114,114,114, 72,  0,  0,  0, 62,116, 62,
  0, 92,113, 86, 73, 73,103, 73,113,114,114,103,103,  0,103, 86,
111,102,102,114,103,103,114, 73, 73, 73,113,114,103, 92,103,113,
113, 92,113,113,  0,103, 73, 73, 93, 92, 97, 62,113,  0, 73, 73,
 86, 92, 73,113, 88,  0,114,114, 86,  0,114,111, 86,  0, 93, 93,
 97,114,102, 88,114, 73, 62,103,102, 86,114, 93, 86, 86, 62,114,
 86,112, 73,114,113,114, 86,114,114, 62, 73,114, 62,103,  0,114,
 97, 62,103,103,103, 88,114,114,103,114, 97, 62, 62, 93,103, 88,
103,114,  0, 73, 62,113,103, 92, 92, 97,115, 62,114, 62, 86, 62,
102, 86,  0, 73,103, 62, 73, 62,113, 73,113, 73,113, 62,113, 73,
 70, 86, 97, 88,103, 97,114,114,102,113,  0,107, 86, 93,  0,  0,
 62, 88,114, 62,102, 73,112,117,  0,114,114,113,114,114,  0,103,
114,114, 62, 93,103, 62, 73,114,103,114, 62, 97,114,103,103,113,
114,114, 93, 86, 88,114, 73,114, 93,102,114,114,114, 62,  0, 62,
114,113,114, 86,  0, 97,103,114,114,114,  0, 73,102, 62,113, 73,
113,114, 62,  0, 62, 73, 73, 62,114,113,114,103,103, 93,114,103,
 62, 62, 73, 86, 86,109, 73,109, 62,113,  0, 73, 93,114, 73, 73,
 73, 73,  0,114, 70,114, 97, 62, 62,102,  0, 62,114,114,  0, 72,
102,102,102, 62,103, 73,114,114,114,114,  0,  0, 86, 93,103,  0,
114,102, 62, 73, 93, 73,  0, 97,103, 62,102,114, 62,102,102,103,
 86, 93, 62,103, 73,114, 62, 73, 93,  0,103, 93, 62,114, 97,114,
 72, 97, 97, 97, 97, 97, 97, 62,  0, 73,102, 73, 73,102, 93,114,
 92, 73,114,103,102, 93,114,103, 62, 93,103, 93,114,114, 73, 62,
114,114, 73,  0,103,114, 93,114,114, 93,114, 93, 73,103, 73,114,
  0, 86, 73,103, 73,102,  0, 73,  0, 73, 86, 97, 97,  0,  0, 97,
103,114,114,114, 73, 73, 92,103, 62,103, 86, 88,103,114,  0,  0,
114, 62,112, 73,103,114, 62, 62, 73,114, 93, 73,  0,116, 73, 92,
 86, 62,114,114,114,113, 73,102,114,114,114, 93,114,114, 73,114,
114, 62, 73, 97,  0, 86, 97, 86, 97, 97, 97, 97, 97, 97, 62,102,
 73, 92, 62, 93, 93,110,103, 73,103,114,103, 86,114,114,103,  0,
 73, 62, 93, 62,114,103,114, 92, 62,  0,114,114, 73,102, 62,114,
114,  0,103,114,107, 62, 88,111,102, 86, 86, 97, 97, 97,  0, 97,
117,102,114,111,114, 92,113,103,114, 73, 73,102,114,113,103, 73,
 73, 73, 62, 73,103,114, 93,113,103,103,102,102, 73, 73,103,103,
  0,114,  0, 92,103,102,  0,  0, 93,103,114,103,114,102, 62,114,
114,113,103, 86, 73, 62, 72, 88, 88, 97,  0, 97, 97, 97, 97, 97,
114,113,103,114, 93,103,114, 92,103,114,114,113,103, 62, 73, 73,
 93,114, 62, 92, 73, 73,114, 62,114,114,103, 73, 62,114,114,114,
103, 62,103,103,103,114,103, 62, 73, 62,114,113,103, 73, 62,114,
 97, 86, 62, 72, 97,  0, 97,114, 92, 73, 62,102, 92,  0, 73, 73,
107, 62, 73,  0,113, 62,103,117,  0, 62,  0, 73,111, 86,113,114,
 73,103,111,  0,113,103,103,113,114,103,114,113,114, 92, 93, 73,
  0, 97, 73,113, 73,114, 73,  0,113,111, 92, 73,  0,114,103,113,
 62, 73,114,113,106, 92, 73,114,114,  0, 73,113,103,  0,113, 86,
114, 92,103, 92, 92, 93,113,114, 62, 73, 73, 62,103,106,113, 62,
103,107,113,103, 62,  0,  0, 86,  0, 73,113,102, 73,103,114,  0,
113,113,103,103,114,  0, 92, 62,107,111,113, 73, 62,102,  0,103,
 62, 73, 73,  0,113, 62,  0,114,102,114,103,113,114,103,113, 73,
 73, 73,113, 73, 73, 73,113, 97,103, 62,113,  0,103,  0,114, 73,
 62,103,102,113,  0, 73, 92,113,114,113,114,114, 92, 92, 62, 62,
 86, 97, 97,  0, 97, 62, 73,  0, 73,  0,  0,  0, 62, 62,103,103,
 73, 62, 62, 92, 73,103,114,103, 73,103, 73, 73, 62,103, 73, 62,
 73, 73,113,  0, 86, 72,113,113,113, 73,113, 73,113, 92, 92,114,
113,103,  0,103,103,  0, 97,117,114, 92,114, 97,114,114,114, 97,
114,114,114, 62, 92,102,114, 97, 97, 73,114, 93, 62, 86, 86,114,
103,114,102,103, 72, 72, 86,103,  0,103,114,103, 97, 73,114, 86,
113,106, 92, 93,114,  0,110, 97, 86, 62, 73, 86,  0,102,109,114,
114,114,103,102, 62,  0,103,114,114,114, 73,114, 70,114, 93,  0,
103,102,102,114,102, 86, 62,  0,114, 73,103, 93,103,  0, 92,  0,
 92, 73, 73, 93,103, 73, 72, 97, 86, 97, 97, 97, 97,102,114,102,
 72,113, 73,102, 73,  0,114, 73,  0,114,103, 73,114,103, 93,114,
114, 73, 86, 92,114,  0, 73, 73, 73,114,114,  0, 73, 62,103,103,
 62,114,114, 93, 92,114, 93,114,114,  0, 97,112, 86,  0, 86, 97,
 97, 97, 97,  0, 97, 97, 62,  0,102, 73, 73,114, 93, 73, 73, 73,
 73,114,  0,103, 73,114,103, 62, 73,114, 62, 93,114,114,103,102,
  0,  0,114,  0,102, 88, 93,114,114,114, 93, 73,114,114,102,113,
114, 92,114,114,114, 62,116,114,114,114,102,114,114, 86,  0, 97,
 86, 86, 97, 97,  0, 97, 97, 97, 97, 97, 62, 73,114,114,114,114,
 73,114,103,114,102, 92, 93,114, 73, 73, 73, 73,102,102,114,114,
 73,114, 93,103, 62,  0,  0,114, 93,114, 62,103, 92,103, 72, 73,
103,114,  0,103, 73, 73,102,  0, 62, 86, 97, 97,  0, 97, 97, 88,
 97, 97, 97, 97, 97, 97,  0, 86, 93,103,102,114, 73,103,  0,114,
  0,  0, 72, 73, 73, 62,103,  0, 73,102,114,110,103,114,113, 86,
 73,103,102,102,103, 72,102, 73, 73,114,103,102,114, 93,102,114,
114, 73, 62, 62,103,114, 73, 92,103, 73, 73, 62, 86,  0, 97, 97,
  0, 97, 97, 97,  0,103, 62,114,113, 93,  0, 92, 62,102,114, 73,
 73,102,113,  0, 62,103, 93,114,103,  0,114,114,103,103,  0,107,
 93, 73,102,113,103, 73,  0,102,114,114,102,  0,114, 73, 93, 93,
102, 73,114,  0,103, 62,114, 73,114,103, 62,113, 73, 73,103, 92,
114,113,114, 93,103,114, 62,114,114,114,114, 92, 93,102,102,103,
 72, 73, 86, 97, 88, 86,  0, 97, 97,  0, 97, 86, 97,103, 93,  0,
113, 62, 73, 92,114,103,114, 73,103, 93, 73, 73, 73, 72,102,114,
114, 62, 93,103, 62,103,114, 73, 73, 73,113,113,103, 73, 97, 73,
102,114,  0, 93, 73,103,  0, 73, 73, 93,102, 73, 62,109,113, 73,
 73, 73,102,103,114,103,114,106, 70,103, 86,  0,  0, 97,  0, 97,
 97, 97, 97,  0,  0, 97, 92,  0,  0,103,103, 72, 72,113, 73,114,
102,  0,103, 93,116, 73,113,113,103,  0, 73, 72,114,  0,102, 73,
102, 72,117, 73,103,103, 93, 73, 92, 62,102, 73,114,114, 73,103,
103,  0,  0, 73, 93,103, 92, 73,  0, 73,112,  0,  0,102,113,102,
 73, 72, 86, 73, 97, 97, 97, 97, 97,  0, 97,103,  0, 73, 92, 62,
 73,103,102,103,102,  0,  0,  0,114, 73, 62,103,103,103, 72,103,
117,103,  0, 62,  0, 73, 73, 93, 73,114,  0, 73, 73,102, 73,113,
 73,  0, 73,103,103, 73, 92, 73,114,109,114,103,  0,103,  0, 73,
  0,  0, 72, 86, 97,102,  0,102,113, 73, 73, 73, 73,  0,  0,103,
103,108,114,113,  0, 93, 72, 73,103,102,113, 62, 73,103,114,103,
 73, 62, 73,103,114,113,103,  0, 62, 93,  0,113,102,114,114,  0,
114, 73,113,103,  0, 97,  0, 97, 97, 86, 97,113, 93,103,103,103,
 97,113, 93, 73,117,114,  0,113,  0,103,117,103, 62,114,116, 73,
102, 62,114,  0,113, 62, 73,102,114, 73,113, 73,  0,  0, 97,  0,
 92,111,114, 92,102,107,114,111, 73,103, 62, 73,113,103,  0, 92,
103, 92,113, 73,113, 62, 86,103, 73,  0,113,103, 73, 92,113,103,
114,103,  0, 73,117, 86, 73, 73, 62,102, 62,  0, 73, 73, 73,103,
 73,  0, 97,103,103, 73,103, 73,114,103,  0,103, 92,113, 62, 62,
 73, 73,103,113, 92, 72,103,  0,  0,103,113,114,113, 73,102,114,
  0, 62, 73, 73, 88, 88,114,113,114,114, 62,114, 62,103,114,114,
  0, 73,  0,103,  0,114, 73, 62,114,102, 73,  0, 97,111,106,114,
 62,114, 62, 73,103, 93,114,113, 92, 93,  0, 97, 73, 93,114, 62,
 62,  0,114,114, 73, 73,114,103, 73,  0, 73, 70,114,106,  0, 73,
 88,  0,114, 73,114,113, 73,114,113, 73,103, 73, 73, 62,106, 73,
 73,103,113,113, 73,107,  0,114, 86, 86, 62, 97,114,  0, 86,  0,
114,114,103, 97, 73,103, 73,114, 62,114,  0,114,114,103, 73,114,
103,114, 73, 62,114,114, 62,114, 73, 97, 73,114,113, 88,103,114,
114,  0,103,103, 62,  0, 73,113, 73,114,  0, 73,114,114,  0,103,
  0,114,103, 93, 93,114, 93,  0, 62, 62,  0,114,114, 73,102,114,
103,  0,114, 73, 62,  0,102,114, 62, 86, 73, 92,  0, 73, 73,103,
112, 92, 93,106,  0,114,114, 88,114,114,  0,  0,114,114, 72, 72,
102,114,103, 73,117,103, 97, 97,  0, 62,114,113,110,110, 62,107,
102,  0, 93, 93,103, 73,114,113,103,117,114, 73,114,103,114,114,
110,117,103,114,114,116, 62,  0,  0, 97,  0,  0, 92,102,107,114,
114,103,103, 62,103,114,103,114,114, 62, 62,103, 62,114,103,114,
107,116, 73,103,114, 93,114, 62,  0,103,110,106, 88,  0, 97, 86,
 62,114,113,114,111,103, 62, 73,  0,113,103,112,102,  0, 62,114,
  0,103, 93, 97, 97, 97, 97, 70, 62,117, 72,117,103,113,113,114,
 62,102, 92,  0,114,110,114,111,114,111,103,107,103,  0,114,114,
 93, 73, 73,107,114, 62,114,116,117,103,114,103,103,  0,102, 62,
103, 86, 97, 86,114,  0, 73,114,113,113, 73,103,102,103,111,  0,
117,114, 62,  0, 73, 73,114,114,113,103, 62, 62, 62,114,  0,103,
117, 73,113,  0, 62,  0, 86, 97, 72, 73, 73,113,  0, 62,114, 73,
 73,103,117,106,114,103,  0, 73, 92,114, 73,117, 86, 73,114, 62,
103, 86, 62, 62,113,  0,110,113,103,113, 73, 73,103,  0, 62,103,
  0,  0, 73,  0, 62,  0,113,  0, 73,114, 92,102,114,114, 73, 62,
113,  0,  0, 73, 73,  0,114,  0,103, 93,  0,103,103, 73,103,  0,
114,  0,114,114,114, 86, 73,114,113,114,107, 62,114, 86,114,114,
114, 73,  0,113, 73,103,  0, 62,114,114, 72,114,  0,114, 62, 92,
 72,  0, 73,103,114,114, 86,114, 73, 62,  0,114, 62,114,111,114,
103, 73,103, 73,  0,  0,114,113,114,  0,114,114,114,114,113, 97,
  0,114,  0,103,114, 72,111, 86, 92, 73,114, 73, 73,114,103, 92,
 97, 86, 97, 97,  0,103,114,103,102,114,  0, 73,102, 73,114,114,
114,114,  0,114, 62,103,114, 73,  0, 92, 73,  0,114,103,114,114,
 93, 88, 86, 86, 86, 88, 62,  0, 97, 97, 93,  0,103,114, 62,114,
114,113, 93,114,103,114,103,114, 73, 73, 73,117, 93, 73,114,114,
  0,102,  0, 73,102, 92, 73,114,  0,114,  0,114, 92, 73,103,107,
114,103, 73,117, 73,114, 62,114,102,103,114, 62,114,114, 97, 73,
 86, 86, 88, 97,  0, 97, 86, 97, 97, 86, 97, 97,  0, 97, 73,114,
116, 62,103,114, 92,102,114,114,114, 92, 73,103, 62, 62,106,  0,
103, 93,103,102,114,103, 92,  0,103,103, 92, 73, 73, 73, 92,114,
114,114,116,114,114,  0,  0, 62, 93,102,114, 73,102,114, 93, 73,
 97, 62, 93, 73, 92, 72,103, 92,  0,114, 73, 73,114, 73, 92,114,
116,114,103,114,114,113,117,103, 73, 62, 73,111, 73, 97,111, 93,
 97,  0, 86, 86, 86, 97,  0, 97, 97, 97, 97, 97, 97,  0, 97, 97,
  0, 97,110,114,103,  0,114,114, 73, 62, 73,  0, 73,102, 86,103,
 73,114,111,  0,  0, 73, 73, 62,103, 93,114, 92, 62,103, 73,117,
 62,103, 93,102, 92, 73,  0, 97,114,114, 73,103,114,114, 97, 62,
114,114,114,114,102,102, 93,  0,114, 72, 70, 73,102, 92,114, 73,
114,114, 62,114,114, 70,  0, 62, 62, 86,  0, 62, 86, 86,  0, 86,
 97, 97, 97, 88, 97, 97, 97, 88, 97, 97,  0,102,  0,110,103,103,
 62,103,103,  0, 93,103,114, 93, 73,103, 62,103,103, 73, 92,113,
 73,114,103, 93, 62,114,102, 73, 62, 73, 73, 73, 73, 86,  0,114,
 73, 73, 73,114,113,  0,103,114, 62,  0, 62, 92,103,113,  0,113,
 92,117,114,103, 73, 62, 88,114,114,103,103, 73, 73,114,103,114,
114,113,103,114, 73,114,111,  0,  0, 86, 86, 62, 86,  0,  0,  0,
 97,  0, 97,  0,113,107, 92, 73,103,114, 86,114,103,114, 73, 62,
103,103,114,103, 92,114,103,113,114, 62,114,  0,103,103, 73,113,
114, 92,  0, 93, 73, 62, 73,113,117, 73,103,103,103, 62,114, 92,
102,102,113, 73, 73,102,103, 73, 73,114,114,103,102,103,  0,  0,
111, 88,  0,  0, 92,114,103, 73, 92, 62,103, 93, 92,114,114, 92,
102,103,114,103, 73, 73, 62,103,  0, 86, 86, 86, 86,  0,  0, 97,
 97, 86, 86, 86, 97, 92, 86,106, 86,  0, 92,  0,  0, 97,  0, 73,
114, 62, 73,103, 93,103, 86, 73,103, 93,  0,103, 73,114,  0,114,
 73, 73,102,  0, 73,103,  0,  0, 73,103,113, 73, 73,  0,103, 73,
  0, 73, 73,113,114,111, 73,116, 73,113,114,103, 92, 93,114, 73,
114,111,113,116, 62,103,102,  0,117,103, 92,114,103,113,114,113,
103,102, 62, 86, 92,113, 73,114,114,114,103,103, 88, 86, 86, 62,
 70, 86, 93, 73, 97,  0, 72, 97, 97, 97, 86,  0,  0,102, 92,  0,
 73, 92, 62, 73, 93,114,103, 73, 70, 73, 73,114,114,  0, 73,  0,
 92,103,  0, 73, 73,117,103,114,102, 73, 73,102, 73,102,113,103,
 73, 93, 86, 73,114, 73, 73,102, 62, 73, 62,114,103, 73, 92, 92,
  0,114, 73,113, 73, 62, 73, 86, 62, 73, 93,113,114,113, 93, 73,
114, 62,  0, 92, 72,  0, 62, 62, 86, 92,  0, 97,  0, 86, 86, 97,
 97,  0,103,  0, 73,103, 73, 92,113,  0,106, 92, 73, 93,103, 62,
  0,103, 93,103, 73, 62, 73, 73, 73, 86,  0,113, 73,114,103,114,
103,103,113, 62, 73, 92, 73, 73, 73, 73,114, 86, 86, 73,  0,103,
  0,117, 86,113, 92,103, 73,114, 72,113, 62, 92,  0,103,113,114,
103,114, 86,113, 62, 73, 73, 73,102, 86, 88, 86,  0,  0, 86, 97,
 62, 97,103,  0,103,114, 86, 62,113,113,113,103, 73,114,102,103,
 73, 73,  0,  0,114, 62,103, 93,113,103, 62,113,  0, 73,103, 73,
102,103,107,106, 73,103,103,  0,114,114, 73,102,  0, 73, 73,113,
 73,114, 92,  0,103, 97, 92,103, 73, 73,103,110,  0, 73,  0, 73,
  0, 70, 86, 62,  0,  0, 73,  0, 86, 97,  0,  0, 97,  0,103, 92,
114,103,  0,103,114, 73, 62,103,  0,117,  0, 62, 73,113,114,  0,
 93,102, 73, 73, 73, 73, 73,114,  0,  0, 73,103,113, 62,103,103,
 93, 73,113,113, 73,103, 73,  0, 73, 97, 86, 70, 93, 73, 92,103,
 62, 62,  0,113,103,  0, 73, 73, 92, 73, 73,113,  0,103, 62, 62,
  0, 86,113,113,  0, 73,103, 73, 62, 62,  0, 73,103, 73,  0, 73,
103, 92,  0,113, 62, 62, 62,  0,  0, 73,113,113,103,103, 92, 92,
 73, 73,  0,  0, 62, 73,  0,103, 92,  0, 92, 73,103,  0, 73, 73,
103,103, 62, 73,  0,  0,106,  0, 73, 73, 92,113,103, 62,  0,  0,
 73,  0,103,103,113, 86, 62, 62, 73,103,113, 73,106,  0,  0,103,
103,103,113, 73,  0,  0,113,103, 73, 73, 73, 62,  0, 86,103, 86,
114,114, 97,114, 70, 73,  0, 88,103,  0,  0, 62,103, 73,  0,103,
  0, 73,114, 73, 73, 62,103, 93, 92, 93,114,103, 73,113,114,103,
  0, 73, 73, 93,  0, 73,116,114, 73, 93,103, 73,114,103,113,  0,
113, 73, 62, 86, 92, 73,103,  0, 62, 93,  0, 92, 73, 62, 73,113,
103,113,114,114,114,109,114,102,  0, 86,114, 62,  0, 73, 62, 86,
 62,  0,110, 86, 86, 62, 73,110,113, 93,  0,114, 97, 62,103,113,
 92, 97,102,114,114, 62,114, 97, 73,114,114, 88, 73, 93, 73, 73,
  0, 73, 97, 97, 73, 92,114,103,113, 73, 97,102,  0,  0,113,103,
103, 97,103,103, 92, 73, 73, 73, 62, 62, 93, 92, 62,103,117,113,
103, 86,113, 93, 88,114, 73,114, 62, 62,113, 86,113,103, 62,114,
 92,115, 97,103,103,114,113, 73, 73,103, 73,114,103,114, 86,109,
 73,  0,114,114,114, 97,116,109,113, 97,103,114,  0,  0, 73, 86,
 73, 70, 73,103, 73,  0,103,103, 73,  0, 97,114,113,  0, 62, 93,
 73, 62, 73, 93,  0, 97,  0,103, 73,102,  0, 73, 73, 72, 73,103,
 73, 73,103, 73,103,102, 72, 97,113,103,  0, 73, 73,102, 62,114,
102,114, 62,114, 93, 72, 72, 86, 72,102, 72, 93,  0, 73,  0,102,
 73, 72, 97,113, 93, 73,102,102,102, 97, 72, 73,103,  0,102, 72,
 72,  0, 97,103,114, 70,103,111,114,  0, 62,103,  0, 97,113,103,
114,114,114, 73,  0,  0, 72, 97,  0, 97,102,103, 73,103,113,103,
114,  0,103,  0,102,114,  0,114,  0,103,111,102,102,114,114,114,
114, 72, 86,  0, 97, 73, 73,103,114, 72,114,103,  0,117,  0,103,
114, 73,114, 92,102,  0,116,  0,103, 70,113,103,  0,114,114,  0,
 73,114,114,114, 73,116,116,117,114,102, 73, 73,114, 92, 73, 72,
114,  0,113,114,116,117,113, 62,103,114,113,114,103, 73,  0, 70,
  0, 88, 86, 97, 97, 97, 97, 97,  0, 97, 97,114, 73, 72,114,  0,
103, 93, 70,114,103,  0, 73, 73,114,114, 92,114,114,114,114,114,
 73,113,117, 73,114, 93,103, 73,  0,114,114,  0,114,103,  0,103,
102,103,103,114,102,114,102,114,  0, 92,103,114,103, 92, 72,  0,
102,114,114,114,  0,114,  0,103,114,103, 88,116,103, 73,116,114,
114, 93,103,114, 62, 72, 97, 97, 97, 73, 97, 97, 97, 97, 97,  0,
 73, 72,  0, 73,102,  0,  0,102, 73, 73,103,114,114, 73,102,103,
 73,117, 93, 62,  0,  0, 73,114, 73,114,102,114,  0, 73,114, 92,
 73,  0, 73,  0,  0,114, 62,116,103,113,114, 93, 73, 73,102,103,
 73,102,114, 93, 73,114,113, 73,113,116, 73,114,102,114,114,103,
 73,114, 73, 97, 86, 88, 97, 97, 97,  0, 97, 97,  0, 97, 97, 97,
  0, 97, 97, 97, 97,  0,  0, 62, 73,114,114,  0,112,  0,102,103,
 72,103, 73,114, 92,103,114,103, 73,114,114,  0,113, 73,114,102,
103,  0,  0,  0,114, 73, 73,114,114,113, 73, 73,102, 73, 73,110,
 73,  0,102, 73, 73,114, 73,117,114,109, 73, 73,114,110,114,  0,
 73,116,103,114,102,114, 62,103,103, 86,  0, 88, 86, 97, 97, 97,
 97, 97,  0, 97, 97,  0, 97, 97, 97, 97,102, 72,103,  0, 72,114,
  0,  0,114, 73,103,114,  0,103, 93, 62, 73, 73, 92,103, 73,102,
114,  0, 73,106,116,114,114,114,103, 73,103,114, 93, 73, 62,117,
 73,114, 92, 73, 73, 92,102, 73,114,114,110,103, 73,102,114,103,
102,114,103, 73, 93,103, 93,  0,113,103,113,114, 93, 73,114,103,
103,114, 73,114,103,113,103,114,106,114,113,114,102, 73,  0,  0,
103,  0,  0, 73, 62, 93,  0, 86, 86, 86, 88, 86, 97, 97, 97,  0,
 97, 97,  0, 86, 97, 86, 97,115,  0,113,114,113, 73, 93, 62,113,
114,114,103,114,114,114,113,103, 73, 88,  0,114,113,114, 92,114,
 73, 73,116, 73,109, 73,117,  0,114,103,114,103,117,110,113, 73,
 73, 73,  0,114,116,103, 73, 73, 62,103,113,103,  0,114, 93, 62,
  0,103,103,102,102, 73,114, 62,114,  0, 73,114,117,103,117,114,
 73, 73,103,103, 73, 73, 73,113,103, 73,  0,114,  0,  0,114,113,
  0, 73,113,117, 73,  0, 86, 73, 73, 73,106, 62,  0, 62, 88, 88,
 86,  0, 86, 97,  0, 97, 97,  0, 73, 72,  0,  0, 86,103, 73, 93,
114,  0, 73,103, 73,  0,113, 73, 93,103,  0, 73,114,113, 73,114,
103, 73,114, 73, 73,114, 73,102,  0,  0,114,110,  0, 62,103,114,
 73,116, 93,103, 72,  0,114, 93,  0, 73,114, 70, 73, 93, 73,103,
103,102,114,103,113,113, 73,102,103,113,103,114,113,103,117,102,
 73,114, 73,114,114, 93, 73, 97, 73,  0, 97,  0, 73, 86, 88, 97,
 97, 97, 97,  0, 97, 97, 97,  0, 97, 97,  0,103, 92,103,103,113,
  0, 73, 92,  0,114, 73, 73, 92,113,102,  0,103, 73,103,113,113,
 73,113,114, 73, 62, 73,114, 73,103, 93,103,  0, 62,103, 73,114,
  0,111, 73, 93,114,114, 62,  0,103, 73,103, 62, 73,  0, 73, 73,
114, 73,113,113, 97, 73,103, 73,  0,102,102,114,113,102, 73,102,
103,114,113,102,  0, 73,102, 73,113, 73, 73,103,103,  0, 93,113,
 73,113,  0, 73,  0, 86, 97, 97,  0,  0,  0, 97,  0, 97, 73,103,
 73,117,103,103,113, 73,  0,117,114, 62,117,113, 88,103,116,113,
 73,103,116, 73,113,  0, 93, 73, 62, 73, 73, 73,103,114,114, 92,
113,  0, 72, 73, 88,  0, 73, 73, 93,  0,114, 73,114,117,117, 73,
 92,111, 92, 62,114, 73, 92,103,116, 72,  0,103,102,116,114,  0,
117, 86,103,103,117, 73,103,113,  0,  0, 62,  0, 97,  0, 73, 62,
103, 93, 73,113,113,103,103,116,103, 73, 92, 73, 73, 73,117,117,
103,113, 73,114, 73, 62,102,  0, 73,114, 73,  0,103, 73,106, 73,
114,113,114,113, 73, 62, 92,103,103, 72,117, 73, 73, 73, 73, 73,
  0, 97, 97,  0, 92,113,  0,  0, 92,  0,107, 92, 73, 73,102,113,
114,114, 73, 73,113,  0, 73, 73,103,117,  0,113,113, 73, 93,114,
103,113, 73, 86, 73, 62, 86, 73,  0, 62, 92, 73,103, 62,113, 73,
103,113,  0,  0, 73,117,117,103,  0,113, 73,113, 73,103, 73,113,
  0,114,  0,  0, 73,113, 73,103,113, 73,114,114,110,113,111,113,
103, 73, 73,116, 73,  0, 92,113,110, 73, 73, 73, 86,  0,  0,117,
 92, 73, 92, 73,103, 72,  0,117, 73,102, 73, 73,103,  0,113, 73,
 73, 73, 73,103,103, 73, 73,  0,103,103,103, 62,114,  0, 62, 97,
106,113, 73,  0, 62,103, 73, 73,113,  0, 73, 73,  0,117,102, 73,
 73, 73, 73,113,103,103, 73,  0, 73, 73, 73,114, 70, 97, 62, 88,
114, 73,  0,  0, 73, 70,102,  0,114,  0, 73,  0,114,113, 70, 97,
 97, 62, 73, 73, 73,116,103,  0,  0, 88,114,  0,  0,  0,114,  0,
  0, 73,114, 73,102,102,102, 62,117,114,110, 62, 97, 97,  0, 73,
  0,110,  0,  0,117,  0,  0,  0,  0, 73,  0,116,114,114, 93,114,
103,102,  0,114,103, 73,  0,116,114,112, 92, 97, 97, 97, 73,  0,
 97, 97, 97, 97,  0, 73, 73, 73,114,  0,102,113,  0, 73, 73,113,
  0,103, 73,103,103, 62, 62, 73,116,114, 73, 97,103,113, 73,112,
 73, 73, 73,  0,102,  0, 97, 97, 97, 97,  0, 97, 97, 97,  0, 72,
 73,111,  0, 73, 73,  0, 73, 72, 73,114,103, 73, 73,114,  0, 73,
 73,  0, 73, 62,117, 62,103, 62,  0,114, 72,103,117, 73, 73, 62,
 72,  0,  0, 72, 86, 97, 97, 73, 97,114,114, 73, 92,  0,117, 73,
103,113, 73, 73,  0, 73,114,  0, 73,  0,  0, 62,  0, 62, 73,102,
116,102, 73,  0,  0,  0,114,  0, 62,  0, 73,  0, 86,  0,  0,  0,
  0,103, 73, 73, 73, 70,103,117,  0,113,108,103,114, 73,114,  0,
117,  0,103, 73, 73, 86,113, 62, 73,113,103,  0,116, 73,116, 73,
103, 73, 92, 73,114,113,114,114,102,113, 73,  0,113,  0,114,  0,
 73,  0, 72, 97,  0,  0,  0,  0, 72, 62, 97, 73,  0,114,  0,  0,
103, 73, 73,  0,114,103, 73,103, 86,110,114,  0, 62,  0,  0,114,
 73,  0,117,  0,114, 86,  0, 73, 97,114,103,103, 73, 73, 73,114,
102, 73,107,  0, 73, 73,  0, 73, 93, 73, 73,  0,114,  0,  0,103,
103,113,103,102,  0, 72,  0,  0, 73,114,107,  0, 73, 73,113,103,
103,117, 73,114,103, 73, 73, 73,113,113, 73,103, 62,  0,114, 73,
113,  0,113, 62,114,114,103, 86, 73,103,103, 73,103,  0,  0,113,
 93, 73, 73,  0, 73,114,113,114, 73,  0,  0,  0, 92,113,114,  0,
 73, 73, 73,  0, 73, 86,  0,  0,103, 93,  0,113,113, 73,117,113,
107, 73, 73, 73,  0, 73,114,103, 62, 62, 73,  0, 73, 92,  0,  0,
113,  0,  0,103, 73,  0,  0, 62,  0, 73,103,113,  0,102, 73,103,
  0,  0, 73, 73, 62,  0, 73, 73, 93, 73,114, 62,114,113,  0, 62,
114, 97,111,  0, 62,114,114, 97,102,102,113,114, 86,114,113, 93,
111,103,103, 62, 73, 62,113,114,114, 73, 73, 92,114, 97, 62,103,
 62,  0,114,103,  0, 62,102,  0,113,114,103,114, 62,114,103,114,
103,114,114,103,  0,  0, 97,114, 62,114, 73, 62, 73,  0,102,102,
 73, 62,114, 73, 92, 97, 73,103,103,114, 97,103,103,113, 93,102,
114,114, 86,  0,102, 73, 73, 86, 73,103, 97, 72, 73,102,103, 97,
 73, 73, 93,103,  0, 73, 92, 73, 73,  0, 73,103,  0, 73, 73, 97,
 86, 73,113, 73, 73, 73, 73,113,103, 73, 73,  0,114, 70,103,114,
 72, 62, 86,  0,102, 73, 88, 97, 97, 88, 73,  0,  0, 73, 62, 73,
110,102,114, 93,114, 73, 92, 62, 97,103, 73, 73,103, 97,114,  0,
114, 73, 93,  0, 73, 62,103,114,103,114, 73, 86, 73,  0, 97,103,
 93,114, 86, 73, 73, 62, 73,  0, 72,114, 73, 73, 88, 88, 97, 97,
 97, 97, 97,102,102,  0, 73, 93,114,113,102,102,114,113,103, 73,
 73, 72, 62, 97, 62, 62,  0,103, 73,  0,114,103, 73, 62, 97, 73,
  0, 73,103,102,  0, 97,114, 93,103,103,  0,114,114,114,102, 86,
  0, 97,102, 73, 62,114, 73,103, 62,114,112,112, 70, 73, 88, 86,
 73,102,103, 73, 93,103,113,114, 97, 97,103,103, 73, 62,114,114,
 73,  0, 73,103,113,113,  0,  0,  0, 73, 73,  0, 73,102, 92, 86,
116, 73,116,  0,  0,  0, 62,114,103, 73, 73, 73,  0,103,103,103,
102, 73, 73, 86,  0, 73,103,103,113,103,113,103,102, 97,103,102,
113, 62,113, 73,  0,113, 73,103,113, 62,113,113,103, 73, 72, 73,
103,103, 73,103,114,103,117,114, 73,114, 73,114,  0,  0,116,  0,
 62, 97, 73,103,110,103,114,117,107,  0,  0, 97, 62, 73, 62,116,
103, 73,102,  0, 73,103,103,106, 73,114, 62,102, 73,117, 97, 97,
 97,  0,114,114, 73,103, 73,102, 73,117, 97, 93,103, 62, 73,103,
114,  0,114, 73,  0,103,103, 73, 93,108,114,103,117,114, 86,108,
 97, 97,103,103, 73,  0,117, 73, 73,116, 73, 73, 73,117,114,  0,
114, 62,  0,117,106,114,107,102, 73,116,113, 73,  0,114, 92,  0,
  0, 86, 97,  0,103,103, 73,107, 92,107,103, 62, 73,117,113,103,
103,117,  0,114,103,114,114,117, 73,114,102, 73, 73, 73,  0, 97,
 97, 62,  0,106,  0,  0, 73,  0,  0,  0,102,116,  0, 73,  0,  0,
110,110,114, 73,103,114,116,  0,116,103,116,117,116,103,116,117,
116,103, 92,114,114,114,114,  0,106, 62,113,  0, 97,  0,  0,113,
117,114, 73,107,117,  0,103, 62,  0,  0, 73,117,  0,103, 73, 73,
 73,103,103,  0, 73,114,  0,116,  0,114,114,114,114, 62,114,114,
111,  0,117, 92,113,106, 62,103,107,113,113, 62,  0,102,103,113,
 93,103,103, 92,  0, 73, 88, 97,  0, 73,  0,  0, 73, 73,114, 73,
102,102,106,114,  0,103,103,116, 73,117, 73,114,  0,  0, 97, 62,
102, 62,103,  0, 73, 73,  0, 73,117, 62,103,  0,116,  0,114,117,
103,117, 86,117,  0,110,103,114,116,102,117,103,  0, 73, 62,103,
113,103,117,  0,  0,117, 73, 73, 73,107, 72,103,  0,113, 73,117,
 73, 73, 73, 73,  0, 73,106,  0, 62, 62,113, 73, 62,  0,  0,113,
 62,  0, 97, 62,113, 73, 73, 73,117, 73,117,103,114, 73,102,103,
114, 73,114,114,102, 73,114, 86,103, 92, 62, 62, 73,  0,114, 70,
 86, 86, 86,  0,102, 73, 93,114, 86,  0, 62,103, 62, 73, 73,102,
 73,106, 73, 92,114, 86, 62, 73, 73,  0,  0, 73, 92, 93, 86, 72,
 73,114,103, 93, 73,113,103,103,114, 97,114,106, 93, 73, 86,114,
 62,103, 73,111, 62,114,113, 62,114,102,103,114,114, 72, 73,102,
114,114,114,114,  0, 97, 62,114,114,103,114, 88, 86,103,102,103,
102,  0,  0, 62, 86, 97, 86,117,102, 86, 86, 93,114, 86,102,114,
 62,111, 62,106,114,  0,  0, 62,  0,114, 93,114,114,113, 62,103,
 86, 62,113, 73, 92,114,114, 86,  0, 86,114, 92, 73, 86,  0,117,
113, 62, 97, 86, 88,106,113, 92,114,102,107, 62, 62,103,103,114,
 73, 62, 86, 97, 73, 62,114,113,  0, 86,113,114, 73,  0,111,114,
103,114, 70, 62, 93,103, 97, 97, 73,102, 93,  0, 62,114,  0, 97,
 97, 97,103, 93,102,114,  0, 73,  0,  0, 73,114, 97,  0, 97, 97,
 72,112,114,114, 70,114, 73,  0,114,114,103, 73,114,114,114,103,
103,103,114, 88,102,114, 62,114, 97, 97, 93, 73,103,114,103,103,
 73, 73,114,  0,114,114, 97,103,114,113, 73,114, 62, 73, 93,103,
103,103,114, 93,102,  0, 72,102, 97, 86, 97, 97, 62, 73, 62,103,
114,102,113, 92,114, 73, 73, 73, 73,102,113, 73,114, 73, 92, 93,
116, 93, 62,102, 62, 97,  0, 62,103, 92,102, 92,102,113,  0,103,
 72, 73, 62,103, 73,102,103, 97, 97,116, 73,102,103,103,103,114,
114,113,114,103,114,102,116, 92, 73,102, 97, 97,  0,102,  0, 73,
 93, 73,103,102, 93,102,  0,  0,102, 62,103,111,102, 73, 97, 97,
 70, 62,113,102, 62, 62, 92, 92, 92,103, 62, 62,114, 97,106,  0,
 73,  0,113, 73, 97, 62,114, 73, 92,103, 73,  0, 93,  0, 97,103,
 73,113, 92, 97,117,103,  0, 86, 86,113, 92, 97,113,103,103, 70,
113,103,113,  0, 62, 73, 86,  0,114, 73, 86,114,113,114,114, 73,
 86,103, 72, 86,114, 62,114,114, 93, 73, 73, 93, 62, 62,114, 73,
111, 97, 73,114,  0,103, 93,  0,  0, 93, 92,103,103,103, 73, 62,
 62,  0, 62, 62,102, 62,103, 62, 62,  0,103, 73,  0,103,114, 73,
 92, 97, 97,  0, 93, 73,  0, 86, 92, 86,113, 73,  0,103, 73,114,
  0, 62,114,113, 73,102,114,  0,114,103,114, 62, 62, 93,102, 97,
 97, 97,114, 73,102,  0,112, 88, 97, 62, 73,114,113, 73,113,114,
 62,113,  0,113,113, 93,103,113, 62, 73, 92,  0,103, 73,114, 72,
103,102,114, 73,114, 73, 62, 73,114,102, 73, 92,116,  0,114,  0,
 62,114,  0, 73,114, 73, 62, 93,114,114,103,114, 86, 97, 62,  0,
 73, 73,103, 73, 62,103,  0, 62,  0,102,102, 92, 62, 73,111, 93,
114,  0,102, 73, 86, 92, 88, 73,102,114,  0,  0,  0,102, 62,102,
  0, 73, 73, 73,103,102,102,114,114,103,114, 73,114,103,103,  0,
112, 97, 62, 97, 73,103,103, 93,  0,  0,103, 73, 73,117,103,103,
 97, 97,103,  0, 73, 73,103, 62,  0, 73, 93,114,103,  0,103,103,
103,114,102,114, 62, 93,114,103, 93, 73,103,114,102, 73, 73, 73,
 62,  0, 62, 62, 62,  0,  0,  0,  0,114, 62,  0, 73,102,114,114,
102, 73, 73, 73,102, 72,  0, 73, 73, 73,  0,113,102,102, 93, 73,
  0,114, 97,  0, 62,103, 62, 73,  0, 73,103, 73, 73, 73,113,102,
 93, 73,102, 73,  0,114,  0,102, 73, 97,102, 73,114,113, 62, 62,
114,103, 73,114, 73,102, 92, 73,  0, 86, 73,114,113, 93, 62,114,
  0,  0, 73, 62, 73,  0,  0, 92,  0,103, 73,  0, 73, 93, 73, 73,
 73, 62, 62, 73, 73,103,  0,114, 73,103, 92,114,114,  0,103, 62,
103,  0,114,114, 62,114, 62, 93, 73,114, 62, 97,102,114,114,113,
103,103, 73,114, 62,  0, 97, 73,102, 73, 73,103, 92, 72, 97, 97,
 97, 97,114, 73,  0,103,103,  0,  0,102,  0,  0, 93,102,103, 73,
 73,102,114, 73, 93, 86, 97, 97, 97,  0, 97,  0, 97,102,  0, 72,
 92,103,103,102,  0,114,114,114, 73, 72, 73, 73,109,102,103, 73,
102, 73,113, 73,114,103,  0,102, 72, 97, 88, 97, 97,  0, 97, 86,
 97,  0,  0,103, 62,114,  0, 70,103, 73, 73,  0,102, 73,102,106,
 72,  0,102,  0,  0, 97, 97, 97,  0,  0,  0,  0,103,114,103,  0,
103, 62, 73, 62,103, 73,  0,  0,103, 73,102,114,114, 72,102,113,
 73, 73, 86,  0, 86,  0,  0, 97,  0, 73, 62, 73,114,  0,103, 73,
 73,111,  0, 73, 73, 73, 92,114,  0, 72, 62,  0,114,112,114,103,
  0,114,  0, 93,103, 92, 73,114,102, 73, 93, 97, 97, 62,103,102,
 73,102, 73,114,103, 72,  0,114,103,113, 92, 73,103,103,  0, 86,
102, 70,102,102, 72, 86,  0,  0,  0, 97,113,117,113, 62, 93, 62,
  0,114,  0, 73, 73,114, 86, 62,103,102,114,114,103, 73,117, 73,
114, 92, 62, 62, 93,102, 62,  0,  0, 97, 92,103,  0, 73, 73,103,
103,103, 73, 73, 62, 73, 62, 92,114, 73,103,  0,114, 73,  0,113,
  0,  0,102,103, 93,106, 62,102,  0, 73,102,117, 73, 92, 73,103,
 62,114, 73,  0, 73, 72, 62, 86,  0, 73,  0,  0,103,  0,113,  0,
103, 92, 92, 72, 73,  0,106, 73,  0, 92, 62, 73,103, 73,102, 62,
 62, 73,  0, 73, 72,103, 92,103, 73,103,113,113,113,103,  0, 73,
  0,103,  0,  0, 70,103,  0,  0, 73, 73,114, 70, 88,103,114,103,
114,114, 73,  0,103,103,102,113,114,114,103,103, 73,  0,  0,103,
113,103, 73, 93,103, 92,114,114, 62,  0,114,116,116,114,114, 93,
114, 73, 88, 73, 73,114,  0,102,114,103, 73,103,  0,114,  0, 97,
 73,  0,103, 73, 73,  0,  0, 88, 97,103,114, 62,103, 73, 62,113,
 88,114, 73,  0, 88, 88,  0,  0, 73,  0, 93,103, 62,113,113,114,
 73,107, 73,103,103,103,103, 73,103,  0, 72,103,103, 86,  0,  0,
 73,103, 73,  0, 73,  0,113,114,103, 62,113,103, 73, 73,113, 62,
 92,117, 73,114,103,  0, 73, 73,103,114, 93,102,  0,114,114,113,
114,114, 62, 97, 62, 73, 97, 62,103,114,107,114,  0, 72, 73,103,
  0,114,114,  0, 62,114,103,  0,114,  0, 62,  0, 73,103,103,114,
103, 86, 62, 93,114, 62,114,114,  0,114,103,102, 92,102, 73, 97,
 88, 62,  0,  0,  0,  0, 73, 73,102,  0, 73,114, 62, 97,  0,  0,
114,  0,102,102, 73,110, 97, 62,113, 62,103,114,103,114, 88,  0,
 73,103, 73, 73,114,103,  0,114, 92,113,114,103,113,  0,102,113,
114, 62, 73, 97,  0,  0, 73, 62, 73,  0,  0,103,  0, 62,113,103,
103,113, 86, 97, 62, 62,106,114, 62,102, 62,114,114,114, 86,114,
113,  0, 86, 86,103, 62,114,103,103,111, 73, 73,103,113,113, 86,
 86, 97,  0,  0, 73, 62,103,114, 73, 62, 73, 73,103, 62,  0,103,
103,113,113, 86,  0, 62,  0,103, 73,113, 62,113, 73,103, 73,  0,
114, 73,  0,  0,114,103,114, 97,102,114,114, 73,  0,111,103,114,
102,114, 62, 88,114,103,102, 73,114, 73,103,103, 73, 97,  0, 73,
103, 70,114,111,103,114, 93, 93,114, 73,  0,  0, 97, 97,103,114,
102,  0, 73,103,  0, 97, 97,  0, 72,113,113, 73,102, 97,113,113,
 86, 73, 73,102, 73,103, 92, 73, 73, 62,113, 62, 62,  0, 73, 93,
 73, 73,  0, 86,113,113, 62,113, 86, 62,113,114, 62, 86, 62, 86,
  0,103, 86, 86,  0, 86, 97,106, 73,114, 86, 62, 86,111, 97,114,
114, 86, 86,114, 73,114, 93,  0, 62, 62,111,103, 62,114, 73,114,
 86, 62,  0,  0, 62,  0,113, 73, 86,114,114,103,  0,102, 62,114,
 73, 73, 86, 97, 93, 73, 93, 62, 93, 73, 93, 88,  0,  0, 73,114,
 73,114, 73, 73, 70, 97,  0,  0, 92,114, 73,114,  0, 73,114, 62,
114,  0, 73,103, 72, 93,114, 62, 93, 62,102,102,114,117,102,103,
103,102, 73, 93,103, 92, 86,  0, 72,111, 97, 73, 97, 62, 97, 62,
103, 62,  0,  0, 73, 93,113,102, 92,114, 73,114,114,113,103,114,
114,114,114,  0,114, 62,114,  0, 72,  0, 97, 97,  0, 88,  0,  0,
116, 73, 97, 73,103, 92,103, 92,  0,103, 62,  0,111,103,114, 62,
 92, 93,102,103, 92,114, 73,102, 73, 97, 86, 97,  0,106, 97,  0,
 97,  0, 73,  0,103, 72, 86,113, 73, 62, 73,113, 73, 93,103,113,
102,103, 86,  0,114,114,103,114, 92, 92,111,103, 93,114, 62, 86,
103,114, 97,  0, 73, 62, 97, 97, 97, 97, 88, 97,102,114,  0,103,
 62,114, 62,  0,114,103, 62, 73,114, 73, 62, 62, 62, 62, 73,  0,
113,114, 62,  0,113, 62,114,114, 62,113,103, 92, 93,  0, 73, 86,
  0, 97,106, 97,103, 73, 62, 62, 73,102,102,103, 73, 93, 73, 73,
113, 72, 73, 73,113, 93, 93, 73,103,113,102, 73,  0, 86, 97,  0,
 73, 72,103, 92,103, 62, 86, 93,103,103, 62, 73, 70, 73,102, 73,
 92,103,103,103, 62, 73,103,114,  0,103, 73,102,102, 92,103,102,
 73, 92,111, 86, 86,  0, 97, 86,  0,103,  0, 62, 73, 73,110, 93,
103,113, 73, 92,  0,103,102,114,103, 73,114,113,103, 73,  0,  0,
 73, 62,  0,103, 62,  0, 62, 92, 93,103, 62, 73, 73,113,113,114,
 93, 97,  0,113,  0, 73, 62, 73, 73, 73,103,  0,113,114,  0, 86,
 92, 62, 62,103, 92, 62, 86, 73, 86,103,103,103,103, 62, 62, 92,
113, 62,  0,103,113, 92, 73,103,  0,103, 73, 73,113, 62,103, 73,
 62,  0,103,114, 97, 92,  0,  0, 73,103, 73, 97, 70,102, 86, 73,
 73, 92, 86,111, 73, 73, 62, 62, 73,114, 73, 86, 73, 92,  0, 62,
 86, 72,114,  0,103,114, 73,114,114,  0,  0, 86, 97, 97,102,114,
 62, 92, 93, 73, 88,114, 62,111, 92,  0, 97, 86,  0, 86,112, 73,
 62,114,114,114, 73, 73, 62, 62,  0,114,103,103,102, 93,114,103,
 86, 97, 86,  0, 62, 93,  0, 70,102, 62,114, 73, 72, 70, 92, 62,
 73, 73, 92, 62,103,102,114,102, 86,102, 62,  0, 93,103,113,114,
114,  0, 92,  0,  0,  0, 62,113, 72, 62, 73, 62, 73,  0, 73, 93,
 73, 73, 92,  0, 92, 62, 92, 73, 93,  0, 86,114,  0, 73,113,  0,
113, 73,113,103,113,113,113,117,117,103,114,113, 73,113, 73,103,
113,103,103,103,113, 92,103,113,113,113,113,113, 92,103,103, 73,
114,113,114, 62,  0,  0, 62, 97, 73, 73, 62,114,113, 62,113,114,
113,103, 92,113,  0,113, 73,  0, 73,113,113, 73,103,103,103, 92,
103,103,113,113,113,113,113,103, 62,  0, 73, 86, 86, 62, 92, 92,
113,103, 73,103, 73, 73, 92, 62, 73, 62, 62, 92,103, 62,113, 73,
  0,113,113, 92,  0, 62,113,103,113, 73,117, 73,  0, 73,114, 73,
103,113,113,113,  0, 86,111, 97, 62,113,103,103, 73, 92,  0,117,
 73,103, 62,103, 73,103,103,  0,103, 86,  0, 62,103,103,110,113,
  0,103, 73,113, 73,  0,103, 62,  0, 86, 86, 86,113,103,103, 92,
110, 73,113, 92,  0,  0,102,103,  0, 73,103, 86,113,113, 93, 92,
 92,113,113, 62,113,113, 62,103,113,103,113,113, 73,113,113,113,
 73, 73,103, 62,103,103,103,113,  0, 73,113,113,103, 62,103, 86,
  0, 86, 92,  0,  0, 86,106,103,113,103,113, 73, 86,113,113, 73,
113,113, 62,110, 86, 62,103, 73,113,113,103, 62,113, 62, 73,113,
 73,103, 92, 73,113, 62,103, 73,  0,103,103,113,  0,  0,  0,  0,
 62, 86,  0, 73, 86, 86,  0,  0,103,113,113, 92, 73, 73, 73, 73,
103,103, 92, 73, 73,117, 73,103,  0,  0, 73,113,103,117,113,113,
103,113, 92,113, 73, 73, 86, 62, 62, 73, 73,113, 62,103,113,117,
 73,113, 92,103, 73, 92,103,113, 73, 92, 92, 93, 73,113,113,103,
 73,114, 73,113,103,103,113,116, 73, 73, 86, 86, 73, 86, 62,  0,
103, 73,117, 73,113,113, 92, 73,103, 92, 92,  0, 73, 86,113,103,
 73,117,103, 73,  0, 62, 86, 86, 73,113,113,117,  0,113, 62,103,
113,  0, 73,103, 73, 73, 73, 73,103,113, 73, 92,113, 92,103, 86,
 73,103,114, 86,  0,  0,103,103, 92, 86,103, 73,113,103, 86,113,
 86,103, 86,113, 92,103,113, 73,117, 73,103,114,113, 62, 62, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,  0, 97,
 97, 97, 97, 97,  0, 97, 97, 97, 97, 97, 97,  0,  0, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97,  0, 97, 97, 97, 97, 97, 97, 97, 97, 97,
 97, 97, 97, 97,  0, 97, 97, 97, 97, 97, 97, 97,  0, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97,  0, 97, 97, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,  0, 97, 97, 97, 97, 97,
  0, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,  0, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97,114,  0,114, 73,114, 62, 62,103,103,103,
  0,  0, 97,103,102, 93,  0, 62, 73,  0, 73, 73,113, 92, 86,103,
114, 93, 62, 62,114,114,  0, 97, 93,  0, 97,103,103,103, 73, 93,
 92,102, 97,103, 62,103,103, 92, 93, 93,114,113, 73,103,114,  0,
113, 70,114, 73, 97,113, 73,113, 86,114, 73, 73, 73,103,102,103,
 62, 97, 86, 92,  0,113, 92, 92,113, 73,114,103,114,103,114, 62,
 62,103, 73,  0,114, 73,103, 62,  0,  0,114, 73,103, 93,114, 97,
 73,102,103, 86,114, 73,103, 72,113,113, 62,  0, 73,103, 86, 93,
 72, 73,114, 73, 62, 73, 92, 73,114,114, 73, 73,102,114, 73,102,
103,114, 73,103,  0,114, 86, 73, 62, 73,114, 73,114, 73,116,103,
 73, 73,113,  0,114,114,  0, 73, 97,  0,  0,103, 73,  0, 73,116,
114,114, 73,103,  0,102, 93,  0,103,114, 73,113,103, 73,102,103,
114, 72,103, 93, 73, 73,  0, 73, 73,113, 62, 93,114,103,103,103,
114,114,  0,114, 93,114,114,103, 62,106, 62, 93,114,102,103,103,
114,103, 93, 62,102,114,102,114,114, 93,  0, 73, 93, 62,103,103,
 70, 92, 97,  0,103, 97,102, 97, 93, 72, 72,  0,103,106, 62,  0,
103, 97,  0,114,103,102,114,102, 97,103, 62, 88, 62,114,103,114,
 62,  0, 97,109, 62,  0,114, 73, 73,  0,114, 97, 97, 97,  0, 73,
 73, 73, 93,  0, 97,  0,113,  0,114,  0,114,  0, 73, 73,113, 86,
 62, 86, 86,  0,103,  0, 62, 73, 86, 97, 97,  0, 73, 62,  0,113,
113,102,113,113, 86,103, 92,113, 73, 92,  0,  0,  0,113,113,114,
 97, 62, 73, 97,114,113,114,114, 62,114, 73,114,114,  0, 62, 73,
 73,  0, 73, 93,  0, 73,114,  0, 93, 73, 93,114,102,114, 62, 97,
 97,114,114, 73, 97,114, 62, 62,  0,114,114,102, 86, 93, 72,114,
  0,114,114,  0,114, 73,  0, 97,103, 62,114,  0, 97, 97, 97, 97,
 97, 97, 72,114,114, 73, 88, 73,103, 73, 73,  0,114,102,114,103,
 73, 73, 62,  0,103,103, 93,102,103, 93,114,114, 72, 93,114,  0,
103,114,  0, 73,114,114, 73, 97, 97, 97, 97, 97, 97,102, 62, 93,
102,114,102,102,114, 73, 70,  0,114,103,102, 73, 93,114,103,  0,
 73, 73,114, 62,  0,113,114,111,113, 88,114, 62,  0, 97, 97, 97,
 97, 97, 97, 97, 97, 73,102, 62,116, 73,112,113, 62, 73,102, 73,
 62, 73, 73,113,103, 73,  0,103,  0,113,  0,110,102, 73,  0,114,
103, 88, 97, 86,  0, 62, 97,  0, 97,113,103,  0, 62, 73,114,  0,
  0,  0,  0, 73, 73, 62, 93,103, 97,  0,102,114,102, 73,113, 73,
114,114,103, 93,114,114,  0, 62,  0, 97, 97, 73, 73,  0, 73, 86,
102,103, 73,  0, 73,114,113,102, 62,102,  0,113,  0, 70, 93,103,
114,114, 73, 73, 93,  0, 73,103,113,114,114, 97, 97, 97, 97,114,
114, 62, 93, 92, 62, 62,103, 73,114, 73,114,103, 73, 73, 62,114,
 62, 97,  0, 86,  0, 92, 62, 73,102, 73,113,102,114,114,103, 73,
113,  0,103,114, 86,  0, 72, 73,114, 92, 97, 73, 73,  0,103,  0,
 92, 73,103,114,103,113,  0, 73, 86, 73,114,102, 73,113,113,113,
114, 97,114,102, 73,103,114, 73, 86, 92,102, 62, 72,113, 62,103,
 73, 92, 73, 86,  0,103,  0,103,113, 92, 92,103,  0,103,103,113,
 92,103, 73,114, 62,113, 73,114,113, 73,114, 62,102,114, 73,  0,
 62, 62,103,114,114, 62, 62, 73,103,103,113,114,114, 62,114,103,
102, 93, 93, 62, 72,114, 97,113,113, 92,113, 73,114,114, 86, 62,
 93, 73,114, 62,102, 73, 92, 86, 86, 62, 62,114,114,103,114,114,
 73,116,102, 97,  0, 73,  0,  0,102, 86,114,114,114, 97, 86, 72,
 97, 97,103, 93,102,114,114,114, 93,114,103, 97, 73, 73, 97, 73,
113,  0, 73, 62,102,117, 62,114,  0, 72,  0,102,  0,  0,103,102,
 73,103, 73, 73,  0, 73,103, 73, 93,113, 93, 73,103, 86, 73, 93,
 62, 73, 86,103,113,  0,113, 62, 93, 73, 86, 92, 73,103,114,114,
 97,113,114, 97,102, 73,111, 92,113, 97, 97, 62, 73,102,114,102,
103, 62, 97,103,102, 73,  0, 62, 97, 62,102,114,  0,114,116, 72,
 73,102,114, 73,103,  0, 62, 97,102,114,117,103, 97,114, 73,114,
103,102, 73,103,102,114,112,103,102,116, 70, 93,114,114,116,114,
102,114, 62,114,102, 73, 73,116,114,114,103,113,117,114,102,107,
 73, 97, 73, 73, 97, 86, 62, 97, 97,  0, 97, 97, 97, 97, 97, 97,
 62,114,114, 93,114,116, 73,114, 97, 92, 62,114, 93,  0,114,114,
102,114, 62, 93,102,114,114,113,103,  0,103, 93, 73,103,  0,102,
 73,114, 73, 92, 93, 73,103, 70,  0, 93, 92, 93,  0,107,117,  0,
103,116,114,114,114,114, 93,102,102,114, 62, 62, 72, 73, 88, 97,
  0, 97,  0,  0, 97, 97, 92,114, 86, 73, 97,102, 93, 62,103, 62,
 73, 62,103, 86, 73, 73, 73, 72,114, 73, 73,114,102,102, 62,114,
 62,114, 92,102,114,114,114,103,114,114,102, 73,102, 62,  0, 73,
114, 73,103,102,103, 92, 97,116, 73,114,113, 73, 73,103,103,114,
 93,116,114,103,102, 62,103, 62, 86,  0, 97, 97, 97,  0, 97, 97,
 97, 97,  0, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,
 62,  0,  0,113, 73, 92, 73,114,102,  0, 73,114, 93,102, 73,103,
 62, 73, 62, 73, 62, 88,102, 92, 73,114,113, 73, 73,103,114, 73,
 73,  0,102, 93,103,103,113, 73,116,103, 92,102, 70,103,114, 86,
 93,  0,113, 73, 73, 73,103,103, 93,116,114,114, 62, 62, 73, 73,
 72, 88, 97, 97, 97, 86, 97, 97, 97, 97, 97,  0, 97,114, 62,103,
102,114, 73, 73, 73,114, 73,102, 73,117,114, 73,114,  0, 92,102,
 62,103,  0,111,102, 73,114, 73, 93, 73,  0, 73,114,102, 73, 93,
 93, 72, 73, 73, 73, 72,  0, 73,103,114,102,113, 73,  0, 73,113,
114,114,114, 73,113, 73,103, 86,102,116, 73, 92,103,114, 73, 73,
  0,102,  0,114,114,  0,102, 92,  0, 73,117, 93,114,114,114,102,
 73,102, 73, 92,  0, 62,  0,  0, 97, 62,  0, 73, 97, 97,  0,  0,
 86,  0, 86, 73, 97, 97, 97, 97, 97,113, 86, 73,113, 73,  0,103,
 73,114, 73, 73, 73, 92, 73, 73,114,103, 73, 73, 93,114,  0, 73,
 73,  0, 73, 73, 73,103, 93,103, 62,113, 62, 73, 73,103, 92, 62,
 73,102,103,  0, 73,  0,103,114, 62,102,102,114, 70, 73, 73, 73,
103,114, 86,114, 62,103,113,103, 73, 93, 62,114,114, 93, 92,113,
103, 88,  0,102,103,114,102, 92,102, 92,114,  0, 62,103, 73,  0,
  0, 62, 93,  0, 86, 62, 73, 97, 97, 97,  0, 88, 97, 73, 72, 73,
113, 73, 62, 62,113, 62,  0, 72, 73,114, 73, 73,114, 73,103, 92,
 73,114, 73,  0, 73,  0, 62, 73,103,103,103, 73, 73, 86, 73,102,
 73,103,114,  0,102,  0, 73,  0,114, 93,102,113,113, 70, 62,114,
117, 93,117,  0,114, 73,113,103, 62,114, 93,113,103,114, 73,103,
 93,114, 73,102, 73,  0, 93, 73,  0, 86,111, 73, 62, 97,  0, 97,
 97,  0,  0, 97,  0, 97, 97,103, 73, 73,103, 73,114,  0,113,103,
102,103,103, 73,113,  0, 73,103,  0, 73,103,103,114,103, 73, 93,
 92,  0,103, 62,  0,  0, 92,103, 73, 73, 73, 73,102, 73,103, 73,
 62,114, 73,114,113, 92, 73,114,113, 73,114,  0,103, 73,117, 93,
 73,114, 62,117,103,117, 92,103, 73, 73,103,102,114,113, 73,117,
 73, 73, 62, 62, 62, 86, 62, 97, 97, 97, 97, 72, 97,114, 73,107,
 92,113,  0,114, 73, 73,103, 73, 93,114, 93, 86,  0, 73,113, 62,
 62,103, 62,117, 73, 92,102, 92, 92,116, 86, 73, 62,103,102, 62,
103,103,103,113,102, 73, 73, 73,114,113,113,103, 73,113, 73, 62,
  0, 73, 97,  0, 97, 73, 73, 92, 73,102,102,102, 73, 62, 93, 62,
 92,103, 73, 73,114,102,103,114, 92,103, 92,103,103, 73, 73,116,
 92,113,  0, 62,113, 73, 73, 86,103, 92, 73,114, 93,103, 73,103,
103, 73,103, 73, 93, 62,113,103,114,113,114, 86, 86, 62, 88,114,
109, 73,  0, 73,103, 73,103,102,103, 93,113,  0, 62,103,103,103,
 73,112,103, 73, 73, 73, 73,103, 73,114, 62,103,  0,113,117,114,
 93, 73, 73, 97,  0,114,  0, 73,103, 73,103,  0,114,113, 73,103,
 62, 73, 73, 73,114,113,103,  0,103,114,113, 73, 73,103,  0, 73,
 73, 73, 73, 62,  0,  0,103,113, 73, 92,113,114, 62, 73, 92,116,
103, 73,111,  0,103,102,113,113,  0, 73,113, 92, 73, 62, 62,  0,
 62,102, 62, 86,  0,  0,112,113,103,103,113,103, 73,  0,103, 73,
 73,103, 92, 73, 73, 73, 73,102,  0,102, 73,  0, 73,113, 73, 86,
 86, 73, 73, 73, 73, 73,103,  0,102, 73,103, 73,102, 62, 73,113,
103, 62, 62, 73,  0,  0,103, 73, 73,  0,  0, 73, 73, 93,114, 97,
114, 97,103,103,114,113,103, 62, 62,103, 88,110,113, 62,114,113,
 62,103,102,103,103, 73,  0,113, 73,103, 73, 93, 70, 73, 72,103,
 73, 93,  0, 73, 73, 62, 62,103,  0,114,102, 93, 72, 97, 97, 97,
 97, 97, 97,  0,  0, 73, 73, 73, 62,  0,114, 93,114,102, 73,  0,
 73,103,  0,114, 73, 93,103, 73,103, 73,103,  0,102, 72, 73,  0,
  0,103, 73,114,114, 73, 62,102,102,114, 93, 86, 97, 62,  0, 93,
 93,102,  0,103,102,102, 93,103,103,103, 72, 73, 73, 73, 73,103,
102,103, 73,103, 93,103, 93,114, 73, 93, 97,114, 73, 86, 88, 97,
 72,102, 62, 73,114, 62, 73,103, 72,114,103,114,103, 73, 93,114,
 62,  0, 73,103,114, 62, 73, 62, 73, 93, 73, 73, 92,114, 88, 86,
 97, 97, 97, 97, 97, 73, 73, 73, 93, 93,103, 92, 62, 62,114,  0,
114, 73,114,114,103,103, 92,102,114, 93, 93,103, 73, 93,103, 62,
 62, 92, 93,102, 62, 97,  0, 97,114,103,114, 73,114,  0,102, 62,
 73,102, 72,102, 73, 93, 73, 73,103, 93, 73,  0, 73, 73,102, 62,
 73,102,103, 73, 93, 73,  0, 93, 73, 62,103, 93,103, 62,102, 93,
103, 73, 73,103,  0, 62, 73, 97, 97, 88,  0, 86, 93,103,114, 73,
 73, 73, 73, 93, 73,113, 73,114,103, 93, 73, 73, 73,103, 73,113,
 93,103, 73, 93,102,102,113, 73,113, 73, 92, 73, 73, 73, 93,103,
 97, 62, 62, 73,114, 73,114, 73,113, 73, 73,102, 97, 97, 97, 86,
  0, 73,114,102,103,102, 62,103,102,103,  0, 70, 62,114,  0, 73,
103, 73, 73,102, 73, 62, 73,102,103, 62, 73, 73, 73, 73,103,114,
 62,  0,113,103, 73,  0,  0, 62, 97,  0, 73, 93,102,102,103, 93,
 73, 62, 73,114, 73,102, 73, 73, 73, 73,114, 92, 73, 93,103,103,
 93, 62, 73, 73,113, 73, 93, 86,103,103,102, 93, 73,  0, 62,  0,
 86, 72, 93, 72, 73, 62, 62, 73, 73,103, 62, 72,103, 73, 73,103,
114, 73,103,103,103, 72, 73, 73, 73,  0,102,103,110,103, 97,113,
  0, 62,113,103, 73,  0, 92, 92, 62,114,103,113, 73,  0,114,103,
 73,103, 73,102,  0,113,103,  0, 73,103,102,103, 73, 92, 86, 86,
103, 92, 62,102,103, 93, 93, 73, 62,103, 62,102,103, 73, 62,117,
 73, 93,114,113, 73, 73, 73, 86,103, 73, 73, 73, 73, 62,103, 73,
103,113,102, 73,  0,103,113, 73, 73, 93, 62,113,102, 73, 73, 73,
114,103, 86,103, 93, 70,111,  0,103, 62,103,103,114,114,103,  0,
  0, 62,113,113, 97,103,103,114, 62,114,103,113, 62,113, 86, 62,
 62,114,114,114, 70, 97,  0, 73,114,102, 73,114, 97, 73, 97, 73,
114,103,114,  0, 73, 92, 73,114,  0,103,  0, 62, 73, 93,114,114,
103,114,114, 73, 97, 97,  0,  0,114, 73,  0,114, 73,114, 73,  0,
  0, 73,114, 73,  0, 73,114,113,103, 92,103,103, 70,  0,113,103,
 62, 73, 93,  0, 93,  0,  0, 73,103,  0,103,114, 73, 97, 86,  0,
 86, 93, 73,  0,111, 86, 73, 93, 73, 73,103,  0, 72,103,103, 86,
103,114,114, 86, 86, 88, 97,  0,  0, 72,103,103,103,103,102,111,
 73, 62,102, 62,114,114, 73, 73, 93,114, 73,103,113,113,103,114,
  0,113, 97, 97, 97, 97,  0,103,114,  0,  0, 73, 73,  0, 73,103,
102,102, 92,114,114,107, 73,103,114, 93, 73, 73, 93,113, 93,  0,
  0,103, 93,  0, 86, 73,103,113,  0, 73, 93, 73, 92, 62,103, 62,
114, 73,114,114, 73,103,103, 73,117,116,102, 97, 62, 86, 92, 73,
 62, 72, 73, 73,  0,114,103,103, 62, 73,114, 93, 73, 73, 73, 73,
102,103,103, 73, 97,103,114, 73,113, 62, 62,113, 73, 73,103,  0,
 62,114,103, 86,114, 62,103,  0,  0,103,  0, 73, 92, 86,  0,103,
 73, 73,103, 73,  0,  0, 92,103, 73, 73,103,103,103, 73, 93,114,
 92,103,103,103,113,  0, 93,  0,  0, 73,113,103, 73, 92,103, 92,
 62, 73,113,103, 92, 62, 73, 86,  0, 73,103,102,103, 62, 92,114,
  0,114, 73,114,  0, 73,114,111, 92, 62, 86,113,  0, 62,  0,113,
 62,  0,  0,113, 62,103,113, 92, 92,  0, 86,103,103, 73, 73,103,
 62,113, 73, 73, 73, 62, 92, 86,  0,111,113,  0, 92, 73, 73, 92,
 62,  0,113, 86, 62, 62,103,103,  0, 73,113,  0, 62,113, 73, 92,
113, 97, 97,  0, 97, 97, 97, 97, 97, 97, 97, 97, 97,  0, 97, 97,
 97, 97,114, 73,103,103,102, 62, 62, 73, 93, 73, 93, 92, 97, 73,
 73, 73, 73,114, 73,102, 93, 86, 73,103,  0,102, 73,103,  0, 97,
 73,103, 73,102,113,  0,103, 73,113, 62, 73, 73, 73, 62, 73,103,
114,  0,113,113,103, 62,  0,102,113,  0,113,  0,113,  0,113,103,
 92,103,103,113, 62,103,113,113,113,  0,  0,113,  0,113,103,113,
 62,  0,103,113, 62,113, 62, 73,  0,  0,113, 62,103,113,  0, 62,
 73,113,  0, 86,113, 62,113, 62,  0, 73,113,113, 92, 62,102, 73,
103, 92,  0, 62, 73,103, 92, 62, 93, 62, 73,  0, 73,103,103, 73,
113, 92, 92, 62,113,113,103,103,103, 73,  0,113, 62, 62,113,  0,
113,103,113,113,  0, 62,113, 62, 73,113,  0, 92, 92,113,113,  0,
113,113,113,113, 73,117,103,103,  0,116,103,103, 92,  0, 62,103,
 62, 73, 92,103, 92,113,103,113,  0, 88, 97,103,113,113,  0,103,
 62, 92,103,114,  0,113,103, 62,113,103, 92,  0,  0,  0,113, 62,
113,113,  0,113,113,113,113,103,113, 62,110, 73, 86, 86, 62, 62,
113,  0,113, 62,  0,  0,103, 62, 73,113, 73,103,113, 73,117,113,
 73,  0,113,103,113, 73,103,113,103,103, 62,113, 86,113,  0,113,
  0,103,113,103,103,103,113,103, 73, 73, 86,113,113,103, 92,103,
 92,113, 92,  0, 92,  0,113,113, 73,  0,106,113, 62,113,113, 73,
103,113, 73, 92,103,103,117,113,113,  0,113, 73,103,  0,113,103,
113,113,113,  0,113,103,103, 93, 73,  0,103,103, 86, 73,113, 73,
113,103, 73, 73,113, 73,113,113, 73,113,113,113,103,113,103, 62,
113, 86, 73, 73, 73, 73, 93, 73,113,  0, 73,113,113, 62, 73, 73,
103, 73,  0,113,  0, 73, 73,103,  0,113, 73, 73,103, 73, 92,  0,
 73,113,103, 62, 62,103,103, 73,103,113, 73, 73, 86, 62,113,113,
 73, 73,103,103,103, 73, 92, 73,113,103,113, 86,113, 73, 62, 92,
 73,  0,  0,103,  0, 73,114, 73, 73,  0, 73, 92,114,103,  0,113,
113, 86, 86,  0,113,  0, 62,113,103,103, 73, 73, 62,113,103, 73,
113, 62, 73, 86,103,103, 73,  0, 73,  0,113,103, 92, 62, 92, 62,
111,  0,113,113,103,103,113,  0, 73, 92,113,  0,103,  0,103,103,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,  0, 97, 97, 97,
 97,  0, 97, 97, 97, 97, 97, 97, 97, 97, 97,  0, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97,  0, 97, 97, 97, 97, 97, 97, 97, 97,
  0, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,  0, 97, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97,  0, 97, 97, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,  0, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97,114, 62,103, 86, 73, 73,103,103,113,
  0,114, 73, 73,  0,103,114,102,113,102,113,103,114, 73, 92,103,
 92, 62,  0, 62,103,114, 73,103, 62, 62,114, 62, 73,103,  0, 73,
  0,114, 93, 62,103, 73,103,  0,103,103,114,114, 92,103,  0, 73,
 73, 73, 73,102,  0,103,103, 73, 93,114,114,103, 86, 73, 62,  0,
 73, 73,114,  0, 73, 93,103, 62,  0, 93,114, 62,114, 92, 86, 73,
103, 73,103,103, 93, 73,  0, 73, 93,103, 73, 62,103,113,113,  0,
113,113,113, 73,103, 73,  0,113,113,113,113,113,113, 86, 86,113,
113,  0, 92,113,113, 73,113,113,113,103,103,113,113,113, 73,113,
113,113,113,113,113,103, 62,113,113, 62,113, 62, 73, 86, 86,103,
  0,113, 73,113,  0,103, 62, 73,  0,103,113, 86,113,103,113, 73,
113,103,113,113,113, 73,113, 73,103,  0,113,  0,103,113, 73, 62,
103, 73, 62, 73,110,103,  0, 62,103, 73, 92,113,113,113,103, 62,
 73, 62, 73, 62,113,113, 73,113,113,103,113, 86,  0,113,  0, 92,
 92,  0, 62,113, 92, 73,113,103,  0, 73,  0,103,  0, 97, 97, 97,
  0, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,
 97,  0,  0, 97, 97, 97, 97,  0, 97, 97, 97, 97, 97, 97, 97,  0,
 97, 97, 97, 97,114, 62,114, 93, 73,103,  0,114,103, 93,103, 73,
114, 86, 73,114,114, 97, 72,114, 73, 73,  0, 73,  0, 73,  0, 62,
 73, 93, 62,  0,102,114,  0,  0, 62, 73,114, 97, 73,103, 73, 73,
103,102, 73, 73, 72,103, 73,  0,  0,113,  0, 73, 73,  0, 62,102,
103, 73,  0,114,  0, 73, 62, 73,113,  0, 73,103,103, 73, 73,103,
  0, 97,103,114, 72,102, 73,103, 97,103,114, 62,102,  0,114, 72,
 62, 73, 92, 97, 97,103,116,103,103,  0, 62,114,114, 73,102,114,
 73,102,  0, 73, 62,103, 93,102, 73,103, 93,114, 73,114, 97, 93,
 73,113, 73,114,102, 62, 73,103,114, 73, 93, 93,102,  0, 73,114,
103,103,103,114,103, 88,  0, 97, 97, 97, 72, 97, 92,102, 73, 92,
 73, 62, 73, 73,103,102,103, 73, 86, 93,114, 62, 97, 73,  0,114,
113,103, 73, 73,102, 73,103, 73, 73, 73, 73, 73, 73, 93,114, 93,
103,103,102,102, 73, 73,103,103,  0, 72,112, 73, 97,  0, 72, 97,
113,102,  0,103, 92,114,103, 62,103,102, 97,  0, 73,102, 73, 73,
102,102,114,  0,114, 73,  0,114,114,114,114,102, 92,103,103, 62,
 92, 97, 97, 73,103, 92, 73, 73,  0,114, 73,103,103,103,103,113,
113,103,103, 92, 92, 73, 72, 73,  0,102, 73,  0,102,102,  0,102,
 70, 62, 93, 73,114,  0,114,  0, 73, 62,103,103, 93,  0,  0, 97,
  0,114,103, 62, 92, 93, 73,114, 73,103,113, 92, 73,113, 73, 97,
102, 92,103, 92, 93,103, 73, 73, 73, 86,103, 62, 97,103,102, 73,
 73, 92, 62, 73, 73, 73, 73, 62, 73,103,113,114,114, 62, 62, 88,
 86, 86, 72, 62,  0, 62,  0,  0,  0,  0,102, 62,  0, 73, 86,  0,
117, 62, 73, 62, 62, 86, 86, 62, 86, 73,113,113,113,113, 97,103,
  0,103,113, 73,103,  0,  0, 73, 73,  0,  0, 92,103, 73, 73,113,
 73, 73, 86, 86,  0, 73, 73, 73,103, 73,  0,113, 73, 62,103, 73,
 62,103,  0,  0, 73, 73, 73,103,113,103,103,113, 92, 86,113, 73,
103, 73,103,113,  0,113, 73,103,103,113, 92, 73, 86, 73, 73, 62,
103, 73,113,113,113,113,103,103,103, 86, 73,113,113,113,117,113,
103, 62,  0,103, 73,103,113,107, 62,113,113,  0,103, 62,103,113,
  0,  0, 73,113,103,103,103,103,113,113, 62,113,  0,  0,113,113,
103, 62, 92,103,113,113, 92,103, 73,113,  0, 73, 86,113,113,103,
 73,103,103,103,103,103, 73, 92,103, 73, 73, 73, 86,117,103,113,
 73, 92,113, 92, 92, 62, 97, 97, 97, 97,  0, 97, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,
  0, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,  0, 97, 97, 97,
 97, 97,  0, 97, 97, 97, 97, 97, 97, 97, 97,114,114, 62, 88, 93,
 62, 62,  0,114, 62, 62,117, 86,114, 97,  0, 97,  0,113, 92,113,
114,114,113,  0, 73, 62, 70, 86, 62, 97, 86, 86, 86, 97, 70, 92,
 62, 70,114,  0, 93,114,103, 97, 97, 73, 62,103,  0,103,114,  0,
 70,114,103,102,114,102, 73, 73, 97, 97, 86, 97, 97, 97, 97, 97,
103, 73, 93,103,102, 93,114,  0,102, 88,114,114,  0,114,102, 86,
114, 62,106, 97, 92,103,103,114, 93,112, 92,103, 73,114,103, 73,
114,114,116,114,102,114,114,  0,107, 97, 97,114,103,114, 86,114,
114,114, 97, 86,114,113, 93,114, 62,113,114,102, 73,114,114,114,
114,114,114,113, 73,  0, 97, 86, 62, 62, 62,  0, 62,102,114,102,
  0,113,113, 62,103,114, 93, 62,114, 86,  0, 97,114, 73,114,103,
  0,114,114, 62,102, 86,  0,114,  0, 92,113,113, 62,114,113, 93,
114,114, 93,114,113,113, 86, 97, 93,113,  0,102,113,117,113,  0,
113,111,102,114,  0, 88, 62,103, 93,113,  0, 73, 62,114,114,113,
103,  0,113, 73,102,114, 92,113,113,103,113, 73,113,114, 73,114,
114,113,114,114,113,103, 73,113,116, 86,113,102, 62, 73, 62,113,
103,114,  0, 97, 73,116,  0,102,103,116,  0,102,  0, 97, 73, 73,
103,102,116,114,  0,103,114, 73,111,  0,114,  0, 97,  0, 97,114,
116,114,103,102,102,114,102,  0,114, 97, 97, 97,  0,103,102, 73,
  0,114,  0,103, 70,102,  0,102,103,  0,114, 73, 62,  0, 93, 97,
 97, 97, 62, 97, 73,103, 73,102,103,103, 73, 93,102,102,106,103,
 73,114, 93, 73, 92,103, 97, 97,114, 73, 73,102, 73,114,  0,102,
103, 73, 73, 73,102,113, 62, 86, 97, 73, 73, 73, 73,114,102,103,
103, 73,114, 73,102,103,103, 73,103, 73,  0, 73,  0,103, 73, 73,
103, 73,113,  0,103,106,103,103,103,114,103, 73,103, 73,102, 73,
103, 73,102,102, 73, 62, 73,117, 73,103, 73, 73, 73,113,103,102,
 92,102,113, 73,103, 73,103, 62, 73,102,103, 73, 62, 62, 73, 73,
 73, 73,  0,102, 73, 73, 72,103,103,114,114,114,114,114,114,102,
 72,  0,114,103, 86, 73, 92,102, 92, 62,102, 62,  0, 97, 97, 73,
 73,102,114, 93,102, 93,  0, 62, 73,114,114,  0,114, 62, 72, 72,
 97, 97, 93, 92,102,114, 97,114,114,102,103, 62,  0, 97, 97, 97,
 73,103, 92,103, 73,102,103,114,  0,114,103,114, 97,114, 62, 73,
 93,102,114,103, 62, 62,  0, 86, 62, 73, 72, 72,113, 73,103, 73,
 73,103, 93, 72, 86, 73, 62, 73,103,  0, 93,113,117,102,116,114,
103,117,103,103,114,114, 62, 73, 86, 73, 93, 62,103,103, 73, 62,
113, 92,103,103,  0,103, 92,114, 86,114, 97,113,114,114,114,114,
113,114,  0,103,103, 73, 86,117,113,103,103, 86,114,113, 62, 86,
  0, 86, 73,113,103, 62, 92,113, 73,103,117, 73,103,103,103, 62,
 62,103,  0, 73, 73,113, 86,103, 73,103,  0, 62, 86,103,  0, 92,
103,103, 73, 73,103,103,103,103,  0,103,103,  0,103,113, 86, 73,
117,113,117, 62, 92, 92,103,110, 62, 73, 73,  0,103, 62,113,  0,
  0,  0,  0,103,103,103,103, 73, 62, 86,  0,  0, 86, 73,103, 62,
103, 73, 73,103,113, 62,103, 92,103,103,117,  0, 62, 73,103,113,
117,  0, 62, 62, 86,113,103, 62, 92,113,103, 92, 73,103,103,103,
 92,103, 73, 73, 73,  0, 73,113, 62, 62, 92,113, 62, 62,113,  0,
103,103,111, 73,113,117,113,103, 62, 62,  0,  0, 73, 73, 62,103,
103, 86, 73,  0, 97, 62,103, 62,103,103, 73,103,103,103, 92,103,
113,  0, 73,113,  0,113, 73, 73,103, 62,103, 73, 73,103,102,  0,
  0,113, 62,113, 73, 92,113,103,113,103, 92, 92,113, 73,  0, 62,
103, 73, 73, 73,103,103, 73,103,103, 73, 73,103, 73, 86, 97, 62,
  0,  0,103,110, 73, 73,117,113, 62,111, 62,103,103, 62,  0, 62,
103,103,103,103, 73,103,103,103,102, 73, 73,103,117,103,103,113,
103, 73,113,103,  0,103,  0,103,103,103,  0,  0, 62,103, 73,103,
103,103,  0, 62,113, 62, 73,103,103, 92,113,  0, 62, 86,103, 73,
103, 73, 86, 86,  0,  0,  0, 73,113,103, 92,103,113,  0, 73,103,
103, 73,103,  0,110,  0, 92,  0,103, 73,  0, 73, 73,103, 73, 92,
113, 62, 73, 73,103,103, 73,  0,113, 92,113, 73, 62,103,117,117,
113,117,113, 92,117,103,113,103,113,103,103,113, 86, 73,113,113,
  0,  0, 86,103,103, 92,103, 62, 73, 73, 86, 86, 73,  0, 97,  0,
  0,  0,  0,  0, 86,  0, 73,103,107,103,110,113, 73,113, 73, 73,
103,103,103,  0,113,103, 92,103,103, 73,103,113, 92,  0,103,  0,
 92, 73,  0, 73,103,103,  0,103,  0, 62,102,  0, 92,103,111, 62,
103,103,  0, 62, 62,113,103, 73,  0, 73,103, 73,113, 62,113, 62,
103, 62,103, 73,  0,  0,  0,  0,103, 73,103, 62,113,103, 73,102,
  0, 73,103,  0,113,103,113, 92,103, 73,113,103,  0, 73,103, 73,
  0,103, 73,117,103, 73,103,113,103,103, 73, 62,113,111, 92, 73,
113, 73, 73, 73,103,103, 62, 73,  0, 86, 62,  0,  0,  0,  0,  0,
 73, 62, 73,113,103, 62, 62,103, 92, 62,102, 62,103,103, 73, 73,
 92,113, 73, 62, 73, 73, 93, 92, 92,103, 73,  0,103, 92,117,103,
  0,113,103, 73,113, 86,103,103, 92,  0,  0,  0, 73,  0, 73,  0,
  0,  0,  0,  0,  0, 73,110,103,103,103,103,103, 73,103, 73, 73,
 73, 62, 62, 92,107,  0, 73, 92, 62,103, 73, 73, 73,103,103,103,
 92, 73, 73, 92, 92,103,103, 62,113, 92, 86,  0,  0,  0,  0, 62,
 73, 86,  0,  0,  0,106,  0,  0, 73, 73, 73,113, 73,  0,103, 62,
 73,103,103,103, 62,113, 92, 73,113, 73, 92,103, 73,103, 97,103,
 73, 86,  0, 62,113,103, 73, 73,103, 73,103, 73,103,  0,  0, 73,
 73,113,113, 86,  0,103,  0, 73,  0, 62, 86,111, 62, 73, 92, 62,
 92, 62, 92,103, 73,  0,  0,  0,103, 73, 92,102,  0,103,103,103,
 92,103,103, 73, 73, 92, 73, 92, 73,  0,  0,  0, 92,113, 92,113,
 73, 92, 73,103, 62, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,
 97,  0, 97, 97, 97, 97,  0, 97,  0, 97, 97, 97, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97,  0, 97, 97, 97, 97, 97, 97, 97,  0,
 97, 97, 97,  0,  0, 97, 97, 97, 97, 97,  0, 97, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97,  0, 97, 97, 97, 97, 97, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,  0, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,  0, 97, 97, 97,
  0, 97, 97, 97, 97, 97, 97,  0, 97, 97, 97, 97, 97, 97, 97, 97,
 97, 97, 97,  0, 97, 97, 97, 97, 97, 97, 97, 97, 97,  0, 97, 97,
 97, 97, 97,  0, 97, 97, 97, 97,  0, 97, 97,  0, 97, 97, 97, 97,
 97, 97, 97, 97, 97,  0, 97, 97, 97, 97,  0, 97, 97, 97, 97, 97,
  0, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,  0, 97,
 97, 97, 97, 97,  0,  0, 97,113, 62, 62, 73, 73, 73, 73, 62, 97,
113,  0, 92,113, 62,  0, 73, 86,103,113, 86,113,103,103,103,113,
 73,113,110,113,113,  0, 86,  0,113, 86,  0, 73, 73, 62,103,103,
 86,103, 86,113,113,113, 62, 86,113,103,  0,103,103,113, 73,  0,
 73,110, 86,  0, 62, 73,103, 73,  0, 92,103,113,113,103, 92,103,
 73,  0,  0, 92,  0, 73,103,113,103,103,113,103, 92, 92,  0,  0,
103,103,103,103,113,113,113,  0, 86, 62,103, 73,113, 62,103,103,
103,113,113, 73,103, 92, 62,  0, 97, 97, 97, 97,  0, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,  0,
 97, 97, 97, 97, 97, 97, 97,  0, 97, 97, 97, 97, 97, 97, 97, 97,
 97, 97, 97,  0, 97, 97, 97, 97,  0, 97, 97,  0,114, 70,103, 97,
 73,114,102, 73,103, 62, 62,  0, 92,  0,114,  0,103, 73,114, 92,
 73,102,114, 70, 97, 97, 97, 62, 62,103,103,114,102,102,  0,114,
114, 62,114, 73,114, 97, 97, 97, 97, 97, 73,114,114,114, 73, 92,
114, 73, 62, 73,102, 97, 62, 62,103,  0,  0,114,113,113,113,114,
  0,102,114,113,114, 86, 86, 97, 97, 97,114, 73, 93, 73, 62, 73,
113, 73, 93,113,102,114,114,114,113,  0, 86, 62,103,113,103, 62,
 73, 62, 62,103,103,114,114, 73, 93,103,113,114,  0,114,113, 88,
 97,103, 73, 73,114,113, 62, 93,114,114, 62,113,114, 62, 73, 62,
 86, 73, 73,111,103, 62, 62,114,113,103,113,  0, 73,  0,103, 62,
 93,113, 86,102, 92,  0, 88,111, 92, 93, 62,113, 93, 97, 97, 73,
114,114, 73, 73,114,114,114,114, 73,114,103,113,114,114,114, 97,
  0, 86,102, 73, 73,114,113, 73,103,113,103,113,113,103,103,103,
 97, 73,113,113,  0, 73,  0,  0,114,116,114, 86,  0,  0,  0,116,
113,103,113, 97,  0, 73,114,114, 73,114,103,113,  0, 73, 97, 73,
114, 97,103, 62, 93,103,114,114, 93,102, 86, 73,  0, 93, 93, 93,
 73,113, 73,114,  0,  0,114,  0, 73,113, 62, 62,114,103,114, 73,
 73, 62,103,103, 92, 73, 73,113,103, 73, 93, 73, 73, 97, 73, 73,
114, 62,114, 62,  0, 73,  0,  0, 93,114, 73,  0,  0,113, 93, 73,
  0, 62,113,103,113,  0, 92, 73,113, 92, 62, 73,  0,  0, 62, 62,
  0,106, 93, 97,  0, 62,114, 62,103, 88,103,102,113,  0,114,  0,
 93,114,114, 62, 86, 97, 92, 62, 92,114,103, 86, 73,111,103,  0,
 73, 86, 73,102,114,  0,102,117,103, 86,113,103, 93,103, 73,103,
103, 92, 73, 73, 92, 93, 86,  0, 73, 62, 73,114,  0,114, 73,113,
 86, 97, 97,  0, 72, 62, 62,103, 93,103,103,  0, 92, 73,103, 62,
114, 73,103, 93, 73, 73, 92,  0,113,  0, 73,114,103,114,103, 97,
  0, 62, 70, 92, 88, 62,103, 73, 62,103, 62, 73, 62,  0, 62,103,
  0,103,  0, 92,103,103,113,103, 86,103, 62,113,103,103,103, 73,
103, 62,  0,113,103, 73, 73,103,103,103,  0, 62,113,103,103, 73,
 62,103,  0, 73, 62, 73, 97, 97,  0, 97, 97, 97, 97, 93, 86, 62,
 73,103, 86,114, 62, 88,114, 62,103, 73,103,113,  0, 73, 73,113,
110,113,113,113, 73,113,113,103,113,  0,117,  0,113,103,103, 92,
113,113,113,113, 62,  0,103,113,113, 62, 86, 73,103, 73,103,  0,
103, 92,  0, 62, 92, 62,103, 73, 73, 73,  0,103, 86,113, 62,103,
117,  0,103, 62, 86,103,  0, 92,113,110,  0,113, 86, 86, 62,  0,
  0, 73,  0, 73,103, 73,113, 62, 73, 73,103, 86,113,113,113, 92,
 73,103,103,103,111, 86, 62,103,113,103,107, 92, 73, 73,113, 73,
 73,  0,103,103, 73,117, 62,113,  0, 73,103,113, 62,  0,  0,113,
 92, 92, 73, 92, 92, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,  0, 97, 97,  0, 97,
 97, 97,  0, 97, 97,  0, 97, 97, 97,  0, 97, 97, 97, 97, 97, 97,
 97, 97, 97,  0, 97, 97, 97, 97,113, 73, 86, 62, 73,103,103,113,
 62,113, 73, 73, 62,  0, 92, 62,103,  0,103,103, 73, 73, 73,103,
 73, 73,103, 86,113, 62, 92,106, 62, 73,  0, 73,103,  0, 97,  0,
  0, 97, 97, 97,  0, 97,  0,  0, 97, 97, 97,113,111,  0, 97,114,
  0,107,113,103,  0,103, 62,102, 97, 92,103, 92,  0,113,111,113,
  0,  0, 92, 62,113,  0,103,  0,  0, 73, 73,  0,113,113,113,  0,
 73,  0,103,113,  0, 92,  0,103,103,113,113,  0,113, 97,  0,  0,
114,103, 92,113, 92,103,103,103,113,  0,103,103, 62, 86,113,103,
111, 92, 62,  0, 92, 73, 62,103,113, 73, 73,103, 92, 73, 93, 73,
 73,103,103,103, 62,103,  0,  0,  0, 62,103, 62,103, 92, 92, 73,
 62,103, 86, 73,  0,113, 62,103,103,113,  0,113,113,107,103,  0,
 92,113,113, 73,116, 93, 73,113,103,103,  0,103,103,  0,103,103,
 62, 73,  0, 97,  0, 97,  0, 97, 97, 97, 97, 97, 97, 97, 97, 97,
 97, 97, 97,  0, 97, 97, 97, 97,  0,  0, 97,  0, 97, 97,  0, 97,
 97, 97,  0,  0, 97, 97, 97, 97, 97,  0, 97, 97,  0, 97,  0, 97,
 97, 97, 97, 97, 97, 97,114, 93, 93,114,  0, 62, 73,117, 73, 62,
  0, 73,  0, 73,  0,114,103, 73,114,  0,  0, 73,113,113,113, 73,
103,117,103,113,113,103,  0,  0,  0,117,103, 73, 86,103,  0, 62,
  0,113, 73,103, 86, 86, 86, 73, 86,103,  0, 73, 73, 73, 73, 73,
113,113,113,103,103,113, 73, 73, 92,117, 62, 92,103,113, 62,113,
  0,  0, 92, 73, 73, 73,  0,103,  0, 73,103, 62,103,113, 92,  0,
103,113, 86,  0,103, 62, 73, 73, 92,103, 73, 92, 73,103,103,113,
  0,113,103,103,103, 92, 73, 73,106, 73, 73,103, 62, 73,113,113,
 62,103, 86, 86, 73, 73,103,  0,  0,113, 73, 73, 73, 73,103,  0,
103,  0,103,103,103, 73,  0,103, 86, 73, 73,113, 73,103,103,  0,
113, 73, 73, 62, 73,103,117,113,103, 73, 73,  0,  0, 73, 92, 73,
113,103, 92,113,103,113, 73, 62, 73, 73,103, 62,103,113,103, 73,
 73, 62, 73, 73,103,113,103,113,  0, 73,113,113,  0, 62, 73,113,
 73,  0,113,  0, 92,113, 73, 73, 73,113,113, 92, 97, 97, 97, 97,
 97, 97,  0, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,
 97, 97, 97,  0, 97, 97, 97, 97, 97,  0, 97, 97, 97,  0,  0, 97,
 97, 97, 97, 97,  0,  0, 97, 97, 97,  0, 97, 97, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97,  0, 97,114,  0, 62, 73, 62, 92, 62,103,
 93, 72, 62, 73,103, 62, 70, 72,114,103, 97,103, 93,  0,103,103,
 93,102, 72, 62, 86, 97,103, 73, 62,  0, 73, 97, 97, 73, 62, 92,
103, 93,103,114,113,103,103, 62,114,  0,  0, 62,103,  0, 86, 93,
 62, 72, 86, 92, 62,107, 93,103,  0, 62, 86, 93,103, 93,113, 93,
  0, 92,103,103, 86, 62, 73, 92,  0,102,103, 93, 73,103, 73, 62,
 62,103, 62,102,103,103, 92,  0,102, 62, 73,103,103,103,103, 97,
103, 73,103, 97,  0, 73,103, 73, 92,103,113, 62, 62,  0, 73, 93,
103,  0, 92, 93, 73, 92, 62,113, 92, 92,111,103,  0, 62, 92, 93,
  0,113, 93,103, 62,103,  0,103,  0, 62,103, 93,114, 62, 73, 73,
  0,114,114,114,114,114, 73, 97,102, 97, 73,103,103, 93, 92,114,
  0, 93, 73,  0,114,103,103, 62, 92, 73,113,103,  0,  0, 62, 73,
 73,103,  0, 62, 73, 62,103, 73,103,  0, 62, 62,103, 62, 62,113,
 73, 73,  0, 62, 92,103, 73,103, 62, 62, 73, 73, 73, 73, 73, 62,
103,  0, 73, 86, 62,103,103,103, 73, 62, 62, 62,  0, 62,111, 62,
103,113, 92, 92, 62, 73, 86, 86,  0,  0,103, 73,  0, 62,103,111,
 92, 73, 73,  0, 73, 73,103, 62, 92, 62, 92,113, 62, 92,113, 73,
 62, 62, 62,  0, 86, 73, 73, 62,103, 92,  0, 62, 62, 73, 62,103,
 92,103,  0, 73, 73,  0, 92,103,103,113, 92,  0,  0,  0, 62, 86,
 62, 86, 86, 73, 92, 73,113,103, 62, 73, 73, 92, 73, 62, 73, 62,
 73, 92, 92, 86,113,103, 73,103,113,  0,103,103, 73,  0,  0, 62,
 92, 86, 86, 62,  0, 86,  0,103,103, 62, 62,  0,  0,103,  0, 62,
 62,  0, 62,  0, 86, 73, 92, 73, 92, 92, 86,103, 86,113, 73, 62,
111, 62,113, 92, 92,111, 62, 73, 62, 62, 62, 86,103, 73, 62,  0,
  0, 92, 62,103, 92,113, 62, 62,103,103, 62, 73, 73, 92, 86, 86,
 86,103,113, 73, 73, 62,103,103,  0, 92, 86,113, 73,103, 92, 73,
 73,103,  0, 62,103, 62, 92,111, 92,117,103, 73, 73, 73,103, 62,
103,  0, 92, 62,103, 73,103,113,103, 73, 86, 62, 62, 62,103,103,
 92,  0, 73,103,  0,  0, 73, 92,103, 62, 62, 62,  0, 73,103,  0,
 62, 73, 62, 73, 73,103, 86,103, 92, 73, 73, 62, 97,  0,  0, 97,
  0, 97, 97,  0,  0, 97, 97, 97, 97,  0,  0, 97,  0, 97, 97,  0,
 97, 97, 97,  0, 97, 97,  0,  0,  0,  0, 97, 97, 97,  0, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,  0, 97,  0, 97, 97,  0,
 97, 97, 97, 97, 97, 97, 97, 97, 97,  0, 97, 97, 97, 97,  0,  0,
  0,  0,  0, 97, 97, 97, 97, 97,  0,  0, 97, 97, 97, 97, 97, 97,
 97,  0,  0, 97, 97, 97, 97, 97, 97, 97,  0,  0, 97, 97, 97, 97,
  0,  0, 97,  0,  0,113,103,113,  0,113, 73, 86, 86, 73,  0,  0,
 86, 73,103,113,113, 73,113,103,  0,103, 73, 73, 73, 73,  0, 73,
 73,  0, 62, 92, 73, 73, 92, 92, 92,113,  0, 62,  0,  0, 86,  0,
 73, 62, 92,  0, 73, 92,  0,103,103, 73,  0,113, 62,103,103, 92,
 73,  0, 73, 92,  0, 73,113,  0,113, 73, 86, 86, 86, 73, 73,103,
103, 73, 62,103, 62,  0, 73, 73, 73,  0, 62,113, 62,103, 92, 92,
 73, 92,103,103, 86,103, 86, 62, 86,  0,103, 73, 73,  0,  0, 73,
 86,113, 73,103,103,  0, 73, 73, 73, 92, 73, 73, 92,113, 86,103,
113,113, 62, 62, 86, 62,  0, 73, 73,103,103,103,113,  0,  0, 92,
103, 73,113, 73, 73, 73, 62,103, 73, 73, 86,103, 62, 73, 62, 73,
 73, 73, 73, 62,103, 73,103, 92, 73, 92,103, 73, 73, 62, 62, 86,
 73,  0,103, 62, 73, 62,103,103,103, 73, 92, 73, 73, 73, 73, 73,
 73,103, 73, 73, 92,  0, 73, 73, 73,113,103, 86,103, 73, 62,113,
  0,103, 92, 73,113,103, 73, 73, 92,103, 92, 92,103,  0, 73,103,
  0, 92, 92,103,111, 73, 86,103, 73, 62,103, 73, 73, 73, 73, 92,
 73, 73, 73, 92, 62,103,103,117, 73, 92,103, 73, 73, 73,103,103,
 62, 73, 73, 73, 73,103, 92, 62, 73,103,  0,103, 73, 92,103, 92,
103,  0,113,103,103, 73, 73, 73,113,113,113, 73,  0, 92,103, 73,
 73, 73,103, 73, 73, 73, 73,103,  0, 73, 62, 73,  0, 73, 62, 73,
103,103,103, 73, 73,103, 62, 73,  0,103,113, 92, 62,103,113, 97,
 97, 97, 97, 97,  0, 97, 97,  0, 97, 97, 97, 97, 97, 97,  0, 97,
  0, 97, 97, 97,  0, 97, 97, 97, 97, 97, 97,  0,  0, 97, 97, 97,
  0, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,  0, 97, 97,
  0, 97,  0,  0,  0, 97,  0, 97, 97,  0, 97, 97, 97,  0, 97,  0,
  0,  0,  0, 97, 97,  0, 97, 97, 97, 97, 97, 97, 97, 97,  0,  0,
 97, 97,  0, 97,  0,113,  0,  0, 86,113,103, 62,103,113, 97,114,
103, 86,102,103, 62, 62, 73,102, 93, 73, 73, 93, 92, 73,103, 62,
  0, 92,114,114, 73, 86, 62,113, 62, 73, 73,103, 73,114, 62,114,
 73, 73,  0,  0,103,113, 88, 73, 62, 92, 86,  0, 62, 92,103, 62,
103,  0,  0, 62,116,117, 73, 73, 88, 86, 86,114, 92, 97,114, 86,
 73,  0, 73,110, 88,  0, 62,  0,103, 97,  0, 62, 92,114,114, 93,
 92,109, 86, 73,114,103, 73,  0,114, 86, 73,114,114, 93,113,102,
 93,  0, 97,  0,103, 93, 73,102,113, 97, 97, 73, 62,103,103, 93,
103, 62,103, 73,113,103, 92, 92, 62, 93, 73, 93, 93, 92, 97,103,
 73, 73, 62, 62,  0,  0, 73,113,111,103, 73, 97,  0, 97,114,103,
102, 62,103,114, 62, 92,103, 70, 73,102,103,103, 73,  0, 73, 62,
114, 86,102, 73, 73, 73, 62,  0, 73, 73,103,103, 93, 73, 73,102,
 73,103,103, 73,103, 73, 73,102, 73, 70, 62,114, 62,102, 93, 62,
 73,103, 73,103, 70, 62,103,103, 73, 73,113,113, 73, 73,113, 92,
 97, 97,113, 62, 92,103,103,103,103, 73, 62, 73, 73,103,103,113,
 92,113, 86, 92, 73, 73, 92,113, 62, 62,113, 73,113, 62,103,103,
103,103, 92, 62, 73,103, 92,113, 73, 73,103, 73,  0, 62, 73, 97,
 97,  0,  0, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,113,  0, 62,
117,103,103,  0,103,113, 62, 62, 73, 97, 97, 97,113, 86, 62, 97,
 93, 62,103, 62, 73, 62,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,
106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,
106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,
106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,
106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,
106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,
106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,
106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,
106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,
106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,
106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,
106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,
106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,
106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,
106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,
106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,
106,106,106,106,106,106,106,106,106,106,106,106, 73, 73,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 73, 73,  0, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73,
 73, 73, 73, 73, 73,  0,  0,  0,  0, 73, 73, 73, 73, 73, 73, 73,
 73,  0, 73,  0, 73, 73, 73, 73,  0, 73, 73, 73, 73, 73, 73, 73,
 73, 73, 73, 73, 73, 73, 73,  0,  0, 73, 73, 73,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 93, 97, 93, 93, 93, 93, 97, 93, 93, 93, 93, 93, 72, 93, 93,
 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 88, 72, 88, 88, 93,
 88, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 97,  0,
  0, 104, 104, 104, 94, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104,
 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104,
 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104,
 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 97, 97,  0, 88,  0, 88,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 105,
};
