/* rygel-seekable-response.c generated by valac 0.11.2, the Vala compiler
 * generated from rygel-seekable-response.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2008 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;
typedef struct _RygelHTTPResponsePrivate RygelHTTPResponsePrivate;

#define RYGEL_TYPE_SEEKABLE_RESPONSE (rygel_seekable_response_get_type ())
#define RYGEL_SEEKABLE_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEEKABLE_RESPONSE, RygelSeekableResponse))
#define RYGEL_SEEKABLE_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEEKABLE_RESPONSE, RygelSeekableResponseClass))
#define RYGEL_IS_SEEKABLE_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEEKABLE_RESPONSE))
#define RYGEL_IS_SEEKABLE_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEEKABLE_RESPONSE))
#define RYGEL_SEEKABLE_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEEKABLE_RESPONSE, RygelSeekableResponseClass))

typedef struct _RygelSeekableResponse RygelSeekableResponse;
typedef struct _RygelSeekableResponseClass RygelSeekableResponseClass;
typedef struct _RygelSeekableResponsePrivate RygelSeekableResponsePrivate;

#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelSeekableResponseRunData RygelSeekableResponseRunData;
typedef struct _RygelSeekableResponsePerformSeekData RygelSeekableResponsePerformSeekData;
typedef struct _RygelSeekableResponseStartReadingData RygelSeekableResponseStartReadingData;
typedef struct _RygelSeekableResponseReadContentsData RygelSeekableResponseReadContentsData;
typedef struct _RygelSeekableResponseCloseStreamData RygelSeekableResponseCloseStreamData;

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelHTTPResponse {
	GObject parent_instance;
	RygelHTTPResponsePrivate * priv;
	SoupMessage* msg;
	GSourceFunc run_continue;
	gpointer run_continue_target;
	GDestroyNotify run_continue_target_destroy_notify;
};

struct _RygelHTTPResponseClass {
	GObjectClass parent_class;
	void (*run) (RygelHTTPResponse* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelHTTPResponse* self, GAsyncResult* _res_);
	void (*end) (RygelHTTPResponse* self, gboolean aborted, guint status);
};

struct _RygelSeekableResponse {
	RygelHTTPResponse parent_instance;
	RygelSeekableResponsePrivate * priv;
};

struct _RygelSeekableResponseClass {
	RygelHTTPResponseClass parent_class;
};

struct _RygelSeekableResponsePrivate {
	RygelHTTPSeek* seek;
	GFile* file;
	GFileInputStream* input_stream;
	guint8* buffer;
	gint buffer_length1;
	gint _buffer_size_;
	gsize total_length;
	gint priority;
};

struct _RygelSeekableResponseRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSeekableResponse* self;
	GCancellable* _tmp0_;
	GFileInputStream* _tmp1_;
	GFileInputStream* _tmp2_;
	GFileInputStream* _tmp3_;
	GError * err;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GError * _inner_error_;
};

struct _RygelSeekableResponsePerformSeekData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSeekableResponse* self;
	gint64 _tmp0_;
	GCancellable* _tmp1_;
	GError * err;
	const gchar* _tmp2_;
	gint64 _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gint64 _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GError * _inner_error_;
};

struct _RygelSeekableResponseStartReadingData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSeekableResponse* self;
	GError * cancelled_err;
	GError * err;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GError * _inner_error_;
};

struct _RygelSeekableResponseReadContentsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSeekableResponse* self;
	GCancellable* _tmp0_;
	gssize _tmp1_;
	gssize bytes_read;
	guint8* _tmp2_;
	guint8* _tmp3_;
	gint data_length1;
	gint _data_size_;
	guint8* _tmp4_;
	guint8* data;
	GSourceFunc _tmp5_;
	GSourceFunc _tmp6_;
	gboolean _tmp7_;
	GCancellable* _tmp8_;
	GCancellable* _tmp9_;
	gboolean _tmp10_;
	GCancellable* _tmp11_;
	gssize _tmp12_;
	gssize _tmp13_;
	GError * _inner_error_;
};

struct _RygelSeekableResponseCloseStreamData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSeekableResponse* self;
	GCancellable* _tmp0_;
	GError * err;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	GCancellable* _tmp5_;
	GCancellable* _tmp6_;
	gboolean _tmp7_;
	GError * _inner_error_;
};


static gpointer rygel_seekable_response_parent_class = NULL;

GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_http_response_get_type (void) G_GNUC_CONST;
GType rygel_seekable_response_get_type (void) G_GNUC_CONST;
GType rygel_http_seek_get_type (void) G_GNUC_CONST;
#define RYGEL_SEEKABLE_RESPONSE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_SEEKABLE_RESPONSE, RygelSeekableResponsePrivate))
enum  {
	RYGEL_SEEKABLE_RESPONSE_DUMMY_PROPERTY
};
#define RYGEL_SEEKABLE_RESPONSE_BUFFER_LENGTH ((gsize) 65536)
RygelSeekableResponse* rygel_seekable_response_new (SoupServer* server, SoupMessage* msg, const gchar* uri, RygelHTTPSeek* seek, gint64 file_length, GCancellable* cancellable);
RygelSeekableResponse* rygel_seekable_response_construct (GType object_type, SoupServer* server, SoupMessage* msg, const gchar* uri, RygelHTTPSeek* seek, gint64 file_length, GCancellable* cancellable);
gint64 rygel_http_seek_get_length (RygelHTTPSeek* self);
RygelHTTPResponse* rygel_http_response_construct (GType object_type, SoupServer* server, SoupMessage* msg, gboolean partial, GCancellable* cancellable);
static gint rygel_seekable_response_get_requested_priority (RygelSeekableResponse* self);
static void rygel_seekable_response_real_run_data_free (gpointer _data);
static void rygel_seekable_response_real_run (RygelHTTPResponse* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_seekable_response_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_seekable_response_real_run_co (RygelSeekableResponseRunData* data);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
void rygel_http_response_end (RygelHTTPResponse* self, gboolean aborted, guint status);
static void rygel_seekable_response_perform_seek (RygelSeekableResponse* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_seekable_response_perform_seek_finish (RygelSeekableResponse* self, GAsyncResult* _res_);
static void rygel_seekable_response_perform_seek_data_free (gpointer _data);
static void rygel_seekable_response_perform_seek_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_seekable_response_perform_seek_co (RygelSeekableResponsePerformSeekData* data);
gint64 rygel_http_seek_get_start (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_stop (RygelHTTPSeek* self);
static void rygel_seekable_response_start_reading (RygelSeekableResponse* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_seekable_response_start_reading_finish (RygelSeekableResponse* self, GAsyncResult* _res_);
static void rygel_seekable_response_start_reading_data_free (gpointer _data);
static void rygel_seekable_response_start_reading_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_seekable_response_start_reading_co (RygelSeekableResponseStartReadingData* data);
static void rygel_seekable_response_read_contents (RygelSeekableResponse* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_seekable_response_read_contents_finish (RygelSeekableResponse* self, GAsyncResult* _res_, GError** error);
static void rygel_seekable_response_close_stream (RygelSeekableResponse* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_seekable_response_close_stream_finish (RygelSeekableResponse* self, GAsyncResult* _res_);
static void rygel_seekable_response_read_contents_data_free (gpointer _data);
static void rygel_seekable_response_read_contents_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_seekable_response_read_contents_co (RygelSeekableResponseReadContentsData* data);
static void _lambda4_ (SoupMessage* msg, RygelSeekableResponse* self);
static void __lambda4__soup_message_wrote_chunk (SoupMessage* _sender, gpointer self);
static guint8* _vala_array_dup1 (guint8* self, int length);
void rygel_http_response_push_data (RygelHTTPResponse* self, guint8* data, int data_length1);
static gboolean _rygel_seekable_response_read_contents_co_gsource_func (gpointer self);
static void rygel_seekable_response_close_stream_data_free (gpointer _data);
static void rygel_seekable_response_close_stream_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_seekable_response_close_stream_co (RygelSeekableResponseCloseStreamData* data);
static void rygel_seekable_response_finalize (GObject* obj);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelSeekableResponse* rygel_seekable_response_construct (GType object_type, SoupServer* server, SoupMessage* msg, const gchar* uri, RygelHTTPSeek* seek, gint64 file_length, GCancellable* cancellable) {
	RygelSeekableResponse * self = NULL;
	gint64 _tmp0_;
	gboolean partial;
	RygelHTTPSeek* _tmp1_;
	RygelHTTPSeek* _tmp2_;
	gint _tmp3_;
	gint64 _tmp4_;
	guint8* _tmp5_ = NULL;
	guint8* _tmp6_;
	GFile* _tmp7_ = NULL;
	GFile* _tmp8_;
	g_return_val_if_fail (server != NULL, NULL);
	g_return_val_if_fail (msg != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (seek != NULL, NULL);
	_tmp0_ = rygel_http_seek_get_length (seek);
	partial = _tmp0_ < file_length;
	self = (RygelSeekableResponse*) rygel_http_response_construct (object_type, server, msg, partial, cancellable);
	_tmp1_ = _g_object_ref0 (seek);
	_tmp2_ = _tmp1_;
	_g_object_unref0 (self->priv->seek);
	self->priv->seek = _tmp2_;
	_tmp3_ = rygel_seekable_response_get_requested_priority (self);
	self->priv->priority = _tmp3_;
	_tmp4_ = rygel_http_seek_get_length (seek);
	self->priv->total_length = (gsize) _tmp4_;
	_tmp5_ = g_new0 (guint8, RYGEL_SEEKABLE_RESPONSE_BUFFER_LENGTH);
	_tmp6_ = _tmp5_;
	self->priv->buffer = (g_free (self->priv->buffer), NULL);
	self->priv->buffer_length1 = RYGEL_SEEKABLE_RESPONSE_BUFFER_LENGTH;
	self->priv->_buffer_size_ = self->priv->buffer_length1;
	self->priv->buffer = _tmp6_;
	_tmp7_ = g_file_new_for_uri (uri);
	_tmp8_ = _tmp7_;
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp8_;
	return self;
}


RygelSeekableResponse* rygel_seekable_response_new (SoupServer* server, SoupMessage* msg, const gchar* uri, RygelHTTPSeek* seek, gint64 file_length, GCancellable* cancellable) {
	return rygel_seekable_response_construct (RYGEL_TYPE_SEEKABLE_RESPONSE, server, msg, uri, seek, file_length, cancellable);
}


static void rygel_seekable_response_real_run_data_free (gpointer _data) {
	RygelSeekableResponseRunData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (RygelSeekableResponseRunData, data);
}


static void rygel_seekable_response_real_run (RygelHTTPResponse* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSeekableResponse * self;
	RygelSeekableResponseRunData* _data_;
	self = (RygelSeekableResponse*) base;
	_data_ = g_slice_new0 (RygelSeekableResponseRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_seekable_response_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_seekable_response_real_run_data_free);
	_data_->self = _g_object_ref0 (self);
	rygel_seekable_response_real_run_co (_data_);
}


static void rygel_seekable_response_real_run_finish (RygelHTTPResponse* base, GAsyncResult* _res_) {
	RygelSeekableResponseRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_seekable_response_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSeekableResponseRunData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_seekable_response_real_run_co (data);
}


static gboolean rygel_seekable_response_real_run_co (RygelSeekableResponseRunData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self);
	data->_state_ = 1;
	g_file_read_async (data->self->priv->file, data->self->priv->priority, data->_tmp0_, rygel_seekable_response_run_ready, data);
	return FALSE;
	_state_1:
	data->_tmp1_ = NULL;
	data->_tmp1_ = g_file_read_finish (data->self->priv->file, data->_res_, &data->_inner_error_);
	data->_tmp2_ = data->_tmp1_;
	if (data->_inner_error_ != NULL) {
		goto __catch33_g_error;
	}
	data->_tmp3_ = data->_tmp2_;
	_g_object_unref0 (data->self->priv->input_stream);
	data->self->priv->input_stream = data->_tmp3_;
	goto __finally33;
	__catch33_g_error:
	{
		data->err = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp4_ = NULL;
		data->_tmp4_ = _ ("Failed to read from URI: %s: %s");
		data->_tmp5_ = NULL;
		data->_tmp5_ = g_file_get_uri (data->self->priv->file);
		data->_tmp6_ = data->_tmp5_;
		g_warning (data->_tmp4_, data->_tmp6_, data->err->message);
		_g_free0 (data->_tmp6_);
		rygel_http_response_end ((RygelHTTPResponse*) data->self, FALSE, (guint) SOUP_STATUS_NOT_FOUND);
		_g_error_free0 (data->err);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	__finally33:
	if (data->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->_state_ = 2;
	rygel_seekable_response_perform_seek (data->self, rygel_seekable_response_run_ready, data);
	return FALSE;
	_state_2:
	rygel_seekable_response_perform_seek_finish (data->self, data->_res_);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void rygel_seekable_response_perform_seek_data_free (gpointer _data) {
	RygelSeekableResponsePerformSeekData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (RygelSeekableResponsePerformSeekData, data);
}


static void rygel_seekable_response_perform_seek (RygelSeekableResponse* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSeekableResponsePerformSeekData* _data_;
	_data_ = g_slice_new0 (RygelSeekableResponsePerformSeekData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_seekable_response_perform_seek);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_seekable_response_perform_seek_data_free);
	_data_->self = _g_object_ref0 (self);
	rygel_seekable_response_perform_seek_co (_data_);
}


static void rygel_seekable_response_perform_seek_finish (RygelSeekableResponse* self, GAsyncResult* _res_) {
	RygelSeekableResponsePerformSeekData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_seekable_response_perform_seek_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSeekableResponsePerformSeekData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_seekable_response_perform_seek_co (data);
}


static gboolean rygel_seekable_response_perform_seek_co (RygelSeekableResponsePerformSeekData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = rygel_http_seek_get_start (data->self->priv->seek);
	data->_tmp1_ = NULL;
	data->_tmp1_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self);
	G_FILE_INPUT_STREAM_GET_CLASS (data->self->priv->input_stream)->seek (data->self->priv->input_stream, data->_tmp0_, G_SEEK_SET, data->_tmp1_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		goto __catch34_g_error;
	}
	goto __finally34;
	__catch34_g_error:
	{
		data->err = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp2_ = NULL;
		data->_tmp2_ = _ ("Failed to seek to %s-%s on URI %s: %s");
		data->_tmp3_ = rygel_http_seek_get_start (data->self->priv->seek);
		data->_tmp4_ = NULL;
		data->_tmp4_ = g_strdup_printf ("%" G_GINT64_FORMAT, data->_tmp3_);
		data->_tmp5_ = data->_tmp4_;
		data->_tmp6_ = rygel_http_seek_get_stop (data->self->priv->seek);
		data->_tmp7_ = NULL;
		data->_tmp7_ = g_strdup_printf ("%" G_GINT64_FORMAT, data->_tmp6_);
		data->_tmp8_ = data->_tmp7_;
		data->_tmp9_ = NULL;
		data->_tmp9_ = g_file_get_uri (data->self->priv->file);
		data->_tmp10_ = data->_tmp9_;
		g_warning (data->_tmp2_, data->_tmp5_, data->_tmp8_, data->_tmp10_, data->err->message);
		_g_free0 (data->_tmp10_);
		_g_free0 (data->_tmp8_);
		_g_free0 (data->_tmp5_);
		rygel_http_response_end ((RygelHTTPResponse*) data->self, FALSE, (guint) SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE);
		_g_error_free0 (data->err);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	__finally34:
	if (data->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->_state_ = 1;
	rygel_seekable_response_start_reading (data->self, rygel_seekable_response_perform_seek_ready, data);
	return FALSE;
	_state_1:
	rygel_seekable_response_start_reading_finish (data->self, data->_res_);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void rygel_seekable_response_start_reading_data_free (gpointer _data) {
	RygelSeekableResponseStartReadingData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (RygelSeekableResponseStartReadingData, data);
}


static void rygel_seekable_response_start_reading (RygelSeekableResponse* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSeekableResponseStartReadingData* _data_;
	_data_ = g_slice_new0 (RygelSeekableResponseStartReadingData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_seekable_response_start_reading);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_seekable_response_start_reading_data_free);
	_data_->self = _g_object_ref0 (self);
	rygel_seekable_response_start_reading_co (_data_);
}


static void rygel_seekable_response_start_reading_finish (RygelSeekableResponse* self, GAsyncResult* _res_) {
	RygelSeekableResponseStartReadingData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_seekable_response_start_reading_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSeekableResponseStartReadingData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_seekable_response_start_reading_co (data);
}


static gboolean rygel_seekable_response_start_reading_co (RygelSeekableResponseStartReadingData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_state_ = 1;
	rygel_seekable_response_read_contents (data->self, rygel_seekable_response_start_reading_ready, data);
	return FALSE;
	_state_1:
	rygel_seekable_response_read_contents_finish (data->self, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		if (g_error_matches (data->_inner_error_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
			goto __catch35_g_io_error_cancelled;
		}
		goto __catch35_g_error;
	}
	goto __finally35;
	__catch35_g_io_error_cancelled:
	{
		data->cancelled_err = data->_inner_error_;
		data->_inner_error_ = NULL;
		_g_error_free0 (data->cancelled_err);
	}
	goto __finally35;
	__catch35_g_error:
	{
		data->err = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp0_ = NULL;
		data->_tmp0_ = _ ("Failed to read contents from URI: %s: %s");
		data->_tmp1_ = NULL;
		data->_tmp1_ = g_file_get_uri (data->self->priv->file);
		data->_tmp2_ = data->_tmp1_;
		g_warning (data->_tmp0_, data->_tmp2_, data->err->message);
		_g_free0 (data->_tmp2_);
		rygel_http_response_end ((RygelHTTPResponse*) data->self, FALSE, (guint) SOUP_STATUS_NOT_FOUND);
		_g_error_free0 (data->err);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	__finally35:
	if (data->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->_state_ = 2;
	rygel_seekable_response_close_stream (data->self, rygel_seekable_response_start_reading_ready, data);
	return FALSE;
	_state_2:
	rygel_seekable_response_close_stream_finish (data->self, data->_res_);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void rygel_seekable_response_read_contents_data_free (gpointer _data) {
	RygelSeekableResponseReadContentsData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (RygelSeekableResponseReadContentsData, data);
}


static void rygel_seekable_response_read_contents (RygelSeekableResponse* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSeekableResponseReadContentsData* _data_;
	_data_ = g_slice_new0 (RygelSeekableResponseReadContentsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_seekable_response_read_contents);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_seekable_response_read_contents_data_free);
	_data_->self = _g_object_ref0 (self);
	rygel_seekable_response_read_contents_co (_data_);
}


static void rygel_seekable_response_read_contents_finish (RygelSeekableResponse* self, GAsyncResult* _res_, GError** error) {
	RygelSeekableResponseReadContentsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_seekable_response_read_contents_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSeekableResponseReadContentsData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_seekable_response_read_contents_co (data);
}


static void _lambda4_ (SoupMessage* msg, RygelSeekableResponse* self) {
	g_return_if_fail (msg != NULL);
	if (((RygelHTTPResponse*) self)->run_continue != NULL) {
		((RygelHTTPResponse*) self)->run_continue (((RygelHTTPResponse*) self)->run_continue_target);
	}
}


static void __lambda4__soup_message_wrote_chunk (SoupMessage* _sender, gpointer self) {
	_lambda4_ (_sender, self);
}


static guint8* _vala_array_dup1 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


static gboolean _rygel_seekable_response_read_contents_co_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_seekable_response_read_contents_co (self);
	return result;
}


static gboolean rygel_seekable_response_read_contents_co (RygelSeekableResponseReadContentsData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self);
	data->_state_ = 1;
	g_input_stream_read_async ((GInputStream*) data->self->priv->input_stream, data->self->priv->buffer, (gsize) data->self->priv->buffer_length1, data->self->priv->priority, data->_tmp0_, rygel_seekable_response_read_contents_ready, data);
	return FALSE;
	_state_1:
	data->_tmp1_ = g_input_stream_read_finish ((GInputStream*) data->self->priv->input_stream, data->_res_, &data->_inner_error_);
	data->bytes_read = data->_tmp1_;
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	g_signal_connect_object (((RygelHTTPResponse*) data->self)->msg, "wrote-chunk", (GCallback) __lambda4__soup_message_wrote_chunk, data->self, 0);
	while (TRUE) {
		if (!(data->bytes_read > 0)) {
			break;
		}
		data->_tmp2_ = (data->_tmp3_ = data->self->priv->buffer + 0, (data->_tmp3_ == NULL) ? ((gpointer) data->_tmp3_) : _vala_array_dup1 (data->_tmp3_, data->bytes_read - 0));
		data->_tmp4_ = data->_tmp2_;
		data->data_length1 = data->bytes_read - 0;
		data->_data_size_ = data->data_length1;
		data->data = data->_tmp4_;
		rygel_http_response_push_data ((RygelHTTPResponse*) data->self, data->data, data->data_length1);
		data->self->priv->total_length = data->self->priv->total_length - ((gsize) data->bytes_read);
		data->_tmp5_ = _rygel_seekable_response_read_contents_co_gsource_func;
		(((RygelHTTPResponse*) data->self)->run_continue_target_destroy_notify == NULL) ? NULL : (((RygelHTTPResponse*) data->self)->run_continue_target_destroy_notify (((RygelHTTPResponse*) data->self)->run_continue_target), NULL);
		((RygelHTTPResponse*) data->self)->run_continue = NULL;
		((RygelHTTPResponse*) data->self)->run_continue_target = NULL;
		((RygelHTTPResponse*) data->self)->run_continue_target_destroy_notify = NULL;
		((RygelHTTPResponse*) data->self)->run_continue_target = data;
		((RygelHTTPResponse*) data->self)->run_continue_target_destroy_notify = NULL;
		((RygelHTTPResponse*) data->self)->run_continue = data->_tmp5_;
		data->_state_ = 2;
		return FALSE;
		_state_2:
		;
		data->_tmp6_ = NULL;
		(((RygelHTTPResponse*) data->self)->run_continue_target_destroy_notify == NULL) ? NULL : (((RygelHTTPResponse*) data->self)->run_continue_target_destroy_notify (((RygelHTTPResponse*) data->self)->run_continue_target), NULL);
		((RygelHTTPResponse*) data->self)->run_continue = NULL;
		((RygelHTTPResponse*) data->self)->run_continue_target = NULL;
		((RygelHTTPResponse*) data->self)->run_continue_target_destroy_notify = NULL;
		((RygelHTTPResponse*) data->self)->run_continue_target = NULL;
		((RygelHTTPResponse*) data->self)->run_continue_target_destroy_notify = NULL;
		((RygelHTTPResponse*) data->self)->run_continue = data->_tmp6_;
		data->_tmp8_ = NULL;
		data->_tmp8_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self);
		if (data->_tmp8_ != NULL) {
			data->_tmp9_ = NULL;
			data->_tmp9_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self);
			data->_tmp10_ = g_cancellable_is_cancelled (data->_tmp9_);
			data->_tmp7_ = data->_tmp10_;
		} else {
			data->_tmp7_ = FALSE;
		}
		if (data->_tmp7_) {
			data->data = (g_free (data->data), NULL);
			break;
		}
		data->_tmp11_ = NULL;
		data->_tmp11_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self);
		data->_state_ = 3;
		g_input_stream_read_async ((GInputStream*) data->self->priv->input_stream, data->self->priv->buffer, (gsize) data->self->priv->buffer_length1, data->self->priv->priority, data->_tmp11_, rygel_seekable_response_read_contents_ready, data);
		return FALSE;
		_state_3:
		data->_tmp12_ = g_input_stream_read_finish ((GInputStream*) data->self->priv->input_stream, data->_res_, &data->_inner_error_);
		data->_tmp13_ = data->_tmp12_;
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			data->data = (g_free (data->data), NULL);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		data->bytes_read = data->_tmp13_;
		data->data = (g_free (data->data), NULL);
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void rygel_seekable_response_close_stream_data_free (gpointer _data) {
	RygelSeekableResponseCloseStreamData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (RygelSeekableResponseCloseStreamData, data);
}


static void rygel_seekable_response_close_stream (RygelSeekableResponse* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSeekableResponseCloseStreamData* _data_;
	_data_ = g_slice_new0 (RygelSeekableResponseCloseStreamData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_seekable_response_close_stream);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_seekable_response_close_stream_data_free);
	_data_->self = _g_object_ref0 (self);
	rygel_seekable_response_close_stream_co (_data_);
}


static void rygel_seekable_response_close_stream_finish (RygelSeekableResponse* self, GAsyncResult* _res_) {
	RygelSeekableResponseCloseStreamData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_seekable_response_close_stream_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSeekableResponseCloseStreamData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_seekable_response_close_stream_co (data);
}


static gboolean rygel_seekable_response_close_stream_co (RygelSeekableResponseCloseStreamData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self);
	data->_state_ = 1;
	g_input_stream_close_async ((GInputStream*) data->self->priv->input_stream, data->self->priv->priority, data->_tmp0_, rygel_seekable_response_close_stream_ready, data);
	return FALSE;
	_state_1:
	g_input_stream_close_finish ((GInputStream*) data->self->priv->input_stream, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		goto __catch36_g_error;
	}
	goto __finally36;
	__catch36_g_error:
	{
		data->err = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp1_ = NULL;
		data->_tmp1_ = _ ("Failed to close stream to URI %s: %s");
		data->_tmp2_ = NULL;
		data->_tmp2_ = g_file_get_uri (data->self->priv->file);
		data->_tmp3_ = data->_tmp2_;
		g_warning (data->_tmp1_, data->_tmp3_, data->err->message);
		_g_free0 (data->_tmp3_);
		_g_error_free0 (data->err);
	}
	__finally36:
	if (data->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->_tmp5_ = NULL;
	data->_tmp5_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self);
	if (data->_tmp5_ == NULL) {
		data->_tmp4_ = TRUE;
	} else {
		data->_tmp6_ = NULL;
		data->_tmp6_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self);
		data->_tmp7_ = g_cancellable_is_cancelled (data->_tmp6_);
		data->_tmp4_ = !data->_tmp7_;
	}
	if (data->_tmp4_) {
		rygel_http_response_end ((RygelHTTPResponse*) data->self, FALSE, (guint) SOUP_STATUS_NONE);
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static gint rygel_seekable_response_get_requested_priority (RygelSeekableResponse* self) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* mode;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = soup_message_headers_get_one (((RygelHTTPResponse*) self)->msg->request_headers, "transferMode.dlna.org");
	_tmp1_ = g_strdup (_tmp0_);
	mode = _tmp1_;
	if (mode == NULL) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = g_strcmp0 (mode, "Interactive") == 0;
	}
	if (_tmp2_) {
		result = G_PRIORITY_DEFAULT;
		_g_free0 (mode);
		return result;
	} else {
		if (g_strcmp0 (mode, "Streaming") == 0) {
			result = G_PRIORITY_HIGH;
			_g_free0 (mode);
			return result;
		} else {
			if (g_strcmp0 (mode, "Background") == 0) {
				result = G_PRIORITY_LOW;
				_g_free0 (mode);
				return result;
			} else {
				result = G_PRIORITY_DEFAULT;
				_g_free0 (mode);
				return result;
			}
		}
	}
	_g_free0 (mode);
}


static void rygel_seekable_response_class_init (RygelSeekableResponseClass * klass) {
	rygel_seekable_response_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelSeekableResponsePrivate));
	RYGEL_HTTP_RESPONSE_CLASS (klass)->run = rygel_seekable_response_real_run;
	RYGEL_HTTP_RESPONSE_CLASS (klass)->run_finish = rygel_seekable_response_real_run_finish;
	G_OBJECT_CLASS (klass)->finalize = rygel_seekable_response_finalize;
}


static void rygel_seekable_response_instance_init (RygelSeekableResponse * self) {
	self->priv = RYGEL_SEEKABLE_RESPONSE_GET_PRIVATE (self);
}


static void rygel_seekable_response_finalize (GObject* obj) {
	RygelSeekableResponse * self;
	self = RYGEL_SEEKABLE_RESPONSE (obj);
	_g_object_unref0 (self->priv->seek);
	_g_object_unref0 (self->priv->file);
	_g_object_unref0 (self->priv->input_stream);
	self->priv->buffer = (g_free (self->priv->buffer), NULL);
	G_OBJECT_CLASS (rygel_seekable_response_parent_class)->finalize (obj);
}


GType rygel_seekable_response_get_type (void) {
	static volatile gsize rygel_seekable_response_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_seekable_response_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelSeekableResponseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_seekable_response_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSeekableResponse), 0, (GInstanceInitFunc) rygel_seekable_response_instance_init, NULL };
		GType rygel_seekable_response_type_id;
		rygel_seekable_response_type_id = g_type_register_static (RYGEL_TYPE_HTTP_RESPONSE, "RygelSeekableResponse", &g_define_type_info, 0);
		g_once_init_leave (&rygel_seekable_response_type_id__volatile, rygel_seekable_response_type_id);
	}
	return rygel_seekable_response_type_id__volatile;
}



