/* rygel-mpris-plugin.c generated by valac 0.11.2, the Vala compiler
 * generated from rygel-mpris-plugin.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2008 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>


#define RYGEL_MPRIS_TYPE_PLUGIN (rygel_mpris_plugin_get_type ())
#define RYGEL_MPRIS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MPRIS_TYPE_PLUGIN, RygelMPRISPlugin))
#define RYGEL_MPRIS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MPRIS_TYPE_PLUGIN, RygelMPRISPluginClass))
#define RYGEL_MPRIS_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MPRIS_TYPE_PLUGIN))
#define RYGEL_MPRIS_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MPRIS_TYPE_PLUGIN))
#define RYGEL_MPRIS_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MPRIS_TYPE_PLUGIN, RygelMPRISPluginClass))

typedef struct _RygelMPRISPlugin RygelMPRISPlugin;
typedef struct _RygelMPRISPluginClass RygelMPRISPluginClass;
typedef struct _RygelMPRISPluginPrivate RygelMPRISPluginPrivate;

#define RYGEL_MPRIS_MEDIA_PLAYER_TYPE_PLAYER_PROXY (rygel_mpris_media_player_player_proxy_get_type ())
#define RYGEL_MPRIS_MEDIA_PLAYER_PLAYER_PROXY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MPRIS_MEDIA_PLAYER_TYPE_PLAYER_PROXY, RygelMPRISMediaPlayerPlayerProxy))
#define RYGEL_MPRIS_MEDIA_PLAYER_IS_PLAYER_PROXY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MPRIS_MEDIA_PLAYER_TYPE_PLAYER_PROXY))
#define RYGEL_MPRIS_MEDIA_PLAYER_PLAYER_PROXY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_MPRIS_MEDIA_PLAYER_TYPE_PLAYER_PROXY, RygelMPRISMediaPlayerPlayerProxyIface))

typedef struct _RygelMPRISMediaPlayerPlayerProxy RygelMPRISMediaPlayerPlayerProxy;
typedef struct _RygelMPRISMediaPlayerPlayerProxyIface RygelMPRISMediaPlayerPlayerProxyIface;

#define RYGEL_MPRIS_MEDIA_PLAYER_TYPE_PLAYER_PROXY_PROXY (rygel_mpris_media_player_player_proxy_proxy_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_MPRIS_TYPE_PLAYER (rygel_mpris_player_get_type ())
#define RYGEL_MPRIS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MPRIS_TYPE_PLAYER, RygelMPRISPlayer))
#define RYGEL_MPRIS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MPRIS_TYPE_PLAYER, RygelMPRISPlayerClass))
#define RYGEL_MPRIS_IS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MPRIS_TYPE_PLAYER))
#define RYGEL_MPRIS_IS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MPRIS_TYPE_PLAYER))
#define RYGEL_MPRIS_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MPRIS_TYPE_PLAYER, RygelMPRISPlayerClass))

typedef struct _RygelMPRISPlayer RygelMPRISPlayer;
typedef struct _RygelMPRISPlayerClass RygelMPRISPlayerClass;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _RygelMPRISPlugin {
	RygelMediaRendererPlugin parent_instance;
	RygelMPRISPluginPrivate * priv;
};

struct _RygelMPRISPluginClass {
	RygelMediaRendererPluginClass parent_class;
};

struct _RygelMPRISMediaPlayerPlayerProxyIface {
	GTypeInterface parent_iface;
	void (*pause) (RygelMPRISMediaPlayerPlayerProxy* self, GError** error);
	void (*play_pause) (RygelMPRISMediaPlayerPlayerProxy* self, GError** error);
	void (*stop) (RygelMPRISMediaPlayerPlayerProxy* self, GError** error);
	void (*play) (RygelMPRISMediaPlayerPlayerProxy* self, GError** error);
	void (*seek) (RygelMPRISMediaPlayerPlayerProxy* self, gint64 offset, GError** error);
	void (*open_uri) (RygelMPRISMediaPlayerPlayerProxy* self, const gchar* uri, GError** error);
	gchar* (*get_playback_status) (RygelMPRISMediaPlayerPlayerProxy* self);
	gdouble (*get_volume) (RygelMPRISMediaPlayerPlayerProxy* self);
	void (*set_volume) (RygelMPRISMediaPlayerPlayerProxy* self, gdouble value);
	gint64 (*get_position) (RygelMPRISMediaPlayerPlayerProxy* self);
	GHashTable* (*get_metadata) (RygelMPRISMediaPlayerPlayerProxy* self);
};

struct _RygelMPRISPluginPrivate {
	RygelMPRISMediaPlayerPlayerProxy* actual_player;
	FreeDesktopProperties* properties;
	gchar** mime_types;
	gint mime_types_length1;
	gint _mime_types_size_;
	gchar** protocols;
	gint protocols_length1;
	gint _protocols_size_;
};


static gpointer rygel_mpris_plugin_parent_class = NULL;

GType rygel_mpris_plugin_get_type (void) G_GNUC_CONST;
GType rygel_mpris_media_player_player_proxy_proxy_get_type (void) G_GNUC_CONST;
guint rygel_mpris_media_player_player_proxy_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType rygel_mpris_media_player_player_proxy_get_type (void) G_GNUC_CONST;
#define RYGEL_MPRIS_PLUGIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MPRIS_TYPE_PLUGIN, RygelMPRISPluginPrivate))
enum  {
	RYGEL_MPRIS_PLUGIN_DUMMY_PROPERTY
};
#define RYGEL_MPRIS_PLUGIN_MEDIA_PLAYER_PATH "/org/mpris/MediaPlayer2"
RygelMPRISPlugin* rygel_mpris_plugin_new (const gchar* service_name, const gchar* title, gchar** mime_types, int mime_types_length1, gchar** schemes, int schemes_length1);
RygelMPRISPlugin* rygel_mpris_plugin_construct (GType object_type, const gchar* service_name, const gchar* title, gchar** mime_types, int mime_types_length1, gchar** schemes, int schemes_length1);
static gchar** _vala_array_dup5 (gchar** self, int length);
static gchar** rygel_mpris_plugin_schemes_to_protocols (RygelMPRISPlugin* self, gchar** schemes, int schemes_length1, int* result_length1);
static RygelMediaPlayer* rygel_mpris_plugin_real_get_player (RygelMediaRendererPlugin* base);
RygelMPRISPlayer* rygel_mpris_player_new (RygelMPRISMediaPlayerPlayerProxy* actual_player, FreeDesktopProperties* properties, gchar** mime_types, int mime_types_length1, gchar** protocols, int protocols_length1);
RygelMPRISPlayer* rygel_mpris_player_construct (GType object_type, RygelMPRISMediaPlayerPlayerProxy* actual_player, FreeDesktopProperties* properties, gchar** mime_types, int mime_types_length1, gchar** protocols, int protocols_length1);
GType rygel_mpris_player_get_type (void) G_GNUC_CONST;
static gchar* rygel_mpris_plugin_scheme_to_protocol (RygelMPRISPlugin* self, const gchar* scheme);
static void rygel_mpris_plugin_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gchar** _vala_array_dup5 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


RygelMPRISPlugin* rygel_mpris_plugin_construct (GType object_type, const gchar* service_name, const gchar* title, gchar** mime_types, int mime_types_length1, gchar** schemes, int schemes_length1) {
	RygelMPRISPlugin * self = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp3_;
	gchar** _tmp4_ = NULL;
	gchar** _tmp5_;
	RygelMPRISMediaPlayerPlayerProxy* _tmp6_;
	RygelMPRISMediaPlayerPlayerProxy* _tmp7_;
	FreeDesktopProperties* _tmp8_;
	FreeDesktopProperties* _tmp9_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (service_name != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	self = (RygelMPRISPlugin*) rygel_media_renderer_plugin_construct (object_type, service_name, title, NULL);
	_tmp0_ = (_tmp1_ = mime_types, (_tmp1_ == NULL) ? ((gpointer) _tmp1_) : _vala_array_dup5 (_tmp1_, mime_types_length1));
	_tmp2_ = _tmp0_;
	self->priv->mime_types = (_vala_array_free (self->priv->mime_types, self->priv->mime_types_length1, (GDestroyNotify) g_free), NULL);
	self->priv->mime_types_length1 = mime_types_length1;
	self->priv->_mime_types_size_ = self->priv->mime_types_length1;
	self->priv->mime_types = _tmp2_;
	_tmp4_ = rygel_mpris_plugin_schemes_to_protocols (self, schemes, schemes_length1, &_tmp3_);
	_tmp5_ = _tmp4_;
	self->priv->protocols = (_vala_array_free (self->priv->protocols, self->priv->protocols_length1, (GDestroyNotify) g_free), NULL);
	self->priv->protocols_length1 = _tmp3_;
	self->priv->_protocols_size_ = self->priv->protocols_length1;
	self->priv->protocols = _tmp5_;
	_tmp6_ = (RygelMPRISMediaPlayerPlayerProxy*) g_initable_new (RYGEL_MPRIS_MEDIA_PLAYER_TYPE_PLAYER_PROXY_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", service_name, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", RYGEL_MPRIS_PLUGIN_MEDIA_PLAYER_PATH, "g-interface-name", "org.mpris.MediaPlayer2.Player", NULL);
	if (_inner_error_ != NULL) {
		goto __catch5_g_error;
	}
	_tmp7_ = _tmp6_;
	_g_object_unref0 (self->priv->actual_player);
	self->priv->actual_player = _tmp7_;
	_tmp8_ = (FreeDesktopProperties*) g_initable_new (FREE_DESKTOP_TYPE_PROPERTIES_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", service_name, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", RYGEL_MPRIS_PLUGIN_MEDIA_PLAYER_PATH, "g-interface-name", "org.freedesktop.DBus.Properties", NULL);
	if (_inner_error_ != NULL) {
		goto __catch5_g_error;
	}
	_tmp9_ = _tmp8_;
	_g_object_unref0 (self->priv->properties);
	self->priv->properties = _tmp9_;
	goto __finally5;
	__catch5_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("rygel-mpris-plugin.vala:57: Failed to connect to session bus: %s", err->message);
		_g_error_free0 (err);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


RygelMPRISPlugin* rygel_mpris_plugin_new (const gchar* service_name, const gchar* title, gchar** mime_types, int mime_types_length1, gchar** schemes, int schemes_length1) {
	return rygel_mpris_plugin_construct (RYGEL_MPRIS_TYPE_PLUGIN, service_name, title, mime_types, mime_types_length1, schemes, schemes_length1);
}


static RygelMediaPlayer* rygel_mpris_plugin_real_get_player (RygelMediaRendererPlugin* base) {
	RygelMPRISPlugin * self;
	RygelMediaPlayer* result = NULL;
	RygelMPRISPlayer* _tmp0_ = NULL;
	self = (RygelMPRISPlugin*) base;
	_tmp0_ = rygel_mpris_player_new (self->priv->actual_player, self->priv->properties, self->priv->mime_types, self->priv->mime_types_length1, self->priv->protocols, self->priv->protocols_length1);
	result = (RygelMediaPlayer*) _tmp0_;
	return result;
}


static gchar** rygel_mpris_plugin_schemes_to_protocols (RygelMPRISPlugin* self, gchar** schemes, int schemes_length1, int* result_length1) {
	gchar** result = NULL;
	gchar** _tmp0_ = NULL;
	gint protocols_length1;
	gint _protocols_size_;
	gchar** _tmp1_;
	gchar** protocols;
	gchar** _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, schemes_length1 + 1);
	_tmp1_ = _tmp0_;
	protocols_length1 = schemes_length1;
	_protocols_size_ = protocols_length1;
	protocols = _tmp1_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gchar* _tmp3_ = NULL;
				gchar* _tmp4_;
				if (!_tmp2_) {
					i++;
				}
				_tmp2_ = FALSE;
				if (!(i < schemes_length1)) {
					break;
				}
				_tmp3_ = rygel_mpris_plugin_scheme_to_protocol (self, schemes[i]);
				_tmp4_ = _tmp3_;
				_g_free0 (protocols[i]);
				protocols[i] = _tmp4_;
			}
		}
	}
	_tmp5_ = protocols;
	*result_length1 = protocols_length1;
	result = _tmp5_;
	return result;
}


static gchar* rygel_mpris_plugin_scheme_to_protocol (RygelMPRISPlugin* self, const gchar* scheme) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	GQuark _tmp1_;
	static GQuark _tmp1__label0 = 0;
	static GQuark _tmp1__label1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (scheme != NULL, NULL);
	_tmp0_ = scheme;
	_tmp1_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp1_ == ((0 != _tmp1__label0) ? _tmp1__label0 : (_tmp1__label0 = g_quark_from_static_string ("http")))) {
		switch (0) {
			default:
			{
				gchar* _tmp2_;
				_tmp2_ = g_strdup ("http-get");
				result = _tmp2_;
				return result;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label1) ? _tmp1__label1 : (_tmp1__label1 = g_quark_from_static_string ("file")))) {
		switch (0) {
			default:
			{
				gchar* _tmp3_;
				_tmp3_ = g_strdup ("internal");
				result = _tmp3_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gchar* _tmp4_;
				_tmp4_ = g_strdup (scheme);
				result = _tmp4_;
				return result;
			}
		}
	}
}


static void rygel_mpris_plugin_class_init (RygelMPRISPluginClass * klass) {
	rygel_mpris_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMPRISPluginPrivate));
	RYGEL_MEDIA_RENDERER_PLUGIN_CLASS (klass)->get_player = rygel_mpris_plugin_real_get_player;
	G_OBJECT_CLASS (klass)->finalize = rygel_mpris_plugin_finalize;
}


static void rygel_mpris_plugin_instance_init (RygelMPRISPlugin * self) {
	self->priv = RYGEL_MPRIS_PLUGIN_GET_PRIVATE (self);
}


static void rygel_mpris_plugin_finalize (GObject* obj) {
	RygelMPRISPlugin * self;
	self = RYGEL_MPRIS_PLUGIN (obj);
	_g_object_unref0 (self->priv->actual_player);
	_g_object_unref0 (self->priv->properties);
	self->priv->mime_types = (_vala_array_free (self->priv->mime_types, self->priv->mime_types_length1, (GDestroyNotify) g_free), NULL);
	self->priv->protocols = (_vala_array_free (self->priv->protocols, self->priv->protocols_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (rygel_mpris_plugin_parent_class)->finalize (obj);
}


GType rygel_mpris_plugin_get_type (void) {
	static volatile gsize rygel_mpris_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_mpris_plugin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMPRISPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_mpris_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMPRISPlugin), 0, (GInstanceInitFunc) rygel_mpris_plugin_instance_init, NULL };
		GType rygel_mpris_plugin_type_id;
		rygel_mpris_plugin_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, "RygelMPRISPlugin", &g_define_type_info, 0);
		g_once_init_leave (&rygel_mpris_plugin_type_id__volatile, rygel_mpris_plugin_type_id);
	}
	return rygel_mpris_plugin_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



