/* rygel-media-export-item.c generated by valac 0.11.2, the Vala compiler
 * generated from rygel-media-export-item.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008 Nokia Corporation.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-dlna/gupnp-dlna-information.h>
#include <gst/discoverer/gstdiscoverer.h>
#include <gst/gst.h>
#include <gst/tag/tag.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER (rygel_media_export_jpeg_writer_get_type ())
#define RYGEL_MEDIA_EXPORT_JPEG_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER, RygelMediaExportJPEGWriter))
#define RYGEL_MEDIA_EXPORT_JPEG_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER, RygelMediaExportJPEGWriterClass))
#define RYGEL_MEDIA_EXPORT_IS_JPEG_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER))
#define RYGEL_MEDIA_EXPORT_IS_JPEG_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER))
#define RYGEL_MEDIA_EXPORT_JPEG_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER, RygelMediaExportJPEGWriterClass))

typedef struct _RygelMediaExportJPEGWriter RygelMediaExportJPEGWriter;
typedef struct _RygelMediaExportJPEGWriterClass RygelMediaExportJPEGWriterClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _gst_structure_free0(var) ((var == NULL) ? NULL : (var = (gst_structure_free (var), NULL)))



RygelMediaItem* rygel_media_export_item_factory_create_simple (RygelMediaContainer* parent, GFile* file, const gchar* mime, guint64 size, guint64 mtime);
gchar* rygel_media_export_media_cache_get_id (GFile* file);
RygelMediaItem* rygel_media_export_item_factory_create_from_info (RygelMediaContainer* parent, GFile* file, GUPnPDLNAInformation* dlna_info, const gchar* mime, guint64 size, guint64 mtime);
RygelMediaItem* rygel_media_export_item_factory_fill_photo_item (RygelPhotoItem* item, GFile* file, GUPnPDLNAInformation* dlna_info, GstStreamVideoInformation* video_info, const gchar* mime, guint64 size, guint64 mtime);
RygelMediaItem* rygel_media_export_item_factory_fill_video_item (RygelVideoItem* item, GFile* file, GUPnPDLNAInformation* dlna_info, GstStreamVideoInformation* video_info, GstStreamAudioInformation* audio_info, const gchar* mime, guint64 size, guint64 mtime);
RygelMediaItem* rygel_media_export_item_factory_fill_music_item (RygelMusicItem* item, GFile* file, GUPnPDLNAInformation* dlna_info, GstStreamAudioInformation* audio_info, const gchar* mime, guint64 size, guint64 mtime);
void rygel_media_export_item_factory_fill_audio_item (RygelAudioItem* item, GUPnPDLNAInformation* dlna_info, GstStreamAudioInformation* audio_info);
void rygel_media_export_item_factory_fill_media_item (RygelMediaItem* item, GFile* file, GUPnPDLNAInformation* dlna_info, const gchar* mime, guint64 size, guint64 mtime);
RygelMediaExportJPEGWriter* rygel_media_export_jpeg_writer_new (GError** error);
RygelMediaExportJPEGWriter* rygel_media_export_jpeg_writer_construct (GType object_type, GError** error);
GType rygel_media_export_jpeg_writer_get_type (void) G_GNUC_CONST;
void rygel_media_export_jpeg_writer_write (RygelMediaExportJPEGWriter* self, GstBuffer* buffer, GFile* file);


RygelMediaItem* rygel_media_export_item_factory_create_simple (RygelMediaContainer* parent, GFile* file, const gchar* mime, guint64 size, guint64 mtime) {
	RygelMediaItem* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* title;
	RygelMediaItem* item;
	gboolean _tmp1_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (mime != NULL, NULL);
	_tmp0_ = g_file_get_basename (file);
	title = _tmp0_;
	item = NULL;
	_tmp1_ = g_str_has_prefix (mime, "video/");
	if (_tmp1_) {
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		RygelVideoItem* _tmp4_ = NULL;
		RygelMediaItem* _tmp5_;
		_tmp2_ = rygel_media_export_media_cache_get_id (file);
		_tmp3_ = _tmp2_;
		_tmp4_ = rygel_video_item_new (_tmp3_, parent, title, RYGEL_VIDEO_ITEM_UPNP_CLASS);
		_tmp5_ = (RygelMediaItem*) _tmp4_;
		_g_object_unref0 (item);
		item = _tmp5_;
		_g_free0 (_tmp3_);
	} else {
		gboolean _tmp6_;
		_tmp6_ = g_str_has_prefix (mime, "image/");
		if (_tmp6_) {
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_;
			RygelPhotoItem* _tmp9_ = NULL;
			RygelMediaItem* _tmp10_;
			_tmp7_ = rygel_media_export_media_cache_get_id (file);
			_tmp8_ = _tmp7_;
			_tmp9_ = rygel_photo_item_new (_tmp8_, parent, title, RYGEL_PHOTO_ITEM_UPNP_CLASS);
			_tmp10_ = (RygelMediaItem*) _tmp9_;
			_g_object_unref0 (item);
			item = _tmp10_;
			_g_free0 (_tmp8_);
		} else {
			gchar* _tmp11_ = NULL;
			gchar* _tmp12_;
			RygelMusicItem* _tmp13_ = NULL;
			RygelMediaItem* _tmp14_;
			_tmp11_ = rygel_media_export_media_cache_get_id (file);
			_tmp12_ = _tmp11_;
			_tmp13_ = rygel_music_item_new (_tmp12_, parent, title, RYGEL_MUSIC_ITEM_UPNP_CLASS);
			_tmp14_ = (RygelMediaItem*) _tmp13_;
			_g_object_unref0 (item);
			item = _tmp14_;
			_g_free0 (_tmp12_);
		}
	}
	_tmp15_ = g_strdup (mime);
	_tmp16_ = _tmp15_;
	_g_free0 (item->mime_type);
	item->mime_type = _tmp16_;
	rygel_media_item_set_size (item, (gint64) size);
	((RygelMediaObject*) item)->modified = mtime;
	_tmp17_ = g_file_get_uri (file);
	_tmp18_ = _tmp17_;
	rygel_media_item_add_uri (item, _tmp18_);
	_g_free0 (_tmp18_);
	result = item;
	_g_free0 (title);
	return result;
}


RygelMediaItem* rygel_media_export_item_factory_create_from_info (RygelMediaContainer* parent, GFile* file, GUPnPDLNAInformation* dlna_info, const gchar* mime, guint64 size, guint64 mtime) {
	RygelMediaItem* result = NULL;
	RygelMediaItem* item;
	gchar* _tmp0_ = NULL;
	gchar* id;
	GstStreamAudioInformation* audio_info;
	GstStreamVideoInformation* video_info;
	GstDiscovererInformation* _tmp1_ = NULL;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (dlna_info != NULL, NULL);
	g_return_val_if_fail (mime != NULL, NULL);
	item = NULL;
	_tmp0_ = rygel_media_export_media_cache_get_id (file);
	id = _tmp0_;
	audio_info = NULL;
	video_info = NULL;
	_tmp1_ = gupnp_dlna_information_get_info (dlna_info);
	{
		GList* stream_info_collection;
		GList* stream_info_it;
		stream_info_collection = _tmp1_->stream_list;
		for (stream_info_it = stream_info_collection; stream_info_it != NULL; stream_info_it = stream_info_it->next) {
			GstStreamInformation* stream_info;
			stream_info = (GstStreamInformation*) stream_info_it->data;
			{
				gboolean _tmp2_ = FALSE;
				if (audio_info == NULL) {
					_tmp2_ = stream_info->streamtype == GST_STREAM_AUDIO;
				} else {
					_tmp2_ = FALSE;
				}
				if (_tmp2_) {
					audio_info = (GstStreamAudioInformation*) stream_info;
				} else {
					gboolean _tmp3_ = FALSE;
					if (video_info == NULL) {
						gboolean _tmp4_ = FALSE;
						if (stream_info->streamtype == GST_STREAM_VIDEO) {
							_tmp4_ = TRUE;
						} else {
							_tmp4_ = stream_info->streamtype == GST_STREAM_IMAGE;
						}
						_tmp3_ = _tmp4_;
					} else {
						_tmp3_ = FALSE;
					}
					if (_tmp3_) {
						video_info = (GstStreamVideoInformation*) stream_info;
					}
				}
			}
		}
	}
	if (video_info != NULL) {
		gboolean _tmp5_ = FALSE;
		if (audio_info == NULL) {
			_tmp5_ = ((GstStreamInformation*) video_info)->streamtype == GST_STREAM_IMAGE;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			RygelPhotoItem* _tmp6_ = NULL;
			RygelMediaItem* _tmp7_;
			RygelMediaItem* _tmp8_;
			RygelMediaItem* _tmp9_ = NULL;
			_tmp6_ = rygel_photo_item_new (id, parent, "", RYGEL_PHOTO_ITEM_UPNP_CLASS);
			_tmp7_ = (RygelMediaItem*) _tmp6_;
			_g_object_unref0 (item);
			item = _tmp7_;
			_tmp9_ = rygel_media_export_item_factory_fill_photo_item ((_tmp8_ = item, RYGEL_IS_PHOTO_ITEM (_tmp8_) ? ((RygelPhotoItem*) _tmp8_) : NULL), file, dlna_info, video_info, mime, size, mtime);
			result = _tmp9_;
			_g_free0 (id);
			_g_object_unref0 (item);
			return result;
		} else {
			RygelVideoItem* _tmp10_ = NULL;
			RygelMediaItem* _tmp11_;
			RygelMediaItem* _tmp12_;
			RygelMediaItem* _tmp13_ = NULL;
			_tmp10_ = rygel_video_item_new (id, parent, "", RYGEL_VIDEO_ITEM_UPNP_CLASS);
			_tmp11_ = (RygelMediaItem*) _tmp10_;
			_g_object_unref0 (item);
			item = _tmp11_;
			_tmp13_ = rygel_media_export_item_factory_fill_video_item ((_tmp12_ = item, RYGEL_IS_VIDEO_ITEM (_tmp12_) ? ((RygelVideoItem*) _tmp12_) : NULL), file, dlna_info, video_info, audio_info, mime, size, mtime);
			result = _tmp13_;
			_g_free0 (id);
			_g_object_unref0 (item);
			return result;
		}
	} else {
		if (audio_info != NULL) {
			RygelMusicItem* _tmp14_ = NULL;
			RygelMediaItem* _tmp15_;
			RygelMediaItem* _tmp16_;
			RygelMediaItem* _tmp17_ = NULL;
			_tmp14_ = rygel_music_item_new (id, parent, "", RYGEL_MUSIC_ITEM_UPNP_CLASS);
			_tmp15_ = (RygelMediaItem*) _tmp14_;
			_g_object_unref0 (item);
			item = _tmp15_;
			_tmp17_ = rygel_media_export_item_factory_fill_music_item ((_tmp16_ = item, RYGEL_IS_MUSIC_ITEM (_tmp16_) ? ((RygelMusicItem*) _tmp16_) : NULL), file, dlna_info, audio_info, mime, size, mtime);
			result = _tmp17_;
			_g_free0 (id);
			_g_object_unref0 (item);
			return result;
		} else {
			result = NULL;
			_g_free0 (id);
			_g_object_unref0 (item);
			return result;
		}
	}
	_g_free0 (id);
	_g_object_unref0 (item);
}


void rygel_media_export_item_factory_fill_audio_item (RygelAudioItem* item, GUPnPDLNAInformation* dlna_info, GstStreamAudioInformation* audio_info) {
	GstDiscovererInformation* _tmp0_ = NULL;
	g_return_if_fail (item != NULL);
	g_return_if_fail (dlna_info != NULL);
	_tmp0_ = gupnp_dlna_information_get_info (dlna_info);
	if (_tmp0_->duration > 0) {
		GstDiscovererInformation* _tmp1_ = NULL;
		_tmp1_ = gupnp_dlna_information_get_info (dlna_info);
		item->duration = (glong) (_tmp1_->duration / GST_SECOND);
	} else {
		item->duration = (glong) (-1);
	}
	if (audio_info != NULL) {
		if (((GstStreamInformation*) audio_info)->tags != NULL) {
			guint tmp = 0U;
			guint _tmp2_;
			gst_tag_list_get_uint (((GstStreamInformation*) audio_info)->tags, GST_TAG_BITRATE, &_tmp2_);
			tmp = _tmp2_;
			item->bitrate = ((gint) tmp) / 8;
		}
		item->channels = (gint) audio_info->channels;
		item->sample_freq = (gint) audio_info->sample_rate;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelMediaItem* rygel_media_export_item_factory_fill_video_item (RygelVideoItem* item, GFile* file, GUPnPDLNAInformation* dlna_info, GstStreamVideoInformation* video_info, GstStreamAudioInformation* audio_info, const gchar* mime, guint64 size, guint64 mtime) {
	RygelMediaItem* result = NULL;
	RygelVideoItem* _tmp0_;
	RygelMediaItem* _tmp2_;
	g_return_val_if_fail (item != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (dlna_info != NULL, NULL);
	g_return_val_if_fail (video_info != NULL, NULL);
	g_return_val_if_fail (mime != NULL, NULL);
	rygel_media_export_item_factory_fill_audio_item ((_tmp0_ = item, RYGEL_IS_AUDIO_ITEM (_tmp0_) ? ((RygelAudioItem*) _tmp0_) : NULL), dlna_info, audio_info);
	rygel_media_export_item_factory_fill_media_item ((RygelMediaItem*) item, file, dlna_info, mime, size, mtime);
	rygel_visual_item_set_width ((RygelVisualItem*) item, (gint) video_info->width);
	rygel_visual_item_set_height ((RygelVisualItem*) item, (gint) video_info->height);
	rygel_visual_item_set_color_depth ((RygelVisualItem*) item, (gint) video_info->depth);
	if (audio_info != NULL) {
		((RygelAudioItem*) item)->channels = (gint) audio_info->channels;
		((RygelAudioItem*) item)->sample_freq = (gint) audio_info->sample_rate;
		if (((GstStreamInformation*) audio_info)->tags != NULL) {
			guint tmp = 0U;
			guint _tmp1_;
			gst_tag_list_get_uint (((GstStreamInformation*) audio_info)->tags, GST_TAG_BITRATE, &_tmp1_);
			tmp = _tmp1_;
			((RygelAudioItem*) item)->bitrate = ((gint) tmp) / 8;
		}
	}
	_tmp2_ = _g_object_ref0 ((RygelMediaItem*) item);
	result = _tmp2_;
	return result;
}


RygelMediaItem* rygel_media_export_item_factory_fill_photo_item (RygelPhotoItem* item, GFile* file, GUPnPDLNAInformation* dlna_info, GstStreamVideoInformation* video_info, const gchar* mime, guint64 size, guint64 mtime) {
	RygelMediaItem* result = NULL;
	RygelMediaItem* _tmp0_;
	g_return_val_if_fail (item != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (dlna_info != NULL, NULL);
	g_return_val_if_fail (video_info != NULL, NULL);
	g_return_val_if_fail (mime != NULL, NULL);
	rygel_media_export_item_factory_fill_media_item ((RygelMediaItem*) item, file, dlna_info, mime, size, mtime);
	rygel_visual_item_set_width ((RygelVisualItem*) item, (gint) video_info->width);
	rygel_visual_item_set_height ((RygelVisualItem*) item, (gint) video_info->height);
	rygel_visual_item_set_color_depth ((RygelVisualItem*) item, (gint) video_info->depth);
	_tmp0_ = _g_object_ref0 ((RygelMediaItem*) item);
	result = _tmp0_;
	return result;
}


static gpointer _gst_structure_copy0 (gpointer self) {
	return self ? gst_structure_copy (self) : NULL;
}


RygelMediaItem* rygel_media_export_item_factory_fill_music_item (RygelMusicItem* item, GFile* file, GUPnPDLNAInformation* dlna_info, GstStreamAudioInformation* audio_info, const gchar* mime, guint64 size, guint64 mtime) {
	RygelMediaItem* result = NULL;
	RygelMusicItem* _tmp0_;
	RygelMediaItem* _tmp16_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (item != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (dlna_info != NULL, NULL);
	g_return_val_if_fail (mime != NULL, NULL);
	rygel_media_export_item_factory_fill_audio_item ((_tmp0_ = item, RYGEL_IS_AUDIO_ITEM (_tmp0_) ? ((RygelAudioItem*) _tmp0_) : NULL), dlna_info, audio_info);
	rygel_media_export_item_factory_fill_media_item ((RygelMediaItem*) item, file, dlna_info, mime, size, mtime);
	if (audio_info != NULL) {
		GstDiscovererInformation* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		GstDiscovererInformation* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		GstDiscovererInformation* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		guint tmp = 0U;
		GstDiscovererInformation* _tmp14_ = NULL;
		guint _tmp15_;
		if (((GstStreamInformation*) audio_info)->tags != NULL) {
			GstBuffer* buffer;
			GstBuffer* _tmp1_ = NULL;
			buffer = NULL;
			gst_tag_list_get_buffer (((GstStreamInformation*) audio_info)->tags, GST_TAG_IMAGE, &_tmp1_);
			buffer = _tmp1_;
			if (buffer != NULL) {
				const GstStructure* _tmp2_ = NULL;
				GstStructure* _tmp3_;
				GstStructure* structure;
				gint image_type = 0;
				gint _tmp4_;
				_tmp2_ = gst_caps_get_structure (buffer->caps, (guint) 0);
				_tmp3_ = _gst_structure_copy0 (_tmp2_);
				structure = _tmp3_;
				gst_structure_get_enum (structure, "image-type", GST_TYPE_TAG_IMAGE_TYPE, &_tmp4_);
				image_type = _tmp4_;
				switch (image_type) {
					case GST_TAG_IMAGE_TYPE_UNDEFINED:
					case GST_TAG_IMAGE_TYPE_FRONT_COVER:
					{
						RygelMediaArtStore* _tmp5_ = NULL;
						RygelMediaArtStore* store;
						GFile* _tmp6_ = NULL;
						GFile* thumb;
						RygelMediaExportJPEGWriter* _tmp7_ = NULL;
						RygelMediaExportJPEGWriter* writer;
						_tmp5_ = rygel_media_art_store_get_default ();
						store = _tmp5_;
						_tmp6_ = rygel_media_art_store_get_media_art_file (store, "album", item, TRUE);
						thumb = _tmp6_;
						_tmp7_ = rygel_media_export_jpeg_writer_new (&_inner_error_);
						writer = _tmp7_;
						if (_inner_error_ != NULL) {
							goto __catch54_g_error;
						}
						rygel_media_export_jpeg_writer_write (writer, buffer, thumb);
						_g_object_unref0 (writer);
						goto __finally54;
						__catch54_g_error:
						{
							GError * _error_;
							_error_ = _inner_error_;
							_inner_error_ = NULL;
							_g_error_free0 (_error_);
						}
						__finally54:
						if (_inner_error_ != NULL) {
							_g_object_unref0 (thumb);
							_g_object_unref0 (store);
							_gst_structure_free0 (structure);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
						_g_object_unref0 (thumb);
						_g_object_unref0 (store);
						break;
					}
					default:
					{
						break;
					}
				}
				_gst_structure_free0 (structure);
			}
		}
		_tmp8_ = gupnp_dlna_information_get_info (dlna_info);
		gst_tag_list_get_string (_tmp8_->tags, GST_TAG_ARTIST, &_tmp9_);
		_g_free0 (item->artist);
		item->artist = _tmp9_;
		_tmp10_ = gupnp_dlna_information_get_info (dlna_info);
		gst_tag_list_get_string (_tmp10_->tags, GST_TAG_ALBUM, &_tmp11_);
		_g_free0 (item->album);
		item->album = _tmp11_;
		_tmp12_ = gupnp_dlna_information_get_info (dlna_info);
		gst_tag_list_get_string (_tmp12_->tags, GST_TAG_GENRE, &_tmp13_);
		_g_free0 (item->genre);
		item->genre = _tmp13_;
		_tmp14_ = gupnp_dlna_information_get_info (dlna_info);
		gst_tag_list_get_uint (_tmp14_->tags, GST_TAG_TRACK_NUMBER, &_tmp15_);
		tmp = _tmp15_;
		item->track_number = (gint) tmp;
	}
	_tmp16_ = _g_object_ref0 ((RygelMediaItem*) item);
	result = _tmp16_;
	return result;
}


void rygel_media_export_item_factory_fill_media_item (RygelMediaItem* item, GFile* file, GUPnPDLNAInformation* dlna_info, const gchar* mime, guint64 size, guint64 mtime) {
	gchar* title;
	gboolean _tmp0_ = FALSE;
	GstDiscovererInformation* _tmp1_ = NULL;
	GstDiscovererInformation* _tmp7_ = NULL;
	const gchar* _tmp18_ = NULL;
	gchar* _tmp27_ = NULL;
	gchar* _tmp28_;
	g_return_if_fail (item != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (dlna_info != NULL);
	g_return_if_fail (mime != NULL);
	title = NULL;
	_tmp1_ = gupnp_dlna_information_get_info (dlna_info);
	if (_tmp1_->tags == NULL) {
		_tmp0_ = TRUE;
	} else {
		GstDiscovererInformation* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gboolean _tmp4_;
		_tmp2_ = gupnp_dlna_information_get_info (dlna_info);
		_tmp4_ = gst_tag_list_get_string (_tmp2_->tags, GST_TAG_TITLE, &_tmp3_);
		_g_free0 (title);
		title = _tmp3_;
		_tmp0_ = !_tmp4_;
	}
	if (_tmp0_) {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		_tmp5_ = g_file_get_basename (file);
		_tmp6_ = _tmp5_;
		_g_free0 (title);
		title = _tmp6_;
	}
	rygel_media_object_set_title ((RygelMediaObject*) item, title);
	_tmp7_ = gupnp_dlna_information_get_info (dlna_info);
	if (_tmp7_->tags != NULL) {
		GDate* date = NULL;
		GstDiscovererInformation* _tmp8_ = NULL;
		GDate* _tmp9_ = NULL;
		gboolean _tmp10_;
		_tmp8_ = gupnp_dlna_information_get_info (dlna_info);
		_tmp10_ = gst_tag_list_get_date (_tmp8_->tags, GST_TAG_DATE, &_tmp9_);
		_g_free0 (date);
		date = _tmp9_;
		if (_tmp10_) {
			gchar* _tmp11_ = NULL;
			gint datestr_length1;
			gint _datestr_size_;
			gchar* _tmp12_;
			gchar* datestr;
			gchar* _tmp13_;
			gchar* _tmp14_;
			_tmp11_ = g_new0 (gchar, 30);
			_tmp12_ = _tmp11_;
			datestr_length1 = 30;
			_datestr_size_ = datestr_length1;
			datestr = _tmp12_;
			g_date_strftime (datestr, datestr_length1, "%F", date);
			_tmp13_ = g_strdup ((const gchar*) datestr);
			_tmp14_ = _tmp13_;
			_g_free0 (item->date);
			item->date = _tmp14_;
			datestr = (g_free (datestr), NULL);
		}
		_g_free0 (date);
	}
	if (item->date == NULL) {
		GTimeVal _tmp15_ = {0};
		GTimeVal tv;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		tv = (_tmp15_.tv_sec = (glong) mtime, _tmp15_.tv_usec = (glong) 0, _tmp15_);
		_tmp16_ = g_time_val_to_iso8601 (&tv);
		_tmp17_ = _tmp16_;
		_g_free0 (item->date);
		item->date = _tmp17_;
	}
	rygel_media_item_set_size (item, (gint64) size);
	((RygelMediaObject*) item)->modified = (guint64) ((gint64) mtime);
	_tmp18_ = gupnp_dlna_information_get_name (dlna_info);
	if (_tmp18_ != NULL) {
		const gchar* _tmp19_ = NULL;
		gchar* _tmp20_;
		gchar* _tmp21_;
		const gchar* _tmp22_ = NULL;
		gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp19_ = gupnp_dlna_information_get_name (dlna_info);
		_tmp20_ = g_strdup (_tmp19_);
		_tmp21_ = _tmp20_;
		_g_free0 (item->dlna_profile);
		item->dlna_profile = _tmp21_;
		_tmp22_ = gupnp_dlna_information_get_mime (dlna_info);
		_tmp23_ = g_strdup (_tmp22_);
		_tmp24_ = _tmp23_;
		_g_free0 (item->mime_type);
		item->mime_type = _tmp24_;
	} else {
		gchar* _tmp25_;
		gchar* _tmp26_;
		_tmp25_ = g_strdup (mime);
		_tmp26_ = _tmp25_;
		_g_free0 (item->mime_type);
		item->mime_type = _tmp26_;
	}
	_tmp27_ = g_file_get_uri (file);
	_tmp28_ = _tmp27_;
	rygel_media_item_add_uri (item, _tmp28_);
	_g_free0 (_tmp28_);
	_g_free0 (title);
}



