/* rygel-l16-transcoder.c generated by valac 0.10.0, the Vala compiler
 * generated from rygel-l16-transcoder.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gst/gst.h>
#include <libgupnp-av/gupnp-av.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define TYPE_ENDIANNESS (endianness_get_type ())

#define RYGEL_TYPE_TRANSCODER (rygel_transcoder_get_type ())
#define RYGEL_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoder))
#define RYGEL_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))
#define RYGEL_IS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODER))
#define RYGEL_IS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODER))
#define RYGEL_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))

typedef struct _RygelTranscoder RygelTranscoder;
typedef struct _RygelTranscoderClass RygelTranscoderClass;
typedef struct _RygelTranscoderPrivate RygelTranscoderPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_L16_TRANSCODER (rygel_l16_transcoder_get_type ())
#define RYGEL_L16_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_L16_TRANSCODER, RygelL16Transcoder))
#define RYGEL_L16_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_L16_TRANSCODER, RygelL16TranscoderClass))
#define RYGEL_IS_L16_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_L16_TRANSCODER))
#define RYGEL_IS_L16_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_L16_TRANSCODER))
#define RYGEL_L16_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_L16_TRANSCODER, RygelL16TranscoderClass))

typedef struct _RygelL16Transcoder RygelL16Transcoder;
typedef struct _RygelL16TranscoderClass RygelL16TranscoderClass;
typedef struct _RygelL16TranscoderPrivate RygelL16TranscoderPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_L16_TRANSCODER_BIN (rygel_l16_transcoder_bin_get_type ())
#define RYGEL_L16_TRANSCODER_BIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_L16_TRANSCODER_BIN, RygelL16TranscoderBin))
#define RYGEL_L16_TRANSCODER_BIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_L16_TRANSCODER_BIN, RygelL16TranscoderBinClass))
#define RYGEL_IS_L16_TRANSCODER_BIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_L16_TRANSCODER_BIN))
#define RYGEL_IS_L16_TRANSCODER_BIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_L16_TRANSCODER_BIN))
#define RYGEL_L16_TRANSCODER_BIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_L16_TRANSCODER_BIN, RygelL16TranscoderBinClass))

typedef struct _RygelL16TranscoderBin RygelL16TranscoderBin;
typedef struct _RygelL16TranscoderBinClass RygelL16TranscoderBinClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;
typedef struct _RygelAudioItemPrivate RygelAudioItemPrivate;
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))
#define _gst_caps_unref0(var) ((var == NULL) ? NULL : (var = (gst_caps_unref (var), NULL)))

typedef enum  {
	ENDIANNESS_LITTLE = G_LITTLE_ENDIAN,
	ENDIANNESS_BIG = G_BIG_ENDIAN
} Endianness;

struct _RygelTranscoder {
	GObject parent_instance;
	RygelTranscoderPrivate * priv;
};

struct _RygelTranscoderClass {
	GObjectClass parent_class;
	GstElement* (*create_source) (RygelTranscoder* self, RygelMediaItem* item, GstElement* src, GError** error);
	GUPnPDIDLLiteResource* (*add_resource) (RygelTranscoder* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error);
	guint (*get_distance) (RygelTranscoder* self, RygelMediaItem* item);
};

struct _RygelL16Transcoder {
	RygelTranscoder parent_instance;
	RygelL16TranscoderPrivate * priv;
};

struct _RygelL16TranscoderClass {
	RygelTranscoderClass parent_class;
};

struct _RygelL16TranscoderPrivate {
	Endianness endianness;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	char* id;
	char* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const char* property);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	char* date;
	char* mime_type;
	char* dlna_profile;
	gboolean place_holder;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GstElement* (*create_stream_source) (RygelMediaItem* self);
	gboolean (*streamable) (RygelMediaItem* self);
	void (*add_uri) (RygelMediaItem* self, const char* uri);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const char* uri, const char* protocol, const char* import_uri, GError** error);
	void (*add_proxy_resources) (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
	GUPnPProtocolInfo* (*get_protocol_info) (RygelMediaItem* self, const char* uri, const char* protocol);
	void (*add_resources) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
};

struct _RygelAudioItem {
	RygelMediaItem parent_instance;
	RygelAudioItemPrivate * priv;
	glong duration;
	gint bitrate;
	gint sample_freq;
	gint bits_per_sample;
	gint channels;
};

struct _RygelAudioItemClass {
	RygelMediaItemClass parent_class;
};


static gpointer rygel_l16_transcoder_parent_class = NULL;

GType endianness_get_type (void) G_GNUC_CONST;
GType rygel_transcoder_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_l16_transcoder_get_type (void) G_GNUC_CONST;
#define RYGEL_L16_TRANSCODER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_L16_TRANSCODER, RygelL16TranscoderPrivate))
enum  {
	RYGEL_L16_TRANSCODER_DUMMY_PROPERTY
};
#define RYGEL_L16_TRANSCODER_CHANNELS 2
#define RYGEL_L16_TRANSCODER_FREQUENCY 44100
#define RYGEL_L16_TRANSCODER_WIDTH 16
#define RYGEL_L16_TRANSCODER_DEPTH 16
#define RYGEL_L16_TRANSCODER_SIGNED TRUE
#define RYGEL_L16_TRANSCODER_AUDIO_CONVERT "audioconvert"
#define RYGEL_L16_TRANSCODER_AUDIO_RESAMPLE "audioresample"
#define RYGEL_L16_TRANSCODER_AUDIO_RATE "audiorate"
#define RYGEL_L16_TRANSCODER_CAPS_FILTER "capsfilter"
RygelL16Transcoder* rygel_l16_transcoder_new (Endianness endianness);
RygelL16Transcoder* rygel_l16_transcoder_construct (GType object_type, Endianness endianness);
#define RYGEL_AUDIO_ITEM_UPNP_CLASS "object.item.audioItem"
RygelTranscoder* rygel_transcoder_construct (GType object_type, const char* mime_type, const char* dlna_profile, const char* upnp_class);
static GstElement* rygel_l16_transcoder_real_create_source (RygelTranscoder* base, RygelMediaItem* item, GstElement* src, GError** error);
RygelL16TranscoderBin* rygel_l16_transcoder_bin_new (RygelMediaItem* item, GstElement* src, RygelL16Transcoder* transcoder, GError** error);
RygelL16TranscoderBin* rygel_l16_transcoder_bin_construct (GType object_type, RygelMediaItem* item, GstElement* src, RygelL16Transcoder* transcoder, GError** error);
GType rygel_l16_transcoder_bin_get_type (void) G_GNUC_CONST;
static GUPnPDIDLLiteResource* rygel_l16_transcoder_real_add_resource (RygelTranscoder* base, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error);
GUPnPDIDLLiteResource* rygel_transcoder_add_resource (RygelTranscoder* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error);
static guint rygel_l16_transcoder_real_get_distance (RygelTranscoder* base, RygelMediaItem* item);
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GstElement* rygel_l16_transcoder_create_encoder (RygelL16Transcoder* self, RygelMediaItem* item, const char* src_pad_name, const char* sink_pad_name, GError** error);
GstElement* rygel_gst_utils_create_element (const char* factoryname, const char* name, GError** error);
static inline void _dynamic_set_caps6 (GstElement* obj, GstCaps* value);
static void rygel_l16_transcoder_finalize (GObject* obj);



GType endianness_get_type (void) {
	static volatile gsize endianness_type_id__volatile = 0;
	if (g_once_init_enter (&endianness_type_id__volatile)) {
		static const GEnumValue values[] = {{ENDIANNESS_LITTLE, "ENDIANNESS_LITTLE", "little"}, {ENDIANNESS_BIG, "ENDIANNESS_BIG", "big"}, {0, NULL, NULL}};
		GType endianness_type_id;
		endianness_type_id = g_enum_register_static ("Endianness", values);
		g_once_init_leave (&endianness_type_id__volatile, endianness_type_id);
	}
	return endianness_type_id__volatile;
}


#line 50 "rygel-l16-transcoder.vala"
RygelL16Transcoder* rygel_l16_transcoder_construct (GType object_type, Endianness endianness) {
#line 275 "rygel-l16-transcoder.c"
	RygelL16Transcoder * self;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	char* _tmp6_;
	char* _tmp7_;
	char* mime_type;
#line 51 "rygel-l16-transcoder.vala"
	mime_type = (_tmp7_ = g_strconcat (_tmp5_ = g_strconcat (_tmp4_ = g_strconcat (_tmp2_ = g_strconcat (_tmp1_ = g_strconcat ("audio/L", _tmp0_ = g_strdup_printf ("%i", RYGEL_L16_TRANSCODER_WIDTH), NULL), ";rate=", NULL), _tmp3_ = g_strdup_printf ("%i", RYGEL_L16_TRANSCODER_FREQUENCY), NULL), ";channels=", NULL), _tmp6_ = g_strdup_printf ("%i", RYGEL_L16_TRANSCODER_CHANNELS), NULL), _g_free0 (_tmp6_), _g_free0 (_tmp5_), _g_free0 (_tmp4_), _g_free0 (_tmp3_), _g_free0 (_tmp2_), _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp7_);
#line 55 "rygel-l16-transcoder.vala"
	self = (RygelL16Transcoder*) rygel_transcoder_construct (object_type, mime_type, "LPCM", RYGEL_AUDIO_ITEM_UPNP_CLASS);
#line 57 "rygel-l16-transcoder.vala"
	self->priv->endianness = endianness;
#line 292 "rygel-l16-transcoder.c"
	_g_free0 (mime_type);
	return self;
}


#line 50 "rygel-l16-transcoder.vala"
RygelL16Transcoder* rygel_l16_transcoder_new (Endianness endianness) {
#line 50 "rygel-l16-transcoder.vala"
	return rygel_l16_transcoder_construct (RYGEL_TYPE_L16_TRANSCODER, endianness);
#line 302 "rygel-l16-transcoder.c"
}


#line 60 "rygel-l16-transcoder.vala"
static GstElement* rygel_l16_transcoder_real_create_source (RygelTranscoder* base, RygelMediaItem* item, GstElement* src, GError** error) {
#line 308 "rygel-l16-transcoder.c"
	RygelL16Transcoder * self;
	GstElement* result = NULL;
	RygelL16TranscoderBin* _tmp0_;
	GError * _inner_error_ = NULL;
	self = (RygelL16Transcoder*) base;
#line 60 "rygel-l16-transcoder.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 60 "rygel-l16-transcoder.vala"
	g_return_val_if_fail (src != NULL, NULL);
#line 63 "rygel-l16-transcoder.vala"
	_tmp0_ = rygel_l16_transcoder_bin_new (item, src, self, &_inner_error_);
#line 320 "rygel-l16-transcoder.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	result = (GstElement*) _tmp0_;
#line 63 "rygel-l16-transcoder.vala"
	return result;
#line 328 "rygel-l16-transcoder.c"
}


#line 66 "rygel-l16-transcoder.vala"
static GUPnPDIDLLiteResource* rygel_l16_transcoder_real_add_resource (RygelTranscoder* base, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error) {
#line 334 "rygel-l16-transcoder.c"
	RygelL16Transcoder * self;
	GUPnPDIDLLiteResource* result = NULL;
	GUPnPDIDLLiteResource* resource;
	GError * _inner_error_ = NULL;
	self = (RygelL16Transcoder*) base;
#line 66 "rygel-l16-transcoder.vala"
	g_return_val_if_fail (didl_item != NULL, NULL);
#line 66 "rygel-l16-transcoder.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 66 "rygel-l16-transcoder.vala"
	g_return_val_if_fail (manager != NULL, NULL);
#line 70 "rygel-l16-transcoder.vala"
	resource = RYGEL_TRANSCODER_CLASS (rygel_l16_transcoder_parent_class)->add_resource (RYGEL_TRANSCODER (self), didl_item, item, manager, &_inner_error_);
#line 348 "rygel-l16-transcoder.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
#line 71 "rygel-l16-transcoder.vala"
	if (resource == NULL) {
#line 355 "rygel-l16-transcoder.c"
		result = NULL;
		_g_object_unref0 (resource);
#line 72 "rygel-l16-transcoder.vala"
		return result;
#line 360 "rygel-l16-transcoder.c"
	}
#line 74 "rygel-l16-transcoder.vala"
	gupnp_didl_lite_resource_set_sample_freq (resource, RYGEL_L16_TRANSCODER_FREQUENCY);
#line 75 "rygel-l16-transcoder.vala"
	gupnp_didl_lite_resource_set_audio_channels (resource, RYGEL_L16_TRANSCODER_CHANNELS);
#line 76 "rygel-l16-transcoder.vala"
	gupnp_didl_lite_resource_set_bits_per_sample (resource, RYGEL_L16_TRANSCODER_WIDTH);
#line 78 "rygel-l16-transcoder.vala"
	gupnp_didl_lite_resource_set_bitrate (resource, ((RYGEL_L16_TRANSCODER_FREQUENCY * RYGEL_L16_TRANSCODER_CHANNELS) * RYGEL_L16_TRANSCODER_WIDTH) / 8);
#line 370 "rygel-l16-transcoder.c"
	result = resource;
#line 82 "rygel-l16-transcoder.vala"
	return result;
#line 374 "rygel-l16-transcoder.c"
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 85 "rygel-l16-transcoder.vala"
static guint rygel_l16_transcoder_real_get_distance (RygelTranscoder* base, RygelMediaItem* item) {
#line 385 "rygel-l16-transcoder.c"
	RygelL16Transcoder * self;
	guint result = 0U;
	RygelMediaItem* _tmp0_;
	RygelAudioItem* audio_item;
	guint distance;
	self = (RygelL16Transcoder*) base;
#line 85 "rygel-l16-transcoder.vala"
	g_return_val_if_fail (item != NULL, 0U);
#line 86 "rygel-l16-transcoder.vala"
	if (!RYGEL_IS_AUDIO_ITEM (item)) {
#line 396 "rygel-l16-transcoder.c"
		result = G_MAXUINT;
#line 87 "rygel-l16-transcoder.vala"
		return result;
#line 400 "rygel-l16-transcoder.c"
	}
#line 90 "rygel-l16-transcoder.vala"
	audio_item = _g_object_ref0 ((_tmp0_ = item, RYGEL_IS_AUDIO_ITEM (_tmp0_) ? ((RygelAudioItem*) _tmp0_) : NULL));
#line 91 "rygel-l16-transcoder.vala"
	distance = 0;
#line 93 "rygel-l16-transcoder.vala"
	if (audio_item->sample_freq > 0) {
#line 94 "rygel-l16-transcoder.vala"
		distance = distance + ((guint) abs (audio_item->sample_freq - RYGEL_L16_TRANSCODER_FREQUENCY));
#line 410 "rygel-l16-transcoder.c"
	}
#line 97 "rygel-l16-transcoder.vala"
	if (audio_item->channels > 0) {
#line 98 "rygel-l16-transcoder.vala"
		distance = distance + ((guint) abs (audio_item->channels - RYGEL_L16_TRANSCODER_CHANNELS));
#line 416 "rygel-l16-transcoder.c"
	}
#line 101 "rygel-l16-transcoder.vala"
	if (audio_item->bits_per_sample > 0) {
#line 102 "rygel-l16-transcoder.vala"
		distance = distance + ((guint) abs (audio_item->bits_per_sample - RYGEL_L16_TRANSCODER_WIDTH));
#line 422 "rygel-l16-transcoder.c"
	}
	result = distance;
	_g_object_unref0 (audio_item);
#line 105 "rygel-l16-transcoder.vala"
	return result;
#line 428 "rygel-l16-transcoder.c"
}


static gpointer _gst_object_ref0 (gpointer self) {
	return self ? gst_object_ref (self) : NULL;
}


static inline void _dynamic_set_caps6 (GstElement* obj, GstCaps* value) {
	g_object_set (obj, "caps", value, NULL);
}


#line 108 "rygel-l16-transcoder.vala"
GstElement* rygel_l16_transcoder_create_encoder (RygelL16Transcoder* self, RygelMediaItem* item, const char* src_pad_name, const char* sink_pad_name, GError** error) {
#line 444 "rygel-l16-transcoder.c"
	GstElement* result = NULL;
	GstElement* convert1;
	GstElement* resample;
	GstElement* audiorate;
	GstElement* convert2;
	GstElement* capsfilter;
	GstBin* bin;
	GstCaps* _tmp0_;
	GstPad* pad;
	GstGhostPad* ghost;
	GstPad* _tmp1_;
	GstGhostPad* _tmp2_;
	GError * _inner_error_ = NULL;
#line 108 "rygel-l16-transcoder.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 108 "rygel-l16-transcoder.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 112 "rygel-l16-transcoder.vala"
	convert1 = rygel_gst_utils_create_element (RYGEL_L16_TRANSCODER_AUDIO_CONVERT, NULL, &_inner_error_);
#line 464 "rygel-l16-transcoder.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
#line 114 "rygel-l16-transcoder.vala"
	resample = rygel_gst_utils_create_element (RYGEL_L16_TRANSCODER_AUDIO_RESAMPLE, RYGEL_L16_TRANSCODER_AUDIO_RESAMPLE, &_inner_error_);
#line 471 "rygel-l16-transcoder.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_gst_object_unref0 (convert1);
		return NULL;
	}
#line 116 "rygel-l16-transcoder.vala"
	audiorate = rygel_gst_utils_create_element (RYGEL_L16_TRANSCODER_AUDIO_RATE, NULL, &_inner_error_);
#line 479 "rygel-l16-transcoder.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_gst_object_unref0 (resample);
		_gst_object_unref0 (convert1);
		return NULL;
	}
#line 117 "rygel-l16-transcoder.vala"
	convert2 = rygel_gst_utils_create_element (RYGEL_L16_TRANSCODER_AUDIO_CONVERT, NULL, &_inner_error_);
#line 488 "rygel-l16-transcoder.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_gst_object_unref0 (audiorate);
		_gst_object_unref0 (resample);
		_gst_object_unref0 (convert1);
		return NULL;
	}
#line 119 "rygel-l16-transcoder.vala"
	capsfilter = rygel_gst_utils_create_element (RYGEL_L16_TRANSCODER_CAPS_FILTER, RYGEL_L16_TRANSCODER_CAPS_FILTER, &_inner_error_);
#line 498 "rygel-l16-transcoder.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_gst_object_unref0 (convert2);
		_gst_object_unref0 (audiorate);
		_gst_object_unref0 (resample);
		_gst_object_unref0 (convert1);
		return NULL;
	}
#line 122 "rygel-l16-transcoder.vala"
	bin = (GstBin*) gst_bin_new ("l16-encoder-bin");
#line 123 "rygel-l16-transcoder.vala"
	gst_bin_add_many (bin, _gst_object_ref0 (convert1), _gst_object_ref0 (resample), _gst_object_ref0 (audiorate), _gst_object_ref0 (convert2), _gst_object_ref0 (capsfilter), NULL);
#line 125 "rygel-l16-transcoder.vala"
	_dynamic_set_caps6 (capsfilter, _tmp0_ = gst_caps_new_simple ("audio/x-raw-int", "channels", G_TYPE_INT, RYGEL_L16_TRANSCODER_CHANNELS, "rate", G_TYPE_INT, RYGEL_L16_TRANSCODER_FREQUENCY, "width", G_TYPE_INT, RYGEL_L16_TRANSCODER_WIDTH, "depth", G_TYPE_INT, RYGEL_L16_TRANSCODER_DEPTH, "signed", G_TYPE_BOOLEAN, RYGEL_L16_TRANSCODER_SIGNED, "endianness", G_TYPE_INT, self->priv->endianness, NULL));
#line 513 "rygel-l16-transcoder.c"
	_gst_caps_unref0 (_tmp0_);
#line 135 "rygel-l16-transcoder.vala"
	gst_element_link_many (convert1, resample, audiorate, convert2, capsfilter, NULL);
#line 137 "rygel-l16-transcoder.vala"
	pad = gst_element_get_static_pad (convert1, "sink");
#line 138 "rygel-l16-transcoder.vala"
	ghost = (GstGhostPad*) gst_ghost_pad_new (sink_pad_name, pad);
#line 139 "rygel-l16-transcoder.vala"
	gst_element_add_pad ((GstElement*) bin, _gst_object_ref0 ((GstPad*) ghost));
#line 141 "rygel-l16-transcoder.vala"
	pad = (_tmp1_ = gst_element_get_static_pad (capsfilter, "src"), _gst_object_unref0 (pad), _tmp1_);
#line 142 "rygel-l16-transcoder.vala"
	ghost = (_tmp2_ = (GstGhostPad*) gst_ghost_pad_new (src_pad_name, pad), _gst_object_unref0 (ghost), _tmp2_);
#line 143 "rygel-l16-transcoder.vala"
	gst_element_add_pad ((GstElement*) bin, _gst_object_ref0 ((GstPad*) ghost));
#line 529 "rygel-l16-transcoder.c"
	result = (GstElement*) bin;
	_gst_object_unref0 (ghost);
	_gst_object_unref0 (pad);
	_gst_object_unref0 (capsfilter);
	_gst_object_unref0 (convert2);
	_gst_object_unref0 (audiorate);
	_gst_object_unref0 (resample);
	_gst_object_unref0 (convert1);
#line 145 "rygel-l16-transcoder.vala"
	return result;
#line 540 "rygel-l16-transcoder.c"
}


static void rygel_l16_transcoder_class_init (RygelL16TranscoderClass * klass) {
	rygel_l16_transcoder_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelL16TranscoderPrivate));
	RYGEL_TRANSCODER_CLASS (klass)->create_source = rygel_l16_transcoder_real_create_source;
	RYGEL_TRANSCODER_CLASS (klass)->add_resource = rygel_l16_transcoder_real_add_resource;
	RYGEL_TRANSCODER_CLASS (klass)->get_distance = rygel_l16_transcoder_real_get_distance;
	G_OBJECT_CLASS (klass)->finalize = rygel_l16_transcoder_finalize;
}


static void rygel_l16_transcoder_instance_init (RygelL16Transcoder * self) {
	self->priv = RYGEL_L16_TRANSCODER_GET_PRIVATE (self);
}


static void rygel_l16_transcoder_finalize (GObject* obj) {
	RygelL16Transcoder * self;
	self = RYGEL_L16_TRANSCODER (obj);
	G_OBJECT_CLASS (rygel_l16_transcoder_parent_class)->finalize (obj);
}


/**
 * Transcoder for linear PCM audio (LPCM). This element uses L16TrancoderBin for
 * actual transcoding.
 */
GType rygel_l16_transcoder_get_type (void) {
	static volatile gsize rygel_l16_transcoder_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_l16_transcoder_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelL16TranscoderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_l16_transcoder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelL16Transcoder), 0, (GInstanceInitFunc) rygel_l16_transcoder_instance_init, NULL };
		GType rygel_l16_transcoder_type_id;
		rygel_l16_transcoder_type_id = g_type_register_static (RYGEL_TYPE_TRANSCODER, "RygelL16Transcoder", &g_define_type_info, 0);
		g_once_init_leave (&rygel_l16_transcoder_type_id__volatile, rygel_l16_transcoder_type_id);
	}
	return rygel_l16_transcoder_type_id__volatile;
}




