/* rygel-http-time-seek-test.c generated by valac 0.10.0, the Vala compiler
 * generated from rygel-http-time-seek-test.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshan.ali@nokia.com>
 *                               <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>
#include <gst/gst.h>


#define RYGEL_TYPE_HTTP_TRANSCODE_HANDLER (rygel_http_transcode_handler_get_type ())
#define RYGEL_HTTP_TRANSCODE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandler))
#define RYGEL_HTTP_TRANSCODE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandlerClass))
#define RYGEL_IS_HTTP_TRANSCODE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER))
#define RYGEL_IS_HTTP_TRANSCODE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER))
#define RYGEL_HTTP_TRANSCODE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandlerClass))

typedef struct _RygelHTTPTranscodeHandler RygelHTTPTranscodeHandler;
typedef struct _RygelHTTPTranscodeHandlerClass RygelHTTPTranscodeHandlerClass;
typedef struct _RygelHTTPTranscodeHandlerPrivate RygelHTTPTranscodeHandlerPrivate;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;
typedef struct _RygelAudioItemPrivate RygelAudioItemPrivate;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;
typedef struct _RygelThumbnailPrivate RygelThumbnailPrivate;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;
typedef struct _RygelSubtitlePrivate RygelSubtitlePrivate;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;
typedef struct _RygelHTTPGetPrivate RygelHTTPGetPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_HTTP_TIME_SEEK_TEST (rygel_http_time_seek_test_get_type ())
#define RYGEL_HTTP_TIME_SEEK_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TIME_SEEK_TEST, RygelHTTPTimeSeekTest))
#define RYGEL_HTTP_TIME_SEEK_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TIME_SEEK_TEST, RygelHTTPTimeSeekTestClass))
#define RYGEL_IS_HTTP_TIME_SEEK_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TIME_SEEK_TEST))
#define RYGEL_IS_HTTP_TIME_SEEK_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TIME_SEEK_TEST))
#define RYGEL_HTTP_TIME_SEEK_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TIME_SEEK_TEST, RygelHTTPTimeSeekTestClass))

typedef struct _RygelHTTPTimeSeekTest RygelHTTPTimeSeekTest;
typedef struct _RygelHTTPTimeSeekTestClass RygelHTTPTimeSeekTestClass;
typedef struct _RygelHTTPTimeSeekTestPrivate RygelHTTPTimeSeekTestPrivate;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;

#define RYGEL_TYPE_HTTP_TIME_SEEK (rygel_http_time_seek_get_type ())
#define RYGEL_HTTP_TIME_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeek))
#define RYGEL_HTTP_TIME_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeekClass))
#define RYGEL_IS_HTTP_TIME_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TIME_SEEK))
#define RYGEL_IS_HTTP_TIME_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TIME_SEEK))
#define RYGEL_HTTP_TIME_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeekClass))

typedef struct _RygelHTTPTimeSeek RygelHTTPTimeSeek;
typedef struct _RygelHTTPTimeSeekClass RygelHTTPTimeSeekClass;

typedef enum  {
	RYGEL_TEST_ERROR_SKIP
} RygelTestError;
#define RYGEL_TEST_ERROR rygel_test_error_quark ()
struct _RygelHTTPTranscodeHandler {
	GObject parent_instance;
	RygelHTTPTranscodeHandlerPrivate * priv;
};

struct _RygelHTTPTranscodeHandlerClass {
	GObjectClass parent_class;
};

struct _RygelMediaItem {
	GObject parent_instance;
	RygelMediaItemPrivate * priv;
	gint64 size;
};

struct _RygelMediaItemClass {
	GObjectClass parent_class;
	gboolean (*should_stream) (RygelMediaItem* self);
};

struct _RygelAudioItem {
	RygelMediaItem parent_instance;
	RygelAudioItemPrivate * priv;
	gint64 duration;
};

struct _RygelAudioItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelThumbnail {
	GObject parent_instance;
	RygelThumbnailPrivate * priv;
};

struct _RygelThumbnailClass {
	GObjectClass parent_class;
};

struct _RygelSubtitle {
	GObject parent_instance;
	RygelSubtitlePrivate * priv;
};

struct _RygelSubtitleClass {
	GObjectClass parent_class;
};

struct _RygelHTTPGet {
	GObject parent_instance;
	RygelHTTPGetPrivate * priv;
	SoupMessage* msg;
	RygelMediaItem* item;
	RygelThumbnail* thumbnail;
	RygelSubtitle* subtitle;
	RygelHTTPTranscodeHandler* handler;
};

struct _RygelHTTPGetClass {
	GObjectClass parent_class;
};

struct _RygelHTTPTimeSeekTest {
	GObject parent_instance;
	RygelHTTPTimeSeekTestPrivate * priv;
};

struct _RygelHTTPTimeSeekTestClass {
	GObjectClass parent_class;
};

struct _RygelHTTPTimeSeekTestPrivate {
	GRegex* range_regex;
};

typedef enum  {
	RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_ERROR_OUT_OF_RANGE = SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE
} RygelHTTPSeekError;
#define RYGEL_HTTP_SEEK_ERROR rygel_http_seek_error_quark ()

static gpointer rygel_http_transcode_handler_parent_class = NULL;
static gpointer rygel_media_item_parent_class = NULL;
static gpointer rygel_audio_item_parent_class = NULL;
static gpointer rygel_thumbnail_parent_class = NULL;
static gpointer rygel_subtitle_parent_class = NULL;
static gpointer rygel_http_get_parent_class = NULL;
static gpointer rygel_http_time_seek_test_parent_class = NULL;

GQuark rygel_test_error_quark (void);
GType rygel_http_transcode_handler_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_TRANSCODE_HANDLER_DUMMY_PROPERTY
};
RygelHTTPTranscodeHandler* rygel_http_transcode_handler_new (void);
RygelHTTPTranscodeHandler* rygel_http_transcode_handler_construct (GType object_type);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MEDIA_ITEM_DUMMY_PROPERTY
};
gboolean rygel_media_item_should_stream (RygelMediaItem* self);
static gboolean rygel_media_item_real_should_stream (RygelMediaItem* self);
RygelMediaItem* rygel_media_item_construct (GType object_type);
static void rygel_media_item_finalize (GObject* obj);
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_AUDIO_ITEM_DUMMY_PROPERTY
};
RygelAudioItem* rygel_audio_item_new (void);
RygelAudioItem* rygel_audio_item_construct (GType object_type);
static void rygel_audio_item_finalize (GObject* obj);
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_THUMBNAIL_DUMMY_PROPERTY
};
RygelThumbnail* rygel_thumbnail_new (void);
RygelThumbnail* rygel_thumbnail_construct (GType object_type);
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_SUBTITLE_DUMMY_PROPERTY
};
RygelSubtitle* rygel_subtitle_new (void);
RygelSubtitle* rygel_subtitle_construct (GType object_type);
GType rygel_http_get_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_GET_DUMMY_PROPERTY
};
#define RYGEL_HTTP_GET_ITEM_URI "http://DoesntMatterWhatThisIs"
RygelHTTPGet* rygel_http_get_new (RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_construct (GType object_type, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_new_seek_start (gint64 start, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_construct_seek_start (GType object_type, gint64 start, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
static void rygel_http_get_add_headers (RygelHTTPGet* self, gint64 start, gint64 stop);
RygelHTTPGet* rygel_http_get_new_seek_stop (gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_construct_seek_stop (GType object_type, gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_new_seek_start_stop (gint64 start, gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_construct_seek_start_stop (GType object_type, gint64 start, gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
static void rygel_http_get_finalize (GObject* obj);
GType rygel_http_time_seek_test_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_TIME_SEEK_TEST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_TIME_SEEK_TEST, RygelHTTPTimeSeekTestPrivate))
enum  {
	RYGEL_HTTP_TIME_SEEK_TEST_DUMMY_PROPERTY
};
gint rygel_http_time_seek_test_main (char** args, int args_length1);
static RygelHTTPTimeSeekTest* rygel_http_time_seek_test_new (void);
static RygelHTTPTimeSeekTest* rygel_http_time_seek_test_construct (GType object_type);
GQuark rygel_http_seek_error_quark (void);
void rygel_http_time_seek_test_run (RygelHTTPTimeSeekTest* self, GError** error);
static void rygel_http_time_seek_test_test_no_seek (RygelHTTPTimeSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error);
static void rygel_http_time_seek_test_test_start_only_seek (RygelHTTPTimeSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error);
static void rygel_http_time_seek_test_test_stop_only_seek (RygelHTTPTimeSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error);
static void rygel_http_time_seek_test_test_start_stop_seek (RygelHTTPTimeSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error);
static void rygel_http_time_seek_test_test_seek (RygelHTTPTimeSeekTest* self, RygelHTTPGet* request, gint64 start, gint64 stop, GError** error);
gboolean rygel_http_time_seek_needed (RygelHTTPGet* request);
RygelHTTPTimeSeek* rygel_http_time_seek_new (RygelHTTPGet* request, GError** error);
RygelHTTPTimeSeek* rygel_http_time_seek_construct (GType object_type, RygelHTTPGet* request, GError** error);
GType rygel_http_seek_get_type (void) G_GNUC_CONST;
GType rygel_http_time_seek_get_type (void) G_GNUC_CONST;
void rygel_http_seek_add_response_headers (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_start (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_stop (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_length (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_total_length (RygelHTTPSeek* self);
static void rygel_http_time_seek_test_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);



GQuark rygel_test_error_quark (void) {
	return g_quark_from_static_string ("rygel_test_error-quark");
}


#line 30 "rygel-http-time-seek-test.vala"
RygelHTTPTranscodeHandler* rygel_http_transcode_handler_construct (GType object_type) {
#line 317 "rygel-http-time-seek-test.c"
	RygelHTTPTranscodeHandler * self;
#line 30 "rygel-http-time-seek-test.vala"
	self = (RygelHTTPTranscodeHandler*) g_object_new (object_type, NULL);
#line 321 "rygel-http-time-seek-test.c"
	return self;
}


#line 30 "rygel-http-time-seek-test.vala"
RygelHTTPTranscodeHandler* rygel_http_transcode_handler_new (void) {
#line 30 "rygel-http-time-seek-test.vala"
	return rygel_http_transcode_handler_construct (RYGEL_TYPE_HTTP_TRANSCODE_HANDLER);
#line 330 "rygel-http-time-seek-test.c"
}


static void rygel_http_transcode_handler_class_init (RygelHTTPTranscodeHandlerClass * klass) {
	rygel_http_transcode_handler_parent_class = g_type_class_peek_parent (klass);
}


static void rygel_http_transcode_handler_instance_init (RygelHTTPTranscodeHandler * self) {
}


GType rygel_http_transcode_handler_get_type (void) {
	static volatile gsize rygel_http_transcode_handler_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_transcode_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPTranscodeHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_transcode_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPTranscodeHandler), 0, (GInstanceInitFunc) rygel_http_transcode_handler_instance_init, NULL };
		GType rygel_http_transcode_handler_type_id;
		rygel_http_transcode_handler_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPTranscodeHandler", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_transcode_handler_type_id__volatile, rygel_http_transcode_handler_type_id);
	}
	return rygel_http_transcode_handler_type_id__volatile;
}


#line 35 "rygel-http-time-seek-test.vala"
static gboolean rygel_media_item_real_should_stream (RygelMediaItem* self) {
#line 357 "rygel-http-time-seek-test.c"
	gboolean result = FALSE;
#line 35 "rygel-http-time-seek-test.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 361 "rygel-http-time-seek-test.c"
	result = TRUE;
#line 36 "rygel-http-time-seek-test.vala"
	return result;
#line 365 "rygel-http-time-seek-test.c"
}


#line 30 "rygel-http-time-seek-test.vala"
gboolean rygel_media_item_should_stream (RygelMediaItem* self) {
#line 30 "rygel-http-time-seek-test.vala"
	return RYGEL_MEDIA_ITEM_GET_CLASS (self)->should_stream (self);
#line 373 "rygel-http-time-seek-test.c"
}


#line 32 "rygel-http-time-seek-test.vala"
RygelMediaItem* rygel_media_item_construct (GType object_type) {
#line 379 "rygel-http-time-seek-test.c"
	RygelMediaItem * self;
#line 32 "rygel-http-time-seek-test.vala"
	self = (RygelMediaItem*) g_object_new (object_type, NULL);
#line 383 "rygel-http-time-seek-test.c"
	return self;
}


static void rygel_media_item_class_init (RygelMediaItemClass * klass) {
	rygel_media_item_parent_class = g_type_class_peek_parent (klass);
	RYGEL_MEDIA_ITEM_CLASS (klass)->should_stream = rygel_media_item_real_should_stream;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_item_finalize;
}


static void rygel_media_item_instance_init (RygelMediaItem * self) {
	self->size = (gint64) (-1);
}


static void rygel_media_item_finalize (GObject* obj) {
	RygelMediaItem * self;
	self = RYGEL_MEDIA_ITEM (obj);
	G_OBJECT_CLASS (rygel_media_item_parent_class)->finalize (obj);
}


GType rygel_media_item_get_type (void) {
	static volatile gsize rygel_media_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaItem), 0, (GInstanceInitFunc) rygel_media_item_instance_init, NULL };
		GType rygel_media_item_type_id;
		rygel_media_item_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaItem", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_media_item_type_id__volatile, rygel_media_item_type_id);
	}
	return rygel_media_item_type_id__volatile;
}


#line 40 "rygel-http-time-seek-test.vala"
RygelAudioItem* rygel_audio_item_construct (GType object_type) {
#line 421 "rygel-http-time-seek-test.c"
	RygelAudioItem * self;
#line 40 "rygel-http-time-seek-test.vala"
	self = (RygelAudioItem*) rygel_media_item_construct (object_type);
#line 425 "rygel-http-time-seek-test.c"
	return self;
}


#line 40 "rygel-http-time-seek-test.vala"
RygelAudioItem* rygel_audio_item_new (void) {
#line 40 "rygel-http-time-seek-test.vala"
	return rygel_audio_item_construct (RYGEL_TYPE_AUDIO_ITEM);
#line 434 "rygel-http-time-seek-test.c"
}


static void rygel_audio_item_class_init (RygelAudioItemClass * klass) {
	rygel_audio_item_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_audio_item_finalize;
}


static void rygel_audio_item_instance_init (RygelAudioItem * self) {
	self->duration = (gint64) 2048;
}


static void rygel_audio_item_finalize (GObject* obj) {
	RygelAudioItem * self;
	self = RYGEL_AUDIO_ITEM (obj);
	G_OBJECT_CLASS (rygel_audio_item_parent_class)->finalize (obj);
}


GType rygel_audio_item_get_type (void) {
	static volatile gsize rygel_audio_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_audio_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelAudioItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_audio_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelAudioItem), 0, (GInstanceInitFunc) rygel_audio_item_instance_init, NULL };
		GType rygel_audio_item_type_id;
		rygel_audio_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_ITEM, "RygelAudioItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_audio_item_type_id__volatile, rygel_audio_item_type_id);
	}
	return rygel_audio_item_type_id__volatile;
}


#line 44 "rygel-http-time-seek-test.vala"
RygelThumbnail* rygel_thumbnail_construct (GType object_type) {
#line 470 "rygel-http-time-seek-test.c"
	RygelThumbnail * self;
#line 44 "rygel-http-time-seek-test.vala"
	self = (RygelThumbnail*) g_object_new (object_type, NULL);
#line 474 "rygel-http-time-seek-test.c"
	return self;
}


#line 44 "rygel-http-time-seek-test.vala"
RygelThumbnail* rygel_thumbnail_new (void) {
#line 44 "rygel-http-time-seek-test.vala"
	return rygel_thumbnail_construct (RYGEL_TYPE_THUMBNAIL);
#line 483 "rygel-http-time-seek-test.c"
}


static void rygel_thumbnail_class_init (RygelThumbnailClass * klass) {
	rygel_thumbnail_parent_class = g_type_class_peek_parent (klass);
}


static void rygel_thumbnail_instance_init (RygelThumbnail * self) {
}


GType rygel_thumbnail_get_type (void) {
	static volatile gsize rygel_thumbnail_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_thumbnail_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelThumbnailClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_thumbnail_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelThumbnail), 0, (GInstanceInitFunc) rygel_thumbnail_instance_init, NULL };
		GType rygel_thumbnail_type_id;
		rygel_thumbnail_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelThumbnail", &g_define_type_info, 0);
		g_once_init_leave (&rygel_thumbnail_type_id__volatile, rygel_thumbnail_type_id);
	}
	return rygel_thumbnail_type_id__volatile;
}


#line 45 "rygel-http-time-seek-test.vala"
RygelSubtitle* rygel_subtitle_construct (GType object_type) {
#line 510 "rygel-http-time-seek-test.c"
	RygelSubtitle * self;
#line 45 "rygel-http-time-seek-test.vala"
	self = (RygelSubtitle*) g_object_new (object_type, NULL);
#line 514 "rygel-http-time-seek-test.c"
	return self;
}


#line 45 "rygel-http-time-seek-test.vala"
RygelSubtitle* rygel_subtitle_new (void) {
#line 45 "rygel-http-time-seek-test.vala"
	return rygel_subtitle_construct (RYGEL_TYPE_SUBTITLE);
#line 523 "rygel-http-time-seek-test.c"
}


static void rygel_subtitle_class_init (RygelSubtitleClass * klass) {
	rygel_subtitle_parent_class = g_type_class_peek_parent (klass);
}


static void rygel_subtitle_instance_init (RygelSubtitle * self) {
}


GType rygel_subtitle_get_type (void) {
	static volatile gsize rygel_subtitle_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_subtitle_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelSubtitleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_subtitle_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSubtitle), 0, (GInstanceInitFunc) rygel_subtitle_instance_init, NULL };
		GType rygel_subtitle_type_id;
		rygel_subtitle_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelSubtitle", &g_define_type_info, 0);
		g_once_init_leave (&rygel_subtitle_type_id__volatile, rygel_subtitle_type_id);
	}
	return rygel_subtitle_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 57 "rygel-http-time-seek-test.vala"
RygelHTTPGet* rygel_http_get_construct (GType object_type, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
#line 555 "rygel-http-time-seek-test.c"
	RygelHTTPGet * self;
	SoupMessage* _tmp0_;
	RygelMediaItem* _tmp1_;
	RygelHTTPTranscodeHandler* _tmp2_;
	RygelThumbnail* _tmp3_;
	RygelSubtitle* _tmp4_;
#line 57 "rygel-http-time-seek-test.vala"
	self = (RygelHTTPGet*) g_object_new (object_type, NULL);
#line 58 "rygel-http-time-seek-test.vala"
	self->msg = (_tmp0_ = soup_message_new ("HTTP", RYGEL_HTTP_GET_ITEM_URI), _g_object_unref0 (self->msg), _tmp0_);
#line 59 "rygel-http-time-seek-test.vala"
	self->item = (_tmp1_ = (RygelMediaItem*) rygel_audio_item_new (), _g_object_unref0 (self->item), _tmp1_);
#line 60 "rygel-http-time-seek-test.vala"
	self->handler = (_tmp2_ = rygel_http_transcode_handler_new (), _g_object_unref0 (self->handler), _tmp2_);
#line 61 "rygel-http-time-seek-test.vala"
	self->thumbnail = (_tmp3_ = _g_object_ref0 (thumbnail), _g_object_unref0 (self->thumbnail), _tmp3_);
#line 62 "rygel-http-time-seek-test.vala"
	self->subtitle = (_tmp4_ = _g_object_ref0 (subtitle), _g_object_unref0 (self->subtitle), _tmp4_);
#line 574 "rygel-http-time-seek-test.c"
	return self;
}


#line 57 "rygel-http-time-seek-test.vala"
RygelHTTPGet* rygel_http_get_new (RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
#line 57 "rygel-http-time-seek-test.vala"
	return rygel_http_get_construct (RYGEL_TYPE_HTTP_GET, thumbnail, subtitle);
#line 583 "rygel-http-time-seek-test.c"
}


#line 65 "rygel-http-time-seek-test.vala"
RygelHTTPGet* rygel_http_get_construct_seek_start (GType object_type, gint64 start, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
#line 589 "rygel-http-time-seek-test.c"
	RygelHTTPGet * self;
#line 68 "rygel-http-time-seek-test.vala"
	self = (RygelHTTPGet*) rygel_http_get_construct (object_type, thumbnail, subtitle);
#line 70 "rygel-http-time-seek-test.vala"
	rygel_http_get_add_headers (self, start, (gint64) (-1));
#line 595 "rygel-http-time-seek-test.c"
	return self;
}


#line 65 "rygel-http-time-seek-test.vala"
RygelHTTPGet* rygel_http_get_new_seek_start (gint64 start, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
#line 65 "rygel-http-time-seek-test.vala"
	return rygel_http_get_construct_seek_start (RYGEL_TYPE_HTTP_GET, start, thumbnail, subtitle);
#line 604 "rygel-http-time-seek-test.c"
}


#line 73 "rygel-http-time-seek-test.vala"
RygelHTTPGet* rygel_http_get_construct_seek_stop (GType object_type, gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
#line 610 "rygel-http-time-seek-test.c"
	RygelHTTPGet * self;
#line 76 "rygel-http-time-seek-test.vala"
	self = (RygelHTTPGet*) rygel_http_get_construct (object_type, thumbnail, subtitle);
#line 78 "rygel-http-time-seek-test.vala"
	rygel_http_get_add_headers (self, (gint64) 0, stop);
#line 616 "rygel-http-time-seek-test.c"
	return self;
}


#line 73 "rygel-http-time-seek-test.vala"
RygelHTTPGet* rygel_http_get_new_seek_stop (gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
#line 73 "rygel-http-time-seek-test.vala"
	return rygel_http_get_construct_seek_stop (RYGEL_TYPE_HTTP_GET, stop, thumbnail, subtitle);
#line 625 "rygel-http-time-seek-test.c"
}


#line 81 "rygel-http-time-seek-test.vala"
RygelHTTPGet* rygel_http_get_construct_seek_start_stop (GType object_type, gint64 start, gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
#line 631 "rygel-http-time-seek-test.c"
	RygelHTTPGet * self;
#line 85 "rygel-http-time-seek-test.vala"
	self = (RygelHTTPGet*) rygel_http_get_construct (object_type, thumbnail, subtitle);
#line 87 "rygel-http-time-seek-test.vala"
	rygel_http_get_add_headers (self, start, stop);
#line 637 "rygel-http-time-seek-test.c"
	return self;
}


#line 81 "rygel-http-time-seek-test.vala"
RygelHTTPGet* rygel_http_get_new_seek_start_stop (gint64 start, gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
#line 81 "rygel-http-time-seek-test.vala"
	return rygel_http_get_construct_seek_start_stop (RYGEL_TYPE_HTTP_GET, start, stop, thumbnail, subtitle);
#line 646 "rygel-http-time-seek-test.c"
}


#line 90 "rygel-http-time-seek-test.vala"
static void rygel_http_get_add_headers (RygelHTTPGet* self, gint64 start, gint64 stop) {
#line 652 "rygel-http-time-seek-test.c"
	char* _tmp0_;
	char* stop_str;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	char* _tmp6_;
	char* range;
#line 90 "rygel-http-time-seek-test.vala"
	g_return_if_fail (self != NULL);
#line 662 "rygel-http-time-seek-test.c"
	g_return_if_fail (start >= 0);
	_tmp0_ = NULL;
#line 91 "rygel-http-time-seek-test.vala"
	if (stop > 0) {
#line 667 "rygel-http-time-seek-test.c"
		char* _tmp1_;
#line 91 "rygel-http-time-seek-test.vala"
		_tmp0_ = (_tmp1_ = g_strdup_printf ("%" G_GINT64_FORMAT, stop), _g_free0 (_tmp0_), _tmp1_);
#line 671 "rygel-http-time-seek-test.c"
	} else {
		char* _tmp2_;
#line 91 "rygel-http-time-seek-test.vala"
		_tmp0_ = (_tmp2_ = g_strdup (""), _g_free0 (_tmp0_), _tmp2_);
#line 676 "rygel-http-time-seek-test.c"
	}
#line 91 "rygel-http-time-seek-test.vala"
	stop_str = g_strdup (_tmp0_);
#line 92 "rygel-http-time-seek-test.vala"
	range = (_tmp6_ = g_strconcat (_tmp5_ = g_strconcat (_tmp4_ = g_strconcat ("npt=", _tmp3_ = g_strdup_printf ("%" G_GINT64_FORMAT, start), NULL), "-", NULL), stop_str, NULL), _g_free0 (_tmp5_), _g_free0 (_tmp4_), _g_free0 (_tmp3_), _tmp6_);
#line 93 "rygel-http-time-seek-test.vala"
	soup_message_headers_append (self->msg->request_headers, "TimeSeekRange.dlna.org", range);
#line 684 "rygel-http-time-seek-test.c"
	_g_free0 (range);
	_g_free0 (stop_str);
	_g_free0 (_tmp0_);
}


static void rygel_http_get_class_init (RygelHTTPGetClass * klass) {
	rygel_http_get_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_http_get_finalize;
}


static void rygel_http_get_instance_init (RygelHTTPGet * self) {
}


static void rygel_http_get_finalize (GObject* obj) {
	RygelHTTPGet * self;
	self = RYGEL_HTTP_GET (obj);
	_g_object_unref0 (self->msg);
	_g_object_unref0 (self->item);
	_g_object_unref0 (self->thumbnail);
	_g_object_unref0 (self->subtitle);
	_g_object_unref0 (self->handler);
	G_OBJECT_CLASS (rygel_http_get_parent_class)->finalize (obj);
}


GType rygel_http_get_get_type (void) {
	static volatile gsize rygel_http_get_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_get_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPGetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_get_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPGet), 0, (GInstanceInitFunc) rygel_http_get_instance_init, NULL };
		GType rygel_http_get_type_id;
		rygel_http_get_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPGet", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_get_type_id__volatile, rygel_http_get_type_id);
	}
	return rygel_http_get_type_id__volatile;
}


#line 100 "rygel-http-time-seek-test.vala"
gint rygel_http_time_seek_test_main (char** args, int args_length1) {
#line 727 "rygel-http-time-seek-test.c"
	gint result = 0;
	GError * _inner_error_ = NULL;
	{
		RygelHTTPTimeSeekTest* test;
#line 102 "rygel-http-time-seek-test.vala"
		test = rygel_http_time_seek_test_new ();
#line 104 "rygel-http-time-seek-test.vala"
		rygel_http_time_seek_test_run (test, &_inner_error_);
#line 736 "rygel-http-time-seek-test.c"
		if (_inner_error_ != NULL) {
			_g_object_unref0 (test);
			if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
				goto __catch0_rygel_test_error_skip;
			}
			goto __catch0_g_error;
		}
		_g_object_unref0 (test);
	}
	goto __finally0;
	__catch0_rygel_test_error_skip:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
			result = 77;
			_g_error_free0 (_error_);
#line 106 "rygel-http-time-seek-test.vala"
			return result;
#line 757 "rygel-http-time-seek-test.c"
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
#line 108 "rygel-http-time-seek-test.vala"
			g_critical ("rygel-http-time-seek-test.vala:108: %s", _error_->message);
#line 769 "rygel-http-time-seek-test.c"
			result = -1;
			_g_error_free0 (_error_);
#line 110 "rygel-http-time-seek-test.vala"
			return result;
#line 774 "rygel-http-time-seek-test.c"
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = 0;
#line 113 "rygel-http-time-seek-test.vala"
	return result;
#line 786 "rygel-http-time-seek-test.c"
}


#line 100 "rygel-http-time-seek-test.vala"
int main (int argc, char ** argv) {
#line 792 "rygel-http-time-seek-test.c"
	g_thread_init (NULL);
#line 100 "rygel-http-time-seek-test.vala"
	g_type_init ();
#line 100 "rygel-http-time-seek-test.vala"
	return rygel_http_time_seek_test_main (argv, argc);
#line 798 "rygel-http-time-seek-test.c"
}


#line 116 "rygel-http-time-seek-test.vala"
void rygel_http_time_seek_test_run (RygelHTTPTimeSeekTest* self, GError** error) {
#line 804 "rygel-http-time-seek-test.c"
	gint thumbnails_length1;
	gint _thumbnails_size_;
	RygelThumbnail** _tmp1_;
	RygelThumbnail** _tmp0_ = NULL;
	RygelThumbnail** thumbnails;
	gint subtitles_length1;
	gint _subtitles_size_;
	RygelSubtitle** _tmp3_;
	RygelSubtitle** _tmp2_ = NULL;
	RygelSubtitle** subtitles;
	GError * _inner_error_ = NULL;
#line 116 "rygel-http-time-seek-test.vala"
	g_return_if_fail (self != NULL);
#line 818 "rygel-http-time-seek-test.c"
	thumbnails = (_tmp1_ = (_tmp0_ = g_new0 (RygelThumbnail*, 2 + 1), _tmp0_[0] = NULL, _tmp0_[1] = rygel_thumbnail_new (), _tmp0_), thumbnails_length1 = 2, _thumbnails_size_ = thumbnails_length1, _tmp1_);
	subtitles = (_tmp3_ = (_tmp2_ = g_new0 (RygelSubtitle*, 2 + 1), _tmp2_[0] = NULL, _tmp2_[1] = rygel_subtitle_new (), _tmp2_), subtitles_length1 = 2, _subtitles_size_ = subtitles_length1, _tmp3_);
	{
		RygelThumbnail** thumbnail_collection;
		int thumbnail_collection_length1;
		int thumbnail_it;
#line 120 "rygel-http-time-seek-test.vala"
		thumbnail_collection = thumbnails;
#line 827 "rygel-http-time-seek-test.c"
		thumbnail_collection_length1 = thumbnails_length1;
		for (thumbnail_it = 0; thumbnail_it < thumbnails_length1; thumbnail_it = thumbnail_it + 1) {
			RygelThumbnail* thumbnail;
			thumbnail = _g_object_ref0 (thumbnail_collection[thumbnail_it]);
			{
				{
					RygelSubtitle** subtitle_collection;
					int subtitle_collection_length1;
					int subtitle_it;
#line 121 "rygel-http-time-seek-test.vala"
					subtitle_collection = subtitles;
#line 839 "rygel-http-time-seek-test.c"
					subtitle_collection_length1 = subtitles_length1;
					for (subtitle_it = 0; subtitle_it < subtitles_length1; subtitle_it = subtitle_it + 1) {
						RygelSubtitle* subtitle;
						subtitle = _g_object_ref0 (subtitle_collection[subtitle_it]);
						{
#line 122 "rygel-http-time-seek-test.vala"
							rygel_http_time_seek_test_test_no_seek (self, thumbnail, subtitle, &_inner_error_);
#line 847 "rygel-http-time-seek-test.c"
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
									g_propagate_error (error, _inner_error_);
									_g_object_unref0 (subtitle);
									_g_object_unref0 (thumbnail);
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
									return;
								} else {
									_g_object_unref0 (subtitle);
									_g_object_unref0 (thumbnail);
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
#line 123 "rygel-http-time-seek-test.vala"
							rygel_http_time_seek_test_test_start_only_seek (self, thumbnail, subtitle, &_inner_error_);
#line 868 "rygel-http-time-seek-test.c"
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
									g_propagate_error (error, _inner_error_);
									_g_object_unref0 (subtitle);
									_g_object_unref0 (thumbnail);
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
									return;
								} else {
									_g_object_unref0 (subtitle);
									_g_object_unref0 (thumbnail);
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
#line 124 "rygel-http-time-seek-test.vala"
							rygel_http_time_seek_test_test_stop_only_seek (self, thumbnail, subtitle, &_inner_error_);
#line 889 "rygel-http-time-seek-test.c"
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
									g_propagate_error (error, _inner_error_);
									_g_object_unref0 (subtitle);
									_g_object_unref0 (thumbnail);
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
									return;
								} else {
									_g_object_unref0 (subtitle);
									_g_object_unref0 (thumbnail);
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
#line 125 "rygel-http-time-seek-test.vala"
							rygel_http_time_seek_test_test_start_stop_seek (self, thumbnail, subtitle, &_inner_error_);
#line 910 "rygel-http-time-seek-test.c"
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
									g_propagate_error (error, _inner_error_);
									_g_object_unref0 (subtitle);
									_g_object_unref0 (thumbnail);
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
									return;
								} else {
									_g_object_unref0 (subtitle);
									_g_object_unref0 (thumbnail);
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							_g_object_unref0 (subtitle);
						}
					}
				}
				_g_object_unref0 (thumbnail);
			}
		}
	}
	subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
	thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
}


#line 130 "rygel-http-time-seek-test.vala"
static RygelHTTPTimeSeekTest* rygel_http_time_seek_test_construct (GType object_type) {
#line 944 "rygel-http-time-seek-test.c"
	RygelHTTPTimeSeekTest * self;
	char* expression;
	GRegex* _tmp0_;
	GRegex* _tmp1_;
	GError * _inner_error_ = NULL;
#line 130 "rygel-http-time-seek-test.vala"
	self = (RygelHTTPTimeSeekTest*) g_object_new (object_type, NULL);
#line 131 "rygel-http-time-seek-test.vala"
	expression = g_strdup ("npt=[0-9]+\\.[0-9][0-9]-" "[0-9]+\\.[0-9][0-9]/" "[0-9]+\\.[0-9][0-9]");
#line 134 "rygel-http-time-seek-test.vala"
	_tmp0_ = g_regex_new (expression, G_REGEX_CASELESS, 0, &_inner_error_);
#line 956 "rygel-http-time-seek-test.c"
	if (_inner_error_ != NULL) {
		_g_free0 (expression);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
#line 134 "rygel-http-time-seek-test.vala"
	self->priv->range_regex = (_tmp1_ = _tmp0_, _g_regex_unref0 (self->priv->range_regex), _tmp1_);
#line 965 "rygel-http-time-seek-test.c"
	_g_free0 (expression);
	return self;
}


#line 130 "rygel-http-time-seek-test.vala"
static RygelHTTPTimeSeekTest* rygel_http_time_seek_test_new (void) {
#line 130 "rygel-http-time-seek-test.vala"
	return rygel_http_time_seek_test_construct (RYGEL_TYPE_HTTP_TIME_SEEK_TEST);
#line 975 "rygel-http-time-seek-test.c"
}


#line 137 "rygel-http-time-seek-test.vala"
static void rygel_http_time_seek_test_test_no_seek (RygelHTTPTimeSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error) {
#line 981 "rygel-http-time-seek-test.c"
	RygelHTTPGet* request;
	RygelMediaItem* _tmp0_;
	RygelAudioItem* audio_item;
	GError * _inner_error_ = NULL;
#line 137 "rygel-http-time-seek-test.vala"
	g_return_if_fail (self != NULL);
#line 139 "rygel-http-time-seek-test.vala"
	request = rygel_http_get_new (thumbnail, subtitle);
#line 140 "rygel-http-time-seek-test.vala"
	audio_item = _g_object_ref0 ((_tmp0_ = request->item, RYGEL_IS_AUDIO_ITEM (_tmp0_) ? ((RygelAudioItem*) _tmp0_) : NULL));
#line 142 "rygel-http-time-seek-test.vala"
	rygel_http_time_seek_test_test_seek (self, request, (gint64) 0, audio_item->duration - 1, &_inner_error_);
#line 994 "rygel-http-time-seek-test.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (audio_item);
			_g_object_unref0 (request);
			return;
		} else {
			_g_object_unref0 (audio_item);
			_g_object_unref0 (request);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (audio_item);
	_g_object_unref0 (request);
}


#line 145 "rygel-http-time-seek-test.vala"
static void rygel_http_time_seek_test_test_start_only_seek (RygelHTTPTimeSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error) {
#line 1016 "rygel-http-time-seek-test.c"
	RygelHTTPGet* request;
	RygelMediaItem* _tmp0_;
	RygelAudioItem* audio_item;
	GError * _inner_error_ = NULL;
#line 145 "rygel-http-time-seek-test.vala"
	g_return_if_fail (self != NULL);
#line 148 "rygel-http-time-seek-test.vala"
	request = rygel_http_get_new_seek_start ((gint64) 128, thumbnail, subtitle);
#line 149 "rygel-http-time-seek-test.vala"
	audio_item = _g_object_ref0 ((_tmp0_ = request->item, RYGEL_IS_AUDIO_ITEM (_tmp0_) ? ((RygelAudioItem*) _tmp0_) : NULL));
#line 151 "rygel-http-time-seek-test.vala"
	rygel_http_time_seek_test_test_seek (self, request, (gint64) 128, audio_item->duration - 1, &_inner_error_);
#line 1029 "rygel-http-time-seek-test.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (audio_item);
			_g_object_unref0 (request);
			return;
		} else {
			_g_object_unref0 (audio_item);
			_g_object_unref0 (request);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (audio_item);
	_g_object_unref0 (request);
}


#line 154 "rygel-http-time-seek-test.vala"
static void rygel_http_time_seek_test_test_stop_only_seek (RygelHTTPTimeSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error) {
#line 1051 "rygel-http-time-seek-test.c"
	RygelHTTPGet* request;
	GError * _inner_error_ = NULL;
#line 154 "rygel-http-time-seek-test.vala"
	g_return_if_fail (self != NULL);
#line 157 "rygel-http-time-seek-test.vala"
	request = rygel_http_get_new_seek_stop ((gint64) 128, thumbnail, subtitle);
#line 159 "rygel-http-time-seek-test.vala"
	rygel_http_time_seek_test_test_seek (self, request, (gint64) 0, (gint64) 128, &_inner_error_);
#line 1060 "rygel-http-time-seek-test.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (request);
			return;
		} else {
			_g_object_unref0 (request);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (request);
}


#line 162 "rygel-http-time-seek-test.vala"
static void rygel_http_time_seek_test_test_start_stop_seek (RygelHTTPTimeSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error) {
#line 1079 "rygel-http-time-seek-test.c"
	RygelHTTPGet* request;
	GError * _inner_error_ = NULL;
#line 162 "rygel-http-time-seek-test.vala"
	g_return_if_fail (self != NULL);
#line 165 "rygel-http-time-seek-test.vala"
	request = rygel_http_get_new_seek_start_stop ((gint64) 128, (gint64) 256, thumbnail, subtitle);
#line 170 "rygel-http-time-seek-test.vala"
	rygel_http_time_seek_test_test_seek (self, request, (gint64) 128, (gint64) 256, &_inner_error_);
#line 1088 "rygel-http-time-seek-test.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (request);
			return;
		} else {
			_g_object_unref0 (request);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (request);
}


#line 173 "rygel-http-time-seek-test.vala"
static void rygel_http_time_seek_test_test_seek (RygelHTTPTimeSeekTest* self, RygelHTTPGet* request, gint64 start, gint64 stop, GError** error) {
#line 1107 "rygel-http-time-seek-test.c"
	RygelHTTPTimeSeek* seek;
	RygelMediaItem* _tmp0_;
	RygelAudioItem* audio_item;
	char* header;
	GError * _inner_error_ = NULL;
#line 173 "rygel-http-time-seek-test.vala"
	g_return_if_fail (self != NULL);
#line 173 "rygel-http-time-seek-test.vala"
	g_return_if_fail (request != NULL);
#line 176 "rygel-http-time-seek-test.vala"
	g_assert (rygel_http_time_seek_needed (request));
#line 178 "rygel-http-time-seek-test.vala"
	seek = rygel_http_time_seek_new (request, &_inner_error_);
#line 1121 "rygel-http-time-seek-test.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
#line 179 "rygel-http-time-seek-test.vala"
	rygel_http_seek_add_response_headers ((RygelHTTPSeek*) seek);
#line 181 "rygel-http-time-seek-test.vala"
	g_assert (seek != NULL);
#line 182 "rygel-http-time-seek-test.vala"
	g_assert (rygel_http_seek_get_start ((RygelHTTPSeek*) seek) == (start * GST_SECOND));
#line 183 "rygel-http-time-seek-test.vala"
	g_assert (rygel_http_seek_get_stop ((RygelHTTPSeek*) seek) == (stop * GST_SECOND));
#line 184 "rygel-http-time-seek-test.vala"
	g_assert (rygel_http_seek_get_length ((RygelHTTPSeek*) seek) == ((rygel_http_seek_get_stop ((RygelHTTPSeek*) seek) + 1) - rygel_http_seek_get_start ((RygelHTTPSeek*) seek)));
#line 186 "rygel-http-time-seek-test.vala"
	audio_item = _g_object_ref0 ((_tmp0_ = request->item, RYGEL_IS_AUDIO_ITEM (_tmp0_) ? ((RygelAudioItem*) _tmp0_) : NULL));
#line 187 "rygel-http-time-seek-test.vala"
	g_assert (rygel_http_seek_get_total_length ((RygelHTTPSeek*) seek) == (audio_item->duration * GST_SECOND));
#line 189 "rygel-http-time-seek-test.vala"
	header = g_strdup (soup_message_headers_get_one (request->msg->response_headers, "TimeSeekRange.dlna.org"));
#line 191 "rygel-http-time-seek-test.vala"
	g_assert (header != NULL);
#line 192 "rygel-http-time-seek-test.vala"
	g_assert (g_regex_match (self->priv->range_regex, header, 0, NULL));
#line 1152 "rygel-http-time-seek-test.c"
	_g_free0 (header);
	_g_object_unref0 (audio_item);
	_g_object_unref0 (seek);
}


static void rygel_http_time_seek_test_class_init (RygelHTTPTimeSeekTestClass * klass) {
	rygel_http_time_seek_test_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPTimeSeekTestPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_http_time_seek_test_finalize;
}


static void rygel_http_time_seek_test_instance_init (RygelHTTPTimeSeekTest * self) {
	self->priv = RYGEL_HTTP_TIME_SEEK_TEST_GET_PRIVATE (self);
}


static void rygel_http_time_seek_test_finalize (GObject* obj) {
	RygelHTTPTimeSeekTest * self;
	self = RYGEL_HTTP_TIME_SEEK_TEST (obj);
	_g_regex_unref0 (self->priv->range_regex);
	G_OBJECT_CLASS (rygel_http_time_seek_test_parent_class)->finalize (obj);
}


GType rygel_http_time_seek_test_get_type (void) {
	static volatile gsize rygel_http_time_seek_test_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_time_seek_test_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPTimeSeekTestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_time_seek_test_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPTimeSeekTest), 0, (GInstanceInitFunc) rygel_http_time_seek_test_instance_init, NULL };
		GType rygel_http_time_seek_test_type_id;
		rygel_http_time_seek_test_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPTimeSeekTest", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_time_seek_test_type_id__volatile, rygel_http_time_seek_test_type_id);
	}
	return rygel_http_time_seek_test_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}




