/* rygel-tracker-search-container.c generated by valac 0.10.0, the Vala compiler
 * generated from rygel-tracker-search-container.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008 Nokia Corporation.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *         Ivan Frade <ivan.frade@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TRACKER_TYPE_SEARCH_CONTAINER (rygel_tracker_search_container_get_type ())
#define RYGEL_TRACKER_SEARCH_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainer))
#define RYGEL_TRACKER_SEARCH_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainerClass))
#define RYGEL_TRACKER_IS_SEARCH_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER))
#define RYGEL_TRACKER_IS_SEARCH_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER))
#define RYGEL_TRACKER_SEARCH_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainerClass))

typedef struct _RygelTrackerSearchContainer RygelTrackerSearchContainer;
typedef struct _RygelTrackerSearchContainerClass RygelTrackerSearchContainerClass;
typedef struct _RygelTrackerSearchContainerPrivate RygelTrackerSearchContainerPrivate;

#define RYGEL_TRACKER_TYPE_QUERY (rygel_tracker_query_get_type ())
#define RYGEL_TRACKER_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQuery))
#define RYGEL_TRACKER_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQueryClass))
#define RYGEL_TRACKER_IS_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_QUERY))
#define RYGEL_TRACKER_IS_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_QUERY))
#define RYGEL_TRACKER_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQueryClass))

typedef struct _RygelTrackerQuery RygelTrackerQuery;
typedef struct _RygelTrackerQueryClass RygelTrackerQueryClass;

#define RYGEL_TRACKER_TYPE_SELECTION_QUERY (rygel_tracker_selection_query_get_type ())
#define RYGEL_TRACKER_SELECTION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_SELECTION_QUERY, RygelTrackerSelectionQuery))
#define RYGEL_TRACKER_SELECTION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_SELECTION_QUERY, RygelTrackerSelectionQueryClass))
#define RYGEL_TRACKER_IS_SELECTION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_SELECTION_QUERY))
#define RYGEL_TRACKER_IS_SELECTION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_SELECTION_QUERY))
#define RYGEL_TRACKER_SELECTION_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_SELECTION_QUERY, RygelTrackerSelectionQueryClass))

typedef struct _RygelTrackerSelectionQuery RygelTrackerSelectionQuery;
typedef struct _RygelTrackerSelectionQueryClass RygelTrackerSelectionQueryClass;

#define RYGEL_TRACKER_TYPE_ITEM_FACTORY (rygel_tracker_item_factory_get_type ())
#define RYGEL_TRACKER_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactory))
#define RYGEL_TRACKER_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactoryClass))
#define RYGEL_TRACKER_IS_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY))
#define RYGEL_TRACKER_IS_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_ITEM_FACTORY))
#define RYGEL_TRACKER_ITEM_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactoryClass))

typedef struct _RygelTrackerItemFactory RygelTrackerItemFactory;
typedef struct _RygelTrackerItemFactoryClass RygelTrackerItemFactoryClass;

#define RYGEL_TRACKER_TYPE_RESOURCES_IFACE (rygel_tracker_resources_iface_get_type ())
#define RYGEL_TRACKER_RESOURCES_IFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_RESOURCES_IFACE, RygelTrackerResourcesIface))
#define RYGEL_TRACKER_IS_RESOURCES_IFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_RESOURCES_IFACE))
#define RYGEL_TRACKER_RESOURCES_IFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TRACKER_TYPE_RESOURCES_IFACE, RygelTrackerResourcesIfaceIface))

typedef struct _RygelTrackerResourcesIface RygelTrackerResourcesIface;
typedef struct _RygelTrackerResourcesIfaceIface RygelTrackerResourcesIfaceIface;

#define RYGEL_TRACKER_TYPE_RESOURCES_IFACE_PROXY (rygel_tracker_resources_iface_proxy_get_type ())
#define _rygel_tracker_query_unref0(var) ((var == NULL) ? NULL : (var = (rygel_tracker_query_unref (var), NULL)))
#define _rygel_tracker_item_factory_unref0(var) ((var == NULL) ? NULL : (var = (rygel_tracker_item_factory_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TRACKER_TYPE_QUERY_TRIPLETS (rygel_tracker_query_triplets_get_type ())
#define RYGEL_TRACKER_QUERY_TRIPLETS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTriplets))
#define RYGEL_TRACKER_QUERY_TRIPLETS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTripletsClass))
#define RYGEL_TRACKER_IS_QUERY_TRIPLETS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS))
#define RYGEL_TRACKER_IS_QUERY_TRIPLETS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS))
#define RYGEL_TRACKER_QUERY_TRIPLETS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTripletsClass))

typedef struct _RygelTrackerQueryTriplets RygelTrackerQueryTriplets;
typedef struct _RygelTrackerQueryTripletsClass RygelTrackerQueryTripletsClass;

#define RYGEL_TRACKER_TYPE_QUERY_TRIPLET (rygel_tracker_query_triplet_get_type ())
#define RYGEL_TRACKER_QUERY_TRIPLET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLET, RygelTrackerQueryTriplet))
#define RYGEL_TRACKER_QUERY_TRIPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLET, RygelTrackerQueryTripletClass))
#define RYGEL_TRACKER_IS_QUERY_TRIPLET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLET))
#define RYGEL_TRACKER_IS_QUERY_TRIPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLET))
#define RYGEL_TRACKER_QUERY_TRIPLET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLET, RygelTrackerQueryTripletClass))

typedef struct _RygelTrackerQueryTriplet RygelTrackerQueryTriplet;
typedef struct _RygelTrackerQueryTripletClass RygelTrackerQueryTripletClass;
typedef struct _RygelTrackerItemFactoryPrivate RygelTrackerItemFactoryPrivate;
#define _rygel_tracker_query_triplet_unref0(var) ((var == NULL) ? NULL : (var = (rygel_tracker_query_triplet_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
typedef struct _RygelTrackerSearchContainerGetChildrenData RygelTrackerSearchContainerGetChildrenData;
typedef struct _RygelTrackerQueryPrivate RygelTrackerQueryPrivate;
typedef struct _RygelTrackerSelectionQueryPrivate RygelTrackerSelectionQueryPrivate;
typedef struct _RygelTrackerSearchContainerSearchData RygelTrackerSearchContainerSearchData;
typedef struct _RygelTrackerSearchContainerFindObjectData RygelTrackerSearchContainerFindObjectData;
typedef struct _RygelTrackerSearchContainerGetChildrenCountData RygelTrackerSearchContainerGetChildrenCountData;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _RygelTrackerSearchContainer {
	RygelMediaContainer parent_instance;
	RygelTrackerSearchContainerPrivate * priv;
	RygelTrackerSelectionQuery* query;
	RygelTrackerItemFactory* item_factory;
};

struct _RygelTrackerSearchContainerClass {
	RygelMediaContainerClass parent_class;
};

struct _RygelTrackerResourcesIfaceIface {
	GTypeInterface parent_iface;
	void (*sparql_query) (RygelTrackerResourcesIface* self, const char* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
	char** (*sparql_query_finish) (RygelTrackerResourcesIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
	void (*sparql_update_blank) (RygelTrackerResourcesIface* self, const char* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable** (*sparql_update_blank_finish) (RygelTrackerResourcesIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
};

struct _RygelTrackerSearchContainerPrivate {
	RygelTrackerResourcesIface* resources;
};

struct _RygelTrackerItemFactory {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTrackerItemFactoryPrivate * priv;
	char* category;
	char* upnp_class;
	char* resources_class_path;
	char* upload_dir;
	GeeArrayList* key_chains;
};

struct _RygelTrackerItemFactoryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTrackerItemFactory *self);
	RygelMediaItem* (*create) (RygelTrackerItemFactory* self, const char* id, const char* uri, RygelTrackerSearchContainer* parent, char** metadata, int metadata_length1, GError** error);
	void (*set_metadata) (RygelTrackerItemFactory* self, RygelMediaItem* item, const char* uri, char** metadata, int metadata_length1, GError** error);
};

struct _RygelTrackerSearchContainerGetChildrenData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelTrackerSearchContainer* self;
	guint offset;
	guint max_count;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	RygelRelationalExpression* expression;
	char* _tmp0_;
	char* _tmp1_;
	guint total_matches;
	RygelMediaObjects* _tmp2_;
	GError * _inner_error_;
};

struct _RygelTrackerQuery {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTrackerQueryPrivate * priv;
	RygelTrackerQueryTriplets* triplets;
};

struct _RygelTrackerQueryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTrackerQuery *self);
	void (*execute) (RygelTrackerQuery* self, RygelTrackerResourcesIface* resources, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*execute_finish) (RygelTrackerQuery* self, GAsyncResult* _res_, GError** error);
	char* (*to_string) (RygelTrackerQuery* self);
};

struct _RygelTrackerSelectionQuery {
	RygelTrackerQuery parent_instance;
	RygelTrackerSelectionQueryPrivate * priv;
	GeeArrayList* variables;
	GeeArrayList* filters;
	char* order_by;
	gint offset;
	gint max_count;
	char** result;
	gint result_length1;
	gint result_length2;
};

struct _RygelTrackerSelectionQueryClass {
	RygelTrackerQueryClass parent_class;
};

struct _RygelTrackerSearchContainerSearchData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelTrackerSearchContainer* self;
	RygelSearchExpression* expression;
	guint offset;
	guint max_count;
	guint total_matches;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	RygelMediaObjects* results;
	gboolean _tmp0_;
	RygelMediaObjects* _tmp1_;
	RygelTrackerSelectionQuery* query;
	RygelSearchExpression* _tmp2_;
	guint i;
	gboolean _tmp3_;
	char* id;
	char* uri;
	char** metadata;
	gint _tmp4_;
	gint metadata_length1;
	gint _metadata_size_;
	char** _tmp5_;
	RygelMediaItem* item;
	GError * _inner_error_;
};

struct _RygelTrackerSearchContainerFindObjectData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelTrackerSearchContainer* self;
	char* id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	RygelMediaObject* _tmp0_;
	GError * _inner_error_;
};

struct _RygelTrackerSearchContainerGetChildrenCountData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelTrackerSearchContainer* self;
	RygelTrackerSelectionQuery* query;
	GeeArrayList* _tmp0_;
	GError * _error_;
	GError * _inner_error_;
};


static gpointer rygel_tracker_search_container_parent_class = NULL;

GType rygel_tracker_search_container_get_type (void) G_GNUC_CONST;
gpointer rygel_tracker_query_ref (gpointer instance);
void rygel_tracker_query_unref (gpointer instance);
GParamSpec* rygel_tracker_param_spec_query (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_tracker_value_set_query (GValue* value, gpointer v_object);
void rygel_tracker_value_take_query (GValue* value, gpointer v_object);
gpointer rygel_tracker_value_get_query (const GValue* value);
GType rygel_tracker_query_get_type (void) G_GNUC_CONST;
GType rygel_tracker_selection_query_get_type (void) G_GNUC_CONST;
gpointer rygel_tracker_item_factory_ref (gpointer instance);
void rygel_tracker_item_factory_unref (gpointer instance);
GParamSpec* rygel_tracker_param_spec_item_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_tracker_value_set_item_factory (GValue* value, gpointer v_object);
void rygel_tracker_value_take_item_factory (GValue* value, gpointer v_object);
gpointer rygel_tracker_value_get_item_factory (const GValue* value);
GType rygel_tracker_item_factory_get_type (void) G_GNUC_CONST;
GType rygel_tracker_resources_iface_proxy_get_type (void) G_GNUC_CONST;
guint rygel_tracker_resources_iface_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType rygel_tracker_resources_iface_get_type (void) G_GNUC_CONST;
#define RYGEL_TRACKER_SEARCH_CONTAINER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainerPrivate))
enum  {
	RYGEL_TRACKER_SEARCH_CONTAINER_DUMMY_PROPERTY
};
#define RYGEL_TRACKER_SEARCH_CONTAINER_TRACKER_SERVICE "org.freedesktop.Tracker1"
#define RYGEL_TRACKER_SEARCH_CONTAINER_RESOURCES_PATH "/org/freedesktop/Tracker1/Resources"
#define RYGEL_TRACKER_SEARCH_CONTAINER_ITEM_VARIABLE "?item"
#define RYGEL_TRACKER_SEARCH_CONTAINER_MODIFIED_PREDICATE "nfo:fileLastModified"
#define RYGEL_TRACKER_SEARCH_CONTAINER_MODIFIED_VARIABLE "?modified"
#define RYGEL_TRACKER_SEARCH_CONTAINER_URL_PREDICATE "nie:url"
#define RYGEL_TRACKER_SEARCH_CONTAINER_URL_VARIABLE "?url"
GType rygel_tracker_query_triplets_get_type (void) G_GNUC_CONST;
RygelTrackerSearchContainer* rygel_tracker_search_container_new (const char* id, RygelMediaContainer* parent, const char* title, RygelTrackerItemFactory* item_factory, RygelTrackerQueryTriplets* triplets, GeeArrayList* filters);
RygelTrackerSearchContainer* rygel_tracker_search_container_construct (GType object_type, const char* id, RygelMediaContainer* parent, const char* title, RygelTrackerItemFactory* item_factory, RygelTrackerQueryTriplets* triplets, GeeArrayList* filters);
RygelTrackerQueryTriplets* rygel_tracker_query_triplets_new (void);
RygelTrackerQueryTriplets* rygel_tracker_query_triplets_construct (GType object_type);
gpointer rygel_tracker_query_triplet_ref (gpointer instance);
void rygel_tracker_query_triplet_unref (gpointer instance);
GParamSpec* rygel_tracker_param_spec_query_triplet (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_tracker_value_set_query_triplet (GValue* value, gpointer v_object);
void rygel_tracker_value_take_query_triplet (GValue* value, gpointer v_object);
gpointer rygel_tracker_value_get_query_triplet (const GValue* value);
GType rygel_tracker_query_triplet_get_type (void) G_GNUC_CONST;
void rygel_tracker_query_triplets_add_triplet (RygelTrackerQueryTriplets* self, RygelTrackerQueryTriplet* triplet);
RygelTrackerQueryTriplet* rygel_tracker_query_triplet_new (const char* subject, const char* predicate, const char* obj);
RygelTrackerQueryTriplet* rygel_tracker_query_triplet_construct (GType object_type, const char* subject, const char* predicate, const char* obj);
RygelTrackerSelectionQuery* rygel_tracker_selection_query_new (GeeArrayList* variables, RygelTrackerQueryTriplets* triplets, GeeArrayList* filters, const char* order_by, gint offset, gint max_count);
RygelTrackerSelectionQuery* rygel_tracker_selection_query_construct (GType object_type, GeeArrayList* variables, RygelTrackerQueryTriplets* triplets, GeeArrayList* filters, const char* order_by, gint offset, gint max_count);
static void rygel_tracker_search_container_get_children_count (RygelTrackerSearchContainer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_tracker_search_container_get_children_count_finish (RygelTrackerSearchContainer* self, GAsyncResult* _res_);
static void rygel_tracker_search_container_real_get_children_data_free (gpointer _data);
static void rygel_tracker_search_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_tracker_search_container_get_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_tracker_search_container_real_get_children_co (RygelTrackerSearchContainerGetChildrenData* data);
static void rygel_tracker_search_container_real_search_data_free (gpointer _data);
static void rygel_tracker_search_container_real_search (RygelMediaContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_tracker_search_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_tracker_search_container_real_search_co (RygelTrackerSearchContainerSearchData* data);
static RygelTrackerSelectionQuery* rygel_tracker_search_container_create_query (RygelTrackerSearchContainer* self, RygelRelationalExpression* expression, gint offset, gint max_count);
void rygel_tracker_query_execute (RygelTrackerQuery* self, RygelTrackerResourcesIface* resources, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_tracker_query_execute_finish (RygelTrackerQuery* self, GAsyncResult* _res_, GError** error);
char* rygel_tracker_search_container_create_child_id_for_urn (RygelTrackerSearchContainer* self, const char* urn);
static char** rygel_tracker_search_container_slice_strvv_tail (RygelTrackerSearchContainer* self, char** strvv, int strvv_length1, int strvv_length2, guint row, guint index, int* result_length1);
RygelMediaItem* rygel_tracker_item_factory_create (RygelTrackerItemFactory* self, const char* id, const char* uri, RygelTrackerSearchContainer* parent, char** metadata, int metadata_length1, GError** error);
static void rygel_tracker_search_container_real_find_object_data_free (gpointer _data);
static void rygel_tracker_search_container_real_find_object (RygelMediaContainer* base, const char* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_tracker_search_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_tracker_search_container_real_find_object_co (RygelTrackerSearchContainerFindObjectData* data);
static gboolean rygel_tracker_search_container_is_our_child (RygelTrackerSearchContainer* self, const char* id);
static void rygel_tracker_search_container_get_children_count_data_free (gpointer _data);
static void rygel_tracker_search_container_get_children_count_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_tracker_search_container_get_children_count_co (RygelTrackerSearchContainerGetChildrenCountData* data);
RygelTrackerSelectionQuery* rygel_tracker_selection_query_new_clone (RygelTrackerSelectionQuery* query);
RygelTrackerSelectionQuery* rygel_tracker_selection_query_construct_clone (GType object_type, RygelTrackerSelectionQuery* query);
static char* rygel_tracker_search_container_create_filter_for_child (RygelTrackerSearchContainer* self, RygelRelationalExpression* expression);
static char* rygel_tracker_search_container_get_item_info (RygelTrackerSearchContainer* self, const char* item_id, char** parent_id);
static char* rygel_tracker_search_container_escape_string (RygelTrackerSearchContainer* self, const char* literal);
static void rygel_tracker_search_container_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



static gpointer _rygel_tracker_item_factory_ref0 (gpointer self) {
	return self ? rygel_tracker_item_factory_ref (self) : NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 47 "rygel-tracker-search-container.vala"
RygelTrackerSearchContainer* rygel_tracker_search_container_construct (GType object_type, const char* id, RygelMediaContainer* parent, const char* title, RygelTrackerItemFactory* item_factory, RygelTrackerQueryTriplets* triplets, GeeArrayList* filters) {
#line 367 "rygel-tracker-search-container.c"
	RygelTrackerSearchContainer * self;
	RygelTrackerItemFactory* _tmp0_;
	GeeArrayList* variables;
	RygelTrackerQueryTriplets* our_triplets;
	RygelTrackerQueryTriplet* _tmp3_;
	RygelTrackerQueryTriplet* _tmp4_;
	RygelTrackerQueryTriplet* _tmp5_;
	RygelTrackerSelectionQuery* _tmp9_;
	GError * _inner_error_ = NULL;
#line 47 "rygel-tracker-search-container.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 47 "rygel-tracker-search-container.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 47 "rygel-tracker-search-container.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 47 "rygel-tracker-search-container.vala"
	g_return_val_if_fail (item_factory != NULL, NULL);
#line 53 "rygel-tracker-search-container.vala"
	self = (RygelTrackerSearchContainer*) rygel_media_container_construct (object_type, id, parent, title, 0);
#line 55 "rygel-tracker-search-container.vala"
	self->item_factory = (_tmp0_ = _rygel_tracker_item_factory_ref0 (item_factory), _rygel_tracker_item_factory_unref0 (self->item_factory), _tmp0_);
#line 57 "rygel-tracker-search-container.vala"
	variables = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
#line 58 "rygel-tracker-search-container.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) variables, RYGEL_TRACKER_SEARCH_CONTAINER_ITEM_VARIABLE);
#line 59 "rygel-tracker-search-container.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) variables, RYGEL_TRACKER_SEARCH_CONTAINER_URL_VARIABLE);
#line 395 "rygel-tracker-search-container.c"
	our_triplets = NULL;
#line 62 "rygel-tracker-search-container.vala"
	if (triplets != NULL) {
#line 399 "rygel-tracker-search-container.c"
		RygelTrackerQueryTriplets* _tmp1_;
#line 63 "rygel-tracker-search-container.vala"
		our_triplets = (_tmp1_ = _g_object_ref0 (triplets), _g_object_unref0 (our_triplets), _tmp1_);
#line 403 "rygel-tracker-search-container.c"
	} else {
		RygelTrackerQueryTriplets* _tmp2_;
#line 65 "rygel-tracker-search-container.vala"
		our_triplets = (_tmp2_ = rygel_tracker_query_triplets_new (), _g_object_unref0 (our_triplets), _tmp2_);
#line 408 "rygel-tracker-search-container.c"
	}
#line 68 "rygel-tracker-search-container.vala"
	rygel_tracker_query_triplets_add_triplet (our_triplets, _tmp3_ = rygel_tracker_query_triplet_new (RYGEL_TRACKER_SEARCH_CONTAINER_ITEM_VARIABLE, "a", item_factory->category));
#line 412 "rygel-tracker-search-container.c"
	_rygel_tracker_query_triplet_unref0 (_tmp3_);
#line 71 "rygel-tracker-search-container.vala"
	rygel_tracker_query_triplets_add_triplet (our_triplets, _tmp4_ = rygel_tracker_query_triplet_new (RYGEL_TRACKER_SEARCH_CONTAINER_ITEM_VARIABLE, RYGEL_TRACKER_SEARCH_CONTAINER_MODIFIED_PREDICATE, RYGEL_TRACKER_SEARCH_CONTAINER_MODIFIED_VARIABLE));
#line 416 "rygel-tracker-search-container.c"
	_rygel_tracker_query_triplet_unref0 (_tmp4_);
#line 74 "rygel-tracker-search-container.vala"
	rygel_tracker_query_triplets_add_triplet (our_triplets, _tmp5_ = rygel_tracker_query_triplet_new (RYGEL_TRACKER_SEARCH_CONTAINER_ITEM_VARIABLE, RYGEL_TRACKER_SEARCH_CONTAINER_URL_PREDICATE, RYGEL_TRACKER_SEARCH_CONTAINER_URL_VARIABLE));
#line 420 "rygel-tracker-search-container.c"
	_rygel_tracker_query_triplet_unref0 (_tmp5_);
	{
		GeeIterator* _chain_it;
#line 78 "rygel-tracker-search-container.vala"
		_chain_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->item_factory->key_chains);
#line 78 "rygel-tracker-search-container.vala"
		while (TRUE) {
#line 428 "rygel-tracker-search-container.c"
			GeeArrayList* chain;
			char* variable;
#line 78 "rygel-tracker-search-container.vala"
			if (!gee_iterator_next (_chain_it)) {
#line 78 "rygel-tracker-search-container.vala"
				break;
#line 435 "rygel-tracker-search-container.c"
			}
#line 78 "rygel-tracker-search-container.vala"
			chain = (GeeArrayList*) gee_iterator_get (_chain_it);
#line 79 "rygel-tracker-search-container.vala"
			variable = g_strdup (RYGEL_TRACKER_SEARCH_CONTAINER_ITEM_VARIABLE);
#line 441 "rygel-tracker-search-container.c"
			{
				GeeIterator* _key_it;
#line 81 "rygel-tracker-search-container.vala"
				_key_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) chain);
#line 81 "rygel-tracker-search-container.vala"
				while (TRUE) {
#line 448 "rygel-tracker-search-container.c"
					char* key;
					char* _tmp6_;
					char* _tmp7_;
					char* _tmp8_;
#line 81 "rygel-tracker-search-container.vala"
					if (!gee_iterator_next (_key_it)) {
#line 81 "rygel-tracker-search-container.vala"
						break;
#line 457 "rygel-tracker-search-container.c"
					}
#line 81 "rygel-tracker-search-container.vala"
					key = (char*) gee_iterator_get (_key_it);
#line 82 "rygel-tracker-search-container.vala"
					variable = (_tmp8_ = g_strconcat (_tmp7_ = g_strconcat (_tmp6_ = g_strconcat (key, "(", NULL), variable, NULL), ")", NULL), _g_free0 (variable), _tmp8_);
#line 463 "rygel-tracker-search-container.c"
					_g_free0 (_tmp7_);
					_g_free0 (_tmp6_);
					_g_free0 (key);
				}
				_g_object_unref0 (_key_it);
			}
#line 85 "rygel-tracker-search-container.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) variables, variable);
#line 472 "rygel-tracker-search-container.c"
			_g_free0 (variable);
			_g_object_unref0 (chain);
		}
		_g_object_unref0 (_chain_it);
	}
#line 88 "rygel-tracker-search-container.vala"
	self->query = (_tmp9_ = rygel_tracker_selection_query_new (variables, our_triplets, filters, RYGEL_TRACKER_SEARCH_CONTAINER_MODIFIED_VARIABLE, 0, -1), _rygel_tracker_query_unref0 (self->query), _tmp9_);
#line 480 "rygel-tracker-search-container.c"
	{
		RygelTrackerResourcesIface* _tmp10_;
		RygelTrackerResourcesIface* _tmp11_;
#line 94 "rygel-tracker-search-container.vala"
		_tmp10_ = (RygelTrackerResourcesIface*) g_initable_new (RYGEL_TRACKER_TYPE_RESOURCES_IFACE_PROXY, NULL, &_inner_error_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES, "g-name", RYGEL_TRACKER_SEARCH_CONTAINER_TRACKER_SERVICE, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", RYGEL_TRACKER_SEARCH_CONTAINER_RESOURCES_PATH, "g-interface-name", "org.freedesktop.Tracker1.Resources", NULL);
#line 486 "rygel-tracker-search-container.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch4_g_io_error;
			}
			_g_object_unref0 (our_triplets);
			_g_object_unref0 (variables);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
#line 94 "rygel-tracker-search-container.vala"
		self->priv->resources = (_tmp11_ = _tmp10_, _g_object_unref0 (self->priv->resources), _tmp11_);
#line 98 "rygel-tracker-search-container.vala"
		rygel_tracker_search_container_get_children_count (self, NULL, NULL);
#line 501 "rygel-tracker-search-container.c"
	}
	goto __finally4;
	__catch4_g_io_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
#line 100 "rygel-tracker-search-container.vala"
			g_critical (_ ("Failed to connect to session bus: %s"), _error_->message);
#line 512 "rygel-tracker-search-container.c"
			_g_error_free0 (_error_);
		}
	}
	__finally4:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (our_triplets);
		_g_object_unref0 (variables);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_object_unref0 (our_triplets);
	_g_object_unref0 (variables);
	return self;
}


#line 47 "rygel-tracker-search-container.vala"
RygelTrackerSearchContainer* rygel_tracker_search_container_new (const char* id, RygelMediaContainer* parent, const char* title, RygelTrackerItemFactory* item_factory, RygelTrackerQueryTriplets* triplets, GeeArrayList* filters) {
#line 47 "rygel-tracker-search-container.vala"
	return rygel_tracker_search_container_construct (RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, id, parent, title, item_factory, triplets, filters);
#line 534 "rygel-tracker-search-container.c"
}


static void rygel_tracker_search_container_real_get_children_data_free (gpointer _data) {
	RygelTrackerSearchContainerGetChildrenData* data;
	data = _data;
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (RygelTrackerSearchContainerGetChildrenData, data);
}


static void rygel_tracker_search_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerSearchContainer * self;
	RygelTrackerSearchContainerGetChildrenData* _data_;
	self = (RygelTrackerSearchContainer*) base;
	_data_ = g_slice_new0 (RygelTrackerSearchContainerGetChildrenData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_tracker_search_container_real_get_children);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_tracker_search_container_real_get_children_data_free);
	_data_->self = g_object_ref (self);
	_data_->offset = offset;
	_data_->max_count = max_count;
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_tracker_search_container_real_get_children_co (_data_);
}


static RygelMediaObjects* rygel_tracker_search_container_real_get_children_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObjects* result;
	RygelTrackerSearchContainerGetChildrenData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_tracker_search_container_get_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackerSearchContainerGetChildrenData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_tracker_search_container_real_get_children_co (data);
}


static gboolean rygel_tracker_search_container_real_get_children_co (RygelTrackerSearchContainerGetChildrenData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 3:
		goto _state_3;
	}
	_state_0:
	data->expression = rygel_relational_expression_new ();
#line 109 "rygel-tracker-search-container.vala"
	((RygelSearchExpression*) data->expression)->op = GINT_TO_POINTER (GUPNP_SEARCH_CRITERIA_OP_EQ);
#line 110 "rygel-tracker-search-container.vala"
	((RygelSearchExpression*) data->expression)->operand1 = (data->_tmp0_ = g_strdup ("@parentID"), _g_free0 (((RygelSearchExpression*) data->expression)->operand1), data->_tmp0_);
#line 111 "rygel-tracker-search-container.vala"
	((RygelSearchExpression*) data->expression)->operand2 = (data->_tmp1_ = g_strdup (((RygelMediaObject*) data->self)->id), _g_free0 (((RygelSearchExpression*) data->expression)->operand2), data->_tmp1_);
#line 601 "rygel-tracker-search-container.c"
	data->_state_ = 3;
	rygel_media_container_search ((RygelMediaContainer*) data->self, (RygelSearchExpression*) data->expression, data->offset, data->max_count, data->cancellable, rygel_tracker_search_container_get_children_ready, data);
	return FALSE;
	_state_3:
	data->_tmp2_ = rygel_media_container_search_finish ((RygelMediaContainer*) data->self, data->_res_, &data->total_matches, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_rygel_search_expression_unref0 (data->expression);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	data->result = data->_tmp2_;
	_rygel_search_expression_unref0 (data->expression);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	_rygel_search_expression_unref0 (data->expression);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void rygel_tracker_search_container_real_search_data_free (gpointer _data) {
	RygelTrackerSearchContainerSearchData* data;
	data = _data;
	_rygel_search_expression_unref0 (data->expression);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (RygelTrackerSearchContainerSearchData, data);
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
	return self ? rygel_search_expression_ref (self) : NULL;
}


static void rygel_tracker_search_container_real_search (RygelMediaContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerSearchContainer * self;
	RygelTrackerSearchContainerSearchData* _data_;
	self = (RygelTrackerSearchContainer*) base;
	_data_ = g_slice_new0 (RygelTrackerSearchContainerSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_tracker_search_container_real_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_tracker_search_container_real_search_data_free);
	_data_->self = g_object_ref (self);
	_data_->expression = _rygel_search_expression_ref0 (expression);
	_data_->offset = offset;
	_data_->max_count = max_count;
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_tracker_search_container_real_search_co (_data_);
}


static RygelMediaObjects* rygel_tracker_search_container_real_search_finish (RygelMediaContainer* base, GAsyncResult* _res_, guint* total_matches, GError** error) {
	RygelMediaObjects* result;
	RygelTrackerSearchContainerSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	*total_matches = _data_->total_matches;
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_tracker_search_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackerSearchContainerSearchData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_tracker_search_container_real_search_co (data);
}


static gboolean rygel_tracker_search_container_real_search_co (RygelTrackerSearchContainerSearchData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
	}
	_state_0:
	data->results = rygel_media_objects_new ();
#line 130 "rygel-tracker-search-container.vala"
	if (data->expression == NULL) {
#line 130 "rygel-tracker-search-container.vala"
		data->_tmp0_ = TRUE;
#line 716 "rygel-tracker-search-container.c"
	} else {
#line 130 "rygel-tracker-search-container.vala"
		data->_tmp0_ = !RYGEL_IS_RELATIONAL_EXPRESSION (data->expression);
#line 720 "rygel-tracker-search-container.c"
	}
#line 130 "rygel-tracker-search-container.vala"
	if (data->_tmp0_) {
#line 724 "rygel-tracker-search-container.c"
		data->_state_ = 4;
		RYGEL_MEDIA_CONTAINER_CLASS (rygel_tracker_search_container_parent_class)->search (RYGEL_MEDIA_CONTAINER (data->self), data->expression, data->offset, data->max_count, data->cancellable, rygel_tracker_search_container_search_ready, data);
		return FALSE;
		_state_4:
		data->_tmp1_ = RYGEL_MEDIA_CONTAINER_CLASS (rygel_tracker_search_container_parent_class)->search_finish (RYGEL_MEDIA_CONTAINER (data->self), data->_res_, &data->total_matches, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->results);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		data->result = data->_tmp1_;
		_g_object_unref0 (data->results);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	data->query = rygel_tracker_search_container_create_query (data->self, (data->_tmp2_ = data->expression, RYGEL_IS_RELATIONAL_EXPRESSION (data->_tmp2_) ? ((RygelRelationalExpression*) data->_tmp2_) : NULL), (gint) data->offset, (gint) data->max_count);
#line 141 "rygel-tracker-search-container.vala"
	if (data->query != NULL) {
#line 759 "rygel-tracker-search-container.c"
		data->_state_ = 5;
		rygel_tracker_query_execute ((RygelTrackerQuery*) data->query, data->self->priv->resources, rygel_tracker_search_container_search_ready, data);
		return FALSE;
		_state_5:
#line 142 "rygel-tracker-search-container.vala"
		rygel_tracker_query_execute_finish ((RygelTrackerQuery*) data->query, data->_res_, &data->_inner_error_);
#line 766 "rygel-tracker-search-container.c"
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_rygel_tracker_query_unref0 (data->query);
			_g_object_unref0 (data->results);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		{
			data->i = (guint) 0;
			{
				data->_tmp3_ = TRUE;
#line 145 "rygel-tracker-search-container.vala"
				while (TRUE) {
#line 145 "rygel-tracker-search-container.vala"
					if (!data->_tmp3_) {
#line 145 "rygel-tracker-search-container.vala"
						data->i++;
#line 792 "rygel-tracker-search-container.c"
					}
#line 145 "rygel-tracker-search-container.vala"
					data->_tmp3_ = FALSE;
#line 145 "rygel-tracker-search-container.vala"
					if (!(data->i < data->query->result_length1)) {
#line 145 "rygel-tracker-search-container.vala"
						break;
#line 800 "rygel-tracker-search-container.c"
					}
					data->id = rygel_tracker_search_container_create_child_id_for_urn (data->self, data->query->result[(data->i * data->query->result_length2) + 0]);
					data->uri = g_strdup (data->query->result[(data->i * data->query->result_length2) + 1]);
					data->metadata = (data->_tmp5_ = rygel_tracker_search_container_slice_strvv_tail (data->self, data->query->result, data->query->result_length1, data->query->result_length2, data->i, (guint) 2, &data->_tmp4_), data->metadata_length1 = data->_tmp4_, data->_metadata_size_ = data->metadata_length1, data->_tmp5_);
					data->item = rygel_tracker_item_factory_create (data->self->item_factory, data->id, data->uri, data->self, data->metadata, data->metadata_length1, &data->_inner_error_);
					if (data->_inner_error_ != NULL) {
						g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
						g_error_free (data->_inner_error_);
						data->metadata = (_vala_array_free (data->metadata, data->metadata_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (data->uri);
						_g_free0 (data->id);
						_rygel_tracker_query_unref0 (data->query);
						_g_object_unref0 (data->results);
						{
							if (data->_state_ == 0) {
								g_simple_async_result_complete_in_idle (data->_async_result);
							} else {
								g_simple_async_result_complete (data->_async_result);
							}
							g_object_unref (data->_async_result);
							return FALSE;
						}
					}
#line 151 "rygel-tracker-search-container.vala"
					gee_abstract_collection_add ((GeeAbstractCollection*) data->results, (RygelMediaObject*) data->item);
#line 826 "rygel-tracker-search-container.c"
					_g_object_unref0 (data->item);
					data->metadata = (_vala_array_free (data->metadata, data->metadata_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (data->uri);
					_g_free0 (data->id);
				}
			}
		}
	}
#line 155 "rygel-tracker-search-container.vala"
	data->total_matches = (guint) gee_collection_get_size ((GeeCollection*) data->results);
#line 837 "rygel-tracker-search-container.c"
	data->result = data->results;
	_rygel_tracker_query_unref0 (data->query);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	_rygel_tracker_query_unref0 (data->query);
	_g_object_unref0 (data->results);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void rygel_tracker_search_container_real_find_object_data_free (gpointer _data) {
	RygelTrackerSearchContainerFindObjectData* data;
	data = _data;
	_g_free0 (data->id);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (RygelTrackerSearchContainerFindObjectData, data);
}


static void rygel_tracker_search_container_real_find_object (RygelMediaContainer* base, const char* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerSearchContainer * self;
	RygelTrackerSearchContainerFindObjectData* _data_;
	self = (RygelTrackerSearchContainer*) base;
	_data_ = g_slice_new0 (RygelTrackerSearchContainerFindObjectData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_tracker_search_container_real_find_object);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_tracker_search_container_real_find_object_data_free);
	_data_->self = g_object_ref (self);
	_data_->id = g_strdup (id);
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_tracker_search_container_real_find_object_co (_data_);
}


static RygelMediaObject* rygel_tracker_search_container_real_find_object_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelTrackerSearchContainerFindObjectData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_tracker_search_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackerSearchContainerFindObjectData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_tracker_search_container_real_find_object_co (data);
}


static gboolean rygel_tracker_search_container_real_find_object_co (RygelTrackerSearchContainerFindObjectData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 6:
		goto _state_6;
	}
	_state_0:
#line 163 "rygel-tracker-search-container.vala"
	if (rygel_tracker_search_container_is_our_child (data->self, data->id)) {
#line 921 "rygel-tracker-search-container.c"
		data->_state_ = 6;
		RYGEL_MEDIA_CONTAINER_CLASS (rygel_tracker_search_container_parent_class)->find_object (RYGEL_MEDIA_CONTAINER (data->self), data->id, data->cancellable, rygel_tracker_search_container_find_object_ready, data);
		return FALSE;
		_state_6:
		data->_tmp0_ = RYGEL_MEDIA_CONTAINER_CLASS (rygel_tracker_search_container_parent_class)->find_object_finish (RYGEL_MEDIA_CONTAINER (data->self), data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		data->result = data->_tmp0_;
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	} else {
		data->result = NULL;
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


#line 170 "rygel-tracker-search-container.vala"
char* rygel_tracker_search_container_create_child_id_for_urn (RygelTrackerSearchContainer* self, const char* urn) {
#line 976 "rygel-tracker-search-container.c"
	char* result = NULL;
	char* _tmp0_;
	char* _tmp1_;
#line 170 "rygel-tracker-search-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 170 "rygel-tracker-search-container.vala"
	g_return_val_if_fail (urn != NULL, NULL);
#line 984 "rygel-tracker-search-container.c"
	result = (_tmp1_ = g_strconcat (_tmp0_ = g_strconcat (((RygelMediaObject*) self)->id, ",", NULL), urn, NULL), _g_free0 (_tmp0_), _tmp1_);
#line 171 "rygel-tracker-search-container.vala"
	return result;
#line 988 "rygel-tracker-search-container.c"
}


#line 174 "rygel-tracker-search-container.vala"
static gboolean rygel_tracker_search_container_is_our_child (RygelTrackerSearchContainer* self, const char* id) {
#line 994 "rygel-tracker-search-container.c"
	gboolean result = FALSE;
	char* _tmp0_;
	gboolean _tmp1_;
#line 174 "rygel-tracker-search-container.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 174 "rygel-tracker-search-container.vala"
	g_return_val_if_fail (id != NULL, FALSE);
#line 1002 "rygel-tracker-search-container.c"
	result = (_tmp1_ = g_str_has_prefix (id, _tmp0_ = g_strconcat (((RygelMediaObject*) self)->id, ",", NULL)), _g_free0 (_tmp0_), _tmp1_);
#line 175 "rygel-tracker-search-container.vala"
	return result;
#line 1006 "rygel-tracker-search-container.c"
}


static void rygel_tracker_search_container_get_children_count_data_free (gpointer _data) {
	RygelTrackerSearchContainerGetChildrenCountData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (RygelTrackerSearchContainerGetChildrenCountData, data);
}


static void rygel_tracker_search_container_get_children_count (RygelTrackerSearchContainer* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerSearchContainerGetChildrenCountData* _data_;
	_data_ = g_slice_new0 (RygelTrackerSearchContainerGetChildrenCountData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_tracker_search_container_get_children_count);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_tracker_search_container_get_children_count_data_free);
	_data_->self = g_object_ref (self);
	rygel_tracker_search_container_get_children_count_co (_data_);
}


static void rygel_tracker_search_container_get_children_count_finish (RygelTrackerSearchContainer* self, GAsyncResult* _res_) {
	RygelTrackerSearchContainerGetChildrenCountData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_tracker_search_container_get_children_count_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackerSearchContainerGetChildrenCountData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_tracker_search_container_get_children_count_co (data);
}


static gboolean rygel_tracker_search_container_get_children_count_co (RygelTrackerSearchContainerGetChildrenCountData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 7:
		goto _state_7;
	}
	_state_0:
	{
		data->query = rygel_tracker_selection_query_new_clone (data->self->query);
#line 182 "rygel-tracker-search-container.vala"
		data->query->variables = (data->_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL), _g_object_unref0 (data->query->variables), data->_tmp0_);
#line 183 "rygel-tracker-search-container.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) data->query->variables, "COUNT(" RYGEL_TRACKER_SEARCH_CONTAINER_ITEM_VARIABLE ") AS x");
#line 1058 "rygel-tracker-search-container.c"
		data->_state_ = 7;
		rygel_tracker_query_execute ((RygelTrackerQuery*) data->query, data->self->priv->resources, rygel_tracker_search_container_get_children_count_ready, data);
		return FALSE;
		_state_7:
#line 185 "rygel-tracker-search-container.vala"
		rygel_tracker_query_execute_finish ((RygelTrackerQuery*) data->query, data->_res_, &data->_inner_error_);
#line 1065 "rygel-tracker-search-container.c"
		if (data->_inner_error_ != NULL) {
			_rygel_tracker_query_unref0 (data->query);
			goto __catch5_g_error;
		}
#line 187 "rygel-tracker-search-container.vala"
		((RygelMediaContainer*) data->self)->child_count = atoi (data->query->result[(0 * data->query->result_length2) + 0]);
#line 188 "rygel-tracker-search-container.vala"
		rygel_media_container_updated ((RygelMediaContainer*) data->self);
#line 1074 "rygel-tracker-search-container.c"
		_rygel_tracker_query_unref0 (data->query);
	}
	goto __finally5;
	__catch5_g_error:
	{
		data->_error_ = data->_inner_error_;
		data->_inner_error_ = NULL;
		{
#line 190 "rygel-tracker-search-container.vala"
			g_critical (_ ("Error getting item count under category '%s': %s"), data->self->item_factory->category, data->_error_->message);
#line 1085 "rygel-tracker-search-container.c"
			_g_error_free0 (data->_error_);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			_g_error_free0 (data->_error_);
		}
	}
	__finally5:
	if (data->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


#line 198 "rygel-tracker-search-container.vala"
static RygelTrackerSelectionQuery* rygel_tracker_search_container_create_query (RygelTrackerSearchContainer* self, RygelRelationalExpression* expression, gint offset, gint max_count) {
#line 1119 "rygel-tracker-search-container.c"
	RygelTrackerSelectionQuery* result = NULL;
	gboolean _tmp0_ = FALSE;
	RygelTrackerSelectionQuery* query;
#line 198 "rygel-tracker-search-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 201 "rygel-tracker-search-container.vala"
	if (_vala_strcmp0 ((const char*) ((RygelSearchExpression*) expression)->operand1, "upnp:class") == 0) {
#line 202 "rygel-tracker-search-container.vala"
		_tmp0_ = !g_str_has_prefix (self->item_factory->upnp_class, (const char*) ((RygelSearchExpression*) expression)->operand2);
#line 1129 "rygel-tracker-search-container.c"
	} else {
#line 201 "rygel-tracker-search-container.vala"
		_tmp0_ = FALSE;
#line 1133 "rygel-tracker-search-container.c"
	}
#line 201 "rygel-tracker-search-container.vala"
	if (_tmp0_) {
#line 1137 "rygel-tracker-search-container.c"
		result = NULL;
#line 203 "rygel-tracker-search-container.vala"
		return result;
#line 1141 "rygel-tracker-search-container.c"
	}
#line 206 "rygel-tracker-search-container.vala"
	query = rygel_tracker_selection_query_new_clone (self->query);
#line 208 "rygel-tracker-search-container.vala"
	if (_vala_strcmp0 ((const char*) ((RygelSearchExpression*) expression)->operand1, "@parentID") == 0) {
#line 209 "rygel-tracker-search-container.vala"
		if (!rygel_relational_expression_compare_string (expression, ((RygelMediaObject*) self)->id)) {
#line 1149 "rygel-tracker-search-container.c"
			result = NULL;
			_rygel_tracker_query_unref0 (query);
#line 210 "rygel-tracker-search-container.vala"
			return result;
#line 1154 "rygel-tracker-search-container.c"
		}
	} else {
#line 212 "rygel-tracker-search-container.vala"
		if (_vala_strcmp0 ((const char*) ((RygelSearchExpression*) expression)->operand1, "upnp:class") != 0) {
#line 1159 "rygel-tracker-search-container.c"
			char* filter;
#line 213 "rygel-tracker-search-container.vala"
			filter = rygel_tracker_search_container_create_filter_for_child (self, expression);
#line 214 "rygel-tracker-search-container.vala"
			if (filter != NULL) {
#line 215 "rygel-tracker-search-container.vala"
				gee_abstract_list_insert ((GeeAbstractList*) query->filters, 0, filter);
#line 1167 "rygel-tracker-search-container.c"
			} else {
				result = NULL;
				_g_free0 (filter);
				_rygel_tracker_query_unref0 (query);
#line 217 "rygel-tracker-search-container.vala"
				return result;
#line 1174 "rygel-tracker-search-container.c"
			}
			_g_free0 (filter);
		}
	}
#line 221 "rygel-tracker-search-container.vala"
	query->offset = offset;
#line 222 "rygel-tracker-search-container.vala"
	query->max_count = max_count;
#line 1183 "rygel-tracker-search-container.c"
	result = query;
#line 224 "rygel-tracker-search-container.vala"
	return result;
#line 1187 "rygel-tracker-search-container.c"
}


#line 227 "rygel-tracker-search-container.vala"
static char* rygel_tracker_search_container_create_filter_for_child (RygelTrackerSearchContainer* self, RygelRelationalExpression* expression) {
#line 1193 "rygel-tracker-search-container.c"
	char* result = NULL;
	char* filter;
	char* variable;
	char* value;
	gboolean _tmp9_ = FALSE;
#line 227 "rygel-tracker-search-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 227 "rygel-tracker-search-container.vala"
	g_return_val_if_fail (expression != NULL, NULL);
#line 228 "rygel-tracker-search-container.vala"
	filter = NULL;
#line 229 "rygel-tracker-search-container.vala"
	variable = NULL;
#line 230 "rygel-tracker-search-container.vala"
	value = NULL;
#line 232 "rygel-tracker-search-container.vala"
	if (_vala_strcmp0 ((const char*) ((RygelSearchExpression*) expression)->operand1, "@id") == 0) {
#line 1211 "rygel-tracker-search-container.c"
		char* _tmp0_;
		char* parent_id;
		char* _tmp1_ = NULL;
		char* _tmp2_;
		char* _tmp3_;
		char* urn;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
#line 233 "rygel-tracker-search-container.vala"
		variable = (_tmp0_ = g_strdup (RYGEL_TRACKER_SEARCH_CONTAINER_ITEM_VARIABLE), _g_free0 (variable), _tmp0_);
#line 1222 "rygel-tracker-search-container.c"
		parent_id = NULL;
#line 237 "rygel-tracker-search-container.vala"
		urn = (_tmp2_ = rygel_tracker_search_container_get_item_info (self, (const char*) ((RygelSearchExpression*) expression)->operand2, &_tmp1_), parent_id = (_tmp3_ = _tmp1_, _g_free0 (parent_id), _tmp3_), _tmp2_);
#line 238 "rygel-tracker-search-container.vala"
		if (urn == NULL) {
#line 238 "rygel-tracker-search-container.vala"
			_tmp5_ = TRUE;
#line 1230 "rygel-tracker-search-container.c"
		} else {
#line 238 "rygel-tracker-search-container.vala"
			_tmp5_ = parent_id == NULL;
#line 1234 "rygel-tracker-search-container.c"
		}
#line 238 "rygel-tracker-search-container.vala"
		if (_tmp5_) {
#line 238 "rygel-tracker-search-container.vala"
			_tmp4_ = TRUE;
#line 1240 "rygel-tracker-search-container.c"
		} else {
#line 238 "rygel-tracker-search-container.vala"
			_tmp4_ = _vala_strcmp0 (parent_id, ((RygelMediaObject*) self)->id) != 0;
#line 1244 "rygel-tracker-search-container.c"
		}
#line 238 "rygel-tracker-search-container.vala"
		if (_tmp4_) {
#line 1248 "rygel-tracker-search-container.c"
			result = NULL;
			_g_free0 (urn);
			_g_free0 (parent_id);
			_g_free0 (value);
			_g_free0 (variable);
			_g_free0 (filter);
#line 239 "rygel-tracker-search-container.vala"
			return result;
#line 1257 "rygel-tracker-search-container.c"
		}
#line 242 "rygel-tracker-search-container.vala"
		switch (GPOINTER_TO_INT (((RygelSearchExpression*) expression)->op)) {
#line 1261 "rygel-tracker-search-container.c"
			case GUPNP_SEARCH_CRITERIA_OP_EQ:
			{
				char* _tmp6_;
				char* _tmp7_;
#line 244 "rygel-tracker-search-container.vala"
				value = (_tmp7_ = g_strconcat (_tmp6_ = g_strconcat ("<", urn, NULL), ">", NULL), _g_free0 (value), _tmp7_);
#line 1268 "rygel-tracker-search-container.c"
				_g_free0 (_tmp6_);
#line 245 "rygel-tracker-search-container.vala"
				break;
#line 1272 "rygel-tracker-search-container.c"
			}
			case GUPNP_SEARCH_CRITERIA_OP_CONTAINS:
			{
				char* _tmp8_;
#line 247 "rygel-tracker-search-container.vala"
				value = (_tmp8_ = g_strdup ((const char*) ((RygelSearchExpression*) expression)->operand2), _g_free0 (value), _tmp8_);
#line 248 "rygel-tracker-search-container.vala"
				break;
#line 1281 "rygel-tracker-search-container.c"
			}
		}
		_g_free0 (urn);
		_g_free0 (parent_id);
	}
#line 252 "rygel-tracker-search-container.vala"
	if (variable == NULL) {
#line 252 "rygel-tracker-search-container.vala"
		_tmp9_ = TRUE;
#line 1291 "rygel-tracker-search-container.c"
	} else {
#line 252 "rygel-tracker-search-container.vala"
		_tmp9_ = value == NULL;
#line 1295 "rygel-tracker-search-container.c"
	}
#line 252 "rygel-tracker-search-container.vala"
	if (_tmp9_) {
#line 1299 "rygel-tracker-search-container.c"
		result = NULL;
		_g_free0 (value);
		_g_free0 (variable);
		_g_free0 (filter);
#line 253 "rygel-tracker-search-container.vala"
		return result;
#line 1306 "rygel-tracker-search-container.c"
	}
#line 256 "rygel-tracker-search-container.vala"
	switch (GPOINTER_TO_INT (((RygelSearchExpression*) expression)->op)) {
#line 1310 "rygel-tracker-search-container.c"
		case GUPNP_SEARCH_CRITERIA_OP_EQ:
		{
			char* _tmp10_;
			char* _tmp11_;
#line 258 "rygel-tracker-search-container.vala"
			filter = (_tmp11_ = g_strconcat (_tmp10_ = g_strconcat (variable, " = ", NULL), value, NULL), _g_free0 (filter), _tmp11_);
#line 1317 "rygel-tracker-search-container.c"
			_g_free0 (_tmp10_);
#line 259 "rygel-tracker-search-container.vala"
			break;
#line 1321 "rygel-tracker-search-container.c"
		}
		case GUPNP_SEARCH_CRITERIA_OP_CONTAINS:
		{
			char* _tmp12_;
			char* _tmp13_;
			char* regex;
			char* _tmp14_;
			char* _tmp15_;
			char* _tmp16_;
			char* _tmp17_;
#line 262 "rygel-tracker-search-container.vala"
			regex = (_tmp13_ = rygel_tracker_search_container_escape_string (self, _tmp12_ = g_regex_escape_string (value, -1)), _g_free0 (_tmp12_), _tmp13_);
#line 264 "rygel-tracker-search-container.vala"
			filter = (_tmp17_ = g_strconcat (_tmp16_ = g_strconcat (_tmp15_ = g_strconcat (_tmp14_ = g_strconcat ("regex(", variable, NULL), ", \"", NULL), regex, NULL), "\", \"i\")", NULL), _g_free0 (filter), _tmp17_);
#line 1336 "rygel-tracker-search-container.c"
			_g_free0 (_tmp16_);
			_g_free0 (_tmp15_);
			_g_free0 (_tmp14_);
			_g_free0 (regex);
#line 265 "rygel-tracker-search-container.vala"
			break;
#line 1343 "rygel-tracker-search-container.c"
		}
	}
	result = filter;
	_g_free0 (value);
	_g_free0 (variable);
#line 268 "rygel-tracker-search-container.vala"
	return result;
#line 1351 "rygel-tracker-search-container.c"
}


#line 273 "rygel-tracker-search-container.vala"
static char* rygel_tracker_search_container_get_item_info (RygelTrackerSearchContainer* self, const char* item_id, char** parent_id) {
#line 1357 "rygel-tracker-search-container.c"
	char* result = NULL;
	gint tokens_length1;
	gint _tokens_size_;
	char** _tmp1_;
	char** _tmp0_;
	char** tokens;
	gboolean _tmp2_ = FALSE;
#line 273 "rygel-tracker-search-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 273 "rygel-tracker-search-container.vala"
	g_return_val_if_fail (item_id != NULL, NULL);
#line 1369 "rygel-tracker-search-container.c"
	if (parent_id != NULL) {
		*parent_id = NULL;
	}
	tokens = (_tmp1_ = _tmp0_ = g_strsplit (item_id, ",", 2), tokens_length1 = _vala_array_length (_tmp0_), _tokens_size_ = tokens_length1, _tmp1_);
#line 277 "rygel-tracker-search-container.vala"
	if (tokens[0] != NULL) {
#line 277 "rygel-tracker-search-container.vala"
		_tmp2_ = tokens[1] != NULL;
#line 1378 "rygel-tracker-search-container.c"
	} else {
#line 277 "rygel-tracker-search-container.vala"
		_tmp2_ = FALSE;
#line 1382 "rygel-tracker-search-container.c"
	}
#line 277 "rygel-tracker-search-container.vala"
	if (_tmp2_) {
#line 1386 "rygel-tracker-search-container.c"
		char* _tmp3_;
#line 278 "rygel-tracker-search-container.vala"
		*parent_id = (_tmp3_ = g_strdup (tokens[0]), _g_free0 (*parent_id), _tmp3_);
#line 1390 "rygel-tracker-search-container.c"
		result = g_strdup (tokens[1]);
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 280 "rygel-tracker-search-container.vala"
		return result;
#line 1395 "rygel-tracker-search-container.c"
	} else {
		result = NULL;
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 282 "rygel-tracker-search-container.vala"
		return result;
#line 1401 "rygel-tracker-search-container.c"
	}
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
}


/**
     * Chops the tail of a particular row in a 2-dimensional string array.
     *
     * param strvv the 2-dimenstional string array to chop the tail of.
     * param row the row whose tail needs to be chopped off.
     * param index index of the first element in the tail.
     *
     * FIXME: Stop using it once vala supports array slicing syntax for
     *        multi-dimentional arrays.
     */
#line 296 "rygel-tracker-search-container.vala"
static char** rygel_tracker_search_container_slice_strvv_tail (RygelTrackerSearchContainer* self, char** strvv, int strvv_length1, int strvv_length2, guint row, guint index, int* result_length1) {
#line 1419 "rygel-tracker-search-container.c"
	char** result = NULL;
	gint slice_length1;
	gint _slice_size_;
	char** _tmp1_;
	gint _tmp0_;
	char** slice;
	char** _tmp4_;
#line 296 "rygel-tracker-search-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1429 "rygel-tracker-search-container.c"
	slice = (_tmp1_ = g_new0 (char*, (_tmp0_ = strvv_length2 - index) + 1), slice_length1 = _tmp0_, _slice_size_ = slice_length1, _tmp1_);
	{
		gint i;
#line 299 "rygel-tracker-search-container.vala"
		i = 0;
#line 1435 "rygel-tracker-search-container.c"
		{
			gboolean _tmp2_;
#line 299 "rygel-tracker-search-container.vala"
			_tmp2_ = TRUE;
#line 299 "rygel-tracker-search-container.vala"
			while (TRUE) {
#line 1442 "rygel-tracker-search-container.c"
				char* _tmp3_;
#line 299 "rygel-tracker-search-container.vala"
				if (!_tmp2_) {
#line 299 "rygel-tracker-search-container.vala"
					i++;
#line 1448 "rygel-tracker-search-container.c"
				}
#line 299 "rygel-tracker-search-container.vala"
				_tmp2_ = FALSE;
#line 299 "rygel-tracker-search-container.vala"
				if (!(i < slice_length1)) {
#line 299 "rygel-tracker-search-container.vala"
					break;
#line 1456 "rygel-tracker-search-container.c"
				}
#line 300 "rygel-tracker-search-container.vala"
				slice[i] = (_tmp3_ = g_strdup (strvv[(row * strvv_length2) + (i + index)]), _g_free0 (slice[i]), _tmp3_);
#line 1460 "rygel-tracker-search-container.c"
			}
		}
	}
	result = (_tmp4_ = slice, *result_length1 = slice_length1, _tmp4_);
#line 303 "rygel-tracker-search-container.vala"
	return result;
#line 1467 "rygel-tracker-search-container.c"
	slice = (_vala_array_free (slice, slice_length1, (GDestroyNotify) g_free), NULL);
}


/**
     * tracker_sparql_escape_string:
     * @literal: a string to escape
     *
     * Escapes a string so that it can be used in a SPARQL query. Copied from
     * Tracker project.
     *
     * Returns: a newly-allocated string with the escaped version of @literal.
     *  The returned string should be freed with g_free() when no longer needed.
     */
#line 316 "rygel-tracker-search-container.vala"
static char* rygel_tracker_search_container_escape_string (RygelTrackerSearchContainer* self, const char* literal) {
#line 1484 "rygel-tracker-search-container.c"
	char* result = NULL;
	GString* str;
	gchar* p;
#line 316 "rygel-tracker-search-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 316 "rygel-tracker-search-container.vala"
	g_return_val_if_fail (literal != NULL, NULL);
#line 317 "rygel-tracker-search-container.vala"
	str = g_string_new ("");
#line 318 "rygel-tracker-search-container.vala"
	p = literal;
#line 320 "rygel-tracker-search-container.vala"
	while (TRUE) {
#line 1498 "rygel-tracker-search-container.c"
		gsize len;
#line 320 "rygel-tracker-search-container.vala"
		if (!((*p) != '\0')) {
#line 320 "rygel-tracker-search-container.vala"
			break;
#line 1504 "rygel-tracker-search-container.c"
		}
#line 321 "rygel-tracker-search-container.vala"
		len = strcspn ((const char*) p, "\t\n\r\b\f\"\\");
#line 322 "rygel-tracker-search-container.vala"
		g_string_append_len (str, (const char*) p, (gssize) ((glong) len));
#line 323 "rygel-tracker-search-container.vala"
		p = p + len;
#line 325 "rygel-tracker-search-container.vala"
		switch (*p) {
#line 1514 "rygel-tracker-search-container.c"
			case '\t':
			{
#line 327 "rygel-tracker-search-container.vala"
				g_string_append (str, "\\t");
#line 328 "rygel-tracker-search-container.vala"
				break;
#line 1521 "rygel-tracker-search-container.c"
			}
			case '\n':
			{
#line 330 "rygel-tracker-search-container.vala"
				g_string_append (str, "\\n");
#line 331 "rygel-tracker-search-container.vala"
				break;
#line 1529 "rygel-tracker-search-container.c"
			}
			case '\r':
			{
#line 333 "rygel-tracker-search-container.vala"
				g_string_append (str, "\\r");
#line 334 "rygel-tracker-search-container.vala"
				break;
#line 1537 "rygel-tracker-search-container.c"
			}
			case '\b':
			{
#line 336 "rygel-tracker-search-container.vala"
				g_string_append (str, "\\b");
#line 337 "rygel-tracker-search-container.vala"
				break;
#line 1545 "rygel-tracker-search-container.c"
			}
			case '\f':
			{
#line 339 "rygel-tracker-search-container.vala"
				g_string_append (str, "\\f");
#line 340 "rygel-tracker-search-container.vala"
				break;
#line 1553 "rygel-tracker-search-container.c"
			}
			case '"':
			{
#line 342 "rygel-tracker-search-container.vala"
				g_string_append (str, "\\\"");
#line 343 "rygel-tracker-search-container.vala"
				break;
#line 1561 "rygel-tracker-search-container.c"
			}
			case '\\':
			{
#line 345 "rygel-tracker-search-container.vala"
				g_string_append (str, "\\\\");
#line 346 "rygel-tracker-search-container.vala"
				break;
#line 1569 "rygel-tracker-search-container.c"
			}
			default:
			{
#line 348 "rygel-tracker-search-container.vala"
				continue;
#line 1575 "rygel-tracker-search-container.c"
			}
		}
#line 351 "rygel-tracker-search-container.vala"
		p++;
#line 1580 "rygel-tracker-search-container.c"
	}
	result = g_strdup (str->str);
	_g_string_free0 (str);
#line 354 "rygel-tracker-search-container.vala"
	return result;
#line 1586 "rygel-tracker-search-container.c"
}


static void rygel_tracker_search_container_class_init (RygelTrackerSearchContainerClass * klass) {
	rygel_tracker_search_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelTrackerSearchContainerPrivate));
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children = rygel_tracker_search_container_real_get_children;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children_finish = rygel_tracker_search_container_real_get_children_finish;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->search = rygel_tracker_search_container_real_search;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->search_finish = rygel_tracker_search_container_real_search_finish;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object = rygel_tracker_search_container_real_find_object;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object_finish = rygel_tracker_search_container_real_find_object_finish;
	G_OBJECT_CLASS (klass)->finalize = rygel_tracker_search_container_finalize;
}


static void rygel_tracker_search_container_instance_init (RygelTrackerSearchContainer * self) {
	self->priv = RYGEL_TRACKER_SEARCH_CONTAINER_GET_PRIVATE (self);
}


static void rygel_tracker_search_container_finalize (GObject* obj) {
	RygelTrackerSearchContainer * self;
	self = RYGEL_TRACKER_SEARCH_CONTAINER (obj);
	_rygel_tracker_query_unref0 (self->query);
	_rygel_tracker_item_factory_unref0 (self->item_factory);
	_g_object_unref0 (self->priv->resources);
	G_OBJECT_CLASS (rygel_tracker_search_container_parent_class)->finalize (obj);
}


/**
 * A container listing a Tracker search result.
 */
GType rygel_tracker_search_container_get_type (void) {
	static volatile gsize rygel_tracker_search_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_tracker_search_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTrackerSearchContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_tracker_search_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTrackerSearchContainer), 0, (GInstanceInitFunc) rygel_tracker_search_container_instance_init, NULL };
		GType rygel_tracker_search_container_type_id;
		rygel_tracker_search_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_CONTAINER, "RygelTrackerSearchContainer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_tracker_search_container_type_id__volatile, rygel_tracker_search_container_type_id);
	}
	return rygel_tracker_search_container_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




