/* rygel-external-icon-factory.c generated by valac 0.10.0, the Vala compiler
 * generated from rygel-external-icon-factory.vala, do not modify */

/*
 * Copyright (C) 2009 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <rygel.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_EXTERNAL_TYPE_ICON_FACTORY (rygel_external_icon_factory_get_type ())
#define RYGEL_EXTERNAL_ICON_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_EXTERNAL_TYPE_ICON_FACTORY, RygelExternalIconFactory))
#define RYGEL_EXTERNAL_ICON_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_EXTERNAL_TYPE_ICON_FACTORY, RygelExternalIconFactoryClass))
#define RYGEL_EXTERNAL_IS_ICON_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_EXTERNAL_TYPE_ICON_FACTORY))
#define RYGEL_EXTERNAL_IS_ICON_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_EXTERNAL_TYPE_ICON_FACTORY))
#define RYGEL_EXTERNAL_ICON_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_EXTERNAL_TYPE_ICON_FACTORY, RygelExternalIconFactoryClass))

typedef struct _RygelExternalIconFactory RygelExternalIconFactory;
typedef struct _RygelExternalIconFactoryClass RygelExternalIconFactoryClass;
typedef struct _RygelExternalIconFactoryPrivate RygelExternalIconFactoryPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelExternalIconFactoryCreateData RygelExternalIconFactoryCreateData;
typedef struct _RygelExternalParamSpecIconFactory RygelExternalParamSpecIconFactory;

struct _RygelExternalIconFactory {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelExternalIconFactoryPrivate * priv;
};

struct _RygelExternalIconFactoryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelExternalIconFactory *self);
};

struct _RygelExternalIconFactoryCreateData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelExternalIconFactory* self;
	char* service_name;
	GHashTable* container_props;
	RygelIconInfo* result;
	GVariant* value;
	char* icon_path;
	FreeDesktopProperties* props;
	GHashTable* item_props;
	GError * _inner_error_;
};

struct _RygelExternalParamSpecIconFactory {
	GParamSpec parent_instance;
};


static char* rygel_external_icon_factory_ITEM_IFACE;
static char* rygel_external_icon_factory_ITEM_IFACE = NULL;
static gpointer rygel_external_icon_factory_parent_class = NULL;

gpointer rygel_external_icon_factory_ref (gpointer instance);
void rygel_external_icon_factory_unref (gpointer instance);
GParamSpec* rygel_external_param_spec_icon_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_external_value_set_icon_factory (GValue* value, gpointer v_object);
void rygel_external_value_take_icon_factory (GValue* value, gpointer v_object);
gpointer rygel_external_value_get_icon_factory (const GValue* value);
GType rygel_external_icon_factory_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_EXTERNAL_ICON_FACTORY_DUMMY_PROPERTY
};
static void rygel_external_icon_factory_create_data_free (gpointer _data);
static void rygel_external_icon_factory_create_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_external_icon_factory_create (RygelExternalIconFactory* self, const char* service_name, GHashTable* container_props, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelIconInfo* rygel_external_icon_factory_create_finish (RygelExternalIconFactory* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_external_icon_factory_create_co (RygelExternalIconFactoryCreateData* data);
static const char* _variant_get26 (GVariant* value);
static RygelIconInfo* rygel_external_icon_factory_create_from_props (RygelExternalIconFactory* self, GHashTable* props);
static const char* _variant_get27 (GVariant* value);
static char* rygel_external_icon_factory_get_ext_for_mime (RygelExternalIconFactory* self, const char* mime_type);
static char** _variant_get28 (GVariant* value, int* result_length1);
static char** _vala_array_dup5 (char** self, int length);
static gint64 _variant_get29 (GVariant* value);
static gint rygel_external_icon_factory_get_int (RygelExternalIconFactory* self, GHashTable* props, const char* prop);
static gint _variant_get30 (GVariant* value);
RygelExternalIconFactory* rygel_external_icon_factory_new (void);
RygelExternalIconFactory* rygel_external_icon_factory_construct (GType object_type);
static void rygel_external_icon_factory_finalize (RygelExternalIconFactory* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);



static void rygel_external_icon_factory_create_data_free (gpointer _data) {
	RygelExternalIconFactoryCreateData* data;
	data = _data;
	_g_free0 (data->service_name);
	_g_hash_table_unref0 (data->container_props);
	_rygel_icon_info_unref0 (data->result);
	rygel_external_icon_factory_unref (data->self);
	g_slice_free (RygelExternalIconFactoryCreateData, data);
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


void rygel_external_icon_factory_create (RygelExternalIconFactory* self, const char* service_name, GHashTable* container_props, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelExternalIconFactoryCreateData* _data_;
	_data_ = g_slice_new0 (RygelExternalIconFactoryCreateData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, rygel_external_icon_factory_create);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_external_icon_factory_create_data_free);
	_data_->self = rygel_external_icon_factory_ref (self);
	_data_->service_name = g_strdup (service_name);
	_data_->container_props = _g_hash_table_ref0 (container_props);
	rygel_external_icon_factory_create_co (_data_);
}


RygelIconInfo* rygel_external_icon_factory_create_finish (RygelExternalIconFactory* self, GAsyncResult* _res_, GError** error) {
	RygelIconInfo* result;
	RygelExternalIconFactoryCreateData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_external_icon_factory_create_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelExternalIconFactoryCreateData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_external_icon_factory_create_co (data);
}


static gpointer _g_variant_ref0 (gpointer self) {
	return self ? g_variant_ref (self) : NULL;
}


static const char* _variant_get26 (GVariant* value) {
	return g_variant_dup_string (value, NULL);
}


static gboolean rygel_external_icon_factory_create_co (RygelExternalIconFactoryCreateData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 29:
		goto _state_29;
	}
	_state_0:
	data->value = _g_variant_ref0 ((GVariant*) g_hash_table_lookup (data->container_props, "Icon"));
#line 34 "rygel-external-icon-factory.vala"
	if (data->value == NULL) {
#line 196 "rygel-external-icon-factory.c"
		data->result = NULL;
		_g_variant_unref0 (data->value);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	data->icon_path = g_strdup (_variant_get26 (data->value));
	data->props = (FreeDesktopProperties*) g_initable_new (FREE_DESKTOP_TYPE_PROPERTIES_PROXY, NULL, &data->_inner_error_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES, "g-name", data->service_name, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", data->icon_path, "g-interface-name", "org.freedesktop.DBus.Properties", NULL);
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == G_IO_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_free0 (data->icon_path);
			_g_variant_unref0 (data->value);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		} else {
			_g_free0 (data->icon_path);
			_g_variant_unref0 (data->value);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->_state_ = 29;
	free_desktop_properties_get_all (data->props, rygel_external_icon_factory_ITEM_IFACE, rygel_external_icon_factory_create_ready, data);
	return FALSE;
	_state_29:
	data->item_props = free_desktop_properties_get_all_finish (data->props, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == G_IO_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->props);
			_g_free0 (data->icon_path);
			_g_variant_unref0 (data->value);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		} else {
			_g_object_unref0 (data->props);
			_g_free0 (data->icon_path);
			_g_variant_unref0 (data->value);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->result = rygel_external_icon_factory_create_from_props (data->self, data->item_props);
	_g_hash_table_unref0 (data->item_props);
	_g_object_unref0 (data->props);
	_g_free0 (data->icon_path);
	_g_variant_unref0 (data->value);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	_g_hash_table_unref0 (data->item_props);
	_g_object_unref0 (data->props);
	_g_free0 (data->icon_path);
	_g_variant_unref0 (data->value);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static const char* _variant_get27 (GVariant* value) {
	return g_variant_dup_string (value, NULL);
}


static char** _variant_get28 (GVariant* value, int* result_length1) {
	char** _tmp3_;
	int _tmp3__length;
	int _tmp3__size;
	int _tmp3__length1;
	GVariantIter _tmp4_;
	GVariant* _tmp5_;
	_tmp3_ = g_new (char*, 5);
	_tmp3__length = 0;
	_tmp3__size = 4;
	_tmp3__length1 = 0;
	g_variant_iter_init (&_tmp4_, value);
	for (; _tmp5_ = g_variant_iter_next_value (&_tmp4_); _tmp3__length1++) {
		if (_tmp3__size == _tmp3__length) {
			_tmp3__size = 2 * _tmp3__size;
			_tmp3_ = g_renew (char*, _tmp3_, _tmp3__size + 1);
		}
		_tmp3_[_tmp3__length++] = g_variant_dup_string (_tmp5_, NULL);
		g_variant_unref (_tmp5_);
	}
	*result_length1 = _tmp3__length1;
	_tmp3_[_tmp3__length] = NULL;
	return _tmp3_;
}


static char** _vala_array_dup5 (char** self, int length) {
	char** result;
	int i;
	result = g_new0 (char*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static gint64 _variant_get29 (GVariant* value) {
	return g_variant_get_int64 (value);
}


#line 49 "rygel-external-icon-factory.vala"
static RygelIconInfo* rygel_external_icon_factory_create_from_props (RygelExternalIconFactory* self, GHashTable* props) {
#line 343 "rygel-external-icon-factory.c"
	RygelIconInfo* result = NULL;
	char* mime_type;
	char* _tmp0_;
	RygelIconInfo* _tmp1_;
	RygelIconInfo* icon;
	gint uris_length1;
	gint _uris_size_;
	char** _tmp7_;
	gint _tmp2_;
	char** _tmp6_;
	char** uris;
	gboolean _tmp8_ = FALSE;
	GVariant* value;
#line 49 "rygel-external-icon-factory.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 49 "rygel-external-icon-factory.vala"
	g_return_val_if_fail (props != NULL, NULL);
#line 50 "rygel-external-icon-factory.vala"
	mime_type = g_strdup (_variant_get27 ((GVariant*) g_hash_table_lookup (props, "MIMEType")));
#line 51 "rygel-external-icon-factory.vala"
	icon = (_tmp1_ = rygel_icon_info_new (mime_type, _tmp0_ = rygel_external_icon_factory_get_ext_for_mime (self, mime_type)), _g_free0 (_tmp0_), _tmp1_);
#line 365 "rygel-external-icon-factory.c"
	uris = (_tmp7_ = (_tmp6_ = _variant_get28 ((GVariant*) g_hash_table_lookup (props, "URLs"), &_tmp2_), (_tmp6_ == NULL) ? ((gpointer) _tmp6_) : _vala_array_dup5 (_tmp6_, _tmp2_)), uris_length1 = _tmp2_, _uris_size_ = uris_length1, _tmp7_);
#line 54 "rygel-external-icon-factory.vala"
	if (uris != NULL) {
#line 54 "rygel-external-icon-factory.vala"
		_tmp8_ = uris[0] != NULL;
#line 371 "rygel-external-icon-factory.c"
	} else {
#line 54 "rygel-external-icon-factory.vala"
		_tmp8_ = FALSE;
#line 375 "rygel-external-icon-factory.c"
	}
#line 54 "rygel-external-icon-factory.vala"
	if (_tmp8_) {
#line 379 "rygel-external-icon-factory.c"
		char* _tmp9_;
#line 55 "rygel-external-icon-factory.vala"
		icon->uri = (_tmp9_ = g_strdup (uris[0]), _g_free0 (icon->uri), _tmp9_);
#line 383 "rygel-external-icon-factory.c"
	}
#line 58 "rygel-external-icon-factory.vala"
	value = _g_variant_ref0 ((GVariant*) g_hash_table_lookup (props, "Size"));
#line 59 "rygel-external-icon-factory.vala"
	if (value != NULL) {
#line 60 "rygel-external-icon-factory.vala"
		icon->size = _variant_get29 (value);
#line 391 "rygel-external-icon-factory.c"
	}
#line 63 "rygel-external-icon-factory.vala"
	icon->width = rygel_external_icon_factory_get_int (self, props, "Width");
#line 64 "rygel-external-icon-factory.vala"
	icon->height = rygel_external_icon_factory_get_int (self, props, "Height");
#line 65 "rygel-external-icon-factory.vala"
	icon->depth = rygel_external_icon_factory_get_int (self, props, "ColorDepth");
#line 399 "rygel-external-icon-factory.c"
	result = icon;
	_g_variant_unref0 (value);
	uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (mime_type);
#line 67 "rygel-external-icon-factory.vala"
	return result;
#line 406 "rygel-external-icon-factory.c"
}


#line 70 "rygel-external-icon-factory.vala"
static char* rygel_external_icon_factory_get_ext_for_mime (RygelExternalIconFactory* self, const char* mime_type) {
#line 412 "rygel-external-icon-factory.c"
	char* result = NULL;
#line 70 "rygel-external-icon-factory.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 70 "rygel-external-icon-factory.vala"
	g_return_val_if_fail (mime_type != NULL, NULL);
#line 71 "rygel-external-icon-factory.vala"
	if (_vala_strcmp0 (mime_type, "image/jpeg") == 0) {
#line 420 "rygel-external-icon-factory.c"
		result = g_strdup ("jpg");
#line 72 "rygel-external-icon-factory.vala"
		return result;
#line 424 "rygel-external-icon-factory.c"
	} else {
#line 73 "rygel-external-icon-factory.vala"
		if (_vala_strcmp0 (mime_type, "image/gif") == 0) {
#line 428 "rygel-external-icon-factory.c"
			result = g_strdup ("gif");
#line 74 "rygel-external-icon-factory.vala"
			return result;
#line 432 "rygel-external-icon-factory.c"
		} else {
			result = g_strdup ("png");
#line 76 "rygel-external-icon-factory.vala"
			return result;
#line 437 "rygel-external-icon-factory.c"
		}
	}
}


static gint _variant_get30 (GVariant* value) {
	return g_variant_get_int32 (value);
}


#line 80 "rygel-external-icon-factory.vala"
static gint rygel_external_icon_factory_get_int (RygelExternalIconFactory* self, GHashTable* props, const char* prop) {
#line 450 "rygel-external-icon-factory.c"
	gint result = 0;
	GVariant* value;
#line 80 "rygel-external-icon-factory.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 80 "rygel-external-icon-factory.vala"
	g_return_val_if_fail (props != NULL, 0);
#line 80 "rygel-external-icon-factory.vala"
	g_return_val_if_fail (prop != NULL, 0);
#line 81 "rygel-external-icon-factory.vala"
	value = _g_variant_ref0 ((GVariant*) g_hash_table_lookup (props, prop));
#line 83 "rygel-external-icon-factory.vala"
	if (value != NULL) {
#line 463 "rygel-external-icon-factory.c"
		result = _variant_get30 (value);
		_g_variant_unref0 (value);
#line 84 "rygel-external-icon-factory.vala"
		return result;
#line 468 "rygel-external-icon-factory.c"
	} else {
		result = -1;
		_g_variant_unref0 (value);
#line 86 "rygel-external-icon-factory.vala"
		return result;
#line 474 "rygel-external-icon-factory.c"
	}
	_g_variant_unref0 (value);
}


#line 27 "rygel-external-icon-factory.vala"
RygelExternalIconFactory* rygel_external_icon_factory_construct (GType object_type) {
#line 482 "rygel-external-icon-factory.c"
	RygelExternalIconFactory* self;
	self = (RygelExternalIconFactory*) g_type_create_instance (object_type);
	return self;
}


#line 27 "rygel-external-icon-factory.vala"
RygelExternalIconFactory* rygel_external_icon_factory_new (void) {
#line 27 "rygel-external-icon-factory.vala"
	return rygel_external_icon_factory_construct (RYGEL_EXTERNAL_TYPE_ICON_FACTORY);
#line 493 "rygel-external-icon-factory.c"
}


static void rygel_external_value_icon_factory_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void rygel_external_value_icon_factory_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		rygel_external_icon_factory_unref (value->data[0].v_pointer);
	}
}


static void rygel_external_value_icon_factory_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_external_icon_factory_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer rygel_external_value_icon_factory_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* rygel_external_value_icon_factory_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		RygelExternalIconFactory* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_external_icon_factory_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* rygel_external_value_icon_factory_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelExternalIconFactory** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_external_icon_factory_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* rygel_external_param_spec_icon_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelExternalParamSpecIconFactory* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_EXTERNAL_TYPE_ICON_FACTORY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer rygel_external_value_get_icon_factory (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_EXTERNAL_TYPE_ICON_FACTORY), NULL);
	return value->data[0].v_pointer;
}


void rygel_external_value_set_icon_factory (GValue* value, gpointer v_object) {
	RygelExternalIconFactory* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_EXTERNAL_TYPE_ICON_FACTORY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_EXTERNAL_TYPE_ICON_FACTORY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_external_icon_factory_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_external_icon_factory_unref (old);
	}
}


void rygel_external_value_take_icon_factory (GValue* value, gpointer v_object) {
	RygelExternalIconFactory* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_EXTERNAL_TYPE_ICON_FACTORY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_EXTERNAL_TYPE_ICON_FACTORY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_external_icon_factory_unref (old);
	}
}


static void rygel_external_icon_factory_class_init (RygelExternalIconFactoryClass * klass) {
	rygel_external_icon_factory_parent_class = g_type_class_peek_parent (klass);
	RYGEL_EXTERNAL_ICON_FACTORY_CLASS (klass)->finalize = rygel_external_icon_factory_finalize;
	rygel_external_icon_factory_ITEM_IFACE = g_strdup ("org.gnome.UPnP.MediaItem1");
}


static void rygel_external_icon_factory_instance_init (RygelExternalIconFactory * self) {
	self->ref_count = 1;
}


static void rygel_external_icon_factory_finalize (RygelExternalIconFactory* obj) {
	RygelExternalIconFactory * self;
	self = RYGEL_EXTERNAL_ICON_FACTORY (obj);
}


GType rygel_external_icon_factory_get_type (void) {
	static volatile gsize rygel_external_icon_factory_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_external_icon_factory_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_external_value_icon_factory_init, rygel_external_value_icon_factory_free_value, rygel_external_value_icon_factory_copy_value, rygel_external_value_icon_factory_peek_pointer, "p", rygel_external_value_icon_factory_collect_value, "p", rygel_external_value_icon_factory_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelExternalIconFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_external_icon_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelExternalIconFactory), 0, (GInstanceInitFunc) rygel_external_icon_factory_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_external_icon_factory_type_id;
		rygel_external_icon_factory_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelExternalIconFactory", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_external_icon_factory_type_id__volatile, rygel_external_icon_factory_type_id);
	}
	return rygel_external_icon_factory_type_id__volatile;
}


gpointer rygel_external_icon_factory_ref (gpointer instance) {
	RygelExternalIconFactory* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void rygel_external_icon_factory_unref (gpointer instance) {
	RygelExternalIconFactory* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_EXTERNAL_ICON_FACTORY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




