/* $Id: open.c,v 1.23 2004/09/13 15:21:54 bdejean Exp $ */

/* Copyright (C) 1998-99 Martin Baulig
   This file is part of LibGTop 1.0.

   Contributed by Martin Baulig <martin@home-of-linux.org>, April 1998.

   LibGTop is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License,
   or (at your option) any later version.

   LibGTop is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
   for more details.

   You should have received a copy of the GNU General Public License
   along with LibGTop; see the file COPYING. If not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#include <glibtop.h>
#include <glibtop/cpu.h>
#include <glibtop/open.h>

/* =====================================================
 * Linux kernel version information for procps utilities
 * Copyright (c) 1996 Charles Blake <cblake@bbn.com>
 */
#include <sys/utsname.h>

static unsigned get_linux_version(void) {

    static unsigned linux_version_code = 0;

    if(!linux_version_code) {
	struct utsname uts;
	unsigned x = 0, y = 0, z = 0;	/* cleared in case sscanf() < 3 */

	if (uname(&uts) == -1) /* failure most likely implies impending death */
	    exit(1);

	if (sscanf(uts.release, "%u.%u.%u", &x, &y, &z) < 3)
	    fprintf(stderr, /* *very* unlikely to happen by accident */
		    "Non-standard uts for running kernel:\n"
		    "release %s=%u.%u.%u gives version code %d\n",
		    uts.release, x, y, z, LINUX_VERSION_CODE(x,y,z));

	linux_version_code = LINUX_VERSION_CODE(x, y, z);
    }

    return linux_version_code;
}

/* ======================================================= */

/* Opens pipe to gtop server. Returns 0 on success and -1 on error. */

#define FILENAME	"/proc/stat"

void
glibtop_open_s (glibtop *server, const char *program_name,
		const unsigned long features,
		const unsigned flags)
{
	char buffer [BUFSIZ], *p = buffer;

	server->name = program_name;

	server->os_version_code = get_linux_version();

	file_to_buffer(server, buffer, FILENAME);

	for (server->ncpu = 0; server->ncpu < GLIBTOP_NCPU; server->ncpu++) {

		p = skip_line(p);

		if (strncmp (p, "cpu", 3) || !isdigit (p [3]))
			break;
	}

#ifdef DEBUG
	printf ("\nThis machine has %d CPUs.\n\n", server->ncpu);
#endif
}
