/*
 * Decompiled with CFR 0.152.
 */
package vncviewer;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import rfb.LogWriter;
import rfb.PixelBuffer;
import rfb.PixelFormat;

public class PixelBufferImage
extends PixelBuffer
implements ImageProducer {
    Image image;
    ImageConsumer ic;
    ColorModel cm;
    static LogWriter vlog = new LogWriter("PixelBufferImage");

    public PixelBufferImage(int n, int n2, Component component) {
        this.setPF(new PixelFormat(32, 24, true, true, 255, 255, 255, 16, 8, 0));
        this.resize(n, n2, component);
        this.cm = new DirectColorModel(24, 0xFF0000, 65280, 255);
    }

    public void resize(int n, int n2, Component component) {
        if (n == this.width() && n2 == this.height()) {
            return;
        }
        int n3 = n2 < this.height() ? n2 : this.height();
        int n4 = n < this.width() ? n : this.width();
        int n5 = this.width();
        int[] nArray = this.data;
        this.width_ = n;
        this.height_ = n2;
        this.image = component.createImage(this);
        this.data = new int[this.width() * this.height()];
        for (int i = 0; i < n3; ++i) {
            System.arraycopy(nArray, n5 * i, this.data, this.width() * i, n4);
        }
    }

    public void put(int n, int n2, int n3, int n4, Graphics graphics) {
        if (this.ic != null) {
            this.ic.setPixels(n, n2, n3, n4, this.cm, this.data, this.width() * n2 + n, this.width());
            this.ic.imageComplete(2);
        }
        graphics.setClip(n, n2, n3, n4);
        graphics.drawImage(this.image, 0, 0, null);
    }

    public void copyRect(int n, int n2, int n3, int n4, int n5, int n6) {
        super.copyRect(n, n2, n3, n4, n5, n6);
        if (this.ic != null) {
            this.ic.setPixels(n, n2, n3, n4, this.cm, this.data, this.width() * n2 + n, this.width());
            this.ic.imageComplete(2);
        }
    }

    public void addConsumer(ImageConsumer imageConsumer) {
        if (this.ic == imageConsumer) {
            return;
        }
        vlog.debug("adding consumer " + imageConsumer);
        if (this.ic != null) {
            vlog.error("Only one ImageConsumer allowed - discarding old one");
        }
        this.ic = imageConsumer;
        this.ic.setDimensions(this.width(), this.height());
        this.ic.setHints(1);
        this.ic.setPixels(0, 0, this.width(), this.height(), this.cm, this.data, 0, this.width());
        this.ic.imageComplete(2);
    }

    public void removeConsumer(ImageConsumer imageConsumer) {
        System.err.println("removeConsumer " + imageConsumer);
        if (this.ic == imageConsumer) {
            this.ic = null;
        }
    }

    public boolean isConsumer(ImageConsumer imageConsumer) {
        return this.ic == imageConsumer;
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
    }

    public void startProduction(ImageConsumer imageConsumer) {
        this.addConsumer(imageConsumer);
    }
}

