/* brlxml.h
 *
 * Copyright 2001, 2002 Sun Microsystems, Inc.,
 * Copyright 2001, 2002 BAUM Retec, A.G.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _brlxml_h
#define _brlxml_h

#include <glib.h>

typedef enum
{
	BPS_IDLE,
	BPS_BRL_OUT,
	BPS_BRL_DISP,
	BPS_DOTS,
	BPS_TEXT,	
	BPS_UNKNOWN
} BRL_PARSER_STATE;

typedef enum
{
	BS_8_DOTS,
	BS_6_DOTS
} BRAILLE_STYLE;

typedef enum
{
	CS_UNDERLINE,
	CS_BLOCK,
	CS_USER_DEFINED	
} CURSOR_STYLE;

typedef struct
{
	gboolean					  ClearDisplay;
	gint8								ID;	
	gchar*						  Role;
	gint16							Start;	
	gint16							Offset;	
	gint16							CursorPosition;
	CURSOR_STYLE	      CursorStyle;
	guint8							CursorMask;
	guint8							CursorPattern;
	guint8							Attribute;
	/* gchar*						Language;				 i.e. "us", "german", etc. */
	guint8*						  TranslationTable;
	GByteArray*				  Dots;
} BRL_DISP;

#define TT_SIZE	256

typedef struct
{
	gboolean							ClearAllCells;
	GArray*								Displays;
	/* gchar*								Language;									i.e. "us", "german", etc. */
	guint8*								TranslationTable;						/* the actual translation table */
	BRAILLE_STYLE			BrailleStyle;
} BRL_OUT;

BRL_DISP* brl_disp_new ();
BRL_DISP* brl_disp_copy (BRL_DISP *brl_disp);
void brl_disp_free (BRL_DISP *brl_disp);
/* ... */
void brl_disp_add_dots (BRL_DISP *brl_disp, guint8* dots, int len);	

BRL_OUT* brl_out_new ();
void brl_out_free (BRL_OUT *brl_out);
void brl_out_add_display (BRL_OUT *brl_out, BRL_DISP *brl_disp);
/* ... */
void brl_out_to_driver (BRL_OUT *brl_out);


#endif
