/*
 *  Copyright (C) 2003 Tommi Komulainen
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef NETWORK_PREFS_H
#define NETWORK_PREFS_H

#include "galeon-dialog.h"

#include <glib-object.h>
#include <glib.h>

G_BEGIN_DECLS

typedef struct NetworkPrefs NetworkPrefs;
typedef struct NetworkPrefsClass NetworkPrefsClass;

#define NETWORK_PREFS_TYPE             (network_prefs_get_type ())
#define NETWORK_PREFS(obj)             (GTK_CHECK_CAST ((obj), NETWORK_PREFS_TYPE, NetworkPrefs))
#define NETWORK_PREFS_CLASS(klass)     (GTK_CHECK_CLASS_CAST ((klass), NETWORK_PREFS, NetworkPrefsClass))
#define IS_NETWORK_PREFS(obj)          (GTK_CHECK_TYPE ((obj), NETWORK_PREFS_TYPE))
#define IS_NETWORK_PREFS_CLASS(klass)  (GTK_CHECK_CLASS_TYPE ((klass), NETWORK_PREFS))

typedef struct NetworkPrefsPrivate NetworkPrefsPrivate;

struct NetworkPrefs
{
        GaleonDialog parent;
        NetworkPrefsPrivate *priv;
};

struct NetworkPrefsClass
{
        GaleonDialogClass parent_class;
};

GType         network_prefs_get_type    		(void);

GaleonDialog *network_prefs_new         		(void);

G_END_DECLS

#endif

