/*
 *  Copyright (C) 2002  Ricardo Fernndez Pascual
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __gul_tbi_navigation_history_h
#define __gul_tbi_navigation_history_h

#include "gul-toolbar-item.h"

/* object forward declarations */

typedef struct _GulTbiNavigationHistory GulTbiNavigationHistory;
typedef struct _GulTbiNavigationHistoryClass GulTbiNavigationHistoryClass;
typedef struct _GulTbiNavigationHistoryPrivate GulTbiNavigationHistoryPrivate;

/**
 * TbiNavigationHistory object
 */

#define GUL_TYPE_TBI_NAVIGATION_HISTORY			(gul_tbi_navigation_history_get_type())
#define GUL_TBI_NAVIGATION_HISTORY(object)		(G_TYPE_CHECK_INSTANCE_CAST((object), \
							 GUL_TYPE_TBI_NAVIGATION_HISTORY,\
							 GulTbiNavigationHistory))
#define GUL_TBI_NAVIGATION_HISTORY_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), \
							 GUL_TYPE_TBI_NAVIGATION_HISTORY,\
							 GulTbiNavigationHistoryClass))
#define GUL_IS_TBI_NAVIGATION_HISTORY(object)		(G_TYPE_CHECK_INSTANCE_TYPE((object), \
							 GUL_TYPE_TBI_NAVIGATION_HISTORY))
#define GUL_IS_TBI_NAVIGATION_HISTORY_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), \
							 GUL_TYPE_TBI_NAVIGATION_HISTORY))
#define GUL_TBI_NAVIGATION_HISTORY_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS((obj), \
							 GUL_TYPE_TBI_NAVIGATION_HISTORY,\
							 GulTbiNavigationHistoryClass))
typedef enum
{
	GUL_TBI_NAVIGATION_HISTORY_UP,
	GUL_TBI_NAVIGATION_HISTORY_BACK,
	GUL_TBI_NAVIGATION_HISTORY_FORWARD
} GulTbiNavigationHistoryDirection;


struct _GulTbiNavigationHistoryClass 
{
	GulTbItemClass parent_class;
	
};

/* Remember: fields are public read-only */
struct _GulTbiNavigationHistory
{
	GulTbItem parent_object;

	GulTbiNavigationHistoryPrivate *priv;
};

/* this class is abstract */

GType			 gul_tbi_navigation_history_get_type	(void);
GulTbiNavigationHistory *gul_tbi_navigation_history_new		(void);
void			 gul_tbi_navigation_history_set_direction (GulTbiNavigationHistory *a,
								   GulTbiNavigationHistoryDirection d);

#endif

