/* $Id: gdict-about.c,v 1.25 2005/06/09 15:55:48 vnoel Exp $ */

/*
 *  Papadimitriou Spiros <spapadim+@cs.cmu.edu>
 *  Mike Hughes <mfh@psilord.com>
 *
 *  This code released under the GNU GPL.
 *  Read the file COPYING for more information.
 *
 *  GDict About box
 *
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <glib/gi18n.h>
#include <gtk/gtkaboutdialog.h>

void
gdict_about (GtkWidget *parent)
{
	GtkWidget *about;

	const gchar *authors[] = {
		"Mike Hughes <mfh@psilord.com>",
		"Spiros Papadimitriou <spapadim+@cs.cmu.edu>",
		"Bradford Hovinen <hovinen@udel.edu>",
		"Vincent Noel <vnoel@cox.net>",
		NULL
	};

	const gchar *documenters[] = {
		"Sun GNOME Documentation Team <gdocteam@sun.com>",
		"John Fleck <jfleck@inkstain.net>",
		NULL
	};

	const gchar *translator_credits = _("translator-credits");
	const gchar *copyright = "Copyright \xc2\xa9 1999-2005 Mike Hughes";
	const gchar *comments = _("A client for the MIT dictionary server.");

	gtk_show_about_dialog (GTK_WINDOW (parent),
												 "name", _("Dictionary"),
												 "version", VERSION,
												 "copyright", copyright,
												 "comments", comments,
												 "authors", authors,
												 "translator-credits", translator_credits,
												 "documenters", documenters,
												 "logo-icon-name", "gdict",
												 NULL);
}
