
#include <config.h>
#include <gdk/gdkx.h>
#include <libbonoboui.h>
#include <libgnomecanvas/gnome-canvas-widget.h>

#include <gst/player/gstmediaplay.h>
enum {
	PROP_LOCATION,
	PROP_STATE,
	PROP_VOLUME,
	PROP_VIDEO_SCALE,
	PROP_DISPLAY_MODE
} GstPlayerControlArgs;

static void
get_prop (BonoboPropertyBag *bag,
          BonoboArg         *arg,
          guint              arg_id,
          CORBA_Environment *ev,
          gpointer           user_data)
{
	GstMediaPlay *mplay = user_data;

	switch (arg_id) {
	case PROP_LOCATION:
		BONOBO_ARG_SET_STRING(arg, gst_media_play_get_location(mplay));
		break;
	case PROP_STATE:
		BONOBO_ARG_SET_INT(arg, gst_media_play_get_state(mplay));
		break;
	case PROP_VOLUME:
		BONOBO_ARG_SET_FLOAT(arg, gst_media_play_get_volume(mplay));
		break;
	case PROP_VIDEO_SCALE:
		BONOBO_ARG_SET_FLOAT(arg, gst_media_play_get_video_scale(mplay));
		break;
	case PROP_DISPLAY_MODE:
		break;
	default:
		bonobo_exception_set (ev, ex_Bonobo_PropertyBag_NotFound);
		break;
	}
}

static void
set_prop (BonoboPropertyBag *bag,
          const BonoboArg         *arg,
          guint              arg_id,
          CORBA_Environment *ev,
          gpointer           user_data)
{
	GstMediaPlay *mplay = user_data;

	switch (arg_id) {
	case PROP_LOCATION:
		gst_media_play_set_location(mplay, BONOBO_ARG_GET_STRING(arg));
		break;
	case PROP_STATE:
		gst_media_play_set_state(mplay, BONOBO_ARG_GET_INT(arg));
		break;
	case PROP_VOLUME:
		gst_media_play_set_volume(mplay, BONOBO_ARG_GET_FLOAT(arg));
		break;
	case PROP_VIDEO_SCALE:
		gst_media_play_set_video_scale(mplay, BONOBO_ARG_GET_FLOAT(arg));
		break;
	case PROP_DISPLAY_MODE:
		break;
	default:
		bonobo_exception_set (ev, ex_Bonobo_PropertyBag_NotFound);
		break;
	}
}
						  
BonoboObject *
bonobo_entry_control_new (void)
{
	BonoboPropertyBag  *pb;
	BonoboControl      *control;
	GstMediaPlay       *mplay;
	
	/* Create the control. */
	mplay = gst_media_play_new ();
	gtk_widget_show (GTK_WIDGET(mplay));
	control = bonobo_control_new (GTK_WIDGET(mplay));

	pb = bonobo_property_bag_new (get_prop, set_prop, mplay);
	bonobo_control_set_properties (control, BONOBO_OBJREF (pb), NULL);

	bonobo_property_bag_add (pb, "location", PROP_LOCATION,
	                         BONOBO_ARG_STRING, NULL,
	                         "Location of media to play", 0);

	bonobo_property_bag_add (pb, "state", PROP_STATE,
	                         BONOBO_ARG_INT, NULL,
	                         "Current playing state.", 0);

	bonobo_property_bag_add (pb, "volume", PROP_VOLUME,
	                         BONOBO_ARG_FLOAT, NULL,
	                         "Volume of audio output", 0);

	bonobo_property_bag_add (pb, "videoscale", PROP_VIDEO_SCALE,
	                         BONOBO_ARG_FLOAT, NULL,
	                         "Scale factor for video dimensions", 0);

	bonobo_property_bag_add (pb, "displaymode", PROP_DISPLAY_MODE,
	                         BONOBO_ARG_STRING, NULL,
	                         "Name of display mode for desired layout of widgets", 0);

	bonobo_object_unref (BONOBO_OBJECT (pb));

	return BONOBO_OBJECT (control);
}

static BonoboObject *
control_factory (BonoboGenericFactory *this,
		 const char           *object_id,
		 void                 *data)
{
	BonoboObject *object = NULL;
	
	g_return_val_if_fail (object_id != NULL, NULL);

	if (!strcmp (object_id, "OAFIID:Gst_Player_Control"))
		object = bonobo_entry_control_new ();

	return object;
}

int
main (int argc, char *argv [])
{
	int retval;
	char *iid;


	if (!bonobo_ui_init ("gst-player-control",
			     VERSION, &argc, argv)){
		g_error (_("Could not initialize Bonobo UI"));
	}

	gst_init (NULL, NULL);


	iid = bonobo_activation_make_registration_id (
		"OAFIID:Gst_Player_ControlFactory",
		DisplayString (gdk_display));

	retval = bonobo_generic_factory_main (iid, control_factory, NULL);
	g_free (iid);

	return retval;
}                                                                             

