#ifndef __GST_MEDIA_PLAY_CONTROL_H__
#define __GST_MEDIA_PLAY_CONTROL_H__

#include <gnome.h>
#include "gstmediaplay.h"

G_BEGIN_DECLS

#define GST_TYPE_CONTROL            (gst_control_get_type ())
#define GST_CONTROL(obj)            (GTK_CHECK_CAST ((obj), GST_TYPE_CONTROL, GstControl))
#define GST_CONTROL_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), GST_TYPE_CONTROL, GstControlClass))
#define GST_IS_CONTROL(obj)         (GTK_CHECK_TYPE ((obj), GST_TYPE_CONTROL))
#define GST_IS_CONTROL_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_CONTROL))
#define GST_CONTROL_GET_CLASS(obj)  (GTK_CHECK_GET_CLASS ((obj), GST_TYPE_CONTROL, GstControlClass))

typedef struct _GstControl         GstControl;
typedef struct _GstControlClass    GstControlClass;
typedef struct _GstControlPrivate  GstControlPrivate;

struct _GstControl
{
	GtkVBox box;

	GstControlPrivate *_priv;
};

struct _GstControlClass
{
	GtkVBoxClass parent_class;

	void (*button_play)    (GstControl *control);
	void (*button_stop)    (GstControl *control);
	void (*button_next)    (GstControl *control);
	void (*button_prev)    (GstControl *control);
	void (*button_list)    (GstControl *control);
	void (*button_mute)    (GstControl *control);
	void (*volume_change)  (GstControl *control);
	void (*seek_change)    (GstControl *control);
	void (*display_mode_change) (GstControl *control, GstMediaPlayMode display_mode);
};

GtkType     gst_control_get_type       (void);
GtkWidget*  gst_control_new            (GladeXML *xml);

void        gst_control_set_display_mode  (GstControl *control, GstMediaPlayMode display_mode);
void        gst_control_set_state  (GstControl *control, GstElementState state);
void        gst_control_set_enable_seek (GstControl* control, gboolean enable);
void        gst_control_set_mute  (GstControl *control, gboolean mute);
void        gst_control_allow_fullscreen (GstControl* control, gboolean allow);
GtkAdjustment* gst_control_get_volume_adjustment (GstControl *control);

G_END_DECLS

#endif /* __GST_MEDIA_PLAY_CONTROL_H__ */

