/*
 *  Copyright (C) 2000, 2001, 2002 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _GALEON_AUTOMATION_H_
#define _GALEON_AUTOMATION_H_

#include "GaleonAutomation.h"

#include <bonobo/bonobo-control.h>
#include <bonobo/bonobo-object.h>

G_BEGIN_DECLS

#define GALEON_AUTOMATION_TYPE         (galeon_automation_get_type ())
#define GALEON_AUTOMATION(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), GALEON_AUTOMATION_TYPE, GaleonAutomation))
#define GALEON_AUTOMATION_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), GALEON_AUTOMATION_TYPE, GaleonAutomationClass))
#define GALEON_AUTOMATION_IS_OBJECT(o) (G_TYPE_CHECK_INSTANCE_TYPE ((o), GALEON_AUTOMATION_TYPE))
#define GALEON_AUTOMATION_IS_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), GALEON_AUTOMATION_TYPE))
#define GALEON_AUTOMATION_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), GALEON_AUTOMATION_TYPE, GaleonAutomationClass))

typedef struct {
        BonoboObject parent;
} GaleonAutomation;

typedef struct {
        BonoboObjectClass parent_class;

        POA_GNOME_GaleonAutomation__epv epv;
} GaleonAutomationClass;

GType          galeon_automation_get_type (void);

BonoboObject  *galeon_automation_new      (void);

G_END_DECLS

#endif /* _GALEON_AUTOMATION_H_ */
