#ifndef OBGTK_CTREE_H
#define OBGTK_CTREE_H 1

#include <obgtk/obgtkCList.h>
#include <gtk/gtkctree.h>

@interface Gtk_CTree : Gtk_CList
{
@public
  GtkCTree *gtkctree;
}

- castGtkCTree:(GtkCTree *) castitem;
- initWithCTreeInfo:(gint) columns
		   :(gint) tree_column;
- initWithCTreeInfoTitles:(gint) ncolumns
			 :(gint) tree_column
		   Titles:(char **) titles;

- (GtkCTreeNode *)insert:(GtkCTreeNode *) parent
		 :(GtkCTreeNode *) sibling
		 :(gchar **) text
		 :(guint8) spacing
		 :(GdkPixmap *) pixmap_closed
		 :(GdkBitmap *) mask_closed
		 :(GdkPixmap *) pixmap_opened
		 :(GdkBitmap *) mask_opened
		 :(gboolean) is_leaf
		 :(gboolean) expanded;
- remove:(GtkCTreeNode *) node;
/* XXX TODO: lots of iterator functions missing here - need to find
   a nice way to map into ObjC */
- move:(GtkCTreeNode *) node
      :(GtkCTreeNode *) new_parent
      :(GtkCTreeNode *) new_sibling;
- expand:(GtkCTreeNode *) node;
- expand_recursive:(GtkCTreeNode *) node;
- expand_to_depth:(GtkCTreeNode *) node :(gint) depth;
- collapse:(GtkCTreeNode *) node;
- collapse_recursive:(GtkCTreeNode *) node;
- collapse_to_depth:(GtkCTreeNode *) node :(gint) depth;
- toggle_expansion:(GtkCTreeNode *) node;
- toggle_expansion_recursive:(GtkCTreeNode *) node;
- select:(GtkCTreeNode *) node;
- select_recursive:(GtkCTreeNode *) node;
- unselect:(GtkCTreeNode *) node;
- unselect_recursive:(GtkCTreeNode *) node;
- real_select_recursive:(GtkCTreeNode *) node :(gint) state;
@end

#endif /* OBGTK_CTREE_H */
