/*
 * GXSNMP -- An snmp mangament application
 * Copyright (C) 1998 Gregory McLean & Jochen Friedrich
 * Beholder RMON ethernet network monitor,Copyright (C) 1993 DNPAP group
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "g_snmp.h"
#include <string.h>

/* This is from RFC2264 */

/*    guchar *password;          IN
 *    guint   passwordlen;       IN
 *    guchar *engineID;          IN  - pointer to snmpEngineID
 *    guint   enginelen;         IN  - length of snmpEngineID
 *    guchar *key;               OUT - caller supplies pointer to 16
 *                                     octet buffer
 */

void g_password_to_key_md5(guchar *password, guint passwordlen, guchar *key)
{
  MD5_CTX     MD;
  guchar      *cp, password_buf[64];
  gulong      password_index = 0;
  gulong      count = 0, i;

  MD5Init (&MD);   /* initialize MD5 */

  /**********************************************/
  /* Use while loop until we've done 1 Megabyte */
  /**********************************************/

  while (count < 1048576) 
    {
      cp = password_buf;
      for(i = 0; i < 64; i++) 
        {
          /*************************************************/
          /* Take the next octet of the password, wrapping */
          /* to the beginning of the password as necessary.*/
          /*************************************************/
          *cp++ = password[ password_index++ % passwordlen ];
        }
      MD5Update (&MD, password_buf, 64);
      count += 64;
    }
  MD5Final (key, &MD);              /* tell MD5 we're done */

  /*****************************************************/
  /* Now localize the key with the engineID and pass   */
  /* through MD5 to produce final key                  */
  /* May want to ensure that engineLength <= 32,       */
  /* otherwise need to use a buffer larger than 64     */
  /*****************************************************/
}

void g_localize_key_md5(guchar *key, guchar *engineID, guint enginelen)
{
  MD5_CTX     MD;
  guchar      *cp, password_buf[64];

  g_memmove (password_buf, key, 16);
  g_memmove (password_buf+16, engineID, enginelen);
  g_memmove (password_buf+16+enginelen, key, 16);

  MD5Init (&MD);
  MD5Update (&MD, password_buf, 32+enginelen);
  MD5Final (key, &MD);

  return;
}

/*    guchar *password;          IN
 *    guint   passwordlen;       IN
 *    guchar *engineID;          IN  - pointer to snmpEngineID
 *    guint   enginelen;         IN  - length of snmpEngineID
 *    guchar *key;               OUT - caller supplies pointer to 20
 *                                     octet buffer
 */

void g_password_to_key_sha(guchar *password, guint passwordlen, guchar *key)
{
  SHA_CTX     SH;
  guchar      *cp, password_buf[72];
  gulong      password_index = 0;
  gulong      count = 0, i;

  SHAInit (&SH);   /* initialize SHA */

  /**********************************************/
  /* Use while loop until we've done 1 Megabyte */
  /**********************************************/
  while (count < 1048576) 
    {
      cp = password_buf;
      for(i = 0; i < 64; i++) 
        {
          /*************************************************/
          /* Take the next octet of the password, wrapping */
          /* to the beginning of the password as necessary.*/
          /*************************************************/
          *cp++ = password[ password_index++ % passwordlen ];
        }
      SHAUpdate (&SH, password_buf, 64);
      count += 64;
    }
  SHAFinal (key, &SH);              /* tell SHA we're done */
  /*****************************************************/
  /* Now localize the key with the engineID and pass   */
  /* through SHA to produce final key                  */
  /* May want to ensure that engineLength <= 32,       */
  /* otherwise need to use a buffer larger than 72     */
  /*****************************************************/
}

void g_localize_key_sha(guchar *key, guchar *engineID, guint enginelen)
{
  SHA_CTX     SH;
  guchar      *cp, password_buf[72];

  g_memmove (password_buf, key, 20);
  g_memmove (password_buf+20, engineID, enginelen);
  g_memmove (password_buf+20+enginelen, key, 20);

  SHAInit (&SH);
  SHAUpdate (&SH, password_buf, 40+enginelen);
  SHAFinal (key, &SH);

  return;
}
