/*
 * $Id: db_interface.c,v 1.3 1998/07/04 15:58:40 gregm Exp $
 * GXSNMP -- An snmp mangament application
 * Copyright (C) 1998 Gregory McLean
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc.,  59 Temple Place - Suite 330, Cambridge, MA 02139, USA.
 *
 * Abstract database interface api
 */
#ifndef lint
static char const copyright[] =
" @(#) Copyright (c) 1998 Gregory McLean";
#endif

#include "main.h"
#include "db_interface.h"
#ifdef HAVE_SQL
#include <mysql/mysql.h>
#endif

/*
 * Local functions
 */

/*
 * Global Functions
 */

/*
 * Call this before any db actions.
 * This should take care of any db specific initilization.
 */
gboolean
db_init ()
{
}

gboolean
db_connect (db_conn *connection)
{
#ifdef HAVE_SQL

  connection->db_handle = (MYSQL *)g_malloc (sizeof(MYSQL));

  if (mysql_connect (connection->db_handle, 
		     connection->db_host,
		     connection->db_user,
		     connection->db_password) )
    {
      return TRUE;
    }
  else
    {
      return FALSE;
    }
#endif

}

/* EOF */









