/*
 * $Id: main.c,v 1.50 1998/08/13 22:21:25 gregm Exp $
 * GXSNMP -- An snmp mangament application
 * Copyright (C) 1998 Gregory McLean
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc.,  59 Temple Place - Suite 330, Cambridge, MA 02139, USA.
 *
 * Main program entry point
 * Also the main panel code is here.
 */
#ifndef lint
static char const copyright[] =
"@(#) Copyright (c) 1998 Gregory McLean";
#endif
static char const rcsid[] =
 "$Id: main.c,v 1.50 1998/08/13 22:21:25 gregm Exp $";
#include <config.h>
#include "main.h"
#include <gtkhost.h>
#include "net_map.h"

/*
 * Local functions 
 */
static void quit_button_cb      (GtkWidget *widget,
				 gpointer  data);
static void delete_host_cb      (GtkWidget *widget,
				 gpointer  data);
static gint host_button_cb      (GtkWidget *widget,
				 GdkEventButton *event,
				 gpointer  data);
static void host_widget_cb      (GtkWidget *widget,
				 gpointer  data);
static void about_menu_cb       (GtkWidget *widget,
				 gpointer  data);
static void menuitem_clicked    (GtkWidget *widget,
				 gpointer  data);
static gint button_press_event  (GtkWidget *widget,
				 GdkEventButton *event);
static gint panel_delete_cb     (GtkWidget *widget,
				 GdkEvent  *e,
				 gpointer  data);
gint draw_host                  (GtkWidget *widget,
				 hosts *hentry);

static GtkWidget                *status;


gxsnmp *app_info;

#define FILE_MENU_NEW    1
#define FILE_MENU_OPEN   2
#define FILE_MENU_SAVE   3
#define FILE_MENU_SAVEAS 4
#define FILE_MENU_QUIT   5
#define EDIT_MENU_COPY   6
#define EDIT_MENU_CUT    7
#define EDIT_MENU_CONFIG 8
#define TOOL_MENU_ADDH   9
#define TOOL_MENU_DELH   10
#define TOOL_MENU_HOSTL  11
#define TOOL_MENU_NETL   12
#define TOOL_MENU_MIBB   13
#define TOOL_MENU_EVENT  14
#define HELP_ABOUT_ITEM  15

typedef struct __MyMenu {
  char *text;
  int  code;
  char *accel;
  gpointer callback;
} MyMenu;


MyMenu Tmenu[] = {
  { N_("Add Host..."), TOOL_MENU_ADDH, "<alt>A", menuitem_clicked },
  { N_("Delete Host..."), TOOL_MENU_DELH, "<alt>D", delete_host_cb }
};

/*
 * Stolen from gzilla :)
 */
/* New menus stuff here (based on GTK+ menus and not menufactory. */

/* Taken from gtkmenufactory.c.

   Todo: make it much more general, so that it can handle keys outside
   the 8-bit ASCII set. This will require changes to GTK :-( */
static void
gtk_menu_factory_parse_accelerator (char   *accelerator,
                                    char   *accelerator_key,
                                    guint8 *accelerator_mods)
{
  int done;

  g_return_if_fail (accelerator != NULL);
  g_return_if_fail (accelerator_key != NULL);
  g_return_if_fail (accelerator_mods != NULL);

  *accelerator_key = 0;
  *accelerator_mods = 0;

  done = FALSE;
  while (!done)
    {
      if (strncmp (accelerator, "<shift>", 7) == 0)
        {
          accelerator += 7;
          *accelerator_mods |= GDK_SHIFT_MASK;
        }
      else if (strncmp (accelerator, "<alt>", 5) == 0)
        {
          accelerator += 5;
          *accelerator_mods |= GDK_MOD1_MASK;
        }
      else if (strncmp (accelerator, "<control>", 9) == 0)
        {
          accelerator += 9;
          *accelerator_mods |= GDK_CONTROL_MASK;
        }
      else
        {
         done = TRUE;
          *accelerator_key = accelerator[0];
        }
    }
}

/*
 * End of code theft
 */

GtkWidget *
generate_menu (gchar *name, MyMenu *mymenu, int count, GtkWidget *window,
	       int right_justify)
{
  int          x;
  char         *tmp;
  char         accel_key;
  guint8       accel_mods;
  GtkWidget    *root;
  GtkWidget    *item;
  GtkWidget    *menu;

  menu = gtk_menu_new ();
  root = gtk_menu_item_new_with_label (name);
  if (right_justify)
    gtk_menu_item_right_justify (GTK_MENU_ITEM (root));
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (root), menu);
  gtk_widget_show (root);
  for (x = 0; x < count; x++)
    {
      tmp = gettext(mymenu[x].text);
      if (tmp != NULL)
	item = gtk_menu_item_new_with_label (tmp);
      else
	item = gtk_menu_item_new ();
      gtk_object_set_user_data (GTK_OBJECT (item), (gint *)mymenu[x].code);
      if (mymenu[x].callback != NULL)
	{
	  gtk_signal_connect (GTK_OBJECT (item), "activate",
			      GTK_SIGNAL_FUNC (mymenu[x].callback),
			      window);
	}
      if (mymenu[x].code == -1)
	gtk_widget_set_sensitive (item, FALSE);
      gtk_menu_append (GTK_MENU (menu), item);
      gtk_widget_show (item);
      if (mymenu[x].accel != NULL)
	{
	  tmp = mymenu[x].accel;
	  gtk_menu_factory_parse_accelerator ( tmp, &accel_key, &accel_mods);
#ifdef GTK_HAVE_FEATURES_1_1_0
	  gtk_widget_add_accelerator (item, "activate", app_info->accel_table,
				      accel_key, accel_mods, 
				      GTK_ACCEL_VISIBLE);
#else
	  gtk_widget_install_accelerator (item,
					  app_info->accel_table,
					  "activate",
					  accel_key,
					  accel_mods);
#endif
	}
    }
#ifdef GTK_HAVE_FEATURES_1_1_0
  gtk_menu_set_accel_group (GTK_MENU (menu), app_info->accel_table);
#else
  gtk_menu_set_accelerator_table (GTK_MENU (menu), app_info->accel_table);
#endif
  return root;
}

GtkWidget *
make_toolbar (GtkWidget *window)
{
  GtkWidget *toolbar;
  char *kludge;

  if (!GTK_WIDGET_REALIZED (window))
    gtk_widget_realize (window);

  toolbar = gtk_toolbar_new (GTK_ORIENTATION_VERTICAL, GTK_TOOLBAR_BOTH);

  gtk_toolbar_append_item (GTK_TOOLBAR (toolbar),
			   _("Mib Browser"), _("Open the mib browser"),
			   NULL,
			   gnome_stock_pixmap_widget (window,
				              GNOME_STOCK_PIXMAP_NEW),
			   open_browser_panel, NULL);
  gtk_toolbar_append_item (GTK_TOOLBAR (toolbar),
			   _("Event Browser"), _("Open the event browser"),
			   NULL,
			   gnome_stock_pixmap_widget (window,
				              GNOME_STOCK_PIXMAP_NEW),
			   open_event_panel, NULL);
  gtk_toolbar_append_item (GTK_TOOLBAR (toolbar),
			   _("Config"), _("Change the configuration settings"),
			   NULL,
                           gnome_stock_pixmap_widget (window, 
                                              GNOME_STOCK_PIXMAP_PREFERENCES),
			   (GtkSignalFunc) open_config_panel, NULL);
  gtk_toolbar_append_item (GTK_TOOLBAR (toolbar),
			   _("Exit"), _("Quit this application"),
			   NULL,
                           gnome_stock_pixmap_widget (window, 
                                                      GNOME_STOCK_PIXMAP_QUIT),
			   (GtkSignalFunc) quit_button_cb, NULL);

  return toolbar;
}
GtkWidget *scrolled;

void
create_main_panel ()
{
    GtkWidget  *scrolled_window;
    GtkWidget  *toolbar;
    GtkWidget  *bar;
    GtkWidget  *menubar;
    GtkWidget  *vbox;
    GtkWidget  *left_box;
    GtkWidget  *right_box;
    GtkWidget  *hbox;
    GtkWidget  *logo;

#ifdef USE_GNOME
    app_info->window = gnome_app_new ("gxsnmp", _("GSXNMP"));
#else
    app_info->window = new_window ("Network Map", GTK_WINDOW_TOPLEVEL,
			 GTK_WIN_POS_CENTER, 1);
#endif
    gtk_window_set_wmclass (GTK_WINDOW (app_info->window), "netmap_window", 
			    "GXSNMP");
    gtk_signal_connect (GTK_OBJECT (app_info->window), "delete_event",
			GTK_SIGNAL_FUNC (panel_delete_cb),
			NULL);
    gtk_widget_realize (app_info->window);
    app_info->cc = gdk_color_context_new (gtk_widget_get_visual 
					  (app_info->window),
					  gtk_widget_get_colormap 
					  (app_info->window));
    vbox = gtk_vbox_new (FALSE, 0);
    gtk_container_add (GTK_CONTAINER (app_info->window), vbox);
    gtk_widget_show (vbox);

    hbox = gtk_handle_box_new ();
    gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
    gtk_widget_show (hbox);

    menubar = gtk_menu_bar_new ();
#ifdef GTK_HAVE_FEATURES_1_1_0
    app_info->accel_table = gtk_accel_group_new ();
#else
    app_info->accel_table = gtk_accelerator_table_new ();
    gtk_accelerator_table_ref (app_info->accel_table);
#endif

    gtk_container_add (GTK_CONTAINER (hbox), menubar);
    gtk_widget_show (menubar);
    bar = gtk_hseparator_new ();
    gtk_box_pack_start (GTK_BOX (vbox), bar, FALSE, FALSE, 0);
    gtk_widget_show (bar);

    gtk_menu_bar_append (GTK_MENU_BAR (menubar), 
			 generate_menu( _("Tools"), Tmenu, 
					ELEMENTS (Tmenu), app_info->window,
					FALSE));
    hbox = gtk_hbox_new (FALSE, 1);
    gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
    gtk_widget_show (hbox);

    left_box = gtk_vbox_new (FALSE, 5);
    gtk_box_pack_start (GTK_BOX (hbox), left_box, FALSE, TRUE, 0);
    gtk_widget_show (left_box);

    bar = gtk_vseparator_new();
    gtk_box_pack_start (GTK_BOX (hbox), bar, FALSE, FALSE, 1);
    gtk_widget_show (bar);

    right_box = gtk_vbox_new (FALSE, 5);
    gtk_box_pack_start (GTK_BOX (hbox), right_box, TRUE, TRUE, 0);
    gtk_widget_show (right_box);

    bar = gtk_hseparator_new ();
    gtk_box_pack_start (GTK_BOX (vbox), bar, FALSE, FALSE, 0);
    gtk_widget_show (bar);

    hbox = gtk_handle_box_new ();
    gtk_box_pack_start (GTK_BOX (left_box), hbox, FALSE, FALSE, 0);
    gtk_widget_show (hbox);

    toolbar = make_toolbar (app_info->window);
    gtk_container_add (GTK_CONTAINER (hbox), toolbar);
    gtk_widget_show (toolbar);

    app_info->app_stat = gtk_statusbar_new ();
    app_info->app_stat_id = gtk_statusbar_get_context_id 
                            (GTK_STATUSBAR(app_info->app_stat),
			     "app_stat");
    gtk_box_pack_start (GTK_BOX (vbox), app_info->app_stat, FALSE, FALSE, 0);
#ifdef GTK_HAVE_FEATURES_1_1_0
    gtk_window_add_accel_group (GTK_WINDOW (app_info->window),
				app_info->accel_table);
#else
    gtk_window_add_accelerator_table (GTK_WINDOW (app_info->window),
				      app_info->accel_table);
#endif
    gtk_widget_show_all (app_info->window);
    init_pixmap_d (app_info->app_stat);
}

void
quit_app ()
{
  quit_button_cb (NULL, NULL);
}

/*
 * The callback functions
 */

static void
quit_button_cb (GtkWidget *widget,
		gpointer  data)
{

  close_file_dialog ();
  destroy_control_panel ();
  destroy_edit_panel ();
  destroy_route_panel ();
  destroy_map_panel ();
  if (app_info->conf_panel != NULL)
    {
      gtk_widget_destroy (app_info->conf_panel->window);
      g_free (app_info->conf_panel);
    }
  if (app_info->hlist_pane != NULL)
    {
      gtk_widget_destroy (app_info->hlist_pane->window);
      g_free (app_info->hlist_pane);
    }
  destroy_add_host_panel ();
  if (app_info->sinf_panel != NULL)
    {
      gtk_widget_destroy (app_info->sinf_panel->window);
      g_free (app_info->sinf_panel);
    }
  destroy_network_panel ();
  destroy_add_net_panel ();
  destroy_monitor_panel ();
  destroy_set_panel ();
  destroy_get_panel ();
  destroy_event_panel ();
  destroy_interface_panel ();
  destroy_browser_panel ();
  gtk_widget_unref (app_info->host_popup_right);
  gtk_widget_destroy (app_info->window);
  destroy_pixmap_cache ();
  gtk_main_quit();
}

static void
delete_host_cb (GtkWidget *widget, gpointer  data)
{
  hosts   *entry;

#ifdef HAVE_SQL
  sql_server    *sql_serv;
#endif
  if (app_info->current_host == NULL)
    {
      update_app_stat (_("No host selected to delete."));
      notice_dlg (_("No host selected to delete."));
      return ;
    }
  else
    {
      entry = (hosts *)gtk_object_get_data (GTK_OBJECT 
					    (app_info->current_host), 
					    "host_entry");
      hl_del_host (entry);
      printf("About to do it...\n");
      app_info->host_count--;
      update_known_hosts (app_info->host_count);
#ifdef HAVE_SQL
      sql_serv = g_new (sql_server, 1);
      sql_serv->sql_host = g_strdup (app_info->current_config.def_sql_host);
      sql_serv->sql_user = g_strdup (app_info->current_config.def_sql_user);
      sql_serv->sql_pass = g_strdup (app_info->current_config.def_sql_pass);
      sql_del_host_entry (sql_serv, entry);
      g_free (sql_serv);
#endif
    }
}
static gint
host_button_cb (GtkWidget *widget, GdkEventButton *event, gpointer data)
{

  if (event->button == 2)
      app_info->current_host = widget;
  if (event->button == 3)
    {
      app_info->current_host = widget;
      host_menu_right_popup (event->button, event->time);
      return FALSE;
    }
  return TRUE;
}

  
static void
host_widget_cb (GtkWidget *widget,
		gpointer  data)
{
  app_info->current_host = widget;
}

static gint
panel_delete_cb (GtkWidget *widget,
		 GdkEvent  *e,
		 gpointer  data)
{
  quit_button_cb (widget, data);
  return TRUE;
}

static void
menuitem_clicked (GtkWidget *widget,
		  gpointer  data)
{
  gint  foo;
 
  foo = (gint)gtk_object_get_user_data (GTK_OBJECT(widget));
  switch (foo) 
    {
    case TOOL_MENU_ADDH:
      open_add_host_panel();
      break;
    case TOOL_MENU_HOSTL:
      hlist_panel_open();
      break;
    case TOOL_MENU_NETL:
      open_network_panel();
      break;
    case TOOL_MENU_MIBB:
      open_browser_panel();
      break;
    case TOOL_MENU_EVENT:
      open_event_panel();
      break;
    }

}

static void
about_menu_cb (GtkWidget *widget, gpointer data)
{
  open_about_panel ();
}

static gint 
button_press_event (GtkWidget *widget,
		    GdkEventButton *event)
{
  if (event->button == 1 && app_info->pixmap != NULL)
    {
    }
  if (event->button == 2 && app_info->current_host != NULL )
    {
    }
  if (event->button == 3)
    {
      g_print ("Do main popup menu...\n");
    }
  return TRUE;
}

void
update_app_stat (gchar *msg, ...)
{
  va_list  ap;
  gchar    buf[1024];

  va_start (ap, msg);
  vsnprintf (buf, sizeof(buf), msg, ap);
  va_end (ap);

  gtk_statusbar_pop (GTK_STATUSBAR (app_info->app_stat),
		     app_info->app_stat_id);
  gtk_statusbar_push (GTK_STATUSBAR (app_info->app_stat),
		      app_info->app_stat_id, buf);
}

gint
draw_host (GtkWidget *widget, hosts *hentry)
{
  GtkWidget *nwidget;
  GdkColor  color;
  GtkStyle  style;
  hosts     *new;
  int       x,y,i;

  
  if (find_host ((char*)hentry->hl_snmp.name) == NULL)
    {
      new = hl_add_host (hentry);
      if (new != NULL)
	{
	  
	  /*	  new->widget = new_host_widget (new); */
          map_add_host (new, -1, -1);
	  /*	  if (!GTK_WIDGET_REALIZED (scrolled))
	    gtk_widget_realize (scrolled);
	  color = get_color (HOST_UP_COLOR);
	  gdk_color_alloc (gdk_window_get_colormap (scrolled->window),
			   &color);
	  memcpy (&style, gtk_widget_get_style (scrolled), 
		  sizeof (GtkStyle));
	  for (i = 0; i < 5; i++)
	    memcpy (&style.bg[i], &color, sizeof (GdkColor));
	  
	  gtk_container_add (GTK_CONTAINER (scrolled), new->widget);
	  gdk_window_set_cursor (new->widget->window, 
				 gdk_cursor_new (GDK_HAND1) );
	  gtk_signal_connect (GTK_OBJECT (new->widget), "button_press_event",
			      GTK_SIGNAL_FUNC (host_button_cb),
			      NULL); */
	  new->snmp_running = FALSE;
	  /*
	  gtk_object_set_data (GTK_OBJECT (new->widget),"host_entry", new);
	  */
	  if (app_info->hlist_pane != NULL)
	    list_add (NULL, new, NULL);
	  if (app_info->brows_panel != NULL)
	    browser_add_host (new->hl_snmp.name);
	  /*
	  gtk_widget_show (new->widget);
	  gtk_widget_set_style (new->widget, &style);
	  app_info->current_host = new->widget;
	  */
	  app_info->host_count++;
	  update_known_hosts (app_info->host_count);
	}
     
    }
  return TRUE;
}

void
app_init()
{
  app_info = (gxsnmp *)g_malloc (sizeof (gxsnmp));
  app_info->x = 1;
  app_info->y = 1;
  app_info->current_host = NULL;
  app_info->conf_panel  = NULL;
  app_info->hlist_pane = NULL;
  app_info->sinf_panel  = NULL;
  app_info->netwk_panel = NULL;
  app_info->inter_panel = NULL;
  app_info->brows_panel = NULL;
  app_info->host_hash   = NULL;
  app_info->host_count  = 0;
  app_info->network_count = 0;
  app_info->root_width  = gdk_screen_width ();
  app_info->root_height = gdk_screen_height ();
}

/*
 * Program entry point
 */
int 
main (int argc, char *argv[])
{
  int           idle_id, time_id;
  app_event     event;
  struct passwd *entry;

  argp_program_version = VERSION;
#ifdef HAS_GDK_IMLIB
  gdk_imlib_init ();
#endif

  bindtextdomain (PACKAGE, GNOMELOCALEDIR);
  textdomain (PACKAGE);                 
  gnome_init ("gxsnmp", NULL, argc, argv, 0, NULL);
  entry = getpwuid (getuid());
  app_init ();
#ifndef GTK_HAVE_FEATURES_1_1_0
  gtk_accelerator_table_set_mod_mask (NULL, GDK_SHIFT_MASK |
				      GDK_CONTROL_MASK |
				      GDK_MOD1_MASK);
#endif
  event.category     = GX_EVENT_INFO;
  event.sub_category = GX_INFO_NONE;
  event.timestamp    = time (NULL);
  event.description  = g_strdup ("gxsnmp started.");
  add_event (&event);
  gtk_rc_parse ("./gxsnmpgtkrc");
#ifdef MAIN_DEBUG  
  g_print ("Pid: [%d]\n",getpid());
#endif
  init_mib();
  snmpinit ();
  
  if (getuid() != 0)
    {
      /*
       * Maybe do a dialog here or set a flag telling the user that 
       * ping and traceroute will be disabled because they are not running as
       * root?
       */
    }
  else
    {
      initpingsocket();
      initping();
    }
  if (load_config () == FALSE)
    {
      app_info->current_config.def_snmp_com  = DEFAULT_COMMUNITY;
      app_info->current_config.def_snmp_wcom = DEFAULT_WCOMMUNITY;
      app_info->current_config.def_snmp_retr = 5;
      app_info->current_config.def_snmp_port = 161;
      app_info->current_config.def_snmp_time = 30;
      app_info->current_config.def_sql_host  = g_strdup ("localhost");
      app_info->current_config.def_sql_user  = g_strdup (entry->pw_name);
      app_info->current_config.def_sql_db    = DEFAULT_DATABASE;
      app_info->snmp_running = 0;
    }
  create_main_panel ();
  open_map_panel ();
  open_control_panel ();
  sql_load_host_table ();

  create_host_popup ( (GtkWindow *)app_info->window);
  
  time_id = gtk_timeout_add (1000, run_queue, NULL);
 
  gtk_main();
  return 0;
}

/* EOF */

