#include "obgtkPacker.h"

@implementation Gtk_Packer
- castGtkPacker:(GtkPacker *) castitem
{
  gtkpacker = castitem;

  return [super castGtkContainer:GTK_CONTAINER(castitem)];
}

- init
{
  return [self castGtkPacker:GTK_PACKER(gtk_packer_new())];
}

- add_defaults:(id) child
	      :(GtkSideType) side
	      :(GtkAnchorType) anchor
	      :(GtkPackerOptions) options
{
  gtk_packer_add_defaults(gtkpacker, ((Gtk_Widget *)child)->gtkwidget,
			  side, anchor, options);
  return self;
}

- add:(id) child
     :(GtkSideType) side
     :(GtkAnchorType) anchor
     :(GtkPackerOptions) options
     :(guint) border_width
     :(guint) pad_x :(guint) pad_y
     :(guint) i_pad_x :(guint) i_pad_y
{
  gtk_packer_add(gtkpacker, ((Gtk_Widget *)child)->gtkwidget,
		 side, anchor, options,
		 border_width, pad_x, pad_y,
		 i_pad_x, i_pad_y);
  return self;
}

- configure:(id) child
	   :(GtkSideType) side
	   :(GtkAnchorType) anchor
	   :(GtkPackerOptions) options
	   :(guint) border_width
	   :(guint) pad_x :(guint) pad_y
	   :(guint) i_pad_x :(guint) i_pad_y
{
  gtk_packer_configure(gtkpacker, ((Gtk_Widget *)child)->gtkwidget,
		       side, anchor, options,
		       border_width, pad_x, pad_y,
		       i_pad_x, i_pad_y);
  return self;
}

- reorder_child:(id) child :(gint) position
{
  gtk_packer_reorder_child(gtkpacker, ((Gtk_Widget *)child)->gtkwidget, position);
  return self;
}

- set_spacing:(guint) spacing
{
  gtk_packer_set_spacing(gtkpacker, spacing);
  return self;
}

- set_default_border_width:(guint) border
{
  gtk_packer_set_default_border_width(gtkpacker, border);
  return self;
}

- set_default_pad:(guint) pad_x :(guint) pad_y
{
  gtk_packer_set_default_pad(gtkpacker, pad_x, pad_y);
  return self;
}

- set_default_ipad:(guint) i_pad_x :(guint) i_pad_y
{
  gtk_packer_set_default_ipad(gtkpacker, i_pad_x, i_pad_y);
  return self;
}
@end
