/*
 * $Id: sql_interface.c,v 1.18 1998/07/29 21:18:52 jochen Exp $
 * GXSNMP -- An snmp mangament application
 * Copyright (C) 1998 Gregory McLean
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc.,  59 Temple Place - Suite 330, Cambridge, MA 02139, USA.
 *
 * SQL interfacing code.
 */
#ifndef lint
static char const copyright[] =
"@(#) Copyright (c) 1998 Gregory McLean";
#endif
static char const rcsid[] =
"$Id: sql_interface.c,v 1.18 1998/07/29 21:18:52 jochen Exp $";

#include "main.h"
#include "db_interface.h"
#ifdef HAVE_SQL
#include <mysql/mysql.h>
#else
typedef struct {
  int foo;
} MYSQL;
typedef MYSQL MYSQL_RES;
typedef MYSQL MYSQL_ROW;
#endif

/*
 * Local module variables
 */

/*
 * Global varibles
 */

extern gxsnmp *app_info;

/*
 * Global Functions
 */
char *
sql_server_status (sql_server *server)
{
  char            *retval;
#ifdef HAVE_SQL
  MYSQL           *sql;
  char            *tmp;
  
  sql = (MYSQL *)g_malloc (sizeof(MYSQL));

  mysql_connect (sql, 
		 server->sql_host,
		 server->sql_user,
		 server->sql_pass);
  tmp = mysql_stat (sql);
  retval = g_strdup (tmp);
  mysql_close (sql);
  g_free (sql);
  return retval;
#else
  retval = g_strdup ("Sql support was not enabled.");
  return retval;
#endif
}

GList *
sql_db_list (sql_server *server)
{
  db_conn   *db_connection;

#ifdef HAVE_SQL
  GList     *db_list;
  MYSQL     *sql;
  MYSQL_RES *sql_res;
  MYSQL_ROW row;

  db_connection = (db_conn *)g_malloc (sizeof (db_conn));

  db_connection->db_host = g_strdup (server->sql_host);
  db_connection->db_user = g_strdup (server->sql_user);
  db_connection->db_password = g_strdup (server->sql_pass);

  if (db_connect (db_connection))
    {
#if 0
  sql = (MYSQL *)g_malloc (sizeof(MYSQL));
  if (mysql_connect (sql, 
		     server->sql_host,
		     server->sql_user,
		     server->sql_pass))
    {
#endif
      sql_res = mysql_use_result (db_connection->db_handle);
      sql_res = mysql_list_dbs (db_connection->db_handle, "");
      while ( (row = mysql_fetch_row(sql_res)) )
	{
	  db_list = g_list_append (db_list, row[0]);
	}
      mysql_free_result (sql_res);
      mysql_close (db_connection->db_handle);
      g_free (db_connection->db_handle);
    }
  if (g_list_length (db_list) > 0)
    return db_list;
  else
    return NULL;
#else
  return NULL;
#endif
}

gboolean
sql_check_db (sql_server *server, gchar *db)
{
#ifdef HAVE_SQL
  MYSQL    *sql;
  
  sql = (MYSQL *)g_malloc (sizeof (MYSQL));
  if (mysql_connect (sql,
		     server->sql_host,
		     server->sql_user,
		     server->sql_pass))
    {
      if (mysql_select_db (sql, db))
	{
	  mysql_close (sql);
	  g_free (sql);
	  return TRUE;
	}
    }
  return FALSE;
#endif
}

gboolean
sql_create_db (sql_server *server, gchar *db)
{
#ifdef HAVE_SQL
  MYSQL      *sql;

  sql = (MYSQL *)g_malloc (sizeof (MYSQL));
  if (mysql_connect (sql,
		     server->sql_host,
		     server->sql_user,
		     server->sql_pass))
    {
      if ( (mysql_select_db (sql, db)) < 0)
	{
	  /* its not there so go ahead and create it */
	  if ( (mysql_create_db (sql, db)) < 0)
	    {
	      /* Couldn't create the db */
	      g_print (mysql_error(sql));
	      mysql_close (sql);
	      g_free (sql);
	      return FALSE;
	    }
	  else
	    {
	      mysql_close (sql);
	      g_free (sql);
	      return TRUE;
	    }
	}
      /* Database is aready present */
      mysql_close (sql);
      g_free (sql);
    }
#endif
  return FALSE;
}

gboolean
sql_drop_db (sql_server *server, gchar *db)
{
#ifdef HAVE_SQL
  MYSQL     *sql;
  
  sql = (MYSQL *)g_malloc (sizeof (MYSQL));
  if (sql)
    {
      if (sql = mysql_connect (sql,
			   server->sql_host,
			   server->sql_user,
			   server->sql_pass))
	{
	  if (mysql_select_db (sql, db))
	    {
	      if (mysql_drop_db (sql, db))
		{
		  mysql_close (sql);
		  g_free (sql);
		  return TRUE;
		}
	    }
	  mysql_close (sql);
	}
      g_free (sql);
    }
#endif
  return FALSE;
}
/*
 * Add a host to the host table in the sql database
 */
gboolean
sql_add_host_entry (sql_server *server, hosts *host)
{
#ifdef HAVE_SQL
  MYSQL     *sql;
  char      query[2048];
  char      datebuf[20];
  struct tm *tim;
  time_t    gm_time;

  sql = (MYSQL *)g_malloc (sizeof (MYSQL));
  if (!sql)
    {
      g_print ("Out of memory for sql operation.\n");
      return FALSE;
    }
  if (mysql_connect (sql,
		     server->sql_host,
		     server->sql_user,
		     server->sql_pass))
    {
      if (mysql_select_db (sql, app_info->current_config.def_sql_db) == 0 )
	{
	  db_time_str (&datebuf[0]);
	  snprintf (query, sizeof (query), "INSERT INTO hosts (hostname, "
		    "display_name, read_comm, write_comm, snmp_port, retries,"
		    "timeout, created, modified) VALUES ('%s', '%s', '%s', "
		    "'%s', %i, %i, %i, '%s', '%s')",
		    host->hl_snmp.name,
		    host->hl_disp,
		    host->hl_snmp.rcomm,
		    host->hl_snmp.wcomm,
		    host->hl_snmp.port,
		    host->hl_snmp.retries,
		    host->hl_snmp.timeout,
		    datebuf,
		    datebuf);
	  if (mysql_query (sql, query) == 0)
	    {
              host->rowid = mysql_insert_id(sql);
	      mysql_close (sql);
	      g_free (sql);
	      return TRUE;
	    }
	}
      else
	{
	  g_print ("Couldn't connect to the %s db\n%s\n",
		   app_info->current_config.def_sql_db,
		   mysql_error (sql));
	}

    }
  else
    {
      g_print ("failed to connect to the sql server\n%s\n",
	       mysql_error (sql));
    }
  mysql_close (sql);
  g_free (sql);
  return FALSE;
#else
  return TRUE;
#endif
}

gboolean
sql_add_snmp_entry (sql_server *server, hosts *host)
{
#ifdef HAVE_SQL
  MYSQL        *sql;
  char         query[2048];
  char         datebuf[20];
  struct tm    *tim;
  time_t       gm_time;

  sql = (MYSQL *)g_malloc (sizeof (MYSQL));
  if (mysql_connect (sql,
		     server->sql_host,
		     server->sql_user,
		     server->sql_pass));
  {
    if (mysql_select_db (sql, "snmp") == 0 )
      {
	gm_time = time (NULL);
	tim     = localtime (&gm_time);
	strftime (datebuf, sizeof (datebuf), "%Y%m%d%H%M%S", tim);
	snprintf (query, sizeof (query), "INSERT INTO snmp (nodename, "
		  "snmp_version, snmp_port, retries, timeout, read_comm, "
		  "write_comm, created, modified) VALUES ('%s', %i, %i, "
		  "%i, %i, '%s', '%s')",
		  host->hl_snmp.name,
		  1,
		  host->hl_snmp.port,
		  host->hl_snmp.retries,
		  host->hl_snmp.timeout,
		  host->hl_snmp.rcomm,
		  host->hl_snmp.wcomm,
		  datebuf,
		  datebuf);
	if (mysql_query (sql, query) == 0)
	  {
	    mysql_close (sql);
	    g_free (sql);
	    return TRUE;
	  }
      }
    else
      {
	g_print ("Unable to connect to the snmp table\n%s\n",
		 mysql_error (sql));
      }
    g_print ("Unable to connect to the sql server\n%s\n",
	     mysql_error (sql));
  }
  mysql_close (sql);
  g_free (sql);
#else
  return FALSE;
#endif
}

gboolean
sql_del_host_entry (sql_server *server, hosts *host)
{
#ifdef HAVE_SQL
  MYSQL     *sql;
  char      query[2048];

  sql = (MYSQL *)g_malloc (sizeof (MYSQL));
  if (!sql)
    {
      g_print ("Out of memory for sql operation.\n");
      return FALSE;
    }
  if (mysql_connect (sql,
		     server->sql_host,
		     server->sql_user,
		     server->sql_pass))
    {
      if (mysql_select_db (sql, app_info->current_config.def_sql_db) == 0 )
	{
	  snprintf (query, sizeof (query), "DELETE FROM hosts "
		    "WHERE _rowid = %d", host->rowid);
	  if (mysql_query (sql, query) == 0)
	    {
	      mysql_close (sql);
	      g_free (sql);
	      return TRUE;
	    }
	}
      else
	{
	  g_print ("Couldn't connect to the %s db\n%s\n",
		   app_info->current_config.def_sql_db,
		   mysql_error (sql));
	}

    }
  else
    {
      g_print ("failed to connect to the sql server\n%s\n",
	       mysql_error (sql));
    }
  mysql_close (sql);
  g_free (sql);
  return FALSE;
#else
  return TRUE;
#endif
}

gboolean
sql_update_host_entry (sql_server *server, hosts *host)
{
#ifdef HAVE_SQL
  MYSQL     *sql;
  char      query[2048];
  char      datebuf[20];
  struct tm *tim;
  time_t    gm_time;

  sql = (MYSQL *)g_malloc (sizeof (MYSQL));
  if (!sql)
    {
      g_print ("Out of memory for sql operation.\n");
      return FALSE;
    }
  if (mysql_connect (sql,
		     server->sql_host,
		     server->sql_user,
		     server->sql_pass))
    {
      if (mysql_select_db (sql, app_info->current_config.def_sql_db) == 0 )
	{
	  db_time_str (&datebuf[0]);
	  snprintf (query, sizeof (query), "UPDATE hosts SET hostname='%s', "
		    "display_name='%s', read_comm='%s', write_comm='%s', "
                    "snmp_port=%i, retries=%i, timeout=%i, modified=%i "
                    "WHERE _rowid=%d",
		    host->hl_snmp.name,
		    host->hl_disp,
		    host->hl_snmp.rcomm,
		    host->hl_snmp.wcomm,
		    host->hl_snmp.port,
		    host->hl_snmp.retries,
		    host->hl_snmp.timeout,
		    datebuf,
		    host->rowid);
	  if (mysql_query (sql, query) == 0)
	    {
	      mysql_close (sql);
	      g_free (sql);
	      return TRUE;
	    }
	}
      else
	{
	  g_print ("Couldn't connect to the %s db\n%s\n",
		   app_info->current_config.def_sql_db,
		   mysql_error (sql));
	}

    }
  else
    {
      g_print ("failed to connect to the sql server\n%s\n",
	       mysql_error (sql));
    }
  mysql_close (sql);
  g_free (sql);
  return FALSE;
#else
  return TRUE;
#endif
}

hosts *
sql_fetch_host_entry (sql_server *server, char *hostname)
{
#ifdef HAVE_SQL
  MYSQL        *sql;
  MYSQL_RES    *sql_res;
  MYSQL_ROW    row;
  char         query[2048];
  hosts        *host;

  sql  = (MYSQL *)g_malloc (sizeof (MYSQL));
  if (sql)                    
    {
      if (sql = mysql_connect (sql, 
			       server->sql_host,
			       server->sql_user,
			       server->sql_pass))
	{
	  /* connected */
	  if (mysql_select_db (sql, app_info->current_config.def_sql_db))
	    {
	      /* database selected */
	      host = g_new (hosts, 1);
	      snprintf (query, sizeof (query), "SELECT * FROM hosts WHERE "
			"hostname LIKE '%s'",hostname);
	      if (mysql_query (sql, query))
		{
		  sql_res = mysql_store_result (sql);
		  if (mysql_num_rows (sql_res))
		    {
		      row = mysql_fetch_row (sql_res);
		      /* copy to host struct */
		    }
		  mysql_free_result (sql_res);
		}
	      g_free (host);
	    }
	  mysql_close (sql);
	}
      g_free (sql);
    }
#endif
  return NULL;
}

/*
 * Get a named field from a result set
 */
char *
mysql_get_field (MYSQL_RES *res, MYSQL_ROW row, char *w_field)
{
#ifdef HAVE_SQL
  MYSQL_FIELD  *field;
  int          i, idx;
  
  
  i   = (mysql_num_fields (res) -1);
  idx = -1;
  while (i >= 0) 
    {
      mysql_field_seek (res, i);
      field = mysql_fetch_field (res);
      if (strcasecmp (field->name, w_field) == 0) 
	{
	  idx = i;
	  break;
	}
      i--;
    }
  if (idx < 0) 
    {
      return (NULL);
    } 
  else 
    {
      return row[idx];
    }
#endif
}

gboolean
sql_load_host_table ()
{
#ifdef HAVE_SQL
  MYSQL       *sql;
  MYSQL_RES   *sql_res;
  MYSQL_RES   *field_res;
  MYSQL_ROW   row;
  MYSQL_FIELD *field;
  hosts       *entry;
  int        i, x;

  sql = (MYSQL *)g_malloc (sizeof (MYSQL));
  if (mysql_connect (sql,
		     app_info->current_config.def_sql_host,
		     app_info->current_config.def_sql_user,
		     app_info->current_config.def_sql_pass))
    {
      if ( (mysql_select_db (sql, app_info->current_config.def_sql_db)) < 0)
	{
	  mysql_close (sql);
	  return FALSE;
	}
      else
	{
	  entry = g_new (hosts, 1);
#if 0
	  field_res = mysql_list_fields (sql, "hosts", "*");
#endif
	  mysql_query (sql, "SELECT * FROM hosts ORDER BY hostname");
	  sql_res = mysql_store_result (sql);
	  i = mysql_num_rows (sql_res);
	  while (i > 0)
	    {
	      row = mysql_fetch_row (sql_res);
	      entry->hl_disp = g_strdup (mysql_get_field (sql_res, row, 
						"display_name"));
	      entry->hl_snmp.name = g_strdup (mysql_get_field (sql_res, row,
						     "hostname"));
	      entry->hl_snmp.rcomm = g_strdup (mysql_get_field (sql_res, row, 
						      "read_comm"));
	      entry->hl_snmp.wcomm = g_strdup (mysql_get_field (sql_res, row,
						      "write_comm"));
	      entry->hl_snmp.retries = atoi (mysql_get_field (sql_res, row,
							      "retries"));
	      entry->hl_snmp.timeout = atoi (mysql_get_field (sql_res, row,
							      "timeout"));
	      entry->hl_snmp.port = atoi (mysql_get_field (sql_res, row,
							   "snmp_port"));
	      entry->rowid = atoi (mysql_get_field (sql_res, row,
							   "_rowid"));

              /* FIXME: Make domain a SQL column name */
	      entry->hl_snmp.domain = AF_INET;

	      draw_host (NULL, entry);
	      i--;
	    }
	  mysql_free_result (sql_res);
	  mysql_close (sql);
	}
    }
#endif
}

/* EOF */
