/*
 * $Id: host.c,v 1.8 1998/05/06 22:07:06 gregm Exp $
 * GXSNMP -- An snmp management application
 * Copyright (C) 1998 Gregory McLean
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc.,  59 Temple Place - Suite 330, Cambridge, MA 02139, USA.
 *
 * Host specific routines.
 */
#ifndef lint 
static char const copyright[] =
"@(#) Copyright (c) 1998 Gregory McLean";
#endif
static char const rcsid[] =
 "$Id: host.c,v 1.8 1998/05/06 22:07:06 gregm Exp $";

#include <config.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <netdb.h>
#include <netinet/in.h>
#include "main.h"

extern gxsnmp  *app_info;

struct hostent 
*lookuphost (char *hostname)
{
  static struct hostent       hent;
  static struct hostent       *hp;
  static char                 address[sizeof(u_long)];
  static char                 *addresses[] = { address, (char *) NULL};
  u_long                      hostaddr;

  /* 
   * Check and see if we got a host name or an ip address 
   */
  if (isdigit(*hostname)) 
    {
      /* Ip address, build our own hostent */
      hent.h_name     = hostname;
      hent.h_aliases  = (char **)NULL;
      hent.h_addrtype = AF_INET;
      hent.h_length   = sizeof(struct in_addr);
      hostaddr        = inet_addr (hostname);
      bcopy (&hostaddr, address, sizeof(u_long));
      hent.h_addr_list= addresses;
      return &hent;
    } else
      {
	hp = gethostbyname(hostname);
	if (hp)
	  return hp;
	else
	  return NULL;
      }
}

static void
check_hash_table (void)
{
  if (!app_info->host_hash)
      app_info->host_hash = g_hash_table_new (g_str_hash, g_str_equal);
}
      
hosts *
find_host (char *hostname)
{
  return (g_hash_table_lookup (app_info->host_hash, hostname));
}

hosts *
hl_add_host (hosts *entry)
{
  hosts         *last;
  char          buff[120];
  app_event     event;
  queue_entry   qentry;

  check_hash_table ();
  last = g_hash_table_lookup (app_info->host_hash, entry->hl_snmp.name);
  if (!last)
    {
#ifdef MEM_DEBUG
      DMC ();
#endif
      last = g_new (hosts, 1);
      memmove (last, entry, sizeof(hosts));
      g_hash_table_insert (app_info->host_hash, g_strdup(last->hl_snmp.name),
			   last);
      last->widget     = NULL;
      last->listwidget = NULL;
      last->hl_if      = NULL;
      sprintf (buff, "Host \"%s\" has been added to the list.", 
	       entry->hl_snmp.name);
      event.category     = GX_EVENT_INFO;
      event.sub_category = GX_INFO_NONE;
      event.timestamp    = time (NULL);
      event.description  = g_strdup (buff);
      add_event (&event);
      qentry.id = get_next_queue_id ();
      qentry.queue_callback = test_callback;
      qentry.data = last;
      add_queue_item (&qentry);
      update_app_stat (buff);
      return last;
    }
 
  sprintf (buff, "Host \"%s\" was not added to the list.", entry->hl_snmp.name);
  update_app_stat (buff);
  return NULL;
}

void
hl_del_host (hosts *entry)
{
  hosts     *del;
  char      buff[80];

  del  = (hosts *)g_hash_table_lookup (app_info->host_hash, entry->hl_snmp.name);
  if (del)
    {
#ifdef MEM_DEBUG
      DMC ();
#endif
      if (del->widget != NULL)
	  gtk_widget_destroy (entry->widget);
      if (del->listwidget != NULL)
	  gtk_container_remove (GTK_CONTAINER (app_info->hlist_pane->list),
				entry->listwidget);
      if (app_info->brows_panel != NULL)
	browser_remove_host (del->hl_snmp.name);
      g_hash_table_remove (app_info->host_hash, entry->hl_snmp.name);
      sprintf (buff, "Host \"%s\" was deleted from the list.", entry->hl_snmp.name);
      update_app_stat (buff);
    }
}

/*
 * interface stuff
 */
void
show_interface_list (hosts *entry)
{
  GSList    *item;
  inf_list  *interface;

  if (!entry->hl_if)
    g_print ("No interfaces known for this host.\n");
  else
    {
      item = entry->hl_if;
      while (item)
	{
	  interface = (inf_list *)item->data;
	  g_print ("Interface %s on node %s\n", inet_ntoa (interface->if_addr),
		   entry->hl_snmp.name);
	  item = g_slist_next (item);
	}
    }
}

static int      found            = FALSE;
static inf_list *which_interface = NULL;
/*
 * This will search the interface list of a host
 */
/*                hostname, hosts entry, interface to find   */
static void
search_host (void *key, void *val, void *data)
{
  hosts           *host;
  struct in_addr  if_addr;
  inf_list        *interface;
  GSList          *item;

  host   = (hosts *)val;
  if (!host->hl_if)
    return;           /* empty list */
  if (found)
    return;
  if_addr.s_addr = ((struct in_addr *)data)->s_addr;
  item = host->hl_if;
  while (item)
    {
      interface = (inf_list *)item->data;
      if ( memcmp ((char *)&interface->if_addr.s_addr,(char *)&if_addr.s_addr,
		   sizeof (if_addr.s_addr)) == 0)
	{
	  found = TRUE;
	  which_interface = interface;
	  break;
	}
      item = g_slist_next (item);
    }
}

inf_list *
find_interface (struct in_addr *if_addr)
{
  found           = FALSE;
  which_interface = NULL;

  g_hash_table_foreach (app_info->host_hash, search_host, if_addr);
  if (found)
    return which_interface;
  else
    return NULL;
}

void
add_interface (hosts *host, inf_list *interface)
{
  inf_list   *cp;

#ifdef MEM_DEBUG
  DMC ();
#endif
  cp = (inf_list *)g_malloc (sizeof (inf_list));
  memcpy ((char *)cp, interface, sizeof (inf_list));
  cp->if_host = host;
  find_interface (&cp->if_addr);
  host->hl_if = g_slist_append (host->hl_if, cp);
}

void 
remove_interface (hosts *host, inf_list *interface)
{
}

hosts *
get_current_host ()
{
  if (app_info->current_host != NULL)
    return (hosts *)gtk_object_get_data (GTK_OBJECT (app_info->current_host),
					 "host_entry");
  else
    return NULL;
}


/* EOF */
