%{
/*
 * GXSNMP - An snmp managment application
 * Copyright (C) 1998 Gregory McLean
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc.,  59 Temple Place - Suite 330, Cambridge, MA 02139, USA.
 *
 * Config file parser grammer.
 */
#ifndef lint
static char const copyright[] =
"@(#) Copyright (c) 1998 Gregory McLean";
#endif
#include "main.h"

extern gxsnmp   *app_info;
%}

%union {
  char    *string;               /* string buffer */
  int     numeric;              /* numeric value buffer */
};
%token EQL
%token <string>  QSTRING C_READ_COMM C_WRITE_COMM C_SQL_HOST C_SQL_USER
%token <string>  C_SQL_PASS C_SQL_DB
%token <numeric> NUMBER C_SNMP_RETRIES C_SNMP_TIME C_SNMP_PORT

%type <string>  qstring
%type <numeric> number

%%          /* Gramer definition */
configs:       config
          |    configs config
          ;

config:     snmp_read 
          | snmp_write 
          | snmp_retr 
          | snmp_time 
          | snmp_port
          | sql_host sql_user sql_pass sql_db
          ;

snmp_read:      
     C_READ_COMM '=' qstring { app_info->current_config.def_snmp_com =
	                       (char *) strdup ($3); }
     | C_READ_COMM qstring { app_info->current_config.def_snmp_com = 
			     (char *) strdup ($2); }
             ;

snmp_write: 
    C_WRITE_COMM '=' qstring { app_info->current_config.def_snmp_wcom =
                             (char *) strdup ($3); }     
    | C_WRITE_COMM qstring { app_info->current_config.def_snmp_wcom =
                             (char *) strdup ($2); }     
             ;
snmp_retr:
   C_SNMP_RETRIES '=' number { app_info->current_config.def_snmp_retr = $3; }
   | C_SNMP_RETRIES number { app_info->current_config.def_snmp_retr = $2; }
             ;

snmp_time:
   C_SNMP_TIME '='   number { app_info->current_config.def_snmp_time = $3; }
   | C_SNMP_TIME    number { app_info->current_config.def_snmp_time = $2; }
             ;

snmp_port:
   C_SNMP_PORT  '='  number { app_info->current_config.def_snmp_port = $3; }
   | C_SNMP_PORT    number { app_info->current_config.def_snmp_port = $2; }
             ;
sql_host: 
   C_SQL_HOST  '='   qstring { app_info->current_config.def_sql_host =
			      (char *)strdup ($3); }
   | C_SQL_HOST     qstring { app_info->current_config.def_sql_host =
			      (char *)strdup ($2); }
             ;

sql_user:  
   C_SQL_USER '='    qstring { app_info->current_config.def_sql_user = 
			      (char *)strdup ($3); }
   | C_SQL_USER     qstring { app_info->current_config.def_sql_user = 
			      (char *)strdup ($2); }
             ;

sql_pass:
   C_SQL_PASS '='    qstring { app_info->current_config.def_sql_pass = 
			      (char *)strdup ($3); }
   | C_SQL_PASS     qstring { app_info->current_config.def_sql_pass = 
			      (char *)strdup ($2); }
             ;

sql_db:
   C_SQL_DB  '='   qstring { app_info->current_config.def_sql_db = 
			      (char *)strdup ($3); }
   | C_SQL_DB       qstring { app_info->current_config.def_sql_db = 
			      (char *)strdup ($2); }
             ;
qstring: QSTRING { $$ = $1; }
       ;

number: NUMBER { $$ = $1; }
       ;

%%
/* Supporting 'C' Functions */

/*
 * Prepare the parser's environment
 */

int
config_prelude()
{
}

/*
 * Wind up this run of the parser and exit out.
 */
int
config_epilog()
{
}

/* EOF */
