%{
/*
 * GXSNMP - An snmp managment application
 * Copyright (C) 1998 Gregory McLean
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc.,  59 Temple Place - Suite 330, Cambridge, MA 02139, USA.
 *
 * Config file lexer.
 */
#ifndef lint
static char const copyright[] = 
"@(#) Copyright (c) 1998 Gregory McLean";
#endif

#include <sys/types.h>
#include <string.h>
#include "c_parser.h"
#include "main.h"

%}
    /* Macro definitions */
whitespc      [ \t]
comment       #.*
number        [0-9]+
qstring       \"[^\"\n]*[\"\n]
newline       \n

%x COMMENT
%%
    /* Rules section */
"/*"               { BEGIN COMMENT; }
<COMMENT>"*/"      { BEGIN INITIAL; }
<COMMENT>.         ;
<COMMENT>{newline} ;
{qstring}         {
                     yylval.string = (char *)strdup (yytext+1);
                     if (yylval.string[yyleng-2] != '"')
                         warning ("Unterminated character string\n",
                         (char *)NULL);
                     else
                       yylval.string[yyleng-2] = '\0';
                     return QSTRING;
                  }
{number}          {
                     yylval.numeric = (int)atoi (yytext);
                     return NUMBER;
                  }
"def_snmp_read"   { return C_READ_COMM; }
"def_snmp_write"  { return C_WRITE_COMM; }
"def_snmp_retr"   { return C_SNMP_RETRIES; }
"def_snmp_time"   { return C_SNMP_TIME; }
"def_snmp_port"   { return C_SNMP_PORT; }
"def_sql_host"    { return C_SQL_HOST; }
"def_sql_user"    { return C_SQL_USER; }
"def_sql_pass"    { return C_SQL_PASS; }
"def_sql_db"      { return C_SQL_DB; }
[_=*/(),.;]       { return yytext[0]; }
{newline}         ;
{whitespc}        ;
.                 { printf (yytext); }

%%             /* End of rules section */

