#ifndef OBGTK_CLIST_H
#define OBGTK_CLIST_H 1

#include <obgtk/obgtkContainer.h>
#include <gtk/gtkclist.h>

@interface Gtk_CList : Gtk_Container
{
@public
  GtkCList *gtkclist;
}

- castGtkCList:(GtkCList *) castitem;
- initWithCListInfo:(gint) ncolumns;
- initWithCListInfoTitles:(gint) ncolumns
		   Titles:(char **) titles;
- set_border:(GtkShadowType) border;
- set_selection_mode:(GtkSelectionMode) mode;
- set_policy:(GtkPolicyType) vscrollbar_policy
	    :(GtkPolicyType) hscrollbar_policy;
- freeze;
- thaw;
- set_column_title:(gint) column
		  :(gchar *) title;
- set_column_widget:(gint) column
		   :(id) widget;
- set_column_justification:(gint) column
			  :(GtkJustification) justification;
- set_column_width:(gint) column
		  :(gint) width;
- set_row_height:(gint) height;
- moveto:(gint) row
	:(gint) column
	:(gfloat) row_align
	:(gfloat) col_align;
- set_text:(gint) row
	  :(gint) column
	  :(gchar *) text;
- set_pixmap:(gint) row
	    :(gint) column
	    :(GdkPixmap *) pixmap
	    :(GdkBitmap *) mask;
- set_pixtext:(gint) row
	     :(gint) column
	     :(gchar *) text
	     :(guint8) spacing
	     :(GdkPixmap *) pixmap
	     :(GdkBitmap *) mask;
- set_foreground:(gint) row
		:(GdkColor *) color;
- set_background:(gint) row
		:(GdkColor *) color;
- set_shift:(gint) row
	   :(gint) column
	   :(gint) vertical
	   :(gint) horizontal;
- (gint)appendCListRow:(gchar **) text;
- insertCListRow:(gchar **) text
		:(gint) row;
- removeCListRow:(gint) row;
- set_row_data:(gint) row
       rowData:(gpointer) data;
- set_row_data_full:(gint) row
	    rowData:(gpointer) data
    destroyCallback:(GtkDestroyNotify) destroy;
- (gpointer) get_row_data:(gint) row;
- (gint) find_row_from_data:(gpointer) data;
- select_row:(gint) row :(gint) column;
- unselect_row:(gint) row :(gint) column;
- clear;

- column_titles_show;
- column_titles_hide;
- column_title_active:(gint) column;
- column_title_passive:(gint) column;
- column_titles_active;
- column_titles_passive;
- (GtkVisibility) row_is_visible:(gint) row;
- (GtkCellType) get_cell_type:(gint) row :(gint) column;
- (gint)get_text:(gint) row
		:(gint) column
	 getText:(gchar **) text;
- (gint) get_pixmap:(gint) row :(gint) column
	  getPixmap:(GdkPixmap **) pixmap
	    getMask:(GdkBitmap **) mask;
- (gint) get_pixtext:(gint) row :(gint) column
	     getText:(gchar **) text
	  getSpacing:(guint8 *) spacing
	  getPixmap:(GdkPixmap **) pixmap
	    getMask:(GdkBitmap **) mask;
- (gint) get_selection_info:(gint) x :(gint) y
		     getRow:(gint *) row
		  getColumn:(gint *) column;
@end

#endif /* OBGTK_CLIST_H */
