/*****************             Electirc Eyes           ***********************/
/* This software is Copyright (C) 1998 but The Rasterman (Carsten Haitzler). */
/* This software falls under the GNU Public License. Please read the COPYING */
/* file for more information                                                 */
/*****************************************************************************/
#include <gdk/gdkx.h>
#include <gdk/gdkprivate.h>
#include "ee.h"

/* The images for the drag operation */
static GtkWidget *drag, *drag_ok;

void init_dirs()
{
   char *hom;
   char *s, *ss;
   FILE *f;
   
   hom = homedir (getuid());
   s = g_copy_strings (hom, "/.ee/icons/", NULL);
   if (isfile(s))
     {
	char time_buffer [40];
	snprintf (time_buffer, 39, "%i", time (NULL));
	
	ss = g_copy_strings (hom, "/.ee/incons.old", time_buffer, NULL);
	mv(s,ss);
	g_free (ss);
     }
   if (!exists(s)) mkdirs(s);
   g_free (s);
   s = g_copy_strings (hom, "/.ee/unknown.png", NULL);
   if (!exists(s))
     {
	f=fopen(s,"w");
	fwrite(unknown,sizeof(char),1904,f);
	fclose(f);
     }
   g_free (s);
   free(hom);
}

char *get_thumb_image(char *file)
{
   char *hom;
   char *s, *ss;
   unsigned long date1,date2;
   GdkImlibImage *im=NULL,*im2=NULL;
   int w,h;
   
   hom=homedir(getuid());
   s = g_copy_strings (hom, "/.ee/icons/", file, NULL);
   if (exists(s))
     {
	date1=moddate(file);
	date2=moddate(s);
	if (date1<date2)
	  {
	     im=gdk_imlib_load_image(s);
	     if ((im->rgb_width==thumb_w)||(im->rgb_height==thumb_h))
	       {
		  free(hom);
		  gdk_imlib_destroy_image(im);
		  return strdup(s);
	       }
	     else
	       gdk_imlib_destroy_image(im);
	  }
     }
   im2=gdk_imlib_load_image(file);
   if (!im2) 
     {
	g_free (s);
	s = g_copy_strings (hom, "/.ee/unknown.png", NULL);
        free(hom);
	return s;
     }
   free(hom);
   w=thumb_w;
   h=(w*im2->rgb_height)/im2->rgb_width;
   if (h>thumb_h)
     {
	h=thumb_h;
	w=(h*im2->rgb_width)/im2->rgb_height;
     }
   im=gdk_imlib_clone_scaled_image(im2,w,h);
   gdk_imlib_destroy_image(im2);
   if (!im) return NULL;
   mkdirs(s);
   gdk_imlib_save_image_to_ppm(im,s);
   gdk_imlib_destroy_image(im);
   return s;
}

void showthumb_cb(GtkWidget *widget, gint num)
{
   if (current.number==num) return;
   show_image_n(num);
}

void del_thumb(char *file)
{
   char *s,*ss;
   int i;
   
   if (!window_thumbs) return;
   i=get_file_number_from_list(file);
   g_free (gnome_icon_list_get_icon_data (GNOME_ICON_LIST (thumbs_box), i));
   gnome_icon_list_remove(GNOME_ICON_LIST(thumbs_box),i);
}

void sel_thumb(char *file)
{
   char *s,*ss;
   int i;
   
   if (!window_thumbs) return;
   i=get_file_number_from_list(file);
   gnome_icon_list_select_icon(GNOME_ICON_LIST(thumbs_box),i);
   if (gnome_icon_list_icon_is_visible(GNOME_ICON_LIST(thumbs_box),i)==
       GTK_VISIBILITY_NONE)
     gnome_icon_list_moveto(GNOME_ICON_LIST(thumbs_box),i,0.50);
}

void add_thumb(char *file)
{
   char *s,*ss;
   int pos;
   
   if (!window_thumbs) return;
   s=get_thumb_image(file);
   if (!s) return;
   ss=fullfileof(file);
   pos = gnome_icon_list_append(GNOME_ICON_LIST(thumbs_box),s,ss);
   gnome_icon_list_set_icon_data (GNOME_ICON_LIST (thumbs_box), pos, g_strdup (file));
   free(ss);
}

void quit_thumbs_cb(GtkWidget *widget, gpointer *data)
{
   gtk_widget_hide(window_thumbs);
}

/*
 * Taken from GNU mc: this starts an artificial drag when a motion is
 * detected instead of waiting for the cursor to leave the window.
 */

/*
 * Hackisigh routine taken from GDK
 */
static void
gdk_dnd_drag_begin (GdkWindow *initial_window)
{
	GdkEventDragBegin tev;
	tev.type = GDK_DRAG_BEGIN;
	tev.window = initial_window;
	tev.u.allflags = 0;
	tev.u.flags.protocol_version = DND_PROTOCOL_VERSION;
	
	gdk_event_put ((GdkEvent *) &tev);
}

void
artificial_drag_start (GdkWindow *window, int x, int y)
{
	GdkWindowPrivate *wp = (GdkWindowPrivate *) window;

	if (!wp->dnd_drag_enabled)
		return;
#if 1
	if (!gdk_dnd.drag_perhaps)
		return;
	if (gdk_dnd.dnd_grabbed)
		return;
	if (gdk_dnd.drag_really)
		return;
	gdk_dnd_drag_addwindow (window);
	gdk_dnd_drag_begin (window);
	XGrabPointer (gdk_display, wp->xwindow, False,
		      ButtonMotionMask | ButtonPressMask | ButtonReleaseMask,
		      GrabModeAsync, GrabModeAsync, gdk_root_window,
		      None, CurrentTime);
	gdk_dnd.dnd_grabbed = TRUE;
	gdk_dnd.drag_really = 1;
	gdk_dnd_display_drag_cursor (x, y, FALSE, TRUE);
#else
	gdk_dnd.real_sw = wp;
	gdk_dnd.dnd_drag_start.x = x;
	gdk_dnd.dnd_drag_start.y = y;
	gdk_dnd.drag_perhaps = 1;
          if(gdk_dnd.drag_startwindows)
            {
              g_free(gdk_dnd.drag_startwindows);
              gdk_dnd.drag_startwindows = NULL;
            }
          gdk_dnd.drag_numwindows = gdk_dnd.drag_really = 0;
          gdk_dnd.dnd_grabbed = FALSE;
	{
           /* Set motion mask for first DnD'd window, since it
               will be the one that is actually dragged */
            XWindowAttributes dnd_winattr;
            XSetWindowAttributes dnd_setwinattr;

            /* We need to get motion events while the button is down, so
               we can know whether to really start dragging or not... */
            XGetWindowAttributes(gdk_display, (Window)wp->xwindow,
                                 &dnd_winattr);
            
            wp->dnd_drag_savedeventmask = dnd_winattr.your_event_mask;
            dnd_setwinattr.event_mask = 
              wp->dnd_drag_eventmask = ButtonMotionMask | ButtonPressMask | ButtonReleaseMask |
                        EnterWindowMask | LeaveWindowMask;
            XChangeWindowAttributes(gdk_display, wp->xwindow,
                                    CWEventMask, &dnd_setwinattr);
        }
#endif
}
static void
thumb_drag_request (GtkWidget *widget, GdkEventDragRequest *event)
{
	GnomeIconList *icon_list = GNOME_ICON_LIST (thumbs_box);
	int  item;
	void *data;
       
	if (!icon_list->selection)
		return;
	
	item = (int) icon_list->selection->data;
	data = gnome_icon_list_get_icon_data (icon_list, item);
	gdk_window_dnd_data_set (GNOME_ICON_LIST (thumbs_box)->ilist_window,
				 (GdkEvent *) event, data, strlen (data) + 1);
}

static void
thumb_motion_notify (GnomeIconList *i, GdkEventMotion *event)
{
	artificial_drag_start (i->ilist_window, event->x, event->y);
}

void
drag_begin (GtkWidget *widget, GdkEvent *event)
{
	GdkPoint hotspot = { 15, 15 };

	if (drag && drag_ok){
		gdk_dnd_set_drag_shape (drag->window, &hotspot,
					drag_ok->window, &hotspot);
		gtk_widget_show (drag);
		gtk_widget_show (drag_ok);
	}
}

static void
connect_dnd (void)
{
	char *drag_types [] = { "url:ALL" };
	
	gdk_window_dnd_drag_set (GNOME_ICON_LIST (thumbs_box)->ilist_window,
				 TRUE, drag_types, 1);

	/* To simulate drags as soon as the user moves the mouse */
	gtk_signal_connect (GTK_OBJECT(thumbs_box), "motion_notify_event",
			    GTK_SIGNAL_FUNC(thumb_motion_notify), NULL);

	/* To transfer the file name */
	gtk_signal_connect (GTK_OBJECT(thumbs_box), "drag_request_event",
			    GTK_SIGNAL_FUNC(thumb_drag_request), NULL);

	/* To set the nice drag icons */
	gtk_signal_connect (GTK_OBJECT(thumbs_box), "drag_begin_event",
			    GTK_SIGNAL_FUNC(drag_begin), NULL);
}

static GtkWidget *
load_transparent_image (char *base)
{
	char *f = gnome_unconditional_pixmap_file (base);
	GtkWidget *window;
	GdkImlibImage *im;

	im = gdk_imlib_load_image (f);
	g_free (f);
	if (!im)
		return NULL;
	
	gtk_widget_push_visual (gdk_imlib_get_visual ());
	gtk_widget_push_colormap (gdk_imlib_get_colormap ());

	window = gtk_window_new (GTK_WINDOW_POPUP);
	gtk_widget_pop_colormap ();
	gtk_widget_pop_visual ();

	gtk_widget_realize (window);
	gtk_widget_set_usize (window, im->rgb_width, im->rgb_height);
	gdk_imlib_render (im, im->rgb_width, im->rgb_height);
	gdk_window_set_back_pixmap (window->window, gdk_imlib_move_image (im), FALSE);
	gdk_window_shape_combine_mask (window->window, gdk_imlib_move_mask (im), 0, 0);
	
	return window;
}

#define GTK_FLUSH \
    while (gtk_events_pending()) \
        gtk_main_iteration();

void showthumbs(GtkWidget *widget, gpointer *data)
{
   GtkWidget *scroll;
   GtkWidget *box;
   int i,num,w,h;
   struct _image *img;

   GtkWidget       *window, *hbox, *vbox, *scanProgress, *label;

   
   if (window_thumbs) 
     {
	if (!GTK_WIDGET_VISIBLE(window_thumbs))
	  gtk_widget_show(window_thumbs);
	else
	  gtk_widget_hide(window_thumbs);
	return;
     }
   window_thumbs=gtk_window_new(GTK_WINDOW_TOPLEVEL);
   gtk_window_set_wmclass(GTK_WINDOW(window_thumbs),"ee","Image Viewer");
   gtk_window_set_title(GTK_WINDOW(window_thumbs),_("Electric Eyes - View Thumbnails"));
   gtk_container_border_width(GTK_CONTAINER(window_thumbs),3);
   gtk_window_set_policy(GTK_WINDOW(window_thumbs),1,1,1);
   gtk_signal_connect(GTK_OBJECT(window_thumbs),"delete_event",
		      GTK_SIGNAL_FUNC(quit_thumbs_cb),NULL);
   thumbs_box=gnome_icon_list_new();
   gnome_icon_list_set_separators (GNOME_ICON_LIST (thumbs_box), " /.-_"); 
   gtk_widget_set_events (thumbs_box, gtk_widget_get_events (thumbs_box) | GDK_MOTION_NOTIFY);
   gtk_signal_connect(GTK_OBJECT(thumbs_box),"realize",
		      GTK_SIGNAL_FUNC(connect_dnd), NULL);
   gtk_signal_connect(GTK_OBJECT(thumbs_box),"select_icon",
		      GTK_SIGNAL_FUNC(showthumb_cb),NULL);
   gtk_container_add(GTK_CONTAINER(window_thumbs),thumbs_box);
   gtk_widget_show(thumbs_box);
   gtk_widget_realize(thumbs_box);
   gtk_widget_realize(window_thumbs);
   num=get_list_length();
   gnome_icon_list_freeze(GNOME_ICON_LIST(thumbs_box));

   /* msf - code for progress bar */
   /* setup progress bar */
   window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
   gtk_window_set_title(GTK_WINDOW(window), "Thumbnail Progress");
   gtk_widget_set_usize (window, 350, 50);
   
   vbox = gtk_vbox_new(FALSE, 5);
   gtk_container_border_width(GTK_CONTAINER(vbox), 5);
   gtk_container_add(GTK_CONTAINER(window), vbox);
   
   hbox = gtk_hbox_new(FALSE, 5);
   gtk_container_border_width(GTK_CONTAINER(hbox), 5);
   gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
   
   label = gtk_label_new("Building Thumbnails:");
   gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
   gtk_widget_show(label);
   
   scanProgress = gtk_progress_bar_new();
   gtk_box_pack_start(GTK_BOX(hbox), scanProgress, FALSE, FALSE,
		      GNOME_PAD_SMALL);
   gtk_widget_show(scanProgress);
   
   gtk_widget_show(hbox);
   gtk_widget_show(vbox);
   gtk_widget_show(window);
   
   
   gtk_grab_add(window);
   GTK_FLUSH;


   for(i=0;i<num;i++)
     {
	img=get_file_n_from_list(i);
	add_thumb(img->file);

		gtk_progress_bar_update(GTK_PROGRESS_BAR(scanProgress),
					(1.0 * i)/num);
		GTK_FLUSH;
     }
   gtk_widget_destroy(window);
   gnome_icon_list_thaw(GNOME_ICON_LIST(thumbs_box));
   w=512;h=384;
   gtk_widget_set_usize(window_thumbs,w,h);
   gtk_widget_show(window_thumbs);

   configure_drop_on_widget(thumbs_box,
			    GNOME_ICON_LIST(thumbs_box)->ilist_window);
}

void
init_dnd (void)
{
   /* Load the icons for drag and drop */
   drag    = gnome_stock_transparent_window (GNOME_STOCK_PIXMAP_NOT, NULL);
   drag_ok = gnome_stock_transparent_window (GNOME_STOCK_PIXMAP_NEW, NULL);
}
