/*****************             Electirc Eyes           ***********************/
/* This software is Copyright (C) 1998 but The Rasterman (Carsten Haitzler). */
/* This software falls under the GNU Public License. Please read the COPYING */
/* file for more information                                                 */
/*****************************************************************************/
#include "ee.h"
#include "stdimg.xpm"

static GnomeUIInfo menu5[]= 
{
   GNOMEUIINFO_ITEM(N_("Original size"),N_("Scale this image to it's original size"),handle_image_resize_original,NULL),
   GNOMEUIINFO_ITEM(N_("Fit to screen"),N_("Scale this image to the size of the screen keeping its current aspect"),handle_image_resize_fit,NULL),
   GNOMEUIINFO_ITEM(N_("Maximize size"),N_("Scale this image to be the full size of the screen"),handle_image_resize_maximize,NULL),
   GNOMEUIINFO_SEPARATOR,
   GNOMEUIINFO_ITEM(N_("Double size"),N_("Double the size of this image"),handle_image_resize_double,NULL),
   GNOMEUIINFO_ITEM(N_("Halve size"),N_("Halve the size of this image"),handle_image_resize_halve,NULL),
   GNOMEUIINFO_ITEM(N_("+10% size"),N_("Increase image size by 10%"),handle_image_resize_up,NULL),
   GNOMEUIINFO_ITEM(N_("-10% size"),N_("Decrease image size by 10%"),handle_image_resize_down,NULL),
   GNOMEUIINFO_SEPARATOR,
   GNOMEUIINFO_ITEM(N_("Set as desktop background"),N_("Put this image in the desktop background in a tiled fashion"),handle_image_set_desktop,NULL),
   GNOMEUIINFO_END
};

static GnomeUIInfo menu4[]= 
{
   GNOMEUIINFO_ITEM(N_("Show/Hide Edit Window"),N_("Display the Editor Window"),start_edit_cb, NULL),
   GNOMEUIINFO_ITEM(N_("Show/Hide Thumbnail Window"),N_("Display the Thumbnail Window"),showthumbs, NULL),
   GNOMEUIINFO_END
};

static GnomeUIInfo menu3[]= 
{
     { GNOME_APP_UI_ITEM,N_("Open"),N_("Open up a new image file and add it to the image list"),image_open,NULL,
	NULL,GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_OPEN,
	0,0,NULL
     },
     { GNOME_APP_UI_ITEM,N_("Save"),N_("Save this image"),image_save,NULL,
	NULL,GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVE,
	0,0,NULL
     },
     { GNOME_APP_UI_ITEM,N_("Save As"),N_("Save this image as a new file"),image_save_as,NULL,
	NULL,GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVE_AS,
	0,0,NULL
     },
   GNOMEUIINFO_SEPARATOR,
     { GNOME_APP_UI_ITEM,N_("Next Image"),N_("Display the next image in the image list"),handle_image_next,NULL,
	NULL,GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_FORWARD,
	0,0,NULL
     },
     { GNOME_APP_UI_ITEM,N_("Previous Image"),N_("Display the previous image in the image list"),handle_image_previous,NULL,
	NULL,GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BACK,
	0,0,NULL
     },
     { GNOME_APP_UI_ITEM,N_("Start Slideshow"),N_("Start an automated slideshow of all the images in the image list"),start_slideshow,NULL,
	NULL,GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_ABOUT,
	0,0,NULL
     },
     { GNOME_APP_UI_ITEM,N_("Stop Slideshow"),N_("Start an automated slideshow of all the images in the image list"),stop_slideshow,NULL,
	NULL,GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_ABOUT,
	0,0,NULL
     },
   GNOMEUIINFO_SEPARATOR,
   GNOMEUIINFO_ITEM(N_("Print"),N_("Print this Image"),print_image,NULL),
   GNOMEUIINFO_SEPARATOR,
     { GNOME_APP_UI_ITEM,N_("Quit"),N_("Exit this program"),quit_image_cb,NULL,
	NULL,GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_QUIT,
	0,0,NULL
     },
   GNOMEUIINFO_END
};

static GnomeUIInfo menu2[]= 
{
   GNOMEUIINFO_SUBTREE(N_("File"),menu3),
   GNOMEUIINFO_SUBTREE(N_("Edit"),menu4),
   GNOMEUIINFO_SUBTREE(N_("Image"),menu5),
   GNOMEUIINFO_SEPARATOR,
     { GNOME_APP_UI_ITEM,N_("Preferences"),N_("Change your user preferences for this program"),show_config,NULL,
	NULL,GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PREF,
	0,0,NULL
     },
   GNOMEUIINFO_HELP("ElectricEyes"),
     { GNOME_APP_UI_ITEM,N_("About"),N_("Info about this program"),about_image_cb,NULL,
	NULL,GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_ABOUT,
	0,0,NULL
     },
   GNOMEUIINFO_HELP("ElectricEyes"),
     { GNOME_APP_UI_ITEM,N_("Help"),N_("Help on this program"),about_image_help_cb,NULL,
	NULL,GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_ABOUT,
	0,0,NULL
     },
   GNOMEUIINFO_SEPARATOR,
     { GNOME_APP_UI_ITEM,N_("Quit"),N_("Exit this program"),quit_image_cb,NULL,
	NULL,GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_QUIT,
	0,0,NULL
     },
   GNOMEUIINFO_END
};

static GnomeUIInfo menu1[]= 
{
   GNOMEUIINFO_SUBTREE("Main",menu2),
   GNOMEUIINFO_END
};

void filenames_dropped (GtkWidget *widget, GdkEventDropDataAvailable *event)
{
   int count = event->data_numbytes;
   char *p = event->data;
   int len,num;
   
   num=get_list_length();
   do {
      len = 1 + strlen (p);
      count -= len;
      add_file_to_list(p);
      p += len;
   } while (count > 0);
   if (get_list_length()!=num)
     show_image_n(num+1);
}

void configure_drop_on_widget(GtkWidget *widget, GdkWindow *window)
{
   static char *drop_types[]=
     {
	"url:ALL" 
     };
   
   gdk_window_dnd_drop_set(window,TRUE,drop_types,1,FALSE);
   gtk_signal_connect(GTK_OBJECT(widget),"drop_data_available_event",
		       GTK_SIGNAL_FUNC (filenames_dropped), NULL);
}

void print_image(GtkWidget *widget, void *data)
{
   GtkWidget *win;
   GtkWidget *hbox;
   GtkWidget *button;
   GtkWidget *entry;
   char fl[1024];
   char cmd[1024];
   
   srand(time(NULL));
   sprintf(fl,"/tmp/eetmpprt%i_%i_%p.ps",rand(),getpid()*getuid(),current.image);
   gdk_imlib_save_image(current.image,fl,NULL);
   if (getenv("PRINT_COMMAD"))
     snprintf(cmd,1024,"%s %s",getenv("PRINT_COMMAD"),fl);
   else
     snprintf(cmd,1024,"%s %s","lpr",fl);
   system(cmd);
   rm(fl);
}

void quit_image_cb(GtkWidget *widget, void *data)
{
  gtk_main_quit();
}

void about_image_ok_cb(GtkWidget *widget, void *data)
{
  gtk_widget_hide(aboutwin);
}

void about_image_help_cb(GtkWidget *widget, void *data)
{
   gchar *file,*file2;
   
   file=gnome_help_file_path("ee","index.html");
   if (file)
     {
	file2=alloca(strlen(file)+10);
	strcpy(file2,"file:");
	strcat(file2,file);
	gnome_help_goto(NULL,file2);
	g_free(file);
     }
}

void about_image_cb(GtkWidget *widget, void *data)
{
   GtkWidget *text;
   GtkWidget *vbox;
   GtkWidget *button;
   GtkWidget *pixmap;
   GdkPixmap *pmap,*mask;
   char about[]=
     "Electric Eyes v0.1\n"
     "(C) 1998 The Rasterman (Carsten Haitzler) and\n"
     "Red Hat Software.\n"
     "\n"
     "This software is distributed as-is under the\n"
     "GNU Public License. The Author(s) accept no\n"
     "responsability for anything this software\n"
     "may or may not do. You use this completely\n"
     "at your own risk.\n"
     "\n"
     "Please see the the help documentation for\n"
     "more information on licensing and how to\n"
     "use this program.\n";
   
   if (aboutwin) 
     {
	gtk_widget_show(aboutwin);
	return;
     }
   aboutwin=gtk_window_new(GTK_WINDOW_TOPLEVEL);
   gtk_window_set_wmclass(GTK_WINDOW(aboutwin),"ee","Image Viewer");
   gtk_window_set_title(GTK_WINDOW(aboutwin),_("Electric Eyes - About"));
   gtk_container_border_width(GTK_CONTAINER(aboutwin),3);
   gtk_window_set_policy(GTK_WINDOW(aboutwin),0,0,1);
   gtk_signal_connect(GTK_OBJECT(aboutwin),"delete_event",
		      GTK_SIGNAL_FUNC(about_image_ok_cb),NULL);
   gtk_window_position(GTK_WINDOW(aboutwin),GTK_WIN_POS_MOUSE);
   vbox=gtk_vbox_new(FALSE,0);
   gtk_widget_show(vbox);
   gtk_container_add(GTK_CONTAINER(aboutwin),vbox);

   button=gtk_button_new_with_label(_("Help"));
   gtk_widget_show(button);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",
		      GTK_SIGNAL_FUNC(about_image_help_cb),NULL);
   gtk_box_pack_start(GTK_BOX(vbox),button,FALSE,FALSE,0);

   gdk_imlib_data_to_pixmap(stdimg_xpm,&pmap,&mask);
   pixmap=gtk_pixmap_new(pmap,mask);
   gtk_widget_show(pixmap);
   gtk_box_pack_start(GTK_BOX(vbox),pixmap,FALSE,FALSE,0);

   text=gtk_text_new(NULL,NULL);
   gtk_text_set_editable(GTK_TEXT(text),0);
   gtk_widget_show(text);
   gtk_box_pack_start(GTK_BOX(vbox),text,TRUE,TRUE,0);
   gtk_widget_set_usize(text,300,240);

   button=gtk_button_new_with_label(_("OK"));
   gtk_widget_show(button);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",
		      GTK_SIGNAL_FUNC(about_image_ok_cb),NULL);
   gtk_box_pack_start(GTK_BOX(vbox),button,FALSE,FALSE,0);

   gtk_widget_show(aboutwin);
   gtk_widget_realize(text);
   gtk_text_insert(GTK_TEXT(text),NULL,NULL,NULL,about,strlen(about));
   gdk_imlib_free_pixmap(pmap);
}

void draw_image()
{
   if (!current.image) return;
   gdk_imlib_free_pixmap(current.pixmap);
   gdk_imlib_render(current.image,current.width,current.height);
   current.pixmap=gdk_imlib_move_image(current.image);
   if (current.pixmap)
     {
	gdk_window_set_back_pixmap(window_image->window,current.pixmap,FALSE);
	gdk_window_clear(window_image->window);
	gdk_flush();
     }
}

void handle_image_resize_cb(GtkWidget *widget, GdkEventConfigure *event)
{
   int w,h;
   
   w=event->width;
   h=event->height;
   if ((w==current.width)&&(h==current.height)) return;
   current.width=w;
   current.height=h;
   if (w>h)
     {
	current.mini_width=128;
	current.mini_height=(h*128)/w;
     }
   else
     {
	current.mini_height=128;
	current.mini_width=(w*128)/h;
     }
   gtk_widget_set_usize(current.mini_area,
			current.mini_width,current.mini_height);
   /* We queue a resize on the view frame because only one level of
    * the heirarchy will be reallocated by default unless more space
    * is needed, and we want to force the view frame's parent
    * alignment to get reallocated */
   gtk_widget_queue_resize (current.mini_view);
   draw_mini_image();
   draw_image();
   mod_width=1;mod_height=1;
   gtk_spin_button_set_value(GTK_SPIN_BUTTON(width_wid),(gfloat)w);
   gtk_spin_button_set_value(GTK_SPIN_BUTTON(height_wid),(gfloat)h);
   gtk_widget_queue_draw(GTK_WIDGET(width_wid));
   gtk_widget_queue_draw(GTK_WIDGET(height_wid));
   incrop=0;crop_x=0;crop_y=0;crop_w=-1;crop_h=-1;
}

void handle_image_resize_double(GtkWidget *widget, GdkEventConfigure *event)
{
   gtk_widget_set_usize(window_image,current.width*2,current.height*2);
}

void handle_image_resize_halve(GtkWidget *widget, GdkEventConfigure *event)
{
   gtk_widget_set_usize(window_image,current.width/2,current.height/2);
}

void handle_image_resize_up(GtkWidget *widget, GdkEventConfigure *event)
{
   gtk_widget_set_usize(window_image,(current.width*11)/10,(current.height*11)/10);
}

void handle_image_resize_down(GtkWidget *widget, GdkEventConfigure *event)
{
   gtk_widget_set_usize(window_image,(current.width*9)/10,(current.height*9)/10);
}

void handle_image_resize_original(GtkWidget *widget, GdkEventConfigure *event)
{
   if (!current.image) return;
   gtk_widget_set_usize(window_image,current.image->rgb_width,current.image->rgb_height);
}

void handle_image_resize_fit(GtkWidget *widget, GdkEventConfigure *event)
{
   int sw,sh,w,h,nw,nh;
   
   if (!current.image) return;
   sw=gdk_screen_width();
   sh=gdk_screen_height();
   w=current.image->rgb_width;
   h=current.image->rgb_height;
   if (((w<<16)/h)>((sw<<16)/sh))
     {
	nw=sw;
	nh=(h*sw)/w;
     }
   else
     {
	nw=(w*sh)/h;
	nh=sh;
     }
   gtk_widget_set_usize(window_image,nw,nh);
   gtk_window_position(GTK_WINDOW(window_image),GTK_WIN_POS_CENTER);
}

void handle_image_resize_maximize(GtkWidget *widget, GdkEventConfigure *event)
{
   gtk_widget_set_usize(window_image,gdk_screen_width(),gdk_screen_height());
   gtk_window_position(GTK_WINDOW(window_image),GTK_WIN_POS_CENTER);
}

void handle_image_next(GtkWidget *widget, GdkEventConfigure *event)
{
   int n;
   
   if (get_list_length()>0)
     show_image_n(current.number+1);
}

void handle_image_previous(GtkWidget *widget, GdkEventConfigure *event)
{
   if (get_list_length()>0)
     show_image_n(current.number-1);
}

void set_desktop_image ()
{
   GdkVisual *gvis;
   GdkWindow *rwin;

   if (!current.pixmap) return;
   rwin=(GdkWindow *)&gdk_root_parent;
   gvis=gdk_window_get_visual(rwin);
   if (gvis!=gdk_imlib_get_visual())
     {
	fprintf(stderr,"**WARNING** Your root window's visual is not the visual Imlib chose\nElectric Eyes cannot set the background currently\n");
	return;
     }
   gdk_window_set_back_pixmap(rwin,current.pixmap,FALSE);
   gdk_window_clear(rwin);
   gdk_flush();
}

void handle_image_set_desktop(GtkWidget *widget, GdkEventConfigure *event)
{
   set_desktop_image ();
}

void no_file(GtkWidget *widget, gpointer *data)
{
   gtk_widget_hide(fsel);
}

void ok_file(GtkWidget *widget, gpointer *data)
{
   gchar *file;
   int num;
   
   gtk_widget_hide(fsel);
   if (list) gtk_clist_freeze(GTK_CLIST(list));
   if (window_thumbs) gnome_icon_list_freeze(GNOME_ICON_LIST(thumbs_box));
   file=gtk_file_selection_get_filename(GTK_FILE_SELECTION(fsel));
   if (loadsave)
     {
	num=get_list_length();
	add_file_to_list(file);
	if (get_list_length()!=num)
	  show_image_n(num+1);
     }
   else
     gdk_imlib_save_image(current.image,file,NULL);
   if (list) gtk_clist_thaw(GTK_CLIST(list));
   if (window_thumbs) gnome_icon_list_thaw(GNOME_ICON_LIST(thumbs_box));
}

void make_fsel()
{
   if (fsel) 
     {
	gtk_window_position(GTK_WINDOW(fsel),GTK_WIN_POS_MOUSE);
	gtk_widget_show(fsel);
	return;
     }
   fsel=gtk_file_selection_new(_("Electric Eyes: Select File"));
   gtk_signal_connect (GTK_OBJECT(fsel),"destroy",GTK_SIGNAL_FUNC(no_file),
		       NULL);
   gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION(fsel)->cancel_button),
			     "clicked",GTK_SIGNAL_FUNC(no_file),NULL);
   gtk_signal_connect (GTK_OBJECT(GTK_FILE_SELECTION(fsel)->ok_button),
		       "clicked",GTK_SIGNAL_FUNC(ok_file),NULL);
   gtk_window_position(GTK_WINDOW(fsel),GTK_WIN_POS_MOUSE);
   gtk_widget_show(fsel);
}

void image_open(GtkWidget *widget, GdkEventConfigure *event)
{
   loadsave=1;
   make_fsel();
}

void image_save(GtkWidget *widget, GdkEventConfigure *event)
{
   loadsave=0;
   if (!current.info)
     {
	image_save_as(NULL,NULL);
     }
   else
     {
	gdk_imlib_save_image(current.image,current.info->file,NULL);
     }
}

void image_save_as(GtkWidget *widget, GdkEventConfigure *event)
{
   loadsave=0;
   make_fsel();
}

void start_slideshow(GtkWidget *widget, GdkEventConfigure *event)
{
   slide_timer=gtk_timeout_add(silde_speed,(GtkFunction)handle_image_next,NULL);
}

void stop_slideshow(GtkWidget *widget, GdkEventConfigure *event)
{
   if (slide_timer) gtk_timeout_remove(slide_timer);
   slide_timer=0;
}

void image_fliph(GtkWidget *widget, GdkEventConfigure *event)
{
   gdk_imlib_flip_image_horizontal(current.image);
   draw_image();
   draw_mini_image();
}

void image_flipv(GtkWidget *widget, GdkEventConfigure *event)
{
   gdk_imlib_flip_image_vertical(current.image);
   draw_image();
   draw_mini_image();
}

void image_rotate(GtkWidget *widget, GdkEventConfigure *event)
{
   int nw,nh;
   
   nw=current.height;
   nh=current.width;
   gdk_imlib_rotate_image(current.image,1);
   gtk_widget_set_usize(window_image,nw,nh);
   if ((nw==current.width)&&(nh=current.height))
     {
	draw_image();
	draw_mini_image();
     }
}

void clear_crop()
{
   GdkWindow *win;
   
   win=window_image->window;
   if ((crop_w<0)||(crop_h<0)) 
     {
	gdk_window_clear(win);
	return;
     }
   if ((crop_w>=10)&&(crop_h>=10))
     gdk_window_clear_area(win,crop_x-1+(crop_w>>1)-4,crop_y-1+(crop_h>>1)-4,8,8);
   gdk_window_clear_area(win,crop_x-8,crop_y-8,8,crop_h+16);
   gdk_window_clear_area(win,crop_x-8,crop_y-8,crop_w+16,8);
   gdk_window_clear_area(win,crop_x+crop_w,crop_y-8,8,crop_h+16);
   gdk_window_clear_area(win,crop_x-8,crop_y+crop_h,crop_w+16,8);
}

void draw_crop()
{
   GdkWindow *win;
   GdkGC *gc;
   GdkColor c1,c2;
   int r,g,b;
   
   win=window_image->window;
   if ((crop_w<0)||(crop_h<0)) 
     {
	gdk_window_clear(win);
	return;
     }
   gc=gdk_gc_new(win);
   r=255,g=180,b=40;
   c1.pixel=gdk_imlib_best_color_match(&r,&g,&b);
   r=0,g=0,b=0;
   c2.pixel=gdk_imlib_best_color_match(&r,&g,&b);
   gdk_gc_set_foreground(gc,&c1);
   if ((crop_w>=10)&&(crop_h>=10))
     {
	gdk_gc_set_foreground(gc,&c2);
	gdk_draw_rectangle(win,gc,FALSE,crop_x-1+(crop_w>>1)-4,crop_y-1+(crop_h>>1)-4,7,7);
	gdk_gc_set_foreground(gc,&c1);
	gdk_draw_rectangle(win,gc,TRUE,crop_x-1+(crop_w>>1)-3,crop_y-1+(crop_h>>1)-3,6,6);
     }
   gdk_gc_set_foreground(gc,&c2);
   gdk_draw_rectangle(win,gc,FALSE,crop_x-7-1,crop_y-7-1,7,7);
   gdk_gc_set_foreground(gc,&c1);
   gdk_draw_rectangle(win,gc,TRUE,crop_x-6-1,crop_y-6-1,6,6);

   gdk_gc_set_foreground(gc,&c2);
   gdk_draw_rectangle(win,gc,FALSE,crop_x+crop_w-1+0+1,crop_y-7-1,7,7);
   gdk_gc_set_foreground(gc,&c1);
   gdk_draw_rectangle(win,gc,TRUE,crop_x+crop_w-1+1+1,crop_y-6-1,6,6);

   gdk_gc_set_foreground(gc,&c2);
   gdk_draw_rectangle(win,gc,FALSE,crop_x+crop_w-1+0+1,crop_y+crop_h+1-1+0,7,7);
   gdk_gc_set_foreground(gc,&c1);
   gdk_draw_rectangle(win,gc,TRUE,crop_x+crop_w-1+1+1,crop_y+crop_h+1-1+1,6,6);

   gdk_gc_set_foreground(gc,&c2);
   gdk_draw_rectangle(win,gc,FALSE,crop_x-7-1,crop_y+crop_h+1-1+0,7,7);
   gdk_gc_set_foreground(gc,&c1);
   gdk_draw_rectangle(win,gc,TRUE,crop_x-6-1,crop_y+crop_h+1+1-1+1-1,6,6);
   
   gdk_gc_set_foreground(gc,&c2);
   gdk_draw_rectangle(win,gc,FALSE,crop_x-2-1,crop_y-2-1,crop_w+2-1+4,crop_h+2-1+4);
   gdk_draw_rectangle(win,gc,FALSE,crop_x-1,crop_y-1,crop_w+2-1,crop_h+2-1);
   gdk_gc_set_foreground(gc,&c1);
   gdk_draw_rectangle(win,gc,FALSE,crop_x-1-1,crop_y-1-1,crop_w+2-1+2,crop_h+2-1+2);
   gdk_flush();
   gdk_gc_destroy(gc);
}

void handle_image_button_cb(GtkWidget *widget, GdkEventButton *event)
{
   int button;
   int x,y;
   
   button=event->button;
   x=event->x;y=event->y; 
   if (GTK_WIDGET_VISIBLE(menu_main)) 
     {
	gtk_menu_popdown(GTK_MENU(menu_main));
	return;
     }
   switch(button)
     {
      case 2:
	clear_crop();
	if ((crop_w>0)&&(crop_h>0))
	  {
	     if ((x>=crop_x)&&(x<crop_x+crop_w)&&
		 (y>=crop_y)&&(y<crop_y+crop_h))
	       {
		  incrop=5;
		  cstart=1;
	       }
	     else if ((x>=crop_x-8)&&(x<crop_x)&&
		 (y>=crop_y-8)&&(y<crop_y))
	       {
		  incrop=1;
		  cstart=1;
	       }
	     else if ((x>=crop_x+crop_w)&&(x<crop_x+crop_w+8)&&
		 (y>=crop_y-8)&&(y<crop_y))
	       {
		  incrop=2;
		  cstart=1;
	       }
	     else if ((x>=crop_x+crop_w)&&(x<crop_x+crop_w+8)&&
		 (y>=crop_y+crop_h)&&(y<crop_y+crop_h+8))
	       {
		  incrop=3;
		  cstart=1;
	       }
	     else if ((x>=crop_x-8)&&(x<crop_x)&&
		 (y>=crop_y+crop_h)&&(y<crop_y+crop_h+8))
	       {
		  incrop=4;
		  cstart=1;
	       }
	     else
	       {
		  incrop=0;
		  crop_x=x;
		  crop_y=y;
		  crop_w=-1;
		  crop_h=-1;
		  cstart=1;
	       }
	  }
	else
	  {
	     incrop=3;
	     crop_x=x;
	     crop_y=y;
	     crop_w=1;
	     crop_h=1;
	     cstart=1;
	  }
	update_crop_spins();
	draw_crop();
	break;
      case 3:
	gtk_menu_popup(GTK_MENU(menu_main),NULL,NULL,NULL,NULL,3,event->time);
	break;
      default:
	break;
     }
}

void handle_image_button_up_cb(GtkWidget *widget, GdkEventButton *event)
{
   int button;
   int x,y;
   
   button=event->button;
   x=event->x;y=event->y; 
   switch(button)
     {
      case 2:
	incrop=0;
	break;
      default:
	break;
     }
}

void handle_image_motion_cb(GtkWidget *widget, GdkEventMotion *event)
{
   int x,y,dx,dy;
   static int px=-999999,py=-999999;
   
   x=event->x;y=event->y; 
   if (cstart)
     {
	px=x;
	py=y;
	cstart=0;
     }
   dx=x-px;dy=y-py;
   px=x;py=y;
   clear_crop();
   switch(incrop)
     {
      case 1:
	crop_x+=dx;
	crop_y+=dy;
	crop_w-=dx;
	crop_h-=dy;
	break;
      case 2:
	crop_y+=dy;
	crop_w+=dx;
	crop_h-=dy;
	break;
      case 3:
	crop_w+=dx;
	crop_h+=dy;
	break;
      case 4:
	crop_x+=dx;
	crop_w-=dx;
	crop_h+=dy;
	break;
      case 5:
	crop_x+=dx;
	crop_y+=dy;
	break;
      default:
	break;
     }
   if (incrop>0)
     {
	if (crop_x<0) crop_x=0;
	if (crop_y<0) crop_y=0;
	if (crop_w<1) crop_w=1;
	if (crop_h<1) crop_h=1;
	if (crop_w>current.width) crop_w=current.width;
	if (crop_h>current.height) crop_h=current.height;
	if (crop_x+crop_w>current.width) crop_x=current.width-crop_w;
	if (crop_y+crop_h>current.height) crop_y=current.height-crop_h;
	draw_crop();
	update_crop_spins();
     }
}

static void
window_motion_notify (void *unused, GdkEventMotion *event, GdkWindow *win)
{
	artificial_drag_start (win, event->x, event->y);
}

static void
window_drag_request (GtkWidget *widget, GdkEventDragRequest *event, GdkWindow *win)
{
	if (!current.info)
		return;
	gdk_window_dnd_data_set (win, (GdkEvent *) event, current.info->file,
				 strlen (current.info->file) + 1);

}

void
configure_drag_on_widget (GtkWidget *widget, GdkWindow *win)
{
	char *drag_types [] = { "url:ALL" };
	
	gdk_window_dnd_drag_set (win, TRUE, drag_types, 1);

	/* To simulate drags as soon as the user moves the mouse */
	gtk_signal_connect (GTK_OBJECT(widget), "motion_notify_event",
			    GTK_SIGNAL_FUNC(window_motion_notify), win);

	/* To transfer the file name */
	gtk_signal_connect (GTK_OBJECT(widget), "drag_request_event",
			    GTK_SIGNAL_FUNC(window_drag_request), win);
	
	/* To set the nice drag icons */
	gtk_signal_connect (GTK_OBJECT(widget), "drag_begin_event",
			    GTK_SIGNAL_FUNC(drag_begin), NULL);
}

void init_image()
{
   GList *gl;
   GtkMenuItem *menuitem;
   
   window_image=gnome_app_new("ee","ElectricEyes");
   gtk_container_border_width(GTK_CONTAINER(window_image),0);
   gtk_window_set_policy(GTK_WINDOW(window_image),1,1,1);
   gtk_signal_connect(GTK_OBJECT(window_image),"delete_event",
		      GTK_SIGNAL_FUNC(quit_image_cb),NULL);
   gtk_signal_connect(GTK_OBJECT(window_image),"configure_event",
		      GTK_SIGNAL_FUNC(handle_image_resize_cb),NULL);
   gtk_signal_connect(GTK_OBJECT(window_image),"button_press_event",
		      GTK_SIGNAL_FUNC(handle_image_button_cb),NULL);
   gtk_signal_connect(GTK_OBJECT(window_image),"button_release_event",
		      GTK_SIGNAL_FUNC(handle_image_button_up_cb),NULL);
   gtk_signal_connect(GTK_OBJECT(window_image),"motion_notify_event",
		      GTK_SIGNAL_FUNC(handle_image_motion_cb),NULL);
   gtk_widget_set_events(window_image,GDK_BUTTON_PRESS_MASK|
			 GDK_BUTTON_RELEASE_MASK|GDK_BUTTON_MOTION_MASK);
   gtk_widget_realize(window_image);
   app=gnome_app_new("ee","ElectricEyes");
   gnome_app_create_menus(GNOME_APP(app),menu1);
   menuitem=GTK_MENU_ITEM(menu1[0].widget);
   menu_main=GTK_WIDGET(menuitem->submenu);
   configure_drop_on_widget(window_image,window_image->window);
   configure_drag_on_widget(window_image,window_image->window);
}

void show_image()
{
   gtk_widget_show(window_image);
}

void hide_image()
{
   gtk_widget_hide(window_image);
}

void show_image_n(int n)
{
   struct _image *current_image;
   int num;
   GdkImlibColor cl;
   
   if (in_init) return;
   num=get_list_length();
   if (n<0) 
     {
	n=0;
	if (slide_timer) n=num-1;
     }
   if (n>=num) 
     {
	n=num-1;
	if (slide_timer) n=0;
     }
   current_image=get_file_n_from_list(n);
   if (current.image) gdk_imlib_destroy_image(current.image);
   if (!current_image)
     {
	current.image=gdk_imlib_create_image_from_xpm_data(stdimg_xpm);
	gtk_window_set_title(GTK_WINDOW(window_image),_("Electric Eyes - No file Selected"));
	current.info=NULL;
     }
   else
     {
	current.number=n;
	current.info=current_image;
	current.image=gdk_imlib_load_image(current.info->file);
	cl.r=-1;cl.g=-1;cl.b=-1;
	gdk_imlib_set_image_shape(current.image,&cl);
	if (gtk_clist_row_is_visible(GTK_CLIST(list),current.number)!=GTK_VISIBILITY_FULL)
	  gtk_clist_moveto(GTK_CLIST(list),current.number,0,0.5,0.5);
	gtk_clist_select_row(GTK_CLIST(list),current.number,0);
	if (!current.image) 
	  {
	     current.image=gdk_imlib_create_image_from_xpm_data(stdimg_xpm);
	     gtk_window_set_title(GTK_WINDOW(window_image),_("Electric Eyes - No file Selected"));
	  }
	else
	  gtk_window_set_title(GTK_WINDOW(window_image),current.info->file);
	sel_thumb(current.info->file);
     }
   if (mods_changed) reset_all_mods();
   
   if ((keepsize)&&((current.image->rgb_width>gdk_screen_width())||
       (current.image->rgb_height>gdk_screen_height())))
     handle_image_resize_fit(NULL,NULL);
   else if ((current.width==current.image->rgb_width)&&
	    (current.height==current.image->rgb_height))
     {
	draw_image();
	draw_mini_image();
     }
   else
     {
	current.width=0;
	current.height=0;
	gtk_widget_set_usize(window_image,current.image->rgb_width,
			     current.image->rgb_height);
     }
}
