/*****************             Electirc Eyes           ***********************/
/* This software is Copyright (C) 1998 but The Rasterman (Carsten Haitzler). */
/* This software falls under the GNU Public License. Please read the COPYING */
/* file for more information                                                 */
/*****************************************************************************/
#include "ee.h"
#include "icons.c"
#include "mag_glass32.xpm"
#include "geoms.xpm"
#include "geom_fliph.xpm"
#include "geom_flipv.xpm"
#include "geom_rot.xpm"
#include "size_down.xpm"
#include "size_up.xpm"
#include "size_double.xpm"
#include "size_halve.xpm"
#include "size_orig.xpm"
#include "size_max.xpm"
#include "size_fit.xpm"

void EE_gtk_hider_showhide_cb(GtkWidget *widget, void *data)
{
   EEGtkHider *hider;
   
   hider=(EEGtkHider *)data;
   
   if (GTK_WIDGET_VISIBLE(hider->hidepixmap))
     {
	gtk_widget_hide(hider->hidepixmap);
	gtk_widget_show(hider->showpixmap);
     }
   else
     {
	gtk_widget_show(hider->hidepixmap);
	gtk_widget_hide(hider->showpixmap);
     }
   if (hider->content)
     {
	if (GTK_WIDGET_VISIBLE(hider->content)) gtk_widget_hide(hider->content);
	else gtk_widget_show(hider->content);
     }
   if (hider->label)
     {
	if (GTK_WIDGET_VISIBLE(hider->label)) gtk_widget_hide(hider->label);
	else gtk_widget_show(hider->label);
     }
}

void EE_gtk_hider_add_content(EEGtkHider *hider, GtkWidget *content)
{
   hider->content=content;
   gtk_widget_show(hider->content);
   gtk_box_pack_start(GTK_BOX(hider->box),hider->content,TRUE,TRUE,0);
}

EEGtkHider *EE_gtk_hider_new(GtkWidget *label)
{
   EEGtkHider *hider;
   GtkWidget *pixmap;
   GtkWidget *box;
   
   hider=malloc(sizeof(EEGtkHider));
   if (!hider) return NULL;
   hider->frame= gtk_frame_new(NULL);
   gtk_widget_show(hider->frame);
   gtk_container_border_width(GTK_CONTAINER(hider->frame),1);
   hider->label=label;
   hider->content=NULL;
   hider->box=gtk_vbox_new(FALSE,4);
   gtk_widget_show(hider->box);
   gtk_container_add(GTK_CONTAINER(hider->frame),hider->box);

   hider->headerbox=gtk_hbox_new(FALSE,1);
   gtk_widget_show(hider->headerbox);
   gtk_box_pack_start(GTK_BOX(hider->box),hider->headerbox,FALSE,FALSE,0);

   box=gtk_hbox_new(FALSE,0);
   gtk_widget_show(box);
   hider->hidebutton=gtk_button_new();
   hider->showpixmap=pixmap=
     gnome_stock_pixmap_widget(window_edit,GNOME_STOCK_MENU_FORWARD);
   gtk_box_pack_start(GTK_BOX(box),pixmap,FALSE,FALSE,0);
   hider->hidepixmap=pixmap=
     gnome_stock_pixmap_widget(window_edit,GNOME_STOCK_MENU_BACK);
   gtk_widget_show(pixmap);
   gtk_box_pack_start(GTK_BOX(box),pixmap,FALSE,FALSE,0);

   gtk_container_add(GTK_CONTAINER(hider->hidebutton),box);
   gtk_widget_show(hider->hidebutton);
   gtk_signal_connect(GTK_OBJECT(hider->hidebutton),"clicked",
		      GTK_SIGNAL_FUNC(EE_gtk_hider_showhide_cb),hider);
   gtk_box_pack_start (GTK_BOX(hider->headerbox),hider->hidebutton,FALSE,FALSE,0);
   
   if (hider->label)
     {
	gtk_widget_show(hider->label);
	gtk_box_pack_start(GTK_BOX(hider->headerbox),hider->label,TRUE,TRUE,0);
     }
   return hider;
}

void make_icons()
{
   GdkImlibImage *im;
   GdkImlibColor icl;
   
   icl.r=255;icl.g=0;icl.b=255;
   im=gdk_imlib_create_image_from_data(brightness_icon,NULL,12,12);
   gdk_imlib_set_image_shape(im,&icl);
   gdk_imlib_render(im,im->rgb_width,im->rgb_height);
   brightness_pmap=gdk_imlib_move_image(im);
   brightness_mask=gdk_imlib_move_mask(im);
   gdk_imlib_kill_image(im);
   im=gdk_imlib_create_image_from_data(contrast_icon,NULL,12,12);
   gdk_imlib_set_image_shape(im,&icl);
   gdk_imlib_render(im,im->rgb_width,im->rgb_height);
   contrast_pmap=gdk_imlib_move_image(im);
   contrast_mask=gdk_imlib_move_mask(im);
   gdk_imlib_kill_image(im);
   im=gdk_imlib_create_image_from_data(gamma_icon,NULL,12,12);
   gdk_imlib_set_image_shape(im,&icl);
   gdk_imlib_render(im,im->rgb_width,im->rgb_height);
   gamma_pmap=gdk_imlib_move_image(im);
   gamma_mask=gdk_imlib_move_mask(im);
   gdk_imlib_kill_image(im);
}

void quit_edit_cb(GtkWidget *widget, void *data)
{
   hide_edit();
}

void start_edit_cb(GtkWidget *widget, void *data)
{
   show_edit();
}

void draw_mini_image()
{
   if (!current.image) return;
   gdk_imlib_free_pixmap(current.mini_pixmap);
   gdk_imlib_render(current.image,current.mini_width,current.mini_height);
   current.mini_pixmap=gdk_imlib_move_image(current.image);
   if (current.mini_pixmap)
     {
	gdk_window_set_back_pixmap(current.mini_area->window,current.mini_pixmap,FALSE);
	gdk_window_clear(current.mini_area->window);
	gdk_flush();
     }
}

void redraw_red_mod()
{
   unsigned char modz[256];
   unsigned char *ptr;
   int i,j,val,x,y;
   
   gdk_imlib_get_image_red_curve(current.image,modz);
   ptr=red_curve->rgb_data; 
   for(y=0;y<64;y++)
     {
	for(x=0;x<64;x++)
	  {
	     *ptr++=0;*ptr++=0;*ptr++=0;
	  }
     }
   for(i=0;i<64;i++)
     {
	val=modz[i<<2]>>2;
	ptr=red_curve->rgb_data+(64*3*63)+(i*3);
	for(y=0;y<val;y++)
	  {
	     ptr[0]=(i<<1)+128;
	     ptr[1]=(y*255*i)/(val*63);
	     ptr[2]=(y*255*i)/(val*63);
	     ptr-=(64*3);
	  }
     }
   ptr=red_curve->rgb_data; 
   for(y=0;y<64;y++)
     {
	for(x=0;x<64;x++)
	  {
	     if ((!(x%8))||(!(y%8)))
	       {
		  val=*ptr+255-(y<<2);
		  if (val>255) val=255;
		  *ptr++=val;
		  val=*ptr+255-(y<<2);
		  if (val>255) val=255;
		  *ptr++=val;
		  val=*ptr+255-(y<<2);
		  if (val>255) val=255;
		  *ptr++=val;
	       }
	     else
	       ptr+=3;
	  }
     }

   gdk_imlib_changed_image(red_curve);
   gdk_imlib_render(red_curve,64,64);
   gdk_imlib_free_pixmap(red_curve_pmap);
   red_curve_pmap=gdk_imlib_move_image(red_curve);
   if (red_curve_pmap)
     {
	gdk_window_set_back_pixmap(red_view->window,red_curve_pmap,FALSE);
	gdk_window_clear(red_view->window);
	gdk_flush();
     }
}

void redraw_green_mod()
{
   unsigned char modz[256];
   unsigned char *ptr;
   int i,j,val,x,y;
   
   gdk_imlib_get_image_green_curve(current.image,modz);
   ptr=green_curve->rgb_data; 
   for(y=0;y<64;y++)
     {
	for(x=0;x<64;x++)
	  {
	     *ptr++=0;*ptr++=0;*ptr++=0;
	  }
     }
   for(i=0;i<64;i++)
     {
	val=modz[i<<2]>>2;
	ptr=green_curve->rgb_data+(64*3*63)+(i*3);
	for(y=0;y<val;y++)
	  {
	     ptr[0]=(y*255*i)/(val*63);
	     ptr[1]=(i<<1)+128;
	     ptr[2]=(y*255*i)/(val*63);
	     ptr-=(64*3);
	  }
     }
   ptr=green_curve->rgb_data; 
   for(y=0;y<64;y++)
     {
	for(x=0;x<64;x++)
	  {
	     if ((!(x%8))||(!(y%8)))
	       {
		  val=*ptr+255-(y<<2);
		  if (val>255) val=255;
		  *ptr++=val;
		  val=*ptr+255-(y<<2);
		  if (val>255) val=255;
		  *ptr++=val;
		  val=*ptr+255-(y<<2);
		  if (val>255) val=255;
		  *ptr++=val;
	       }
	     else
	       ptr+=3;
	  }
     }

   gdk_imlib_changed_image(green_curve);
   gdk_imlib_render(green_curve,64,64);
   gdk_imlib_free_pixmap(green_curve_pmap);
   green_curve_pmap=gdk_imlib_move_image(green_curve);
   if (green_curve_pmap)
     {
	gdk_window_set_back_pixmap(green_view->window,green_curve_pmap,FALSE);
	gdk_window_clear(green_view->window);
	gdk_flush();
     }
}

void redraw_blue_mod()
{
   unsigned char modz[256];
   unsigned char *ptr;
   int i,j,val,x,y;
   
   gdk_imlib_get_image_blue_curve(current.image,modz);
   ptr=blue_curve->rgb_data; 
   for(y=0;y<64;y++)
     {
	for(x=0;x<64;x++)
	  {
	     *ptr++=0;*ptr++=0;*ptr++=0;
	  }
     }
   for(i=0;i<64;i++)
     {
	val=modz[i<<2]>>2;
	ptr=blue_curve->rgb_data+(64*3*63)+(i*3);
	for(y=0;y<val;y++)
	  {
	     ptr[0]=(y*255*i)/(val*63);
	     ptr[1]=(y*255*i)/(val*63);
	     ptr[2]=(i<<1)+128;
	     ptr-=(64*3);
	  }
     }
   ptr=blue_curve->rgb_data; 
   for(y=0;y<64;y++)
     {
	for(x=0;x<64;x++)
	  {
	     if ((!(x%8))||(!(y%8)))
	       {
		  val=*ptr+255-(y<<2);
		  if (val>255) val=255;
		  *ptr++=val;
		  val=*ptr+255-(y<<2);
		  if (val>255) val=255;
		  *ptr++=val;
		  val=*ptr+255-(y<<2);
		  if (val>255) val=255;
		  *ptr++=val;
	       }
	     else
	       ptr+=3;
	  }
     }

   gdk_imlib_changed_image(blue_curve);
   gdk_imlib_render(blue_curve,64,64);
   gdk_imlib_free_pixmap(blue_curve_pmap);
   blue_curve_pmap=gdk_imlib_move_image(blue_curve);
   if (blue_curve_pmap)
     {
	gdk_window_set_back_pixmap(blue_view->window,blue_curve_pmap,FALSE);
	gdk_window_clear(blue_view->window);
	gdk_flush();
     }
}

void mod_gamma_cb(GtkWidget *widget, void *data)
{
   int value;
   GdkImlibColorModifier modz;
   
   value=(int)GTK_ADJUSTMENT(adjusters[0])->value;
   gdk_imlib_get_image_modifier(current.image,&modz);
   modz.gamma=value;
   gdk_imlib_set_image_modifier(current.image,&modz);
   redraw_red_mod();
   redraw_green_mod();
   redraw_blue_mod();
   if(autoapply) draw_image();
   draw_mini_image();
   mods_changed=1;
}

void reset_gamma_cb(GtkWidget *widget, void *data)
{
   GdkImlibColorModifier modz;
   
   GTK_ADJUSTMENT(adjusters[0])->value=(gfloat)(256);
   gtk_range_set_adjustment(GTK_RANGE(sliders[0]),GTK_ADJUSTMENT(adjusters[0]));
   gtk_range_slider_update(GTK_RANGE(sliders[0]));
   gdk_imlib_get_image_modifier(current.image,&modz);
   modz.gamma=256;
   gdk_imlib_set_image_modifier(current.image,&modz);
   redraw_red_mod();
   redraw_green_mod();
   redraw_blue_mod();
   if(autoapply) draw_image();
   draw_mini_image();
   mods_changed=1;
}

void mod_brightness_cb(GtkWidget *widget, void *data)
{
   int value;
   GdkImlibColorModifier modz;
   
   value=(int)GTK_ADJUSTMENT(adjusters[1])->value;
   gdk_imlib_get_image_modifier(current.image,&modz);
   modz.brightness=value;
   gdk_imlib_set_image_modifier(current.image,&modz);
   redraw_red_mod();
   redraw_green_mod();
   redraw_blue_mod();
   if(autoapply) draw_image();
   draw_mini_image();
   mods_changed=1;
}

void reset_brightness_cb(GtkWidget *widget, void *data)
{
   GdkImlibColorModifier modz;
   
   GTK_ADJUSTMENT(adjusters[1])->value=(gfloat)(256);
   gtk_range_set_adjustment(GTK_RANGE(sliders[1]),GTK_ADJUSTMENT(adjusters[1]));
   gtk_range_slider_update(GTK_RANGE(sliders[1]));
   gdk_imlib_get_image_modifier(current.image,&modz);
   modz.brightness=256;
   gdk_imlib_set_image_modifier(current.image,&modz);
   redraw_red_mod();
   redraw_green_mod();
   redraw_blue_mod();
   if(autoapply) draw_image();
   draw_mini_image();
   mods_changed=1;
}

void mod_contrast_cb(GtkWidget *widget, void *data)
{
   int value;
   GdkImlibColorModifier modz;
   
   value=(int)GTK_ADJUSTMENT(adjusters[2])->value;
   gdk_imlib_get_image_modifier(current.image,&modz);
   modz.contrast=value;
   gdk_imlib_set_image_modifier(current.image,&modz);
   redraw_red_mod();
   redraw_green_mod();
   redraw_blue_mod();
   if(autoapply) draw_image();
   draw_mini_image();
   mods_changed=1;
}

void reset_contrast_cb(GtkWidget *widget, void *data)
{
   GdkImlibColorModifier modz;
   
   GTK_ADJUSTMENT(adjusters[2])->value=(gfloat)(256);
   gtk_range_set_adjustment(GTK_RANGE(sliders[2]),GTK_ADJUSTMENT(adjusters[2]));
   gtk_range_slider_update(GTK_RANGE(sliders[2]));
   gdk_imlib_get_image_modifier(current.image,&modz);
   modz.contrast=256;
   gdk_imlib_set_image_modifier(current.image,&modz);
   redraw_red_mod();
   redraw_green_mod();
   redraw_blue_mod();
   if(autoapply) draw_image();
   draw_mini_image();
   mods_changed=1;
}


void mod_red_gamma_cb(GtkWidget *widget, void *data)
{
   int value;
   GdkImlibColorModifier modz;
   
   value=(int)GTK_ADJUSTMENT(adjusters[3])->value;
   gdk_imlib_get_image_red_modifier(current.image,&modz);
   modz.gamma=value;
   gdk_imlib_set_image_red_modifier(current.image,&modz);
   redraw_red_mod();
   if(autoapply) draw_image();
   draw_mini_image();
   mods_changed=1;
}

void reset_red_gamma_cb(GtkWidget *widget, void *data)
{
   GdkImlibColorModifier modz;
   
   GTK_ADJUSTMENT(adjusters[3])->value=(gfloat)(256);
   gtk_range_set_adjustment(GTK_RANGE(sliders[3]),GTK_ADJUSTMENT(adjusters[3]));
   gtk_range_slider_update(GTK_RANGE(sliders[3]));
   gdk_imlib_get_image_red_modifier(current.image,&modz);
   modz.gamma=256;
   gdk_imlib_set_image_red_modifier(current.image,&modz);
   redraw_red_mod();
   if(autoapply) draw_image();
   draw_mini_image();
   mods_changed=1;
}

void mod_red_brightness_cb(GtkWidget *widget, void *data)
{
   int value;
   GdkImlibColorModifier modz;
   
   value=(int)GTK_ADJUSTMENT(adjusters[4])->value;
   gdk_imlib_get_image_red_modifier(current.image,&modz);
   modz.brightness=value;
   gdk_imlib_set_image_red_modifier(current.image,&modz);
   redraw_red_mod();
   if(autoapply) draw_image();
   draw_mini_image();
   mods_changed=1;
}

void reset_red_brightness_cb(GtkWidget *widget, void *data)
{
   GdkImlibColorModifier modz;
   
   GTK_ADJUSTMENT(adjusters[4])->value=(gfloat)(256);
   gtk_range_set_adjustment(GTK_RANGE(sliders[4]),GTK_ADJUSTMENT(adjusters[4]));
   gtk_range_slider_update(GTK_RANGE(sliders[4]));
   gdk_imlib_get_image_red_modifier(current.image,&modz);
   modz.brightness=256;
   gdk_imlib_set_image_red_modifier(current.image,&modz);
   redraw_red_mod();
   if(autoapply) draw_image();
   draw_mini_image();
   mods_changed=1;
}

void mod_red_contrast_cb(GtkWidget *widget, void *data)
{
   int value;
   GdkImlibColorModifier modz;
   
   value=(int)GTK_ADJUSTMENT(adjusters[5])->value;
   gdk_imlib_get_image_red_modifier(current.image,&modz);
   modz.contrast=value;
   gdk_imlib_set_image_red_modifier(current.image,&modz);
   redraw_red_mod();
   if(autoapply) draw_image();
   draw_mini_image();
   mods_changed=1;
}

void reset_red_contrast_cb(GtkWidget *widget, void *data)
{
   GdkImlibColorModifier modz;
   
   GTK_ADJUSTMENT(adjusters[5])->value=(gfloat)(256);
   gtk_range_set_adjustment(GTK_RANGE(sliders[5]),GTK_ADJUSTMENT(adjusters[5]));
   gtk_range_slider_update(GTK_RANGE(sliders[5]));
   gdk_imlib_get_image_red_modifier(current.image,&modz);
   modz.contrast=256;
   gdk_imlib_set_image_red_modifier(current.image,&modz);
   redraw_red_mod();
   if(autoapply) draw_image();
   draw_mini_image();
   mods_changed=1;
}




void mod_green_gamma_cb(GtkWidget *widget, void *data)
{
   int value;
   GdkImlibColorModifier modz;
   
   value=(int)GTK_ADJUSTMENT(adjusters[6])->value;
   gdk_imlib_get_image_green_modifier(current.image,&modz);
   modz.gamma=value;
   gdk_imlib_set_image_green_modifier(current.image,&modz);
   redraw_green_mod();
   if(autoapply) draw_image();
   draw_mini_image();
   mods_changed=1;
}

void reset_green_gamma_cb(GtkWidget *widget, void *data)
{
   GdkImlibColorModifier modz;
   
   GTK_ADJUSTMENT(adjusters[6])->value=(gfloat)(256);
   gtk_range_set_adjustment(GTK_RANGE(sliders[6]),GTK_ADJUSTMENT(adjusters[6]));
   gtk_range_slider_update(GTK_RANGE(sliders[6]));
   gdk_imlib_get_image_green_modifier(current.image,&modz);
   modz.gamma=256;
   gdk_imlib_set_image_green_modifier(current.image,&modz);
   redraw_green_mod();
   if(autoapply) draw_image();
   draw_mini_image();
   mods_changed=1;
}

void mod_green_brightness_cb(GtkWidget *widget, void *data)
{
   int value;
   GdkImlibColorModifier modz;
   
   value=(int)GTK_ADJUSTMENT(adjusters[7])->value;
   gdk_imlib_get_image_green_modifier(current.image,&modz);
   modz.brightness=value;
   gdk_imlib_set_image_green_modifier(current.image,&modz);
   redraw_green_mod();
   if(autoapply) draw_image();
   draw_mini_image();
   mods_changed=1;
}

void reset_green_brightness_cb(GtkWidget *widget, void *data)
{
   GdkImlibColorModifier modz;
   
   GTK_ADJUSTMENT(adjusters[7])->value=(gfloat)(256);
   gtk_range_set_adjustment(GTK_RANGE(sliders[7]),GTK_ADJUSTMENT(adjusters[7]));
   gtk_range_slider_update(GTK_RANGE(sliders[7]));
   gdk_imlib_get_image_green_modifier(current.image,&modz);
   modz.brightness=256;
   gdk_imlib_set_image_green_modifier(current.image,&modz);
   redraw_green_mod();
   if(autoapply) draw_image();
   draw_mini_image();
   mods_changed=1;
}

void mod_green_contrast_cb(GtkWidget *widget, void *data)
{
   int value;
   GdkImlibColorModifier modz;
   
   value=(int)GTK_ADJUSTMENT(adjusters[8])->value;
   gdk_imlib_get_image_green_modifier(current.image,&modz);
   modz.contrast=value;
   gdk_imlib_set_image_green_modifier(current.image,&modz);
   redraw_green_mod();
   if(autoapply) draw_image();
   draw_mini_image();
   mods_changed=1;
}

void reset_green_contrast_cb(GtkWidget *widget, void *data)
{
   GdkImlibColorModifier modz;
   
   GTK_ADJUSTMENT(adjusters[8])->value=(gfloat)(256);
   gtk_range_set_adjustment(GTK_RANGE(sliders[8]),GTK_ADJUSTMENT(adjusters[8]));
   gtk_range_slider_update(GTK_RANGE(sliders[8]));
   gdk_imlib_get_image_green_modifier(current.image,&modz);
   modz.contrast=256;
   gdk_imlib_set_image_green_modifier(current.image,&modz);
   redraw_green_mod();
   if(autoapply) draw_image();
   draw_mini_image();
   mods_changed=1;
}





void mod_blue_gamma_cb(GtkWidget *widget, void *data)
{
   int value;
   GdkImlibColorModifier modz;
   
   value=(int)GTK_ADJUSTMENT(adjusters[9])->value;
   gdk_imlib_get_image_blue_modifier(current.image,&modz);
   modz.gamma=value;
   gdk_imlib_set_image_blue_modifier(current.image,&modz);
   redraw_blue_mod();
   if(autoapply) draw_image();
   draw_mini_image();
   mods_changed=1;
}

void reset_blue_gamma_cb(GtkWidget *widget, void *data)
{
   GdkImlibColorModifier modz;
   
   GTK_ADJUSTMENT(adjusters[9])->value=(gfloat)(256);
   gtk_range_set_adjustment(GTK_RANGE(sliders[9]),GTK_ADJUSTMENT(adjusters[9]));
   gtk_range_slider_update(GTK_RANGE(sliders[9]));
   gdk_imlib_get_image_blue_modifier(current.image,&modz);
   modz.gamma=256;
   gdk_imlib_set_image_blue_modifier(current.image,&modz);
   redraw_blue_mod();
   if(autoapply) draw_image();
   draw_mini_image();
   mods_changed=1;
}

void mod_blue_brightness_cb(GtkWidget *widget, void *data)
{
   int value;
   GdkImlibColorModifier modz;
   
   value=(int)GTK_ADJUSTMENT(adjusters[10])->value;
   gdk_imlib_get_image_blue_modifier(current.image,&modz);
   modz.brightness=value;
   gdk_imlib_set_image_blue_modifier(current.image,&modz);
   redraw_blue_mod();
   if(autoapply) draw_image();
   draw_mini_image();
   mods_changed=1;
}

void reset_blue_brightness_cb(GtkWidget *widget, void *data)
{
   GdkImlibColorModifier modz;
   
   GTK_ADJUSTMENT(adjusters[10])->value=(gfloat)(256);
   gtk_range_set_adjustment(GTK_RANGE(sliders[10]),GTK_ADJUSTMENT(adjusters[10]));
   gtk_range_slider_update(GTK_RANGE(sliders[10]));
   gdk_imlib_get_image_blue_modifier(current.image,&modz);
   modz.brightness=256;
   gdk_imlib_set_image_blue_modifier(current.image,&modz);
   redraw_blue_mod();
   if(autoapply) draw_image();
   draw_mini_image();
   mods_changed=1;
}

void mod_blue_contrast_cb(GtkWidget *widget, void *data)
{
   int value;
   GdkImlibColorModifier modz;
   
   value=(int)GTK_ADJUSTMENT(adjusters[11])->value;
   gdk_imlib_get_image_blue_modifier(current.image,&modz);
   modz.contrast=value;
   gdk_imlib_set_image_blue_modifier(current.image,&modz);
   redraw_blue_mod();
   if(autoapply) draw_image();
   draw_mini_image();
   mods_changed=1;
}

void reset_blue_contrast_cb(GtkWidget *widget, void *data)
{
   GdkImlibColorModifier modz;
   
   GTK_ADJUSTMENT(adjusters[11])->value=(gfloat)(256);
   gtk_range_set_adjustment(GTK_RANGE(sliders[11]),GTK_ADJUSTMENT(adjusters[11]));
   gtk_range_slider_update(GTK_RANGE(sliders[11]));
   gdk_imlib_get_image_blue_modifier(current.image,&modz);
   modz.contrast=256;
   gdk_imlib_set_image_blue_modifier(current.image,&modz);
   redraw_blue_mod();
   if(autoapply) draw_image();
   draw_mini_image();
   mods_changed=1;
}

void reset_all_mods()
{
   int i;
   for(i=0;i<12;i++)
     {
	GTK_ADJUSTMENT(adjusters[i])->value=(gfloat)(256);
	gtk_range_set_adjustment(GTK_RANGE(sliders[i]),GTK_ADJUSTMENT(adjusters[i]));
	gtk_range_slider_update(GTK_RANGE(sliders[i]));
     }
   redraw_red_mod();
   redraw_green_mod();
   redraw_blue_mod();
   mods_changed=0;
}

void reset_all_mods_cb(GtkWidget *widget, void *data)
{
   GdkImlibColorModifier modz;

   modz.gamma=256;
   modz.brightness=256;
   modz.contrast=256;
   gdk_imlib_set_image_modifier(current.image,&modz);
   gdk_imlib_set_image_red_modifier(current.image,&modz);
   gdk_imlib_set_image_green_modifier(current.image,&modz);
   gdk_imlib_set_image_blue_modifier(current.image,&modz);
   reset_all_mods();
   if(autoapply) draw_image();
   draw_mini_image();
}

void toggle_auto_cb(GtkWidget *widget, void *data)
{
   if (autoapply) autoapply=0;
   else
     {
	autoapply=1;
	draw_image();
	draw_mini_image();
     }
}

void update_crop_spins()
{
   int dif;
   
   dif=crop_x-(int)GTK_ADJUSTMENT(cropx_adj)->value;
   if (dif!=0)
     {
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(cropx_wid),(gfloat)crop_x);
	gtk_widget_queue_draw(GTK_WIDGET(cropx_wid));
	mod_cx=1;
     }
   dif=crop_y-(int)GTK_ADJUSTMENT(cropy_adj)->value;
   if (dif!=0)
     {
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(cropy_wid),(gfloat)crop_y);
	gtk_widget_queue_draw(GTK_WIDGET(cropy_wid));
	mod_cy=1;
     }
   dif=crop_w-(int)GTK_ADJUSTMENT(cropw_adj)->value;
   if (dif!=0)
     {
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(cropw_wid),(gfloat)crop_w);
	gtk_widget_queue_draw(GTK_WIDGET(cropw_wid));
	mod_cw=1;
     }
   dif=crop_h-(int)GTK_ADJUSTMENT(croph_adj)->value;
   if (dif!=0)
     {
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(croph_wid),(gfloat)crop_h);
	gtk_widget_queue_draw(GTK_WIDGET(croph_wid));
	mod_ch=1;
     }
}

void do_crop_cb(GtkWidget *widget, void *data)
{
   int x,y,w,h;
   
   if ((crop_w>0)&&(crop_h>0))
     {
	x=(crop_x*current.image->rgb_width)/current.width;
	y=(crop_y*current.image->rgb_height)/current.height;
	w=(crop_w*current.image->rgb_width)/current.width;
	h=(crop_h*current.image->rgb_height)/current.height;
	gdk_imlib_crop_image(current.image,x,y,w,h);
	gtk_widget_set_usize(window_image,crop_w,crop_h);
     }
}

void mod_crop_x_cb(GtkWidget *widget, void *data)
{
   if (mod_cx)
     {
	mod_cx=0;
	return;
     }
   clear_crop();
   crop_x=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(cropx_wid));
   if ((crop_w>0)&&(crop_h>0))
     {
	if (crop_x<0) crop_x=0;
	if (crop_y<0) crop_y=0;
	if (crop_w<1) crop_w=1;
	if (crop_h<1) crop_h=1;
	if (crop_x+crop_w>current.width) crop_x=current.width-crop_w;
	if (crop_y+crop_h>current.height) crop_y=current.height-crop_h;
	draw_crop();
	update_crop_spins();
     }
}

void mod_crop_y_cb(GtkWidget *widget, void *data)
{
   if (mod_cy)
     {
	mod_cy=0;
	return;
     }
   clear_crop();
   crop_y=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(cropy_wid));
   if ((crop_w>0)&&(crop_h>0))
     {
	if (crop_x<0) crop_x=0;
	if (crop_y<0) crop_y=0;
	if (crop_w<1) crop_w=1;
	if (crop_h<1) crop_h=1;
	if (crop_x+crop_w>current.width) crop_x=current.width-crop_w;
	if (crop_y+crop_h>current.height) crop_y=current.height-crop_h;
	draw_crop();
	update_crop_spins();
     }
}

void mod_crop_w_cb(GtkWidget *widget, void *data)
{
   if (mod_cw)
     {
	mod_cw=0;
	return;
     }
   clear_crop();
   crop_w=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(cropw_wid));
   if ((crop_w>0)&&(crop_h>0))
     {
	if (crop_x<0) crop_x=0;
	if (crop_y<0) crop_y=0;
	if (crop_w<1) crop_w=1;
	if (crop_h<1) crop_h=1;
	if (crop_x+crop_w>current.width) crop_x=current.width-crop_w;
	if (crop_y+crop_h>current.height) crop_y=current.height-crop_h;
	draw_crop();
	update_crop_spins();
     }
}

void mod_crop_h_cb(GtkWidget *widget, void *data)
{
   if (mod_ch)
     {
	mod_ch=0;
	return;
     }
   clear_crop();
   crop_h=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(croph_wid));
   if ((crop_w>0)&&(crop_h>0))
     {
	if (crop_x<0) crop_x=0;
	if (crop_y<0) crop_y=0;
	if (crop_w<1) crop_w=1;
	if (crop_h<1) crop_h=1;
	if (crop_x+crop_w>current.width) crop_x=current.width-crop_w;
	if (crop_y+crop_h>current.height) crop_y=current.height-crop_h;
	draw_crop();
	update_crop_spins();
     }
}

void force_aspect_from_w()
{
   int w,h,ww;
   
   w=(int)GTK_ADJUSTMENT(width_adj)->value;
   h=(int)GTK_ADJUSTMENT(height_adj)->value;
   
   ww=(w*current.image->rgb_height)/current.image->rgb_width;
   gtk_spin_button_spin(GTK_SPIN_BUTTON(height_wid),1,(gfloat)
			(gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(height_wid))-
			 ww));
   gtk_widget_queue_draw(GTK_WIDGET(height_wid));
   mod_height=1;
}

void force_aspect_from_h()
{
   int w,h,hh;
   
   w=(int)GTK_ADJUSTMENT(width_adj)->value;
   h=(int)GTK_ADJUSTMENT(height_adj)->value;
   
   hh=(h*current.image->rgb_width)/current.image->rgb_height;
   gtk_spin_button_spin(GTK_SPIN_BUTTON(width_wid),1,(gfloat)
			(gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(width_wid))-
			 hh));
   gtk_widget_queue_draw(GTK_WIDGET(width_wid));
   mod_width=1;
}

void mod_width_cb(GtkWidget *widget, void *data)
{
   if (mod_height)
     {
	mod_height=0;
	return;
     }
   if (fixed_aspect) force_aspect_from_w();
}

void mod_height_cb(GtkWidget *widget, void *data)
{
   if (mod_width)
     {
	mod_width=0;
	return;
     }
   if (fixed_aspect) force_aspect_from_h();
}

void toggle_fixed_cb(GtkWidget *widget, void *data)
{
   if (fixed_aspect) fixed_aspect=0;
   else
     {
	force_aspect_from_w();
	fixed_aspect=1;
     }
}

void apply_size_cb(GtkWidget *widget, void *data)
{
   int w,h;
   
   w=(int)GTK_ADJUSTMENT(width_adj)->value;
   h=(int)GTK_ADJUSTMENT(height_adj)->value;
   
   gtk_widget_set_usize(window_image,w,h);
}

void apply_changes_cb(GtkWidget *widget, void *data)
{
   if (!autoapply) draw_image();
}

void keep_changes_cb(GtkWidget *widget, void *data)
{
   GdkImlibImage *im;
   
   if (!current.image) return;
   if ((current.width!=current.image->rgb_width)||
       (current.height!=current.image->rgb_height))
     {
	im=gdk_imlib_clone_scaled_image(current.image,
					current.width,current.height);
	gdk_imlib_destroy_image(current.image);
	current.image=im;
     }
   gdk_imlib_apply_modifiers_to_rgb(current.image);
   reset_all_mods();
   if (!autoapply) draw_image();
}

GtkWidget *make_adjust(GtkSignalFunc change_func, GtkSignalFunc reset_func,
		       GtkObject **adjust_ret, GtkWidget **range_ret, 
		       GdkPixmap *pmap, GdkPixmap *mask, int width)
{
   GtkWidget *scale;
   GtkWidget *pixmap;
   GtkWidget *button;
   GtkObject *adj;
   GtkWidget *box;
   GdkImlibColorModifier mod,rmod,gmod,bmod;
   
   box=gtk_hbox_new(FALSE,0);
   gtk_widget_show(box);

   adj=gtk_adjustment_new(0,0.0,1024.0,1.0,4.0,0.0);
   *adjust_ret=adj;
   scale=gtk_hscale_new(GTK_ADJUSTMENT(adj));
   *range_ret=scale;
   gtk_widget_show(scale);
   gtk_range_set_update_policy(GTK_RANGE(scale),GTK_UPDATE_CONTINUOUS);
   gtk_scale_set_draw_value(GTK_SCALE(scale),FALSE);
   gtk_widget_set_usize(scale,width,-1);
   gtk_box_pack_start(GTK_BOX(box),scale,TRUE,TRUE,0);
   gtk_signal_connect(GTK_OBJECT(adj),"value_changed",GTK_SIGNAL_FUNC(change_func),adj);

   button=gtk_button_new();
   gtk_widget_show(button);
   pixmap=gtk_pixmap_new(pmap,mask);
   gtk_widget_show(pixmap);
   gtk_container_add(GTK_CONTAINER(button),pixmap);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(reset_func),adj);
   gtk_box_pack_start(GTK_BOX(box),button,TRUE,TRUE,0);
   return box;
}

void handle_clist_click(GtkWidget *widget, gint row)
{
   if (row==current.number) return;
   show_image_n(row);
}

void handle_add_to_clist(GtkWidget *widget, gpointer *data)
{
   image_open(NULL,NULL);
}

void handle_del_from_clist(GtkWidget *widget, gpointer *data)
{
   del_file_from_list(current.info->file);
   show_image_n(current.number);
}

void handle_load_clist(GtkWidget *widget, gpointer *data)
{
   int num,i;
   struct _image *img;
   FILE *f;
   char *hom,s[4096],ss[2048];
   
   if (list)
     gtk_clist_freeze(GTK_CLIST(list));
   if (window_thumbs)
     gnome_icon_list_freeze(GNOME_ICON_LIST(thumbs_box));
   num=get_list_length();
   for(i=0;i<num;i++)
     {
	img=get_file_n_from_list(0);
	del_file_from_list(img->file);
     }
   hom=homedir(getuid());
   snprintf(s,2048,"%s/.ee/list",hom);
   free(hom);
   f=fopen(s,"r");
   if (!f) return;
   while(fgets(s,4096,f))
     {
	sscanf(s,"%s",ss);
	add_file_to_list(ss);
     }
   fclose(f);
   if (list)
     gtk_clist_thaw(GTK_CLIST(list));
   if (window_thumbs)
     gnome_icon_list_thaw(GNOME_ICON_LIST(thumbs_box));
   show_image_n(0);
}

void handle_save_clist(GtkWidget *widget, gpointer *data)
{
   int num,i;
   struct _image *img;
   FILE *f;
   char *hom,s[2048];
   
   hom=homedir(getuid());
   snprintf(s,2048,"%s/.ee/list",hom);
   free(hom);
   f=fopen(s,"w");
   if (!f) return;
   num=get_list_length();
   for(i=0;i<num;i++)
     {
	img=get_file_n_from_list(i);
	fprintf(f,"%s\n",img->file);
     }
   fclose(f);
}

void init_edit()
{
   GtkWidget *button;
   GtkWidget *notebk;
   GtkWidget *hbox;
   GtkWidget *page;
   GtkWidget *label;
   GtkWidget *box;
   GtkWidget *vbox;
   GtkWidget *hbox2;
   GtkWidget *frame;
   GtkWidget *alignment;
   GtkWidget *area;
   GtkWidget *adjuster;
   GtkWidget *view;
   GtkObject *obj;
   GtkWidget *slid;
   GtkWidget *pixmap;
   GtkWidget *tip;
   char *data;
   GdkPixmap *pmap;
   GdkPixmap *mask;
   GtkWidget *ba;
   EEGtkHider *hider;
     
   make_icons();
   data=malloc(64*64*3);
   red_curve=gdk_imlib_create_image_from_data(data,NULL,64,64);
   data=malloc(64*64*3);
   green_curve=gdk_imlib_create_image_from_data(data,NULL,64,64);
   data=malloc(64*64*3);
   blue_curve=gdk_imlib_create_image_from_data(data,NULL,64,64);
   window_edit=gtk_window_new(GTK_WINDOW_TOPLEVEL);
   gtk_window_set_wmclass(GTK_WINDOW(window_edit),"ee","Image Viewer");
   gtk_window_set_title(GTK_WINDOW(window_edit),_("Electric Eyes - Edit Image"));
   gtk_container_border_width(GTK_CONTAINER(window_edit),3);
   gtk_window_set_policy(GTK_WINDOW(window_edit),0,0,1);
   gtk_signal_connect(GTK_OBJECT(window_edit),"delete_event",
		      GTK_SIGNAL_FUNC(quit_edit_cb),NULL);
   gtk_widget_realize(window_edit);

   hbox=gtk_hbox_new(FALSE,0);
   gtk_widget_show(hbox);
   gtk_container_add(GTK_CONTAINER(window_edit),hbox);

   tips=(GtkWidget *)gtk_tooltips_new();
   gtk_tooltips_enable(GTK_TOOLTIPS(tips));
   
   label=gtk_label_new(_("View"));
   hider=EE_gtk_hider_new(label);
   
   box=gtk_vbox_new(FALSE,0);
   gtk_widget_show(box);
   
   EE_gtk_hider_add_content(hider,box);
   gtk_box_pack_start(GTK_BOX(hbox),hider->frame,FALSE,FALSE,0);
   
   hbox2=gtk_hbox_new(TRUE,0);
   gtk_widget_show(hbox2);
   gtk_box_pack_start(GTK_BOX(box),hbox2,FALSE,FALSE,0);
   
   pixmap=gnome_stock_pixmap_widget(window_edit,GNOME_STOCK_PIXMAP_OPEN);
   gtk_widget_show(pixmap);
   button=gtk_button_new();
   gtk_container_add(GTK_CONTAINER(button),pixmap);
   gtk_widget_show(button);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(image_open),NULL);
   gtk_box_pack_start(GTK_BOX(hbox2),button,TRUE,TRUE,0);
   
   pixmap=gnome_stock_pixmap_widget(window_edit,GNOME_STOCK_PIXMAP_SAVE);
   gtk_widget_show(pixmap);
   button=gtk_button_new();
   gtk_container_add(GTK_CONTAINER(button),pixmap);
   gtk_widget_show(button);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(image_save),NULL);
   gtk_box_pack_start(GTK_BOX(hbox2),button,TRUE,TRUE,0);
   
   pixmap=gnome_stock_pixmap_widget(window_edit,GNOME_STOCK_PIXMAP_SAVE_AS);
   gtk_widget_show(pixmap);
   button=gtk_button_new();
   gtk_container_add(GTK_CONTAINER(button),pixmap);
   gtk_widget_show(button);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(image_save_as),NULL);
   gtk_box_pack_start(GTK_BOX(hbox2),button,TRUE,TRUE,0);
   
   frame=gtk_frame_new(_("Image Preview"));
   gtk_widget_show(frame);
   gtk_box_pack_start(GTK_BOX(box),frame,TRUE,TRUE,0);
   current.mini_redraw=frame;
   gtk_widget_set_usize(frame,140,140);
   
   alignment = gtk_alignment_new (0.5, 0.5, 0.0, 0.0);
   gtk_container_add (GTK_CONTAINER(frame),alignment);
   gtk_widget_show (alignment);
   
   view=gtk_frame_new(NULL);
   gtk_widget_show(view);
   gtk_container_add (GTK_CONTAINER(alignment),view);
   
   area=gtk_drawing_area_new();
   gtk_widget_show(area);
   gtk_container_add(GTK_CONTAINER(view),area);
   current.mini_view=view;
   current.mini_area=area;
   current.mini_pixmap=NULL;
   
   hbox2=gtk_hbox_new(TRUE,0);
   gtk_widget_show(hbox2);
   gtk_box_pack_start(GTK_BOX(box),hbox2,FALSE,FALSE,0);
   
   pixmap=gnome_stock_pixmap_widget(window_edit,GNOME_STOCK_PIXMAP_BACK);
   gtk_widget_show(pixmap);
   button=gtk_button_new();
   gtk_container_add(GTK_CONTAINER(button),pixmap);
   gtk_widget_show(button);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(handle_image_previous),NULL);
   gtk_box_pack_start(GTK_BOX(hbox2),button,TRUE,TRUE,0);

   pixmap=gnome_stock_pixmap_widget(window_edit,GNOME_STOCK_PIXMAP_FORWARD);
   gtk_widget_show(pixmap);
   button=gtk_button_new();
   gtk_container_add(GTK_CONTAINER(button),pixmap);
   gtk_widget_show(button);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(handle_image_next),NULL);
   gtk_box_pack_start(GTK_BOX(hbox2),button,TRUE,TRUE,0);
   
   button=gtk_check_button_new_with_label(_("Auto Apply"));
   gtk_widget_show(button);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(toggle_auto_cb),button);
   gtk_box_pack_start (GTK_BOX(box),button,FALSE,FALSE,0);
   
   button=gtk_button_new_with_label(_("Apply Changes"));
   gtk_widget_show(button);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(apply_changes_cb),NULL);
   gtk_box_pack_start(GTK_BOX(box),button,FALSE,FALSE,0);

   button=gtk_button_new_with_label(_("Keep Changes"));
   gtk_widget_show(button);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(keep_changes_cb),NULL);
   gtk_box_pack_start(GTK_BOX(box),button,FALSE,FALSE,0);
   
   
   
   label=gtk_label_new(_("Editing"));
   hider=EE_gtk_hider_new(label);
   
   notebk=gtk_notebook_new();
   gtk_widget_show(notebk);

   EE_gtk_hider_add_content(hider,notebk);
   gtk_box_pack_start(GTK_BOX(hbox),hider->frame,FALSE,FALSE,0);
   
   label=gtk_label_new(_("Image List"));
   hider=EE_gtk_hider_new(label);
   
   box=gtk_vbox_new(FALSE,0);
   gtk_widget_show(box);

   EE_gtk_hider_add_content(hider,box);
   gtk_box_pack_start(GTK_BOX(hbox),hider->frame,FALSE,FALSE,0);

   hbox2=gtk_hbox_new(TRUE,0);
   gtk_widget_show(hbox2);
   gtk_box_pack_start(GTK_BOX(box),hbox2,TRUE,FALSE,0);

   pixmap=gnome_stock_pixmap_widget(window_edit,GNOME_STOCK_MENU_PASTE);
   gtk_widget_show(pixmap);
   button=gtk_button_new();
   gtk_container_add(GTK_CONTAINER(button),pixmap);
   gtk_widget_show(button);
    gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(handle_add_to_clist),NULL);
   gtk_box_pack_start (GTK_BOX(hbox2),button,TRUE,TRUE,0);

   pixmap=gnome_stock_pixmap_widget(window_edit,GNOME_STOCK_MENU_CUT);
   gtk_widget_show(pixmap);
   button=gtk_button_new();
   gtk_container_add(GTK_CONTAINER(button),pixmap);
   gtk_widget_show(button);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(handle_del_from_clist),NULL);
   gtk_box_pack_start (GTK_BOX(hbox2),button,TRUE,TRUE,0);

   pixmap=gnome_stock_pixmap_widget(window_edit,GNOME_STOCK_MENU_OPEN);
   gtk_widget_show(pixmap);
   button=gtk_button_new();
   gtk_container_add(GTK_CONTAINER(button),pixmap);
   gtk_widget_show(button);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(handle_load_clist),NULL);
   gtk_box_pack_start (GTK_BOX(hbox2),button,TRUE,TRUE,0);

   pixmap=gnome_stock_pixmap_widget(window_edit,GNOME_STOCK_MENU_SAVE);
   gtk_widget_show(pixmap);
   button=gtk_button_new();
   gtk_container_add(GTK_CONTAINER(button),pixmap);
   gtk_widget_show(button);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(handle_save_clist),NULL);
   gtk_box_pack_start (GTK_BOX(hbox2),button,TRUE,TRUE,0);

   
   
   hbox2=gtk_hbox_new(FALSE,0);
   gtk_widget_show(hbox2);
   gtk_box_pack_start(GTK_BOX(box),hbox2,TRUE,FALSE,0);
   
   list=gtk_clist_new(1);
   gtk_clist_set_policy(GTK_CLIST(list),GTK_POLICY_ALWAYS,GTK_POLICY_AUTOMATIC);
   gtk_clist_set_selection_mode(GTK_CLIST(list),GTK_SELECTION_SINGLE);
   gtk_widget_set_usize(list,160,360);
   gtk_box_pack_start(GTK_BOX(hbox2),list,FALSE,FALSE,0);
   gtk_widget_show(list);
   gtk_signal_connect(GTK_OBJECT(list),"select_row",GTK_SIGNAL_FUNC(handle_clist_click),NULL);
   
   vbox=gtk_vbox_new(FALSE,0);
   gtk_widget_show(vbox);
   gtk_box_pack_start(GTK_BOX(hbox2),vbox,TRUE,FALSE,0);

   pixmap=gnome_stock_pixmap_widget(window_edit,GNOME_STOCK_MENU_BACK);
   gtk_widget_show(pixmap);
   button=gtk_button_new();
   gtk_container_add(GTK_CONTAINER(button),pixmap);
   gtk_widget_show(button);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(handle_image_previous),NULL);
   gtk_box_pack_start (GTK_BOX(vbox),button,FALSE,FALSE,0);
   gtk_accelerator_table_install(image_accel,
				 GTK_OBJECT(button),"clicked",
				 'z',0);

   pixmap=gnome_stock_pixmap_widget(window_edit,GNOME_STOCK_MENU_FORWARD);
   gtk_widget_show(pixmap);
   button=gtk_button_new();
   gtk_container_add(GTK_CONTAINER(button),pixmap);
   gtk_widget_show(button);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(handle_image_next),NULL);
   gtk_box_pack_start (GTK_BOX(vbox),button,FALSE,FALSE,0);
   gtk_accelerator_table_install(image_accel,
				 GTK_OBJECT(button),"clicked",
				 ' ',0);

   
   
   label=gtk_label_new(_("Colors"));
   gtk_widget_show(label);
   
   vbox=gtk_vbox_new(FALSE,0);
   gtk_widget_show(vbox);
   gtk_notebook_append_page(GTK_NOTEBOOK(notebk),vbox,label);
   
   frame=gtk_aspect_frame_new(_("Combined Channel Modifiers"),0.5,0.5,0.0,TRUE);
   gtk_widget_show(frame);
   gtk_box_pack_start(GTK_BOX(vbox),frame,TRUE,TRUE,0);

   hbox2=gtk_hbox_new(FALSE,0);
   gtk_widget_show(hbox2);
   gtk_container_add(GTK_CONTAINER(frame),hbox2);
   
   view=gtk_frame_new(NULL);
   gtk_widget_show(view);
   gtk_box_pack_start(GTK_BOX(hbox2),view,TRUE,TRUE,0);
   
   area=gtk_drawing_area_new();
   gtk_widget_show(area);
   gtk_container_add(GTK_CONTAINER(view),area);
   gtk_widget_set_usize(area,64,64);
   
   box=gtk_vbox_new(TRUE,0);
   gtk_widget_show(box);
   gtk_box_pack_start(GTK_BOX(hbox2),box,TRUE,TRUE,0);

   adjuster=make_adjust(GTK_SIGNAL_FUNC(mod_gamma_cb),
			GTK_SIGNAL_FUNC(reset_gamma_cb),&adjusters[0],
			&sliders[0],gamma_pmap,gamma_mask,160);
   gtk_widget_show(adjuster);
   gtk_box_pack_start(GTK_BOX(box),adjuster,TRUE,TRUE,0);
   adjuster=make_adjust(GTK_SIGNAL_FUNC(mod_brightness_cb),
			GTK_SIGNAL_FUNC(reset_brightness_cb),&adjusters[1],
			&sliders[1],brightness_pmap,brightness_mask,160);
   gtk_widget_show(adjuster);
   gtk_box_pack_start(GTK_BOX(box),adjuster,TRUE,TRUE,0);
   adjuster=make_adjust(GTK_SIGNAL_FUNC(mod_contrast_cb),
			GTK_SIGNAL_FUNC(reset_contrast_cb),&adjusters[2],
			&sliders[2],contrast_pmap,contrast_mask,160);
   gtk_widget_show(adjuster);
   gtk_box_pack_start(GTK_BOX(box),adjuster,TRUE,TRUE,0);

   
   frame=gtk_aspect_frame_new(_("Red Channel Modifiers"),0.5,0.5,0.0,TRUE);
   gtk_widget_show(frame);
   gtk_box_pack_start(GTK_BOX(vbox),frame,TRUE,TRUE,0);

   hbox2=gtk_hbox_new(FALSE,0);
   gtk_widget_show(hbox2);
   gtk_container_add(GTK_CONTAINER(frame),hbox2);
   
   view=gtk_viewport_new(NULL,NULL);
   gtk_widget_show(view);
   gtk_box_pack_start(GTK_BOX(hbox2),view,TRUE,TRUE,0);
   gtk_widget_set_usize(view,64+4,64+4);
   
   area=gtk_drawing_area_new();
   gtk_widget_show(area);
   gtk_container_add(GTK_CONTAINER(view),area);
   red_view=area;
   
   box=gtk_vbox_new(TRUE,0);
   gtk_widget_show(box);
   gtk_box_pack_start(GTK_BOX(hbox2),box,TRUE,TRUE,0);

   adjuster=make_adjust(GTK_SIGNAL_FUNC(mod_red_gamma_cb),
			GTK_SIGNAL_FUNC(reset_red_gamma_cb),&adjusters[3],
			&sliders[3],gamma_pmap,gamma_mask,160);
   gtk_widget_show(adjuster);
   gtk_box_pack_start(GTK_BOX(box),adjuster,TRUE,TRUE,0);
   adjuster=make_adjust(GTK_SIGNAL_FUNC(mod_red_brightness_cb),
			GTK_SIGNAL_FUNC(reset_red_brightness_cb),&adjusters[4],
			&sliders[4],brightness_pmap,brightness_mask,160);
   gtk_widget_show(adjuster);
   gtk_box_pack_start(GTK_BOX(box),adjuster,TRUE,TRUE,0);
   adjuster=make_adjust(GTK_SIGNAL_FUNC(mod_red_contrast_cb),
			GTK_SIGNAL_FUNC(reset_red_contrast_cb),&adjusters[5],
			&sliders[5],contrast_pmap,contrast_mask,160);
   gtk_widget_show(adjuster);
   gtk_box_pack_start(GTK_BOX(box),adjuster,TRUE,TRUE,0);

   
   frame=gtk_aspect_frame_new(_("Green Channel Modifiers"),0.5,0.5,0.0,TRUE);
   gtk_widget_show(frame);
   gtk_box_pack_start(GTK_BOX(vbox),frame,TRUE,TRUE,0);

   hbox2=gtk_hbox_new(FALSE,0);
   gtk_widget_show(hbox2);
   gtk_container_add(GTK_CONTAINER(frame),hbox2);
   
   view=gtk_viewport_new(NULL,NULL);
   gtk_widget_show(view);
   gtk_box_pack_start(GTK_BOX(hbox2),view,TRUE,TRUE,0);
   gtk_widget_set_usize(view,64+4,64+4);
   
   area=gtk_drawing_area_new();
   gtk_widget_show(area);
   gtk_container_add(GTK_CONTAINER(view),area);
   green_view=area;
   
   box=gtk_vbox_new(TRUE,0);
   gtk_widget_show(box);
   gtk_box_pack_start(GTK_BOX(hbox2),box,TRUE,TRUE,0);

   adjuster=make_adjust(GTK_SIGNAL_FUNC(mod_green_gamma_cb),
			GTK_SIGNAL_FUNC(reset_green_gamma_cb),&adjusters[6],
			&sliders[6],gamma_pmap,gamma_mask,160);
   gtk_widget_show(adjuster);
   gtk_box_pack_start(GTK_BOX(box),adjuster,TRUE,TRUE,0);
   adjuster=make_adjust(GTK_SIGNAL_FUNC(mod_green_brightness_cb),
			GTK_SIGNAL_FUNC(reset_green_brightness_cb),&adjusters[7],
			&sliders[7],brightness_pmap,brightness_mask,160);
   gtk_widget_show(adjuster);
   gtk_box_pack_start(GTK_BOX(box),adjuster,TRUE,TRUE,0);
   adjuster=make_adjust(GTK_SIGNAL_FUNC(mod_green_contrast_cb),
			GTK_SIGNAL_FUNC(reset_green_contrast_cb),&adjusters[8],
			&sliders[8],contrast_pmap,contrast_mask,160);
   gtk_widget_show(adjuster);
   gtk_box_pack_start(GTK_BOX(box),adjuster,TRUE,TRUE,0);

   
   frame=gtk_aspect_frame_new(_("Blue Channel Modifiers"),0.5,0.5,0.0,TRUE);
   gtk_widget_show(frame);
   gtk_box_pack_start(GTK_BOX(vbox),frame,TRUE,TRUE,0);

   hbox2=gtk_hbox_new(FALSE,0);
   gtk_widget_show(hbox2);
   gtk_container_add(GTK_CONTAINER(frame),hbox2);
   
   view=gtk_viewport_new(NULL,NULL);
   gtk_widget_show(view);
   gtk_box_pack_start(GTK_BOX(hbox2),view,TRUE,TRUE,0);
   gtk_widget_set_usize(view,64+4,64+4);
   
   area=gtk_drawing_area_new();
   gtk_widget_show(area);
   gtk_container_add(GTK_CONTAINER(view),area);
   blue_view=area;
   
   box=gtk_vbox_new(TRUE,0);
   gtk_widget_show(box);
   gtk_box_pack_start(GTK_BOX(hbox2),box,TRUE,TRUE,0);

   adjuster=make_adjust(GTK_SIGNAL_FUNC(mod_blue_gamma_cb),
			GTK_SIGNAL_FUNC(reset_blue_gamma_cb),&adjusters[9],
			&sliders[9],gamma_pmap,gamma_mask,160);
   gtk_widget_show(adjuster);
   gtk_box_pack_start(GTK_BOX(box),adjuster,TRUE,TRUE,0);
   adjuster=make_adjust(GTK_SIGNAL_FUNC(mod_blue_brightness_cb),
			GTK_SIGNAL_FUNC(reset_blue_brightness_cb),&adjusters[10],
			&sliders[10],brightness_pmap,brightness_mask,160);
   gtk_widget_show(adjuster);
   gtk_box_pack_start(GTK_BOX(box),adjuster,TRUE,TRUE,0);
   adjuster=make_adjust(GTK_SIGNAL_FUNC(mod_blue_contrast_cb),
			GTK_SIGNAL_FUNC(reset_blue_contrast_cb),&adjusters[11],
			&sliders[11],contrast_pmap,contrast_mask,160);
   gtk_widget_show(adjuster);
   gtk_box_pack_start(GTK_BOX(box),adjuster,TRUE,TRUE,0);

   button=gtk_button_new_with_label(_("Reset All"));
   gtk_widget_show(button);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(reset_all_mods_cb),NULL);
   gtk_box_pack_start(GTK_BOX(vbox),button,FALSE,FALSE,0);

   label=gtk_label_new(_("Geometry"));
   gtk_widget_show(label);
   
   vbox=gtk_vbox_new(FALSE,0);
   gtk_widget_show(vbox);
   gtk_notebook_append_page(GTK_NOTEBOOK(notebk),vbox,label);
   
   frame=gtk_aspect_frame_new(_("Sizing"),0.5,0.5,0.0,TRUE);
   gtk_widget_show(frame);
   gtk_box_pack_start(GTK_BOX(vbox),frame,TRUE,TRUE,0);

   hbox=gtk_hbox_new(FALSE,0);
   gtk_widget_show(hbox);
   gtk_container_add(GTK_CONTAINER(frame),hbox);
   
   hbox2=gtk_hbox_new(FALSE,0);
   gtk_widget_show(hbox2);
   gtk_box_pack_start(GTK_BOX(hbox),hbox2,FALSE,FALSE,0);
   
   gdk_imlib_data_to_pixmap(mag_glass32_xpm,&pmap,&mask);
   pixmap=gtk_pixmap_new(pmap,mask);gtk_widget_show(pixmap);
   gtk_box_pack_start(GTK_BOX(hbox2),pixmap,FALSE,FALSE,0);
   
   box=gtk_vbox_new(FALSE,0);
   gtk_widget_show(box);
   gtk_box_pack_start(GTK_BOX(hbox),box,FALSE,FALSE,0);
   

   
   
   
   hbox2=gtk_hbox_new(TRUE,0);
   gtk_widget_show(hbox2);
   gtk_box_pack_start(GTK_BOX(box),hbox2,FALSE,FALSE,0);
   
   label=gtk_label_new(_("Width:"));
   gtk_widget_show(label);
   gtk_box_pack_start(GTK_BOX(hbox2),label,FALSE,FALSE,0);
   
   width_adj=obj=gtk_adjustment_new(0,1.0,32767.0,1.0,1.0,0.0);
   width_wid=button=gtk_spin_button_new(GTK_ADJUSTMENT(obj),1.0,0);
   gtk_spin_button_set_update_policy(GTK_SPIN_BUTTON(button),
				     GTK_UPDATE_ALWAYS);
   gtk_signal_connect(GTK_OBJECT(obj),"value_changed",GTK_SIGNAL_FUNC(mod_width_cb),NULL);
   gtk_widget_show(button);
   gtk_box_pack_start(GTK_BOX(hbox2),button,TRUE,TRUE,0);
   
   label=gtk_label_new(_("Height:"));
   gtk_widget_show(label);
   gtk_box_pack_start(GTK_BOX(hbox2),label,FALSE,FALSE,0);
   
   height_adj=obj=gtk_adjustment_new(0,1.0,32767.0,1.0,1.0,0.0);
   height_wid=button=gtk_spin_button_new(GTK_ADJUSTMENT(obj),1.0,0);
   gtk_spin_button_set_update_policy(GTK_SPIN_BUTTON(button),
				     GTK_UPDATE_ALWAYS);
   gtk_signal_connect(GTK_OBJECT(obj),"value_changed",GTK_SIGNAL_FUNC(mod_height_cb),NULL);
   gtk_widget_show(button);
   gtk_box_pack_start(GTK_BOX(hbox2),button,TRUE,TRUE,0);
   
   hbox2=gtk_hbox_new(TRUE,0);
   gtk_widget_show(hbox2);
   gtk_box_pack_start(GTK_BOX(box),hbox2,FALSE,FALSE,4);
   
   button=gtk_button_new_with_label(_("Apply Size"));
   gtk_widget_show(button);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(apply_size_cb),NULL);
   gtk_box_pack_start(GTK_BOX(hbox2),button,TRUE,TRUE,0);
   
   button=gtk_check_button_new_with_label(_("Fixed Aspect"));
   gtk_widget_show(button);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(toggle_fixed_cb),button);
   gtk_box_pack_start(GTK_BOX(hbox2),button,TRUE,TRUE,0);
   
   
   
   
   
   hbox2=gtk_hbox_new(TRUE,0);
   gtk_widget_show(hbox2);
   gtk_box_pack_start(GTK_BOX(box),hbox2,FALSE,FALSE,0);
   
   gdk_imlib_data_to_pixmap(size_halve_xpm,&pmap,&mask);
   pixmap=gtk_pixmap_new(pmap,mask);gtk_widget_show(pixmap);
   button=gtk_button_new();
   gtk_container_add(GTK_CONTAINER(button),pixmap);
   gtk_widget_show(button);
   gtk_tooltips_set_tip(GTK_TOOLTIPS(tips),button,
			_("Halves the width and height of the image (CTRL-,)"),NULL);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(handle_image_resize_halve),NULL);
   gtk_box_pack_start(GTK_BOX(hbox2),button,TRUE,TRUE,0);
   gtk_accelerator_table_install(image_accel,
				 GTK_OBJECT(button),"clicked",
				 ',',GDK_CONTROL_MASK);
   
   gdk_imlib_data_to_pixmap(size_down_xpm,&pmap,&mask);
   pixmap=gtk_pixmap_new(pmap,mask);gtk_widget_show(pixmap);
   button=gtk_button_new();
   gtk_container_add(GTK_CONTAINER(button),pixmap);
   gtk_widget_show(button);
   gtk_tooltips_set_tip(GTK_TOOLTIPS(tips),button,
			_("Reduces the size of the image by 10% (,)"),NULL);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(handle_image_resize_down),NULL);
   gtk_box_pack_start(GTK_BOX(hbox2),button,TRUE,TRUE,0);
   gtk_accelerator_table_install(image_accel,
				 GTK_OBJECT(button),"clicked",
				 ',',0);

   gdk_imlib_data_to_pixmap(size_orig_xpm,&pmap,&mask);
   pixmap=gtk_pixmap_new(pmap,mask);gtk_widget_show(pixmap);
   button=gtk_button_new();
   gtk_container_add(GTK_CONTAINER(button),pixmap);
   gtk_widget_show(button);
   gtk_tooltips_set_tip(GTK_TOOLTIPS(tips),button,
			_("Restores the image to its original size (n)"),NULL);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(handle_image_resize_original),NULL);
   gtk_box_pack_start(GTK_BOX(hbox2),button,TRUE,TRUE,0);
   gtk_accelerator_table_install(image_accel,
				 GTK_OBJECT(button),"clicked",
				 'n',0);

   gdk_imlib_data_to_pixmap(size_up_xpm,&pmap,&mask);
   pixmap=gtk_pixmap_new(pmap,mask);gtk_widget_show(pixmap);
   button=gtk_button_new();
   gtk_container_add(GTK_CONTAINER(button),pixmap);
   gtk_widget_show(button);
   gtk_tooltips_set_tip(GTK_TOOLTIPS(tips),button,
			_("Increases the image size by 10% (.)"),NULL);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(handle_image_resize_up),NULL);
   gtk_box_pack_start(GTK_BOX(hbox2),button,TRUE,TRUE,0);
   gtk_accelerator_table_install(image_accel,
				 GTK_OBJECT(button),"clicked",
				 '.',0);

   gdk_imlib_data_to_pixmap(size_double_xpm,&pmap,&mask);
   pixmap=gtk_pixmap_new(pmap,mask);gtk_widget_show(pixmap);
   button=gtk_button_new();
   gtk_container_add(GTK_CONTAINER(button),pixmap);
   gtk_widget_show(button);
   gtk_tooltips_set_tip(GTK_TOOLTIPS(tips),button,
			_("Doubles the width and height of the image (CTRL-.)"),NULL);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(handle_image_resize_double),NULL);
   gtk_box_pack_start(GTK_BOX(hbox2),button,TRUE,TRUE,0);
   gtk_accelerator_table_install(image_accel,
				 GTK_OBJECT(button),"clicked",
				 '.',GDK_CONTROL_MASK);

   hbox2=gtk_hbox_new(TRUE,0);
   gtk_widget_show(hbox2);
   gtk_box_pack_start(GTK_BOX(box),hbox2,FALSE,FALSE,0);
   
   gdk_imlib_data_to_pixmap(size_fit_xpm,&pmap,&mask);
   pixmap=gtk_pixmap_new(pmap,mask);gtk_widget_show(pixmap);
   button=gtk_button_new();
   gtk_container_add(GTK_CONTAINER(button),pixmap);
   gtk_widget_show(button);
   gtk_tooltips_set_tip(GTK_TOOLTIPS(tips),button,
			_("Expands the image to fit the screen whilst retaining its current aspect ratio (f)"),NULL);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(handle_image_resize_fit),NULL);
   gtk_box_pack_start(GTK_BOX(hbox2),button,TRUE,TRUE,0);
   gtk_accelerator_table_install(image_accel,
				 GTK_OBJECT(button),"clicked",
				 'f',0);

   gdk_imlib_data_to_pixmap(size_max_xpm,&pmap,&mask);
   pixmap=gtk_pixmap_new(pmap,mask);gtk_widget_show(pixmap);
   button=gtk_button_new();
   gtk_container_add(GTK_CONTAINER(button),pixmap);
   gtk_widget_show(button);
   gtk_tooltips_set_tip(GTK_TOOLTIPS(tips),button,
			_("Expands the image to fill the entire screen (m)"),NULL);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(handle_image_resize_maximize),NULL);
   gtk_box_pack_start(GTK_BOX(hbox2),button,TRUE,TRUE,0);
   gtk_accelerator_table_install(image_accel,
				 GTK_OBJECT(button),"clicked",
				 'm',0);

   frame=gtk_aspect_frame_new(_("Geometry"),0.5,0.5,0.0,TRUE);
   gtk_widget_show(frame);
   gtk_box_pack_start(GTK_BOX(vbox),frame,TRUE,TRUE,0);

   hbox=gtk_hbox_new(FALSE,0);
   gtk_widget_show(hbox);
   gtk_container_add(GTK_CONTAINER(frame),hbox);
   
   hbox2=gtk_hbox_new(FALSE,0);
   gtk_widget_show(hbox2);
   gtk_box_pack_start(GTK_BOX(hbox),hbox2,FALSE,FALSE,0);
   
   gdk_imlib_data_to_pixmap(geoms_xpm,&pmap,&mask);
   pixmap=gtk_pixmap_new(pmap,mask);gtk_widget_show(pixmap);
   gtk_box_pack_start(GTK_BOX(hbox2),pixmap,FALSE,FALSE,0);
   
   hbox2=gtk_hbox_new(TRUE,0);
   gtk_widget_show(hbox2);
   gtk_box_pack_start(GTK_BOX(hbox),hbox2,TRUE,TRUE,10);
   
   gdk_imlib_data_to_pixmap(geom_fliph_xpm,&pmap,&mask);
   pixmap=gtk_pixmap_new(pmap,mask);gtk_widget_show(pixmap);
   button=gtk_button_new();
   gtk_container_add(GTK_CONTAINER(button),pixmap);
   gtk_widget_show(button);
   gtk_tooltips_set_tip(GTK_TOOLTIPS(tips),button,
			_("Flips the image horizontally (h)"),NULL);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(image_fliph),NULL);
   gtk_box_pack_start(GTK_BOX(hbox2),button,TRUE,TRUE,0);
   gtk_accelerator_table_install(image_accel,
				 GTK_OBJECT(button),"clicked",
				 'h',0);

   gdk_imlib_data_to_pixmap(geom_flipv_xpm,&pmap,&mask);
   pixmap=gtk_pixmap_new(pmap,mask);gtk_widget_show(pixmap);
   button=gtk_button_new();
   gtk_container_add(GTK_CONTAINER(button),pixmap);
   gtk_widget_show(button);
   gtk_tooltips_set_tip(GTK_TOOLTIPS(tips),button,
			_("Flips the image vertically (v)"),NULL);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(image_flipv),NULL);
   gtk_box_pack_start(GTK_BOX(hbox2),button,TRUE,TRUE,0);
   gtk_accelerator_table_install(image_accel,
				 GTK_OBJECT(button),"clicked",
				 'v',0);

   hbox2=gtk_hbox_new(FALSE,0);
   gtk_widget_show(hbox2);
   gtk_box_pack_start(GTK_BOX(hbox),hbox2,FALSE,FALSE,0);
   
   gdk_imlib_data_to_pixmap(geom_rot_xpm,&pmap,&mask);
   pixmap=gtk_pixmap_new(pmap,mask);gtk_widget_show(pixmap);
   button=gtk_button_new();
   gtk_container_add(GTK_CONTAINER(button),pixmap);
   gtk_widget_show(button);
   gtk_tooltips_set_tip(GTK_TOOLTIPS(tips),button,
			_("Flips the image around the x=y diagonal (r)"),NULL);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(image_rotate),NULL);
   gtk_box_pack_start(GTK_BOX(hbox2),button,TRUE,TRUE,0);
   gtk_accelerator_table_install(image_accel,
				 GTK_OBJECT(button),"clicked",
				 'r',0);
   
   frame=gtk_aspect_frame_new(_("Cropping"),0.5,0.5,0.0,TRUE);
   gtk_widget_show(frame);
   gtk_box_pack_start(GTK_BOX(vbox),frame,TRUE,TRUE,0);

   hbox=gtk_hbox_new(FALSE,0);
   gtk_widget_show(hbox);
   gtk_container_add(GTK_CONTAINER(frame),hbox);
   
   hbox2=gtk_hbox_new(FALSE,0);
   gtk_widget_show(hbox2);
   gtk_box_pack_start(GTK_BOX(hbox),hbox2,FALSE,FALSE,0);
   
   gdk_imlib_data_to_pixmap(geoms_xpm,&pmap,&mask);
   pixmap=gtk_pixmap_new(pmap,mask);gtk_widget_show(pixmap);
   gtk_box_pack_start(GTK_BOX(hbox2),pixmap,FALSE,FALSE,0);
   
   box=gtk_vbox_new(FALSE,0);
   gtk_widget_show(box);
   gtk_box_pack_start(GTK_BOX(hbox),box,FALSE,FALSE,0);
   
   hbox2=gtk_hbox_new(TRUE,0);
   gtk_widget_show(hbox2);
   gtk_box_pack_start(GTK_BOX(box),hbox2,TRUE,TRUE,0);
   
   label=gtk_label_new(_("X:"));
   gtk_widget_show(label);
   gtk_box_pack_start(GTK_BOX(hbox2),label,FALSE,FALSE,0);
   
   cropx_adj=obj=gtk_adjustment_new(0,0.0,16384,1.0,1.0,0.0);
   cropx_wid=button=gtk_spin_button_new(GTK_ADJUSTMENT(obj),1.0,0);
   gtk_signal_connect(GTK_OBJECT(obj),"value_changed",GTK_SIGNAL_FUNC(mod_crop_x_cb),NULL);
   gtk_widget_show(button);
   gtk_box_pack_start(GTK_BOX(hbox2),button,TRUE,TRUE,0);
   
   label=gtk_label_new(_("Y:"));
   gtk_widget_show(label);
   gtk_box_pack_start(GTK_BOX(hbox2),label,FALSE,FALSE,0);
   
   cropy_adj=obj=gtk_adjustment_new(0,0.0,16384,1.0,1.0,0.0);
   cropy_wid=button=gtk_spin_button_new(GTK_ADJUSTMENT(obj),1.0,0);
   gtk_signal_connect(GTK_OBJECT(obj),"value_changed",GTK_SIGNAL_FUNC(mod_crop_y_cb),NULL);
   gtk_widget_show(button);
   gtk_box_pack_start(GTK_BOX(hbox2),button,TRUE,TRUE,0);

   hbox2=gtk_hbox_new(TRUE,0);
   gtk_widget_show(hbox2);
   gtk_box_pack_start(GTK_BOX(box),hbox2,FALSE,FALSE,0);
   
   label=gtk_label_new(_("Width:"));
   gtk_widget_show(label);
   gtk_box_pack_start(GTK_BOX(hbox2),label,FALSE,FALSE,0);
   
   cropw_adj=obj=gtk_adjustment_new(0,0.0,16384,1.0,1.0,0.0);
   cropw_wid=button=gtk_spin_button_new(GTK_ADJUSTMENT(obj),1.0,0);
   gtk_signal_connect(GTK_OBJECT(obj),"value_changed",GTK_SIGNAL_FUNC(mod_crop_w_cb),NULL);
   gtk_widget_show(button);
   gtk_box_pack_start(GTK_BOX(hbox2),button,TRUE,TRUE,0);
   
   label=gtk_label_new(_("Height:"));
   gtk_widget_show(label);
   gtk_box_pack_start(GTK_BOX(hbox2),label,FALSE,FALSE,0);
   
   croph_adj=obj=gtk_adjustment_new(0,0.0,16384,1.0,1.0,0.0);
   croph_wid=button=gtk_spin_button_new(GTK_ADJUSTMENT(obj),1.0,0);
   gtk_signal_connect(GTK_OBJECT(obj),"value_changed",GTK_SIGNAL_FUNC(mod_crop_h_cb),NULL);
   gtk_widget_show(button);
   gtk_box_pack_start(GTK_BOX(hbox2),button,TRUE,TRUE,0);
   
   hbox2=gtk_hbox_new(TRUE,0);
   gtk_widget_show(hbox2);
   gtk_box_pack_start(GTK_BOX(box),hbox2,FALSE,FALSE,4);
   
   button=gtk_button_new_with_label(_("Do Crop"));
   gtk_widget_show(button);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(do_crop_cb),NULL);
   gtk_box_pack_start(GTK_BOX(hbox2),button,TRUE,TRUE,0);
   
     {
	int i;

	for(i=0;i<12;i++)
	     gtk_widget_realize(sliders[i]);
	gtk_widget_realize(list);
	gtk_widget_realize(red_view);
	gtk_widget_realize(green_view);
	gtk_widget_realize(blue_view);
	gtk_widget_realize(red_view);
	gtk_widget_realize(current.mini_area);
     }
   configure_drop_on_widget(list,GTK_CLIST(list)->clist_window);
}

void show_edit()
{
   if (!GTK_WIDGET_VISIBLE(window_edit))
     gtk_widget_show(window_edit);
   else
     gtk_widget_hide(window_edit);
}

void hide_edit()
{
   if (GTK_WIDGET_VISIBLE(window_edit))
     gtk_widget_hide(window_edit);
}
