/*****************             Electirc Eyes           ***********************/
/* This software is Copyright (C) 1998 but The Rasterman (Carsten Haitzler). */
/* This software falls under the GNU Public License. Please read the COPYING */
/* file for more information                                                 */
/*****************************************************************************/
#include "ee.h"

void quit_config_cb(GtkWidget *widget, void *data)
{
   gtk_widget_hide(window_config);
}

void spin_thumbw_cb(GtkWidget *widget, void *data)
{
   int v;
   
   v=(int)gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(data));
   thumb_w=v;
}

void spin_thumbh_cb(GtkWidget *widget, void *data)
{
   int v;
   
   v=(int)gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(data));
   thumb_h=v;
}

void spin_slide_cb(GtkWidget *widget, void *data)
{
   int v;
   
   v=(int)(gtk_spin_button_get_value_as_float(GTK_SPIN_BUTTON(data))*1000);
   silde_speed=v;
}

void toggle_sizekeep_cb(GtkWidget *widget, void *data)
{
   if (keepsize) keepsize=0;
   else keepsize=1;
}

void show_config(GtkWidget *widget, void *data)
{  
   GtkWidget *vbox;
   GtkWidget *hbox;
   GtkWidget *frame;
   GtkWidget *label;
   GtkWidget *button;
   GtkWidget *spin;
   GtkObject *obj;
   
   window_config=gtk_window_new(GTK_WINDOW_TOPLEVEL);
   gtk_window_set_wmclass(GTK_WINDOW(window_config),"ee","Image Viewer");
   gtk_window_set_title(GTK_WINDOW(window_config),_("Electric Eyes - Preferences"));
   gtk_container_border_width(GTK_CONTAINER(window_config),3);
   gtk_window_set_policy(GTK_WINDOW(window_config),0,0,1);
   gtk_signal_connect(GTK_OBJECT(window_config),"delete_event",
		      GTK_SIGNAL_FUNC(quit_config_cb),NULL);
   gtk_window_position(GTK_WINDOW(window_config),GTK_WIN_POS_MOUSE);
   vbox=gtk_vbox_new(FALSE,0);
   gtk_widget_show(vbox);
   gtk_container_add(GTK_CONTAINER(window_config),vbox);

   frame=gtk_frame_new(_("Slideshow"));
   gtk_widget_show(frame);
   gtk_box_pack_start(GTK_BOX(vbox),frame,FALSE,FALSE,0);
   hbox=gtk_hbox_new(FALSE,0);
   gtk_widget_show(hbox);
   gtk_container_add(GTK_CONTAINER(frame),hbox);
   label=gtk_label_new(_("Number of seconds between slides"));
   gtk_widget_show(label);
   gtk_box_pack_start(GTK_BOX(hbox),label,FALSE,FALSE,0);
   obj=gtk_adjustment_new(((gfloat)silde_speed)/1000,0.0,99999.0,0.05,0.05,0.0);
   spin=gtk_spin_button_new(GTK_ADJUSTMENT(obj),0.05,2);
   gtk_signal_connect(GTK_OBJECT(obj),"value_changed",
		      GTK_SIGNAL_FUNC(spin_slide_cb),spin);
   gtk_widget_show(spin);
   gtk_spin_button_set_update_policy(GTK_SPIN_BUTTON(spin),
				     GTK_UPDATE_ALWAYS);
   gtk_box_pack_start(GTK_BOX(hbox),spin,FALSE,FALSE,0);

   frame=gtk_frame_new(_("Thumbnails"));
   gtk_widget_show(frame);
   gtk_box_pack_start(GTK_BOX(vbox),frame,FALSE,FALSE,0);
   hbox=gtk_hbox_new(FALSE,0);
   gtk_widget_show(hbox);
   gtk_container_add(GTK_CONTAINER(frame),hbox);
   label=gtk_label_new(_("Preferred Thumbnail Width:"));
   gtk_widget_show(label);
   gtk_box_pack_start(GTK_BOX(hbox),label,FALSE,FALSE,0);
   obj=gtk_adjustment_new((gfloat)thumb_w,1.0,512.0,1.0,1.0,0.0);
   spin=gtk_spin_button_new(GTK_ADJUSTMENT(obj),1.0,0);
   gtk_signal_connect(GTK_OBJECT(obj),"value_changed",
		      GTK_SIGNAL_FUNC(spin_thumbw_cb),spin);
   gtk_widget_show(spin);
   gtk_spin_button_set_update_policy(GTK_SPIN_BUTTON(spin),
				     GTK_UPDATE_ALWAYS);
   gtk_box_pack_start(GTK_BOX(hbox),spin,FALSE,FALSE,0);
   label=gtk_label_new(_("Height:"));
   gtk_widget_show(label);
   gtk_box_pack_start(GTK_BOX(hbox),label,FALSE,FALSE,0);
   obj=gtk_adjustment_new((gfloat)thumb_h,1.0,512.0,1.0,1.0,0.0);
   spin=gtk_spin_button_new(GTK_ADJUSTMENT(obj),1.0,0);
   gtk_widget_show(spin);
   gtk_signal_connect(GTK_OBJECT(obj),"value_changed",
		      GTK_SIGNAL_FUNC(spin_thumbh_cb),spin);
   gtk_spin_button_set_update_policy(GTK_SPIN_BUTTON(spin),
				     GTK_UPDATE_ALWAYS);
   gtk_box_pack_start(GTK_BOX(hbox),spin,FALSE,FALSE,0);
   
   frame=gtk_frame_new(_("Sizing"));
   gtk_widget_show(frame);
   gtk_box_pack_start(GTK_BOX(vbox),frame,FALSE,FALSE,0);
   hbox=gtk_hbox_new(FALSE,0);
   gtk_widget_show(hbox);
   gtk_container_add(GTK_CONTAINER(frame),hbox);
   button=gtk_check_button_new_with_label(_("Keep image size within screen dimensions on load"));
   gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(button),(gint)keepsize);
   gtk_widget_show(button);
   gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",
		      GTK_SIGNAL_FUNC(toggle_sizekeep_cb),NULL);

   button=gtk_button_new_with_label(_("Done"));
   gtk_widget_show(button);
   gtk_signal_connect(GTK_OBJECT(button),"clicked",
		      GTK_SIGNAL_FUNC(quit_config_cb),NULL);
   gtk_box_pack_start(GTK_BOX(vbox),button,FALSE,FALSE,0);
								      
   gtk_widget_show(window_config);
}
