
#ifndef __PROCVIEW_H__
#define __PROCVIEW_H__

#include <gtk/gtk.h>

#include "fromtop.h"
#include "global.h"

typedef enum _p_fmt p_fmt;

enum _p_fmt {
	P_USER,
	P_CMD,
	P_STATE,
	P_TTYC,
	P_ENVIRON,
	P_CMDLINE,
	P_UID,
	P_PID,
	P_PPID,
	P_PGRP,
	P_SESSION,
	P_TTY,
	P_TPGID,
	P_PRIORITY,
	P_NICE,
	P_SIGNAL,
	P_BLOCKED,
	P_SIGIGNORE,
	P_SIGCATCH,
	P_STARTTIME,
	P_UTIME,
	P_STIME,
	P_CUTIME,
	P_CSTIME,
	P_SIZE,
	P_RESIDENT,
	P_SHARE,
	P_TRS,
	P_LRS,
	P_DRS,
	P_DT,
	P_PCPU,
	P_PMEM,
	P_TIME,
	P_VSIZE,
	P_RSS,
	P_RSS_RLIM,
	P_TIMEOUT,
	P_IT_REALVALUE,
	P_FLAGS,
	P_MIN_FLT,
	P_MAJ_FLT,
	P_CMIN_FLT,
	P_CMAJ_FLT,
	P_START_CODE,
	P_END_CODE,
	P_START_STACK,
	P_KSTK_ESP,
	P_KSTK_EIP,
	P_WCHAN,
};

struct save_hist {
    int ticks;
    int pid;
    int pcpu;
    int utime;
    int stime;
};

typedef struct _ProcProcData ProcProcData;

struct _ProcProcData {
	proc_t *p;

	gint pcpu;
	gint pmem;
};

typedef struct _proc_field proc_field;

struct _proc_field {

	gchar *label;
	gchar *long_info;
	p_fmt fmt;
	int (*compare) (const ProcProcData **, const ProcProcData **);
	gint order;
	gint flag;
	GtkJustification justification;
	GtkWidget *hb;

};

extern proc_field p_fields [];

void *addProcessesView ();
gchar *sprint_fmt (ProcProcData *d, p_fmt fmt);
        
#endif
