/* GnomENIUS Calculator
 * Copyright (C) 1997, 1998 George Lebl.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _CALC_H_
#define _CALC_H_

#include "structs.h"

typedef enum {INFIX_NOTATION,POSTFIX_NOTATION,PREFIX_NOTATION} notation_t;
typedef enum {	NO_ERROR=0,
		PARSE_ERROR,
		INTERNAL_MPW_ERROR,
		NUMERICAL_MPW_ERROR
	} calc_error_t;

typedef struct _calcstate_t {
	/*about incoming stuff*/
	notation_t notation_in; /*notation of input*/
	int float_prec;        /*precision of floats to use*/
	/*about outgoing stuff*/
	notation_t notation_out; /*notation of output*/
	int max_digits; /*max digits in the display 0= as many as I got*/
	int make_floats_ints;  /*make ints from floats during calculations*/
	int results_as_floats;  /*give result as float*/
	int scientific_notation; /*allways scientific notation*/
} calcstate_t;


/*so we can use and set the yyparse function for parse errors*/
int yyparse(void);

/*spit out ordinary primitives, such as plus, minus etc*/
char * str_normalprim(char *s,char *p, tree_t *l, tree_t *r);

/*appends to S the primitive op and it's arguments*/
char * str_prim(char *s, int op, tree_t *l, tree_t *r, tree_t *sr);

/*make a string representation of an expression*/
char * makeexprstr(char *s,tree_t *n);

/*add the right parenthesis and brackets to the end of the expression*/
char * addparenth(char *s);

/*this is the function to be mstly called outsied of calc.c
  evaluate the xpression string and give back a string with the
  result*/
char * evalexp(char * str, calcstate_t state,void (*errorfunc)(char *));

#endif
