#include "obgtk.h"

@implementation Gtk_Tooltips
- castGtkTooltips:(GtkTooltips *) castitem
{
  gtktooltips = castitem;
  return [super castGtkData:(GtkData *) castitem];
}

- init
{
  gtktooltips = gtk_tooltips_new();
  return self;
}

- initWithGtkWidgetLabel:(Gtk_Widget *)widget
		tipsText:(gchar *) tips_text
{
  gtktooltips = gtk_tooltips_new();
  return [self set_tips:widget tipsText:tips_text];
}

- enable
{
  gtk_tooltips_enable(gtktooltips);
  return self;
}

- disable
{
  gtk_tooltips_disable(gtktooltips);
  return self;
}

- set_delay:(gint) delay
{
  gtk_tooltips_set_delay(gtktooltips, delay);
  return self;
}

- set_tip:(Gtk_Widget *) widget
  tipsText:(gchar *) tips_text
  tipsPrivate:(gchar *) tips_private
{
  gtk_tooltips_set_tip(gtktooltips, widget->gtkwidget, tips_text, tips_private);
  return self;
}

- set_colors:(GdkColor *) background
   colorFg:(GdkColor *) foreground
{
  gtk_tooltips_set_colors(gtktooltips, background, foreground);
  return self;
}
@end
